/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.engine.core.WriteOffQueueGroup;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffPlugin;

public class RedBlueBeforeWriteOffPlugin
implements IWriteOffPlugin {
    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_PUR_RED_FLUSH, WriteOffTypeIdConst.HXLB_PURRECEIVE_RED_FLUSH);
    }

    @Override
    public void beforeWriteOff(List<WriteOffQueueGroup> queueGroups) {
        Boolean isCQConfig = (Boolean)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"isCQConfig", (Object[])new Object[0]);
        if (!isCQConfig.booleanValue()) {
            return;
        }
        HashSet<Long> asstactIds = new HashSet<Long>(16);
        for (WriteOffQueueGroup queue : queueGroups) {
            Long asstactId = (Long)queue.getMainQueue().peek().getWriteOffObject().get("invoicesupplier");
            asstactIds.add(asstactId);
        }
        ArrayList ispremiumIds = new ArrayList(16);
        DynamicObject[] suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,issuppcolla", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        Arrays.stream(suppliers).filter(supplier -> supplier.getBoolean("issuppcolla")).forEach(supplier -> ispremiumIds.add(supplier.getLong("id")));
        if (ispremiumIds.size() > 0) {
            HashMap<Long, List<Long>> dataMap = new HashMap<Long, List<Long>>(16);
            HashMap<Long, String> billIdToBillNoMapping = new HashMap<Long, String>(16);
            for (WriteOffQueueGroup queue : queueGroups) {
                Long asstactId = (Long)queue.getMainQueue().peek().getWriteOffObject().get("invoicesupplier");
                if (!ispremiumIds.contains(asstactId)) continue;
                this.buildParamAndMapping(dataMap, queue, billIdToBillNoMapping);
            }
            if (dataMap.size() == 0) {
                return;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("billIds", dataMap);
            paramMap.put("entityName", queueGroups.get(0).getGroup().getBillTypeConfig().getBillType());
            paramMap.put("entryKey", "billentry");
            try (TXHandle tx = TX.requiresNew((String)"unVerifyinvokeScm");){
                Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"ICancelVerifyService", (String)"CanCancelVerify", (Object[])new Object[]{paramMap});
                if (resultMap.size() > 0 && !((Boolean)resultMap.get("succed")).booleanValue()) {
                    Map resultDataMap = (Map)resultMap.get("data");
                    HashSet noWriteoffEntryIds = new HashSet(16);
                    for (List entryIds : resultDataMap.values()) {
                        noWriteoffEntryIds.addAll(entryIds);
                    }
                    HashSet<WriteOffQueueGroup> noWriteoffQueues = new HashSet<WriteOffQueueGroup>(16);
                    for (WriteOffQueueGroup queue : queueGroups) {
                        Long mainBillEntryId = queue.getCandidateQueues().get(0).peek().getWriteOffObject().getLong("billentry");
                        Long assistBillEntryId = queue.getCandidateQueues().get(1).peek().getWriteOffObject().getLong("billentry");
                        if (!noWriteoffEntryIds.contains(mainBillEntryId) && !noWriteoffEntryIds.contains(assistBillEntryId)) continue;
                        noWriteoffQueues.add(queue);
                    }
                    if (!noWriteoffQueues.isEmpty()) {
                        queueGroups.removeAll(noWriteoffQueues);
                    }
                }
            }
        }
    }

    private void buildParamAndMapping(Map<Long, List<Long>> dataMap, WriteOffQueueGroup queue, Map<Long, String> billIdToBillNoMapping) {
        List<Long> entryIds;
        DynamicObject mainBill = queue.getCandidateQueues().get(0).peek().getWriteOffObject();
        DynamicObject assistBill = queue.getCandidateQueues().get(1).peek().getWriteOffObject();
        Long billId = mainBill.getLong("id");
        Long entryId = mainBill.getLong("billentry");
        String billNo = mainBill.getString("billno");
        if (dataMap.get(billId) != null) {
            entryIds = dataMap.get(billId);
            entryIds.add(entryId);
            dataMap.put(billId, entryIds);
            billIdToBillNoMapping.put(billId, billNo);
        } else {
            entryIds = new ArrayList<Long>(8);
            entryIds.add(entryId);
            dataMap.put(billId, entryIds);
            billIdToBillNoMapping.put(billId, billNo);
        }
        billId = assistBill.getLong("id");
        entryId = assistBill.getLong("billentry");
        billNo = assistBill.getString("billno");
        if (dataMap.get(billId) != null) {
            entryIds = dataMap.get(billId);
            entryIds.add(entryId);
            dataMap.put(billId, entryIds);
            billIdToBillNoMapping.put(billId, billNo);
        } else {
            entryIds = new ArrayList<Long>(8);
            entryIds.add(entryId);
            dataMap.put(billId, entryIds);
            billIdToBillNoMapping.put(billId, billNo);
        }
    }
}

