/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeObjConst;
import kd.mpscmm.mscommon.writeoff.common.helper.ECServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.scmc.writeback.AbstractWriteBackBillByMService;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IKdtxWfPlugin;

public class WriteBackBillByPlugin
extends AbstractWriteBackBillByMService
implements IKdtxWfPlugin {
    protected static final Log logger = LogFactory.getLog(WriteBackBillByPlugin.class);

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_PUR, WriteOffTypeIdConst.HXLB_SALE, WriteOffTypeIdConst.HXLB_PRODUCT_OM, WriteOffTypeIdConst.HXLB_PUR_RED_FLUSH, WriteOffTypeIdConst.HXLB_PURRECEIVE, WriteOffTypeIdConst.HXLB_OUT_RED_FLUSH, WriteOffTypeIdConst.HXLB_REVCF_RED_FLUSH, WriteOffTypeIdConst.HXLB_OM_PUR);
    }

    @Override
    public void kdtxWfPlugin(List<DynamicObject> records, Map<String, Object> kdtxRecordParam) throws KDBizException {
        logger.info("\u8fdb\u5165\u6838\u9500\u65b9\u6cd5WriteBackBillByPlugin");
        Lists.partition(new ArrayList<DynamicObject>(records), (int)20000).forEach(recordList -> {
            Map<Long, Object[]> paramMap = this.resolveWFRecords((List<DynamicObject>)recordList);
            for (Map.Entry<Long, Object[]> key2Params : paramMap.entrySet()) {
                Long key = key2Params.getKey();
                Object[] params = key2Params.getValue();
                CommonParam ecParam = (CommonParam)params[0];
                List businessInfo = (List)params[1];
                List disposeList = (List)ecParam.get((Object)"disposeList");
                long uniqueKey = this.getUniqueKey();
                for (Map dispose : disposeList) {
                    dispose.put("uniquekey", uniqueKey);
                }
                if (this.isAPWriteOff(key)) {
                    logger.info("\u8c03\u7528\u6838\u9500\u53cd\u5199\u5165\u5e93\u5355\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a" + ecParam);
                    try {
                        ECServiceHelper.execute("msmod_writeoff_mservice", "msmod_writeoff_wbpur", "fi", "ap", "scm", "ApVerifyWBPurEC", businessInfo, (Param)this.copyAndAss2VerifyAmt(ecParam), "");
                    }
                    catch (Exception e) {
                        logger.error("\u8c03\u7528\u6700\u7ec8\u4e00\u81f4\u6027\u5931\u8d25\u3002", (Throwable)e);
                        throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u6700\u7ec8\u4e00\u81f4\u6027\u5931\u8d25\u3002", (String)"WriteBackBillByPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
                    }
                    Boolean isCQConfig = this.doPurService();
                    if (!isCQConfig.booleanValue()) continue;
                    long uniqueKey2 = this.getUniqueKey();
                    for (Map dispose : disposeList) {
                        dispose.put("uniquekey", uniqueKey2);
                    }
                    CommonParam ecParam2 = new CommonParam();
                    ecParam2.put((Object)"isverify", (Object)true);
                    ecParam2.put((Object)"disposelist", (Object)disposeList);
                    logger.info("\u8c03\u7528\u6838\u9500\u53cd\u5199\u4f9b\u5e94\u5546\u534f\u540c,\u8bf7\u6c42\u53c2\u6570:" + ecParam2);
                    ECServiceHelper.execute("msmod_writeoff_mservice", "msmod_writeoff_wbsmcpur", "scm", "pur", "scm", "IVerifyService", (Param)ecParam2, "");
                    continue;
                }
                if (!this.isARWriteOff(key)) continue;
                logger.info("\u8c03\u7528\u6838\u9500\u53cd\u5199\u51fa\u5e93\u5355\uff0c\u8bf7\u6c42\u53c2\u6570:" + ecParam);
                try {
                    ECServiceHelper.execute("msmod_writeoff_mservice", "msmod_writeoff_wbsal", "fi", "ar", "scm", "ArVerifyWBSalEC", businessInfo, (Param)this.copyAndAss2VerifyAmt(ecParam), "");
                }
                catch (Exception e) {
                    logger.error("\u8c03\u7528\u6700\u7ec8\u4e00\u81f4\u6027\u5931\u8d25\u3002", (Throwable)e);
                    throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u6700\u7ec8\u4e00\u81f4\u6027\u5931\u8d25\u3002", (String)"WriteBackBillByPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
                }
                if (WriteOffTypeObjConst.WFTYPE_SALOUT.compareTo(key) != 0) continue;
                for (Map dispose : disposeList) {
                    dispose.put("isverify", true);
                }
                CommonParam ecParam2 = new CommonParam();
                ecParam2.put((Object)"disposeList", (Object)disposeList);
                logger.info("\u8c03\u7528\u6838\u9500\u53cd\u5199\u8d22\u52a1\u5e94\u6536\u5355,\u8bf7\u6c42\u53c2\u6570\uff1a" + ecParam2);
                ECServiceHelper.execute("msmod_writeoff_mservice", "msmod_writeoff_wbfiar", "fi", "ar", "scm", "ArVerifyDisposeECService", (Param)ecParam2, "");
                CommonParam performanceCostEcParam = new CommonParam();
                HashSet recordIds = new HashSet(16);
                HashSet salOutIds = new HashSet(16);
                HashSet salOutEntryIds = new HashSet(16);
                HashSet revcfmIds = new HashSet(16);
                HashSet revcfmEntryIds = new HashSet(16);
                for (Map dispose : disposeList) {
                    Map asstData = (Map)((List)dispose.get("asstdata")).get(0);
                    if (asstData.get("ischargeoff") != null && ((Boolean)asstData.get("ischargeoff")).booleanValue() || asstData.get("hadchargeoff") != null && ((Boolean)asstData.get("hadchargeoff")).booleanValue()) continue;
                    revcfmIds.add(asstData.get("asstpk"));
                    revcfmEntryIds.add(asstData.get("asstentrypk"));
                    salOutIds.add(dispose.get("pk"));
                    salOutEntryIds.add(dispose.get("entrypk"));
                    recordIds.add(dispose.get("recordid"));
                }
                performanceCostEcParam.put((Object)"isreserve", (Object)true);
                performanceCostEcParam.put((Object)"recordids", recordIds);
                performanceCostEcParam.put((Object)"ids", salOutIds);
                performanceCostEcParam.put((Object)"entryids", salOutEntryIds);
                performanceCostEcParam.put((Object)"revcfmids", revcfmIds);
                performanceCostEcParam.put((Object)"revcfmentryids", revcfmEntryIds);
                logger.info("WriteBackBillByPlugin\u8c03\u7528\u6838\u9500\u7ed3\u8f6c\u5c65\u7ea6\u6210\u672c\u4e00\u81f4\u6027\u5904\u7406,\u8bf7\u6c42\u53c2\u6570\uff1a" + performanceCostEcParam.toString());
                ECServiceHelper.execute("msmod_writeoff_mservice", "msmod_writeoff_arperformanceCost", "fi", "ar", "scm", "PerformanceCostsDisposeVerifyECService", (Param)performanceCostEcParam, "");
            }
            boolean hasProductType = ((DynamicObject)recordList.get(0)).getDataEntityType().getProperties().containsKey((Object)"producttype");
            if (hasProductType) {
                this.doChildRecordWriteBack((List<DynamicObject>)recordList);
            }
        });
    }

    private void doChildRecordWriteBack(List<DynamicObject> records) {
        HashSet<Integer> writeOffSeqSet = new HashSet<Integer>(16);
        HashSet<Long> pidSet = new HashSet<Long>(16);
        for (DynamicObject record : records) {
            Long writeTypeId = record.getLong("writeofftypeid_id");
            if (WriteOffTypeObjConst.WFTYPE_SALOUT.compareTo(writeTypeId) != 0 || !"kitparent".equals(record.getString("producttype"))) continue;
            writeOffSeqSet.add(record.getInt("verifyseq"));
            pidSet.add(record.getLong("pid"));
        }
        if (writeOffSeqSet.isEmpty()) {
            logger.info("WriteBackBillByPlugin:\u6ca1\u6709\u5957\u4ef6\u7236\u9879\u6838\u9500\u8bb0\u5f55");
            return;
        }
        QFilter childRecordQ = new QFilter("verifyseq", "in", writeOffSeqSet);
        childRecordQ.and("pid", "in", pidSet);
        childRecordQ.and("producttype", "=", (Object)"kitchild");
        DataSet childRecordDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_salwfrecord", (String)"producttype,verifyqty,verifybaseqty,billid,billentryid", (QFilter[])childRecordQ.toArray(), null);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        for (Row row : childRecordDS) {
            if (!"kitchild".equals(row.getString("producttype"))) continue;
            BigDecimal verifyQty = row.getBigDecimal("verifyqty");
            BigDecimal verifyBaseQty = row.getBigDecimal("verifybaseqty");
            Long billId = row.getLong("billid");
            Long billEntryId = row.getLong("billentryid");
            Object[] param = new Object[]{verifyQty, verifyQty, verifyBaseQty, verifyBaseQty, billEntryId, billId};
            paramList.add(param);
        }
        try (TXHandle h = TX.required();){
            try {
                if (!paramList.isEmpty()) {
                    String sql = "update t_im_saloutbillentry_r set  funverifyqty = funverifyqty-?,fverifyqty = fverifyqty+?,  funverifybaseqty = funverifybaseqty-?,fverifybaseqty = fverifybaseqty+?  where fentryid=? and fid = ?";
                    logger.info("SQL:" + sql);
                    logger.info("Param:" + SerializationUtils.toJsonString(paramList));
                    DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, paramList);
                }
            }
            catch (Exception ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    private Boolean doPurService() {
        return (Boolean)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"isCQConfig", (Object[])new Object[0]);
    }

    private long getUniqueKey() {
        return DB.genGlobalLongId();
    }
}

