/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin.WriteOffDealRecordCommomCalPlugin;

public class WriteOffDealRecordDataCalPlugin
extends WriteOffDealRecordCommomCalPlugin {
    private Map<Long, DynamicObject> orgInitInfoMap = new HashMap<Long, DynamicObject>(16);

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_PUR, WriteOffTypeIdConst.HXLB_SALE, WriteOffTypeIdConst.HXLB_PUR_RED_FLUSH, WriteOffTypeIdConst.HXLB_INVOICE_RED_FLUSH, WriteOffTypeIdConst.HXLB_PURRECEIVE, WriteOffTypeIdConst.HXLB_PURRECEIVE_RED_FLUSH, WriteOffTypeIdConst.HXLB_PRODUCT_OM, WriteOffTypeIdConst.HXLB_PRODUCT_OM_RED, WriteOffTypeIdConst.HXLB_OUT_RED_FLUSH, WriteOffTypeIdConst.HXLB_REVCF_RED_FLUSH, WriteOffTypeIdConst.HXLB_SIMPLE_OM, WriteOffTypeIdConst.HXLB_SIMPLE_OM_RED);
    }

    @Override
    public void beforeAllWfRecordGenerate(List<DynamicObject> recordBills) {
        super.beforeAllWfRecordGenerate(recordBills);
        if (this.mainBillType == null) {
            return;
        }
        this.dealWriteDate(recordBills);
    }

    private void dealWriteDate(List<DynamicObject> recordBills) {
        this.initOrgInfo(recordBills);
        for (DynamicObject recordBill : recordBills) {
            Date createDate;
            DynamicObject assistBillDym;
            Long mainBillEntryId = recordBill.getLong("billentryid");
            Long assistBillEntryId = ((DynamicObject)recordBill.getDynamicObjectCollection("entry").get(0)).getLong("e_billentryid");
            DynamicObject mainBillDym = (DynamicObject)this.mainBillDymMap.get(mainBillEntryId);
            Date bookdate = this.getBookDate(mainBillDym, assistBillDym = (DynamicObject)this.assistBillDymMap.get(assistBillEntryId));
            Date maxDate = bookdate.after(createDate = this.getCreateDate(recordBill)) ? bookdate : createDate;
            recordBill.set("verifydate", (Object)maxDate);
        }
    }

    private Date getBookDate(DynamicObject mainBillDym, DynamicObject assistBillDym) {
        Date assistBillBookdate;
        Date mainBillBookdate = mainBillDym.getDate("bookdate");
        return mainBillBookdate.after(assistBillBookdate = assistBillDym.getDate("bookdate")) ? mainBillBookdate : assistBillBookdate;
    }

    private Date getCreateDate(DynamicObject recordBill) {
        Date createTime = recordBill.getDate("createtime");
        Long orgId = recordBill.getDynamicObject("org").getLong("id");
        DynamicObject initObj = this.orgInitInfoMap.get(orgId);
        if (initObj == null) {
            return createTime;
        }
        Date startDate = initObj.getDate("curperiod.begindate");
        Date endDate = initObj.getDate("curperiod.enddate");
        if (startDate != null && createTime.before(startDate) || endDate != null && createTime.after(endDate)) {
            return startDate;
        }
        return createTime;
    }

    private void initOrgInfo(List<DynamicObject> recordBills) {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (DynamicObject recordBill : recordBills) {
            Long orgId = recordBill.getDynamicObject("org").getLong("id");
            orgIds.add(orgId);
        }
        String recordEntityNum = recordBills.get(0).getDataEntityType().getName();
        String initEntityNum = "cal_purwfrecord".equals(recordEntityNum) ? "ap_init" : "ar_init";
        QFilter q = new QFilter("org", "in", orgIds);
        q.and("isfinishinit", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection initObjs = QueryServiceHelper.query((String)initEntityNum, (String)"org,curperiod.begindate,curperiod.enddate", (QFilter[])q.toArray());
        for (DynamicObject initObj : initObjs) {
            this.orgInitInfoMap.put(initObj.getLong("org"), initObj);
        }
    }
}

