/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.receivematch.plugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.scmc.receivematch.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.ext.scmc.receivematch.pojo.WriteOffResponse;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IUnWriteOffCheckPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IUnWriteOffPlugin;

public class SalContractBackWriteOffPlugin
implements IUnWriteOffPlugin,
IUnWriteOffCheckPlugin {
    private static final Log log = LogFactory.getLog(SalContractBackWriteOffPlugin.class);

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_REC_PLAN);
    }

    @Override
    public Map<String, Set<String>> preparePropKey() {
        HashMap<String, Set<String>> fieldMap = new HashMap<String, Set<String>>(4);
        fieldMap.put("conm_scmatch", new HashSet<String>(Arrays.asList("wfseq", "entry.billid", "entry.billentryid", "entry.entryseq", "entry.billno", "entry.assbillid", "entry.assbillentryid", "entry.asscurwfamount", "entry.sallDetailId")));
        return fieldMap;
    }

    @Override
    public boolean check(DynamicObject record) {
        DynamicObjectCollection entrys = record.getDynamicObjectCollection("entry");
        String batchNumber = record.getString("wfseq");
        List<Map<String, Object>> list = this.getDetails(entrys);
        WriteOffResponse validate = this.cancelMatchValidate(batchNumber, list);
        log.info("\u6536\u6b3e\u5355\u53d6\u6d88\u53d8\u66f4\u6821\u9a8c\u63a5\u53e3\u8fd4\u56de\u503c\uff1a" + JSON.toJSONString((Object)validate));
        if (validate != null && "success".equalsIgnoreCase(validate.getStatus())) {
            return true;
        }
        String errorMsg = CommonHelper.showCalMatchFailMsg(validate);
        throw new KDBizException(errorMsg);
    }

    @Override
    public void beforeWfRecordDelete(List<DynamicObject> records) {
        for (DynamicObject recordBill : records) {
            DynamicObjectCollection entrys = recordBill.getDynamicObjectCollection("entry");
            String batchNumber = recordBill.getString("wfseq");
            List<Map<String, Object>> list = this.getDetails(entrys);
            WriteOffResponse match = this.cancelMatch(batchNumber, list);
            log.info("\u6536\u6b3e\u5355\u53d6\u6d88\u53d8\u66f4\u63a5\u53e3\u8fd4\u56de\u503c\uff1a" + JSON.toJSONString((Object)match));
            if (match != null && "success".equalsIgnoreCase(match.getStatus())) continue;
            String errorMsg = CommonHelper.showCalMatchFailMsg(match);
            throw new KDBizException(errorMsg);
        }
    }

    private List<Map<String, Object>> getDetails(DynamicObjectCollection entrys) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (DynamicObject entry : entrys) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sourceBillType", "conm_salcontract");
            Long billid = entry.getLong("billid");
            map.put("sourceBillId", billid);
            Long entryid = entry.getLong("billentryid");
            map.put("sourceBillEntryId", entryid);
            Long entrySeq = entry.getLong("entryseq");
            map.put("sourceBillEntrySeq", entrySeq);
            String billNo = entry.getString("billno");
            map.put("sourceBillNo", billNo);
            Long casbillid = entry.getLong("assbillid");
            map.put("billId", casbillid);
            Long casEntryid = entry.getLong("assbillentryid");
            map.put("billEntryId", casEntryid);
            BigDecimal cas_amount = entry.getBigDecimal("asscurwfamount");
            map.put("matchAmt", cas_amount);
            Long sallDetailId = entry.getLong("sallDetailId");
            if (sallDetailId == null || sallDetailId <= 0L) {
                sallDetailId = CommonHelper.getRandomLong();
                entry.set("sallDetailId", (Object)sallDetailId);
            }
            map.put("sallDetailId", sallDetailId);
            list.add(map);
        }
        return list;
    }

    private WriteOffResponse cancelMatchValidate(String batchNumber, List<Map<String, Object>> details) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("details", details);
        map.put("operate", "cancelMatchValidate");
        map.put("batchNumber", batchNumber);
        return this.dispachService(map);
    }

    private WriteOffResponse cancelMatch(String batchNumber, List<Map<String, Object>> details) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("details", details);
        map.put("operate", "cancelMatch");
        map.put("batchNumber", batchNumber);
        return this.dispachService(map);
    }

    private WriteOffResponse dispachService(HashMap<String, Object> map) {
        String param = JSON.toJSONString(map);
        log.info("\u9884\u6536\u6b3e\u53cd\u5339\u914d\u8c03\u7528\u6536\u6b3e\u5355\u53d6\u6d88\u53d8\u66f4\u63a5\u53e3\u53c2\u6570\uff1a" + param);
        String re = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"recBusinessAccountService", (String)"operate", (Object[])new Object[]{param});
        log.info("\u9884\u6536\u6b3e\u53cd\u5339\u914d\u8c03\u7528\u6536\u6b3e\u5355\u53d6\u6d88\u53d8\u66f4\u63a5\u53e3\u8fd4\u56de\u503c\uff1a" + re);
        WriteOffResponse writeOffResponse = (WriteOffResponse)JSON.parseObject((String)re, WriteOffResponse.class);
        return writeOffResponse;
    }
}

