/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.taxc;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffTypeContext;
import kd.mpscmm.mscommon.writeoff.business.engine.core.WriteOffQueueGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.factory.WfPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.WriteOffRecordMapper;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.manager.WriteOffObjectManager;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.queue.WriteOffObjectQueue;
import kd.mpscmm.mscommon.writeoff.business.engine.core.writeoff.impl.AbstractWriteOffStrategy;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.taxc.TaxcWriteOffUtil;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class CktsScqyWriteOffStrategy
extends AbstractWriteOffStrategy {
    private static final Log logger = LogFactory.getLog(CktsScqyWriteOffStrategy.class);
    private static final int LIMIT_COUNT = 300;
    private static final String COUNT = "count";
    private static final int exportIndex = 0;
    private static final int simIndex = 1;
    private String sourceUnitCol = "";
    private String entrySourceUnitCol = "";
    private Boolean isMatch = Boolean.FALSE;
    private Boolean isMylajZero = Boolean.FALSE;

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_SCQY);
    }

    @Override
    public void batchExecute(SchemeContextConfig schemeContextConfig, List<WriteOffQueueGroup> queueGroups) {
        for (WriteOffQueueGroup queue : queueGroups) {
            this.execute(schemeContextConfig, queue.getCandidateQueues());
        }
    }

    @Override
    public void execute(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> candidateQueues) {
        logger.info("logflag:\u5f00\u59cb\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u751f\u4ea7\u4f01\u4e1a\uff09\u6838\u9500,\u6574\u4f53\u6267\u884c");
        long l = System.currentTimeMillis();
        if (this.isCompleted(candidateQueues)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4ee5\u6838\u9500\u7684\u6570\u636e\u3002", (String)"CktsScqyWriteOffStrategy_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        for (int i = 0; i < candidateQueues.size(); ++i) {
            if (candidateQueues.get(i) == null) continue;
            if (logger.isDebugEnabled()) {
                List collect = candidateQueues.get(i).peekAll().stream().map(WriteOffObjectBase::getWriteOffObjectPk).collect(Collectors.toList());
                logger.debug("logflag:\u6838\u9500\u961f\u5217\u6570\u636e:" + JSONObject.toJSONString(collect));
            }
            logger.info("logflag:\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u751f\u4ea7\u4f01\u4e1a\uff09\u6838\u9500,\u7b2c{}\u4e2a\u961f\u5217\u7684\u6570\u636e\u957f\u5ea6\u4e3a{}", (Object)i, (Object)candidateQueues.get(i).size());
        }
        boolean isWhole = this.isWhole(schemeContextConfig, candidateQueues);
        if (isWhole) {
            this.validExport(candidateQueues.get(0));
            List<List<IWriteOffQueue>> writeOffQueueGroups = this.wfRecordGroup(schemeContextConfig, candidateQueues);
            WriteOffTypeContext snapShootHolder = this.getSnapShootHolder();
            for (List<IWriteOffQueue> writeOffQueueList : writeOffQueueGroups) {
                WriteOffRecordMapper recordBill = this.writeOffRecord(writeOffQueueList, null, schemeContextConfig);
                recordBill.getRecordBill().set("type", (Object)TaxcWriteOffUtil.WF_MODEL_MAP.get(schemeContextConfig.getWfMode()));
                snapShootHolder.addRecordBill(recordBill);
            }
            return;
        }
        this.sourceUnitCol = this.getSourceUnitCol();
        String[] split = this.sourceUnitCol.split("\\.");
        this.entrySourceUnitCol = split[split.length - 1];
        Map<String, Object> result = this.executeFirstSameUnit(schemeContextConfig, candidateQueues, isWhole);
        int count = (Integer)result.getOrDefault(COUNT, 0);
        if (count == 0) {
            logger.info("logflag:\u6838\u9500\u5931\u8d25\uff0c\u6ca1\u6709\u5408\u9002\u7684\u5355\u4f4d\u6362\u7b97\u5173\u7cfb\u6216\u6362\u6c47\u6210\u672c\u8ba1\u7b97\u8d85\u51fa\u9650\u5236\u3002");
            if (this.isMylajZero.booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u5931\u8d25\uff0c\u7f8e\u5143\u79bb\u5cb8\u4ef7\u4e0d\u80fd\u4e3a0\uff0c\u8bf7\u5148\u8ba1\u7b97\u51fa\u53e3\u62a5\u5173\u5355\u7684\u7f8e\u5143\u79bb\u5cb8\u4ef7\u3002", (String)"CktsScqyWriteOffStrategy_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            }
            if (this.isMatch.booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u5931\u8d25\uff0c\u6362\u6c47\u6210\u672c\u8ba1\u7b97\u8d85\u51fa\u9650\u5236\u3002", (String)"CktsScqyWriteOffStrategy_2", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u5931\u8d25\uff0c\u6838\u9500\u5355\u636e\u5b58\u5728\u8ba1\u91cf\u5355\u4f4d\u4e0d\u4e00\u81f4\u7684\u573a\u666f\uff0c\u8bf7\u5148\u7ef4\u62a4\u901a\u7528\u5355\u4f4d\u6362\u7b97\u7cfb\u6570\u3002", (String)"CktsScqyWriteOffStrategy_3", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        long l1 = System.currentTimeMillis();
        logger.info("logflag:\u7ed3\u675f\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u751f\u4ea7\u4f01\u4e1a\uff09\u6838\u9500,\u6574\u4f53\u6267\u884c,cost:{}ms", (Object)(l1 - l));
    }

    private void validExport(IWriteOffQueue writeOffQueue) {
        List<WriteOffObjectBase> writeOffObjectBases = writeOffQueue.peekAll();
        for (WriteOffObjectBase poll : writeOffObjectBases) {
            BigDecimal mylaj = (BigDecimal)poll.getValue("mylaj");
            if (mylaj.compareTo(BigDecimal.ZERO) > 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u7f8e\u5143\u79bb\u5cb8\u4ef7\u5927\u4e8e0\u624d\u80fd\u6838\u9500\uff0c\u5b58\u5728\u4e0d\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CktsScqyWriteOffStrategy_5", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
    }

    private Map<String, Object> executeFirstSameUnit(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> candidateQueues, boolean isWhole) {
        long l = System.currentTimeMillis();
        logger.info("logflag:\u5f00\u59cb\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u751f\u4ea7\u4f01\u4e1a\uff09\u6838\u9500,\u6267\u884c\u5355\u4f4d\u76f8\u540c\u4f18\u5148\u6838\u9500");
        int count = 0;
        Map<Object, Object> result = new HashMap();
        for (IWriteOffQueue writeOffQueue : candidateQueues) {
            if (!schemeContextConfig.isWhole()) continue;
            writeOffQueue.sortByWhole();
        }
        HashMap<Long, String> exportUnitIdMap = new HashMap<Long, String>();
        List<Map<String, IWriteOffQueue>> splitData = this.splitDataByUnit(candidateQueues, exportUnitIdMap);
        Map<String, IWriteOffQueue> queueMapEx = splitData.get(0);
        ArrayList<IWriteOffQueue> multiUnitQueues = new ArrayList<IWriteOffQueue>(2);
        multiUnitQueues.add(new WriteOffObjectQueue());
        multiUnitQueues.add(new WriteOffObjectQueue());
        HashSet<String> invoiceUnitNameSet = new HashSet<String>();
        invoiceUnitNameSet.addAll(splitData.get(1).keySet());
        for (Map.Entry<Long, String> entry : exportUnitIdMap.entrySet()) {
            Long unitid = entry.getKey();
            String unitname = entry.getValue();
            boolean bl = false;
            for (String invoiceUnitName : invoiceUnitNameSet) {
                BigDecimal unitRateFromCache = TaxcWriteOffUtil.getUnitRateFromCache(invoiceUnitName, unitname, unitid);
                if (unitRateFromCache == null) continue;
                bl = true;
            }
            if (bl) continue;
            queueMapEx.remove(unitname);
        }
        Iterator<Map.Entry<String, IWriteOffQueue>> iterator = queueMapEx.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, IWriteOffQueue> next = iterator.next();
            String key = next.getKey();
            if (splitData.get(1).containsKey(key)) continue;
            ((IWriteOffQueue)multiUnitQueues.get(0)).addAll(next.getValue().peekAll());
            iterator.remove();
        }
        logger.info("logflag:\u6bcf\u7ec4\u5355\u4f4d\u5148\u6838\u9500 start");
        Map<String, IWriteOffQueue> exportMap = splitData.get(0);
        Map<String, IWriteOffQueue> simMap = splitData.get(1);
        for (Map.Entry entry : exportMap.entrySet()) {
            if (count >= 300) break;
            String sameUnit = (String)entry.getKey();
            IWriteOffQueue exportQueue = (IWriteOffQueue)entry.getValue();
            IWriteOffQueue simQueue = simMap.get(sameUnit);
            if (exportQueue == null || exportQueue.isEmpty() || simQueue == null || simQueue.isEmpty()) continue;
            ArrayList<IWriteOffQueue> queueList = new ArrayList<IWriteOffQueue>();
            queueList.add(exportQueue);
            queueList.add(simQueue);
            result = this.executeMulUnit(schemeContextConfig, queueList, isWhole, true);
            count += result.getOrDefault(COUNT, 0).intValue();
        }
        logger.info("logflag:\u6bcf\u7ec4\u5355\u4f4d\u5148\u6838\u9500 end");
        logger.info("logflag:\u4e0d\u540c\u5355\u4f4d\u6838\u9500 start");
        long l2 = System.currentTimeMillis();
        if (count < 300) {
            for (int i = 0; i < splitData.size(); ++i) {
                Map<String, IWriteOffQueue> queueMap = splitData.get(i);
                for (IWriteOffQueue queue : queueMap.values()) {
                    if (queue.isEmpty()) continue;
                    ((IWriteOffQueue)multiUnitQueues.get(i)).addAll(queue.peekAll());
                }
            }
            result = this.executeMulUnit(schemeContextConfig, multiUnitQueues, isWhole, false);
            result.put(COUNT, count += ((Integer)result.getOrDefault(COUNT, 0)).intValue());
        }
        long l1 = System.currentTimeMillis();
        logger.info("logflag:\u4e0d\u540c\u5355\u4f4d\u6838\u9500 end,cost:{}ms", (Object)(l1 - l2));
        logger.info("logflag:\u7ed3\u675f\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u751f\u4ea7\u4f01\u4e1a\uff09\u6838\u9500,\u6267\u884c\u5355\u4f4d\u76f8\u540c\u4f18\u5148\u6838\u9500,cost:{}ms", (Object)(l1 - l));
        return result;
    }

    private Map<String, Object> executeMulUnit(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> candidateQueues, boolean isWhole, boolean mergeData) {
        long l = System.currentTimeMillis();
        logger.debug("logflag:\u5f00\u59cb\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u751f\u4ea7\u4f01\u4e1a\uff09\u6838\u9500,\u6267\u884c\u5355\u4f4d\u4e0d\u7edf\u4e00\u7684\u60c5\u51b5");
        HashMap<String, Object> reulst = new HashMap<String, Object>(4);
        int count = 0;
        if (this.isCompleted(candidateQueues)) {
            reulst.put(COUNT, count);
            return reulst;
        }
        IDataEntityProperty simUnitProp = null;
        IDataEntityProperty simIdProp = null;
        for (IWriteOffQueue writeOffQueue : candidateQueues) {
            String billType = this.getBillType(writeOffQueue);
            if ("sim_vatinvoice".equals(billType)) {
                simUnitProp = (IDataEntityProperty)writeOffQueue.peek().getWriteOffObject().getDataEntityType().getProperties().get((Object)"unit");
                simIdProp = (IDataEntityProperty)writeOffQueue.peek().getWriteOffObject().getDataEntityType().getProperties().get((Object)"id");
            }
            if (logger.isDebugEnabled()) {
                List collect = writeOffQueue.peekAll().stream().map(WriteOffObjectBase::getWriteOffObjectPk).collect(Collectors.toList());
                logger.debug("logflag:\u5f00\u59cb\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u751f\u4ea7\u4f01\u4e1a\uff09\u6838\u9500,\u6267\u884c\u5355\u4f4d\u4e0d\u7edf\u4e00\u7684\u60c5\u51b5,\u6838\u9500\u961f\u5217\u6570\u636e:" + JSONObject.toJSONString(collect));
            }
            logger.info("logflag:\u5f00\u59cb\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u751f\u4ea7\u4f01\u4e1a\uff09\u6838\u9500,\u6267\u884c\u5355\u4f4d\u4e0d\u7edf\u4e00\u7684\u60c5\u51b5,{}\u961f\u5217\u7684\u6570\u636e\u957f\u5ea6\u4e3a{}", (Object)(billType + " "), (Object)writeOffQueue.size());
        }
        if (simIdProp == null && simUnitProp == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u53d1\u7968\u7684id\u548c\u5355\u4f4d\u5217\u3002", (String)"CktsScqyWriteOffStrategy_4", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        WriteOffTypeConfig typeConfig = this.getTypeConfig();
        WriteOffTypeContext snapShootHolder = this.getSnapShootHolder();
        WriteOffObjectQueue simPool = new WriteOffObjectQueue();
        IWriteOffQueue exportQueue = candidateQueues.get(0);
        IWriteOffQueue simQueue = candidateQueues.get(1);
        ArrayList<IWriteOffQueue> queueList = new ArrayList<IWriteOffQueue>();
        queueList.add(new WriteOffObjectQueue());
        queueList.add(simQueue);
        int i = 0;
        WriteOffObjectQueue exportNoMatchQueue = new WriteOffObjectQueue();
        WriteOffObjectQueue rimNoMatchQueue = new WriteOffObjectQueue();
        while (!exportQueue.isEmpty() && count < 300) {
            List<IWriteOffQueue> writeOffQueues;
            Optional<IWriteOffQueue> first;
            WriteOffObjectBase export = this.pollExportEntry(exportQueue);
            if (export == null) continue;
            ((IWriteOffQueue)queueList.get(0)).add(export);
            while (!this.isCompleted(queueList) && count < 300 && !(first = (writeOffQueues = this.pickDiffUnitWriteOffObjects(schemeContextConfig, queueList, isWhole, exportNoMatchQueue, rimNoMatchQueue, simUnitProp, simIdProp)).stream().filter(IWriteOffQueue::isEmpty).findFirst()).isPresent()) {
                ++i;
                this.isMatch = Boolean.TRUE;
                List<IWriteOffQueue> copyQueues = this.copyQueues(writeOffQueues);
                String wbDetail = null;
                WriteOffRecordMapper recordBill = this.writeOffRecord(writeOffQueues, wbDetail, schemeContextConfig);
                boolean checkWithoutException = WfPluginExtFactory.checkWithoutException(recordBill.getRecordBill(), typeConfig);
                if (checkWithoutException) {
                    recordBill.getRecordBill().set("type", (Object)TaxcWriteOffUtil.WF_MODEL_MAP.get(schemeContextConfig.getWfMode()));
                    snapShootHolder.addRecordBill(recordBill);
                    ++count;
                    continue;
                }
                logger.debug("logflag:WfPluginExtFactory.check,false");
                ((IWriteOffQueue)queueList.get(0)).addAll(copyQueues.get(0).peekAll());
                simPool.addAll(copyQueues.get(1).peekAll());
            }
            rimNoMatchQueue.peekAll().clear();
            exportNoMatchQueue.addAll(((IWriteOffQueue)queueList.get(0)).peekAll());
            ((IWriteOffQueue)queueList.get(0)).peekAll().clear();
        }
        exportQueue.addAll(exportNoMatchQueue.peekAll());
        simQueue.addAll(simPool.peekAll());
        if (mergeData) {
            candidateQueues.forEach(this::mergeData);
        }
        reulst.put(COUNT, count);
        long l1 = System.currentTimeMillis();
        logger.info("logflag:\u7ed3\u675f\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u751f\u4ea7\u4f01\u4e1a\uff09\u6838\u9500,\u6267\u884c\u5355\u4f4d\u4e0d\u7edf\u4e00\u7684\u60c5\u51b5,cost:{}ms,\u5faa\u73af\uff1a{}\u6b21", (Object)(l1 - l), (Object)i);
        return reulst;
    }

    private void mergeData(IWriteOffQueue candidateQueue) {
        ArrayList<WriteOffObjectBase> queueList = new ArrayList<WriteOffObjectBase>(32);
        Map<String, List<WriteOffObjectBase>> map = candidateQueue.peekAll().stream().filter(a -> a != null).collect(Collectors.groupingBy(a -> String.format("%s_%s", a.getWfBillPk(), a.getPkValue())));
        for (Map.Entry<String, List<WriteOffObjectBase>> entry : map.entrySet()) {
            List<WriteOffObjectBase> values = entry.getValue();
            WriteOffObjectBase writeOffObjectBase = values.get(0);
            BigDecimal reduce = values.stream().map(WriteOffObjectBase::getWriteOffNumber).reduce(BigDecimal.ZERO, BigDecimal::add);
            writeOffObjectBase.setWriteOffNumber(reduce);
            queueList.add(writeOffObjectBase);
        }
        candidateQueue.peekAll().clear();
        candidateQueue.addAll(queueList);
    }

    private List<IWriteOffQueue> copyQueues(List<IWriteOffQueue> writeOffQueues) {
        ArrayList<IWriteOffQueue> copyQueues = new ArrayList<IWriteOffQueue>(4);
        for (IWriteOffQueue writeOffQueue : writeOffQueues) {
            WriteOffObjectQueue copyQueue = new WriteOffObjectQueue();
            copyQueue.addAll(writeOffQueue.peekAll());
            copyQueues.add(copyQueue);
        }
        return copyQueues;
    }

    private List<Map<String, IWriteOffQueue>> splitDataByUnit(List<IWriteOffQueue> candidateQueues, HashMap<Long, String> exportUnitIdMap) {
        long l = System.currentTimeMillis();
        logger.info("logflag:\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u751f\u4ea7\u4f01\u4e1a\uff09 splitDataByUnit start");
        ArrayList<Map<String, IWriteOffQueue>> splitData = new ArrayList<Map<String, IWriteOffQueue>>(4);
        Object rimUnitProp = null;
        Object simUnitProp = null;
        for (IWriteOffQueue candidateQueue : candidateQueues) {
            LinkedHashMap<String, IWriteOffQueue> map = new LinkedHashMap<String, IWriteOffQueue>();
            while (!candidateQueue.isEmpty()) {
                WriteOffObjectBase poll = candidateQueue.poll();
                String billType = this.getBillType(poll);
                String unitName = null;
                if ("tdm_export_declaration".equals(billType)) {
                    unitName = (String)poll.getValue(this.entrySourceUnitCol + ".name");
                    Long id = (Long)poll.getValue(this.entrySourceUnitCol);
                    exportUnitIdMap.putIfAbsent(id, unitName);
                } else if ("sim_vatinvoice".equals(billType)) {
                    unitName = (String)poll.getValue("unit");
                }
                if (unitName == null) continue;
                IWriteOffQueue orDefault = map.getOrDefault(unitName, new WriteOffObjectQueue());
                orDefault.add(poll);
                map.put(unitName, orDefault);
            }
            splitData.add(map);
        }
        logger.info("logflag:\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u751f\u4ea7\u4f01\u4e1a\uff09 splitDataByUnit end,cost:{}ms", (Object)(System.currentTimeMillis() - l));
        return splitData;
    }

    @Override
    public boolean isCompleted(List<IWriteOffQueue> candidateQueues) {
        for (IWriteOffQueue candidateQueue : candidateQueues) {
            if (!candidateQueue.isEmpty()) continue;
            logger.info("logflag:\u4e0d\u5b58\u5728\u53ef\u914d\u5bf9\u7684\u6838\u9500\u5bf9\u8c61");
            return true;
        }
        logger.debug("logflag:\u5b58\u5728\u53ef\u914d\u5bf9\u7684\u6838\u9500\u5bf9\u8c61");
        return false;
    }

    @Override
    public List<IWriteOffQueue> pickWriteOffObjects(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> candidateQueues) {
        return null;
    }

    private IWriteOffQueue pollQueue(IWriteOffQueue candidateQueue, boolean isWhole, BigDecimal needWriteOffNumber, Map<String, BigDecimal> rateMap, IDataEntityProperty simIdProp) {
        String billType = this.getBillType(candidateQueue);
        IWriteOffQueue writeOffQueue = new WriteOffObjectQueue();
        if (StringUtils.isNotEmpty((String)billType)) {
            if ("tdm_export_declaration".equals(billType)) {
                writeOffQueue = candidateQueue.pollQueue(isWhole, needWriteOffNumber);
            } else if ("sim_vatinvoice".equals(billType)) {
                BigDecimal queueWfNumber = BigDecimal.ZERO;
                while (!candidateQueue.isEmpty() || queueWfNumber.compareTo(needWriteOffNumber) < 0) {
                    WriteOffObjectBase poll = candidateQueue.poll();
                    Long id = (Long)simIdProp.getValueFast((Object)poll.getWriteOffObject());
                    BigDecimal unitRate = rateMap.get(billType + id);
                    BigDecimal originalNumber = WriteOffObjectManager.getLogicWriteOffNumber(poll);
                    BigDecimal canWONumber = originalNumber.multiply(unitRate);
                    BigDecimal temp = queueWfNumber.add(canWONumber);
                    if (temp.compareTo(needWriteOffNumber) > 0) {
                        BigDecimal lastNeed = needWriteOffNumber.subtract(queueWfNumber);
                        BigDecimal planWriteOffNumber = lastNeed.divide(unitRate, 10, 4);
                        BigDecimal returnWriteOffNumber = originalNumber.subtract(planWriteOffNumber);
                        WriteOffObjectBase planWriteOffObject = poll.clone();
                        WriteOffObjectManager.setLogicWriteOffNumber(planWriteOffObject, planWriteOffNumber);
                        writeOffQueue.add(planWriteOffObject);
                        WriteOffObjectManager.setLogicWriteOffNumberNotAss(poll, returnWriteOffNumber, planWriteOffObject.getWriteOffValues());
                        candidateQueue.add(poll);
                        break;
                    }
                    poll.setWfComplete(true);
                    writeOffQueue.add(poll);
                    queueWfNumber = temp;
                }
            }
        }
        return writeOffQueue;
    }

    private List<IWriteOffQueue> pickDiffUnitWriteOffObjects(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> candidateQueues, boolean isWhole, WriteOffObjectQueue exportNoMatchQueue, WriteOffObjectQueue rimNoMatchQueue, IDataEntityProperty simUnitProp, IDataEntityProperty simIdProp) {
        long l = System.currentTimeMillis();
        logger.info("logflag:\u51fa\u53e3\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u751f\u4ea7\u4f01\u4e1a\uff09 pickWriteOffObjects start");
        ArrayList<WriteOffObjectQueue> selectedQueues = new ArrayList<WriteOffObjectQueue>(10);
        BigDecimal needWriteOffNumber = BigDecimal.valueOf(Integer.MAX_VALUE);
        BigDecimal exportWriteOffNumber = BigDecimal.valueOf(Integer.MAX_VALUE);
        BigDecimal simWrirteOffNumber = BigDecimal.ZERO;
        HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>();
        Long targetUnitId = null;
        String targetUnitName = null;
        HashMap<String, IWriteOffQueue> queuesMap = new HashMap<String, IWriteOffQueue>();
        for (IWriteOffQueue writeOffQueue : candidateQueues) {
            String string = this.getBillType(writeOffQueue);
            if (!StringUtils.isNotEmpty((String)string)) continue;
            queuesMap.put(string, writeOffQueue);
        }
        for (IWriteOffQueue candidateQueue : candidateQueues) {
            String string = this.getBillType(candidateQueue);
            WriteOffObjectQueue curCanWfQueue = new WriteOffObjectQueue();
            if (StringUtils.isNotEmpty((String)string) && "tdm_export_declaration".equals(string)) {
                WriteOffObjectBase poll = this.pollExportEntry(candidateQueue);
                if (poll != null) {
                    curCanWfQueue.add(poll);
                    targetUnitId = (Long)poll.getValue(this.entrySourceUnitCol);
                    targetUnitName = (String)poll.getValue(this.entrySourceUnitCol + ".name");
                    exportWriteOffNumber = poll.getWriteOffNumber();
                }
            } else if ("sim_vatinvoice".equals(string)) {
                long l1 = System.currentTimeMillis();
                logger.debug("logflag:\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u751f\u4ea7\u4f01\u4e1a\uff09 pickWriteOffObjects traverse {} queue start", (Object)string);
                BigDecimal queueWfSum = BigDecimal.ZERO;
                if (targetUnitId != null) {
                    WriteOffObjectQueue curNoCanWfQueue = new WriteOffObjectQueue();
                    while (candidateQueue.size() > 0 && queueWfSum.compareTo(exportWriteOffNumber) < 0) {
                        WriteOffObjectBase writeOffObjectBase = candidateQueue.peek();
                        String invoiceUnit = (String)simUnitProp.getValueFast((Object)writeOffObjectBase.getWriteOffObject());
                        BigDecimal unitRate = TaxcWriteOffUtil.getUnitRateFromCache(invoiceUnit, targetUnitName, targetUnitId);
                        if (unitRate != null) {
                            writeOffObjectBase = candidateQueue.poll();
                            BigDecimal originalNumber = WriteOffObjectManager.getLogicWriteOffNumber(writeOffObjectBase);
                            BigDecimal canWONumber = originalNumber.multiply(unitRate);
                            Long id = (Long)simIdProp.getValueFast((Object)writeOffObjectBase.getWriteOffObject());
                            rateMap.put(string + id, unitRate);
                            curCanWfQueue.add(writeOffObjectBase);
                            queueWfSum = queueWfSum.add(canWONumber);
                            continue;
                        }
                        if (StringUtils.isEmpty((String)invoiceUnit)) {
                            candidateQueue.poll();
                            continue;
                        }
                        curNoCanWfQueue.add(candidateQueue.poll());
                    }
                    candidateQueue.addAll(curNoCanWfQueue.peekAll());
                    logger.debug("logflag:\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u751f\u4ea7\u4f01\u4e1a\uff09 pickWriteOffObjects traverse {} queue end,cost:{}ms", (Object)string, (Object)(System.currentTimeMillis() - l1));
                }
                simWrirteOffNumber = queueWfSum;
            }
            selectedQueues.add(curCanWfQueue);
        }
        for (BigDecimal decimal : Arrays.asList(exportWriteOffNumber, simWrirteOffNumber)) {
            if (decimal.abs().compareTo(needWriteOffNumber.abs()) >= 0) continue;
            needWriteOffNumber = decimal;
        }
        ArrayList<IWriteOffQueue> finalQueues = new ArrayList<IWriteOffQueue>(10);
        for (IWriteOffQueue iWriteOffQueue : selectedQueues) {
            if (needWriteOffNumber.compareTo(BigDecimal.ZERO) > 0) {
                IWriteOffQueue writeOffQueue = this.pollQueue(iWriteOffQueue, isWhole, needWriteOffNumber, rateMap, simIdProp);
                finalQueues.add(writeOffQueue);
                this.reInQueue(queuesMap, rateMap, iWriteOffQueue, true, simIdProp, exportNoMatchQueue, rimNoMatchQueue);
                continue;
            }
            this.reInQueue(queuesMap, rateMap, iWriteOffQueue, true, simIdProp, exportNoMatchQueue, rimNoMatchQueue);
            finalQueues.add(new WriteOffObjectQueue());
        }
        logger.info("logflag:\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u751f\u4ea7\u4f01\u4e1a\uff09 pickWriteOffObjects end,cost:{}ms", (Object)(System.currentTimeMillis() - l));
        return finalQueues;
    }

    private WriteOffObjectBase pollExportEntry(IWriteOffQueue candidateQueue) {
        BigDecimal mylaj;
        WriteOffObjectBase poll = candidateQueue.poll();
        while (poll != null && ((mylaj = (BigDecimal)poll.getValue("mylaj")).compareTo(BigDecimal.ZERO) <= 0 || poll.getWriteOffNumber().compareTo(BigDecimal.ZERO) <= 0)) {
            poll = candidateQueue.poll();
        }
        if (poll == null) {
            this.isMylajZero = Boolean.TRUE;
        }
        return poll;
    }

    private void reInQueue(Map<String, IWriteOffQueue> queuesMap, Map<String, BigDecimal> rateMap, IWriteOffQueue restQueue, boolean recordExport, IDataEntityProperty simIdProp, WriteOffObjectQueue exportNoMatchQueue, WriteOffObjectQueue rimNoMatchQueue) {
        long l = System.currentTimeMillis();
        logger.debug("logflag:\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u751f\u4ea7\u4f01\u4e1a\uff09 pickWriteOffObjects reInQueue start");
        String billType = this.getBillType(restQueue);
        if (StringUtils.isNotEmpty((String)billType) && simIdProp != null) {
            IWriteOffQueue originalQueue = queuesMap.get(billType);
            if ("sim_vatinvoice".equals(billType)) {
                originalQueue.addAll(restQueue.peekAll());
            } else if ("rim_inv_special".equals(billType)) {
                if (recordExport) {
                    originalQueue.addAll(restQueue.peekAll());
                } else {
                    rimNoMatchQueue.addAll(restQueue.peekAll());
                }
            } else if ("tdm_export_declaration".equals(billType)) {
                if (recordExport) {
                    originalQueue.addAll(restQueue.peekAll());
                } else {
                    exportNoMatchQueue.addAll(restQueue.peekAll());
                }
            }
        }
        logger.debug("logflag:\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u751f\u4ea7\u4f01\u4e1a\uff09 pickWriteOffObjects reInQueue end,cost:{}ms", (Object)(System.currentTimeMillis() - l));
    }

    private String getBillType(IWriteOffQueue candidateQueue) {
        WriteOffObjectBase peekOne = candidateQueue.peek();
        if (peekOne != null) {
            WriteOffBillConfig writeOffBillConfig = this.getBillConfig(peekOne);
            return writeOffBillConfig.getBillType();
        }
        return null;
    }

    private String getBillType(WriteOffObjectBase peekOne) {
        WriteOffBillConfig writeOffBillConfig = this.getBillConfig(peekOne);
        return writeOffBillConfig.getBillType();
    }

    private boolean isWhole(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> writeOffQueues) {
        if ("2".equals(schemeContextConfig.getWfMode()) && (schemeContextConfig.isManualWhole() || this.queueIsWhole(writeOffQueues))) {
            return true;
        }
        if ("3".equals(schemeContextConfig.getWfMode())) {
            return false;
        }
        return schemeContextConfig.isWhole() && this.queueIsWhole(writeOffQueues);
    }

    private boolean queueIsWhole(List<IWriteOffQueue> writeOffQueues) {
        for (IWriteOffQueue writeOffQueue : writeOffQueues) {
            boolean flag = writeOffQueue.peek().getWhole();
            if (!flag) continue;
            return true;
        }
        return false;
    }

    private WriteOffBillConfig getBillConfig(WriteOffObjectBase writeOffObject) {
        return this.getTypeConfig().getBillConfigsById((Long)writeOffObject.getWfBillEntity().getPkValue());
    }

    private String getSourceUnitCol() {
        DynamicObjectCollection writeoffbillentry = this.getTypeConfig().getObj().getDynamicObjectCollection("writeoffbillentry");
        Object mappingid = ((DynamicObject)writeoffbillentry.get(0)).getDynamicObject("wfmapping").get("id");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)mappingid, (String)"sbs_billfieldmapping");
        DynamicObjectCollection colsmap = dynamicObject.getDynamicObjectCollection("colsmap");
        Optional<DynamicObject> targetbillcol = colsmap.stream().filter(a -> "entry.unit".equals(a.getString("targetobjcol"))).findFirst();
        return targetbillcol.get().getString("sourcebillcol");
    }
}

