/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.taxc;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.taxc.TaxcWriteOffUtil;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWfEndWriteBackPlugin;
import org.apache.commons.lang.StringUtils;

public class CktsThreeBillWriteBackPlugin
implements IWfEndWriteBackPlugin {
    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_WMQY_SDPP, WriteOffTypeIdConst.HXLB_WMQY_SDPP_SDP, WriteOffTypeIdConst.HXLB_SCQY);
    }

    @Override
    public Set<String> handleDbRouteKey() {
        return Collections.singleton("taxc");
    }

    @Override
    public void endWriteBack(String DBRouteKey, List<DynamicObject> records) {
        if ("taxc".equals(DBRouteKey) && records != null && records.size() > 0) {
            long wfTypeId = records.get(0).getLong("writeofftypeid.id");
            String sourceUnitCol = TaxcWriteOffUtil.getSourceUnitColByTypeId(wfTypeId);
            String sourceNumCol = TaxcWriteOffUtil.getSourceNumCol(sourceUnitCol);
            if (StringUtils.isEmpty((String)sourceNumCol)) {
                throw new KDBizException("Can't find the number of customs declaration form fields\uff01");
            }
            List collect = records.stream().filter(a -> a.getDynamicObjectCollection("entry") != null).flatMap(a -> a.getDynamicObjectCollection("entry").stream()).filter(a -> "tdm_export_declaration".equalsIgnoreCase(a.getString("billtype.id"))).collect(Collectors.toList());
            Set<Object> billid = collect.stream().collect(Collectors.groupingBy(k -> k.get("billid"))).keySet();
            DynamicObject[] exports = BusinessDataServiceHelper.load((String)"tdm_export_declaration", (String)"id,entryentity.id,entryentity.writeoffqty,entryentity.unwriteoffqty,entryentity.firstunitqty,entryentity.secondunitqty,entryentity.tradeqty", (QFilter[])new QFilter[]{new QFilter("id", "in", billid)});
            Map<Object, DynamicObject> entryMap = Arrays.stream(exports).flatMap(a -> a.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toMap(k -> k.getString("id"), v -> v, (m, n) -> m));
            Map<String, List<DynamicObject>> exportRecordGroup = collect.stream().collect(Collectors.groupingBy(k -> k.getString("billentryid")));
            for (Map.Entry<String, List<DynamicObject>> entry : exportRecordGroup.entrySet()) {
                DynamicObject dynamicObject = entryMap.get(entry.getKey());
                if (dynamicObject == null) continue;
                BigDecimal totalNum = dynamicObject.getBigDecimal(sourceNumCol);
                BigDecimal dbWriteoffqty = dynamicObject.getBigDecimal("writeoffqty");
                BigDecimal unWriteoffqty = totalNum.subtract(dbWriteoffqty);
                dynamicObject.set("unwriteoffqty", (Object)unWriteoffqty);
            }
            SaveServiceHelper.save((DynamicObject[])exports);
        }
    }
}

