/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.taxc;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscommon.writeoff.ext.taxc.LocalMemoryCacheHelper;

public class TaxcWriteOffUtil {
    public static final String TDM_EXPORT_DECLARATION = "tdm_export_declaration";
    public static final String RIM_INV_SPECIAL = "rim_inv_special";
    public static final String RIM_INV_ELECTRIC = "rim_inv_electric";
    public static final String SIM_VATINVOICE = "sim_vatinvoice";
    private static final Map<String, String> NUM_FIELD_MAP = new LinkedHashMap(){
        {
            this.put("entryentity.tradeunit", "tradeqty");
            this.put("entryentity.firstunit", "firstunitqty");
            this.put("entryentity.secondunit", "secondunitqty");
        }
    };
    public static final Map<String, String> WF_MODEL_MAP = new LinkedHashMap(){
        {
            this.put("1", "lchx");
            this.put("2", "sghx");
            this.put("3", "zdhx");
        }
    };

    public static String getSourceNumCol(Long typeBillEntryId) {
        String traceId = RequestContext.get().getTraceId();
        String key = "TempExpSourceNumCol:" + traceId + ":" + typeBillEntryId;
        LocalMemoryCache localCache = LocalMemoryCacheHelper.getLocalCache();
        String value = (String)localCache.get(key);
        if (value == null) {
            String sourceUnitCol = TaxcWriteOffUtil.getSourceUnitCol(typeBillEntryId);
            value = NUM_FIELD_MAP.get(sourceUnitCol);
            localCache.put(key, (Object)value);
        }
        return value;
    }

    public static String getSourceNumCol(String sourceUnitCol) {
        return NUM_FIELD_MAP.get(sourceUnitCol);
    }

    private static String getSourceUnitCol(Long typeBillEntryId) {
        DynamicObject typeObj = QueryServiceHelper.queryOne((String)"msmod_writeofftype", (String)"writeoffbillentry.wfmapping.id as mappingid", (QFilter[])new QFilter("writeoffbillentry.id", "=", (Object)typeBillEntryId).toArray());
        Object billfieldmappingId = typeObj.get("mappingid");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"sbs_billfieldmapping", (String)"id,colsmap.targetobjcol as targetobjcol,colsmap.sourcebillcol as sourcebillcol", (QFilter[])new QFilter("id", "=", billfieldmappingId).toArray());
        Optional<DynamicObject> targetbillcol = query.stream().filter(a -> "entry.unit".equals(a.getString("targetobjcol"))).findFirst();
        return targetbillcol.get().getString("sourcebillcol");
    }

    private static String getSourceUnitColByTypeIdFromDb(Long typeId) {
        DynamicObject writeofftype = BusinessDataServiceHelper.loadSingle((Object)typeId, (String)"msmod_writeofftype");
        DynamicObjectCollection writeoffbillentry = writeofftype.getDynamicObjectCollection("writeoffbillentry");
        Object billfieldmappingId = writeoffbillentry.stream().filter(a -> TDM_EXPORT_DECLARATION.equals(a.getString("writeoffbilltype.id"))).map(a -> a.get("wfmapping.id")).findFirst().get();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"sbs_billfieldmapping", (String)"id,colsmap.targetobjcol as targetobjcol,colsmap.sourcebillcol as sourcebillcol", (QFilter[])new QFilter("id", "=", billfieldmappingId).toArray());
        Optional<DynamicObject> targetbillcol = query.stream().filter(a -> "entry.unit".equals(a.getString("targetobjcol"))).findFirst();
        return targetbillcol.get().getString("sourcebillcol");
    }

    public static String getSourceUnitColByTypeId(Long typeId) {
        String traceId = RequestContext.get().getTraceId();
        String key = "TempSourceUnitCol:" + traceId + ":" + typeId;
        LocalMemoryCache localCache = LocalMemoryCacheHelper.getLocalCache();
        String value = (String)localCache.get(key);
        if (value == null) {
            value = TaxcWriteOffUtil.getSourceUnitColByTypeIdFromDb(typeId);
            localCache.put(key, (Object)value);
        }
        return value;
    }

    public static Object getUnitId(String invoiceUnit) {
        String traceId = RequestContext.get().getTraceId();
        String key = "TempUnitId:" + traceId + ":" + invoiceUnit;
        LocalMemoryCache localCache = LocalMemoryCacheHelper.getLocalCache();
        String value = (String)localCache.get(key);
        if (value == null) {
            DynamicObject unitBaseData = TaxcWriteOffUtil.getUnitBaseDataByName(invoiceUnit);
            if (unitBaseData == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u6ca1\u6709\u8be5\u5355\u4f4d\u201c%s\u201d\u53ef\u7528\u6570\u636e\u3002", (String)"CktsThreeBillWriteOffPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), invoiceUnit));
            }
            value = unitBaseData.getString("id");
            localCache.put(key, (Object)value);
        }
        return Long.parseLong(value);
    }

    private static DynamicObject getUnitBaseDataByName(String invoiceUnit) {
        QFilter qFilter = new QFilter("name", "=", (Object)invoiceUnit).and("enable", "=", (Object)"1").and("status", "=", (Object)"C");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_measureunits", (String)"id,name,number,precision", (QFilter[])qFilter.toArray(), (String)"modifytime desc");
        DynamicObject result = query.size() > 0 ? (DynamicObject)query.get(0) : null;
        return result;
    }

    public static BigDecimal getUnitRateFromCache(String invoiceUnit, DynamicObject unit) {
        if (StringUtils.isBlank((String)invoiceUnit)) {
            return null;
        }
        Object id = unit.get("id");
        String traceId = RequestContext.get().getTraceId();
        String key = "TempUnitRate:" + traceId + ":" + invoiceUnit + "_" + id;
        LocalMemoryCache localCache = LocalMemoryCacheHelper.getLocalCache();
        String value = (String)localCache.get(key);
        if (value == null) {
            BigDecimal result = null;
            String name = unit.getString("name");
            if (Objects.equals(name, invoiceUnit)) {
                result = BigDecimal.ONE;
            } else {
                QFilter qFilter = new QFilter("srcmuid.name", "=", (Object)invoiceUnit).and("desmuid", "=", id);
                DynamicObject measureunitconv = QueryServiceHelper.queryOne((String)"bd_measureunitconv", (String)"denominator,numerator, srcmuid.name,desmuid", (QFilter[])qFilter.toArray());
                if (measureunitconv != null) {
                    BigDecimal rate;
                    result = rate = measureunitconv.getBigDecimal("numerator").divide(measureunitconv.getBigDecimal("denominator"), 10, 4);
                } else {
                    qFilter = new QFilter("desmuid.name", "=", (Object)invoiceUnit).and("srcmuid", "=", id);
                    measureunitconv = QueryServiceHelper.queryOne((String)"bd_measureunitconv", (String)"denominator,numerator, srcmuid.name,desmuid", (QFilter[])qFilter.toArray());
                    if (measureunitconv != null) {
                        BigDecimal rate;
                        result = rate = measureunitconv.getBigDecimal("denominator").divide(measureunitconv.getBigDecimal("numerator"), 10, 4);
                    }
                }
            }
            value = result != null ? result.toPlainString() : "null";
            localCache.put(key, (Object)value);
        }
        if ("null".equals(value)) {
            return null;
        }
        return new BigDecimal(value);
    }

    public static BigDecimal getUnitRateFromCache(String invoiceUnit, String unitName, Long unitId) {
        if (StringUtils.isBlank((String)invoiceUnit)) {
            return null;
        }
        String traceId = RequestContext.get().getTraceId();
        String key = "TempUnitRate:" + traceId + ":" + invoiceUnit + "_" + unitId;
        LocalMemoryCache localCache = LocalMemoryCacheHelper.getLocalCache();
        String value = (String)localCache.get(key);
        if (value == null) {
            BigDecimal result = null;
            if (Objects.equals(unitName, invoiceUnit)) {
                result = BigDecimal.ONE;
            } else {
                QFilter qFilter = new QFilter("srcmuid.name", "=", (Object)invoiceUnit).and("desmuid", "=", (Object)unitId);
                DynamicObject measureunitconv = QueryServiceHelper.queryOne((String)"bd_measureunitconv", (String)"denominator,numerator, srcmuid.name,desmuid", (QFilter[])qFilter.toArray());
                if (measureunitconv != null) {
                    BigDecimal rate;
                    result = rate = measureunitconv.getBigDecimal("numerator").divide(measureunitconv.getBigDecimal("denominator"), 10, 4);
                } else {
                    qFilter = new QFilter("desmuid.name", "=", (Object)invoiceUnit).and("srcmuid", "=", (Object)unitId);
                    measureunitconv = QueryServiceHelper.queryOne((String)"bd_measureunitconv", (String)"denominator,numerator, srcmuid.name,desmuid", (QFilter[])qFilter.toArray());
                    if (measureunitconv != null) {
                        BigDecimal rate;
                        result = rate = measureunitconv.getBigDecimal("denominator").divide(measureunitconv.getBigDecimal("numerator"), 10, 4);
                    }
                }
            }
            value = result != null ? result.toPlainString() : "null";
            localCache.put(key, (Object)value);
        }
        if ("null".equals(value)) {
            return null;
        }
        return new BigDecimal(value);
    }
}

