/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.form;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.mscommon.writeoff.common.cols.IColsSelectStrategy;
import kd.mpscmm.mscommon.writeoff.common.consts.PropertyDataType;
import kd.mpscmm.mscommon.writeoff.common.helper.PageShowHelper;
import kd.mpscmm.mscommon.writeoff.common.util.ColsTreeUtil;
import kd.mpscmm.mscommon.writeoff.common.util.FormUtils;
import kd.mpscmm.mscommon.writeoff.common.util.WfWarnException;
import kd.mpscmm.mscommon.writeoff.form.entity.FormConditionFilter;
import kd.mpscmm.mscommon.writeoff.form.entity.FormFormula;
import kd.mpscmm.mscommon.writeoff.form.entity.FormSelectFieldKey;
import kd.mpscmm.mscommon.writeoff.lang.FormLang;

public abstract class AbstractWfFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof NewEntry) {
            NewEntry newEntry = (NewEntry)args.getSource();
            String entryKey = String.valueOf(newEntry.getParameter().get("entryId"));
            if (StringUtils.isEmpty((CharSequence)entryKey)) {
                return;
            }
            Map allEntities = this.getModel().getDataEntityType().getAllEntities();
            EntityType entityType = (EntityType)allEntities.get(entryKey);
            if (entityType instanceof SubEntryType) {
                IDataEntityType parentEntry = ((SubEntryType)entityType).getParent();
                int pFocusIndex = ((EntryGrid)this.getControl(parentEntry.getName())).getEntryState().getFocusRow();
                String parentEntryDisName = parentEntry.getDisplayName().getLocaleValue();
                if (pFocusIndex == -1) {
                    throw new WfWarnException(FormLang.plsParentEntrySelect(parentEntryDisName));
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (FormConditionFilter formCondition : this.getFormConditions()) {
            this.addClickListeners(new String[]{formCondition.getCondtionKey()});
        }
        for (FormFormula formula : this.getFormulaField()) {
            this.addClickListeners(new String[]{formula.getFormulaKey()});
        }
        for (FormSelectFieldKey fieldKey : this.getSelectFieldKey()) {
            this.addClickListeners(new String[]{fieldKey.getFieldName()});
        }
    }

    protected String presetKey() {
        return null;
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        String presetKey = this.presetKey();
        if (StringUtils.isNotEmpty((CharSequence)presetKey)) {
            this.getModel().setValue(presetKey, (Object)Boolean.FALSE);
        }
    }

    public void addF7Listener(String ... f7Name) {
        this.addF7Listener(this, f7Name);
    }

    public void addF7Listener(BeforeF7SelectListener listener, String ... f7Name) {
        FormUtils.addF7Listener(listener, this, f7Name);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        block3: {
            try {
                QFilter filter = this.buildF7SelectFilter(event.getProperty().getName(), event);
                if (filter != null) {
                    ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                    showParameter.getListFilterParameter().setFilter(filter);
                }
            }
            catch (KDBizException e) {
                event.setCancel(true);
                if (event.getSourceMethod().equals("setItemByNumber")) break block3;
                this.getView().showTipNotification(e.getMessage());
            }
        }
    }

    protected QFilter buildF7SelectFilter(String key, BeforeF7SelectEvent event) {
        return null;
    }

    protected Object getValue(String key) {
        Object value = this.getModel().getValue(key);
        if (value == null) {
            this.keyNoValue(key);
        }
        return value;
    }

    protected String getStrValue(String key) {
        String value = (String)this.getModel().getValue(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.keyNoValue(key);
        }
        return value;
    }

    protected Object getValue(String key, int index) {
        Object value = this.getModel().getValue(key, index);
        if (value == null) {
            this.entryKetNoValue(key, index);
        }
        return value;
    }

    protected String getStrValue(String key, int index) {
        String value = (String)this.getModel().getValue(key, index);
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.entryKetNoValue(key, index);
        }
        return value;
    }

    private void entryKetNoValue(String key, int index) {
        MainEntityType entityType = this.getModel().getDataEntityType();
        IDataEntityProperty findProperty = entityType.findProperty(key);
        throw new WfWarnException(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165%s\u3002", (String)"AbstractWfFormPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), findProperty.getDisplayName().getLocaleValue()));
    }

    private void keyNoValue(String key) {
        MainEntityType entityType = this.getModel().getDataEntityType();
        IDataEntityProperty findProperty = entityType.findProperty(key);
        throw new WfWarnException(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165%s\u3002", (String)"AbstractWfFormPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), findProperty.getDisplayName().getLocaleValue()));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        for (FormConditionFilter formCondition : this.getFormConditions()) {
            if (!fieldName.equals(formCondition.getCondtionKey())) continue;
            this.changeConditionField(e, formCondition);
        }
        for (FormFormula formula : this.getFormulaField()) {
            if (!fieldName.equals(formula.getFormulaKey())) continue;
            this.changeFormula(e, formula);
        }
        for (FormSelectFieldKey fieldKey : this.getSelectFieldKey()) {
            if (!fieldName.equals(fieldKey.getFieldName())) continue;
            this.changeFieldName(e, fieldKey);
        }
    }

    public void click(EventObject evt) {
        try {
            super.click(evt);
            Control source = (Control)evt.getSource();
            String fieldKey = source.getKey();
            for (FormConditionFilter formCondition : this.getFormConditions()) {
                if (!fieldKey.equals(formCondition.getCondtionKey())) continue;
                this.clickFilterCondition(formCondition);
            }
            for (FormFormula formula : this.getFormulaField()) {
                if (!fieldKey.equals(formula.getFormulaKey())) continue;
                this.clickFormula(formula);
            }
            for (FormSelectFieldKey selectfieldKey : this.getSelectFieldKey()) {
                if (!fieldKey.equals(selectfieldKey.getFieldName())) continue;
                this.clickFieldKey(selectfieldKey);
            }
        }
        catch (WfWarnException e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        for (FormConditionFilter formCondition : this.getFormConditions()) {
            if (!actionId.equals(formCondition.getCondtionDescTagKey())) continue;
            this.callBackSetFilterCdit((String)e.getReturnData(), formCondition);
        }
        for (FormFormula formula : this.getFormulaField()) {
            if (!actionId.equals(formula.getFormulaKey())) continue;
            this.callBackFormula((String)e.getReturnData(), formula);
        }
        for (FormSelectFieldKey selectfieldKey : this.getSelectFieldKey()) {
            if (!actionId.equals(selectfieldKey.getFieldName())) continue;
            this.callBackSelectFieldKey(ColsTreeUtil.parseReturnData(e), selectfieldKey);
        }
    }

    protected List<FormConditionFilter> getFormConditions() {
        return Collections.emptyList();
    }

    private void clickFilterCondition(FormConditionFilter formCondition) {
        this.beforeShowFilterPage(formCondition);
        int entryCurrRow = this.getModel().getEntryCurrentRowIndex(formCondition.getEntryKey());
        DynamicObject wfBillAlias = (DynamicObject)this.getValue(formCondition.getWfBillAliasKey(), entryCurrRow);
        String wfBillTypeNum = null;
        IDataEntityType entityType = wfBillAlias.getDataEntityType();
        wfBillTypeNum = "bos_billmainentity".equals(entityType.getName()) ? wfBillAlias.getString("number") : wfBillAlias.getString("wfbill.number");
        PageShowHelper.showEntryFieldFilterForm((AbstractFormPlugin)this, this.getModel(), wfBillTypeNum, entryCurrRow, formCondition.getCondtionDescTagKey(), formCondition.getCondtionDescTagKey(), formCondition.isShowHighCondition());
    }

    protected void beforeShowFilterPage(FormConditionFilter formCondition) {
    }

    private void callBackSetFilterCdit(String returnData, FormConditionFilter formCondition) {
        String exprTran;
        if (returnData == null) {
            return;
        }
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
        String entityNumCache = this.getPageCache().get("entitynumbercachekey");
        int entryRow = Integer.parseInt(this.getPageCache().get("entryrowindex"));
        FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumCache), condition.getFilterCondition());
        filterBuilder.buildFilter(false);
        IDataModel model = this.getModel();
        String string = exprTran = condition.getExprTran() == null ? "" : condition.getExprTran();
        if (StringUtils.isEmpty((CharSequence)exprTran)) {
            model.setValue(formCondition.getCondtionKey(), (Object)"", entryRow);
            model.setValue(formCondition.getCondtionDescKey(), (Object)"", entryRow);
            model.setValue(formCondition.getCondtionDescTagKey(), (Object)"", entryRow);
        } else {
            String destValueShow = exprTran.length() >= 255 ? exprTran.substring(0, 252) + "..." : exprTran;
            model.setValue(formCondition.getCondtionKey(), (Object)destValueShow, entryRow);
            model.setValue(formCondition.getCondtionDescKey(), (Object)"", entryRow);
            model.setValue(formCondition.getCondtionDescTagKey(), (Object)returnData, entryRow);
        }
    }

    private void changeConditionField(PropertyChangedArgs e, FormConditionFilter formCondition) {
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        for (ChangeData data : changeSet) {
            if (!StringUtils.isEmpty((CharSequence)String.valueOf(data.getNewValue()))) continue;
            model.setValue(formCondition.getCondtionDescKey(), (Object)"", data.getRowIndex());
            model.setValue(formCondition.getCondtionDescTagKey(), (Object)"", data.getRowIndex());
        }
    }

    protected List<FormSelectFieldKey> getSelectFieldKey() {
        return Collections.emptyList();
    }

    private void clickFieldKey(FormSelectFieldKey fieldKey) {
        this.beforeClickFieldKey(fieldKey);
        IDataModel model = this.getModel();
        DynamicObject wfBillType = null;
        String billAliasEntryKey = fieldKey.getBillAliasEntryKey();
        if (StringUtils.isEmpty((CharSequence)billAliasEntryKey)) {
            wfBillType = (DynamicObject)this.getValue(fieldKey.getWfBillAliasKey());
        } else {
            int billentry = model.getEntryCurrentRowIndex(billAliasEntryKey);
            wfBillType = (DynamicObject)this.getValue(fieldKey.getWfBillAliasKey(), billentry);
        }
        int index = model.getEntryCurrentRowIndex(fieldKey.getEntryKey());
        if (wfBillType == null) {
            return;
        }
        IDataEntityType entityType = wfBillType.getDataEntityType();
        String wfBillTypeNum = null;
        wfBillTypeNum = "bos_billmainentity".equals(entityType.getName()) ? wfBillType.getString("number") : wfBillType.getString("wfbill.number");
        PropertyDataType[] filterDataProp = fieldKey.getFilterDataProp();
        IColsSelectStrategy strategy = this.getSelectStrategy(fieldKey);
        if (fieldKey.isShowId()) {
            PageShowHelper.showSubEColsTree3Page(this, wfBillTypeNum, strategy, fieldKey.getFieldName(), index, Collections.emptyList(), new IDataEntityProperty[0]);
        } else {
            PageShowHelper.showSubEColsTreePage(this, wfBillTypeNum, strategy, fieldKey.getFieldName(), index, null, filterDataProp);
        }
    }

    protected void beforeClickFieldKey(FormSelectFieldKey fieldKey) {
    }

    protected IColsSelectStrategy getSelectStrategy(FormSelectFieldKey fieldKey) {
        return null;
    }

    private void callBackSelectFieldKey(JSONArray returnData, FormSelectFieldKey selectfieldKey) {
        if (returnData == null || returnData.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        JSONObject dataJson = JSONObject.parseObject((String)returnData.get(0).toString());
        int index = model.getEntryCurrentRowIndex(selectfieldKey.getEntryKey());
        model.setValue(selectfieldKey.getFieldName(), dataJson.get((Object)"text"), index);
        model.setValue(selectfieldKey.getFieldKey(), dataJson.get((Object)"id"), index);
    }

    private void changeFieldName(PropertyChangedArgs e, FormSelectFieldKey fieldKey) {
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        for (ChangeData data : changeSet) {
            if (!StringUtils.isEmpty((CharSequence)String.valueOf(data.getNewValue()))) continue;
            model.setValue(fieldKey.getFieldKey(), (Object)"", data.getRowIndex());
        }
    }

    protected List<FormFormula> getFormulaField() {
        return Collections.emptyList();
    }

    private void clickFormula(FormFormula formula) {
        int index = this.getModel().getEntryCurrentRowIndex(formula.getEntryKey());
        DynamicObject wfBillType = (DynamicObject)this.getValue(formula.getWfBillAliasKey(), index);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)wfBillType.getString("wfbill.number"));
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(dataEntityType);
        String formulaJson = (String)this.getModel().getValue(formula.getFormulaTextTagKey(), index);
        TreeNode billTreeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
        String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getCustomParams().put("formula", formulaJson);
        showParameter.getCustomParams().put("entitynumber", dataEntityType.getName());
        showParameter.getCustomParams().put("treenodes", fldNodes);
        showParameter.setFormId("botp_formula");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formula.getFormulaKey()));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void callBackFormula(String result, FormFormula formula) {
        if (result == null) {
            return;
        }
        CRCondition formulaStr = (CRCondition)SerializationUtils.fromJsonString((String)result, CRCondition.class);
        int row = this.getModel().getEntryCurrentRowIndex(formula.getEntryKey());
        if (formulaStr != null) {
            String exprTran = formulaStr.getExpression();
            String destValueShow = exprTran.length() >= 255 ? exprTran.substring(0, 252) + "..." : exprTran;
            this.getModel().setValue(formula.getFormulaTextTagKey(), (Object)result, row);
            this.getModel().setValue(formula.getFormulaTextKey(), (Object)destValueShow, row);
            this.getModel().setValue(formula.getFormulaKey(), (Object)formulaStr.getExprDesc(), row);
        }
    }

    private void changeFormula(PropertyChangedArgs e, FormFormula formula) {
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        model.beginInit();
        for (ChangeData data : changeSet) {
            if (!StringUtils.isEmpty((CharSequence)String.valueOf(data.getNewValue()))) continue;
            model.setValue(formula.getFormulaTextKey(), (Object)"", data.getRowIndex());
            model.setValue(formula.getFormulaTextTagKey(), (Object)"", data.getRowIndex());
        }
        model.endInit();
        this.getView().updateView(formula.getEntryKey());
    }
}

