/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.writeoff.form.AbstractWfFormPlugin;

public abstract class AbstractWfTypeBaseDataPlugin
extends AbstractWfFormPlugin
implements IBillPlugin {
    public void afterCreateNewData(EventObject e) {
        Object wftypeId = this.getView().getFormShowParameter().getCustomParams().get("wftypeid");
        if (wftypeId != null) {
            this.getModel().setItemValueByID(this.writeOffTypeKey(), wftypeId);
        }
        super.afterCreateNewData(e);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        if (fieldName.equals(this.writeOffTypeKey())) {
            ChangeData[] valueSet = e.getChangeSet();
            this.writeoffTypeChanged(valueSet[0].getOldValue(), valueSet[0].getNewValue());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent msgBoxClosedEvent) {
        super.confirmCallBack(msgBoxClosedEvent);
        String callBackId = msgBoxClosedEvent.getCallBackId();
        MessageBoxResult result = msgBoxClosedEvent.getResult();
        switch (callBackId) {
            case "SchemeConst_writeofftypeconfirmCB": {
                this.confirmWriteoffTypeCB(result);
                break;
            }
        }
    }

    protected String writeOffTypeKey() {
        return "writeofftype";
    }

    protected final List<Object> getAllWriteOffTypeBillAlias() {
        return this.getWriteOffTypeBillAlias(false);
    }

    protected final List<Object> getWriteOffTypeBillAlias() {
        return this.getWriteOffTypeBillAlias(true);
    }

    private List<Object> getWriteOffTypeBillAlias(boolean excludeAutoGen) {
        DynamicObject writeOffType = (DynamicObject)this.getValue(this.writeOffTypeKey());
        QFilter qFilter = new QFilter("id", "=", writeOffType.getPkValue());
        DynamicObject wfTypeEntity = BusinessDataServiceHelper.loadSingleFromCache((String)"msmod_writeofftype", (String)"writeoffbillentry.wfbillalias,writeoffbillentry.isautogenerate", (QFilter[])qFilter.toArray());
        DynamicObjectCollection wfBills = wfTypeEntity.getDynamicObjectCollection("writeoffbillentry");
        ArrayList<Object> ids = new ArrayList<Object>(16);
        for (DynamicObject wfBill : wfBills) {
            DynamicObject alias = wfBill.getDynamicObject("wfbillalias");
            boolean isAuto = wfBill.getBoolean("isautogenerate");
            if (excludeAutoGen && isAuto || alias == null) continue;
            ids.add(alias.getPkValue());
        }
        return ids;
    }

    private void writeoffTypeChanged(Object oldValue, Object newValue) {
        if (oldValue != null) {
            Long pkValue = (Long)((DynamicObject)oldValue).getPkValue();
            if (newValue != null && this.notPopWriteOffChange((DynamicObject)oldValue, (DynamicObject)newValue)) {
                return;
            }
            IPageCache pagecache = this.getPageCache();
            pagecache.put("SchemeConst_writeofftypeconfirmCB", String.valueOf(pkValue));
            String isUnCditMtConfmMsg = ResManager.loadKDString((String)"\u6838\u9500\u7c7b\u522b\u5207\u6362\u5c06\u6e05\u9664\u9875\u9762\u5df2\u7ef4\u62a4\u5206\u5f55\u7684\u6240\u6709\u4fe1\u606f\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"SchemeEditPlugin_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("SchemeConst_writeofftypeconfirmCB", (IFormPlugin)this);
            this.getView().showConfirm(isUnCditMtConfmMsg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, null, "");
        } else {
            this.changeWriteOffType((DynamicObject)newValue);
        }
    }

    protected boolean notPopWriteOffChange(DynamicObject oldValue, DynamicObject newValue) {
        return false;
    }

    protected void changeWriteOffType(DynamicObject newValue) {
    }

    private void confirmWriteoffTypeCB(MessageBoxResult result) {
        if (result.equals((Object)MessageBoxResult.Yes)) {
            this.clearWriteOffType();
        } else {
            String oldValue = this.getPageCache().get("SchemeConst_writeofftypeconfirmCB");
            this.getModel().beginInit();
            this.getModel().setValue("writeofftype", (Object)oldValue);
            this.getView().updateView("writeofftype");
            this.getModel().endInit();
        }
    }

    protected abstract void clearWriteOffType();

    protected boolean isFeeShare() {
        DynamicObject writeOffType = (DynamicObject)this.getModel().getValue("writeofftype");
        return writeOffType != null && !"B".equals(writeOffType.getString("writeofftype"));
    }
}

