/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.writeoff.form.AbstractWfFormPlugin;
import kd.mpscmm.mscommon.writeoff.form.entity.FormSelectFieldKey;
import org.apache.commons.lang.StringUtils;

public class LoadBillFieldEdit
extends AbstractWfFormPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"reffield"});
    }

    @Override
    protected List<FormSelectFieldKey> getSelectFieldKey() {
        FormSelectFieldKey selectFieldKey = FormSelectFieldKey.build("billentity", "entryentity", "fieldname", "fieldkey");
        selectFieldKey.setBillAliasEntryKey(null);
        return Collections.singletonList(selectFieldKey);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        if ("reffield".equals(fieldKey)) {
            this.clickRefField();
        }
    }

    private void clickRefField() {
        ArrayList combitems;
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("entryentity");
        String[] fieldKey = this.getStrValue("fieldkey", index).split("\\.");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)((DynamicObject)this.getValue("billentity")).getString("number"));
        IDataEntityProperty property = entityType.findProperty(fieldKey[fieldKey.length - 1]);
        if (property instanceof BasedataProp) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)((BasedataProp)property).getBaseEntityId());
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            combitems = new ArrayList(properties.size());
            for (IDataEntityProperty item : properties) {
                HashMap<String, String> values = new HashMap<String, String>(3);
                if (item.getDisplayName() == null || item instanceof DynamicCollectionProperty) continue;
                values.put("Name", item.getDisplayName().getLocaleValue());
                values.put("Value", item.getName());
                combitems.add(values);
            }
        } else {
            throw new KDBizException("plsSelectBaseDataProp");
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ide_comboitemsselect");
        showParameter.getCustomParams().put("comboProp", combitems);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectRefField"));
        this.getView().showForm(showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        switch (e.getActionId()) {
            case "selectRefField": {
                this.setRefFieldInfo(e);
                break;
            }
        }
    }

    private void setRefFieldInfo(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        Map results = (Map)SerializationUtils.fromJsonString((String)((String)returnData), Map.class);
        String expression = (String)results.get("expression");
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (StringUtils.isNotEmpty((String)expression)) {
            this.getModel().setValue("reffield", (Object)expression, index);
        } else {
            this.getModel().setValue("reffield", null, index);
        }
    }
}

