/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.form;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.mpscmm.mscommon.writeoff.common.cols.IColsSelectStrategy;
import kd.mpscmm.mscommon.writeoff.common.cols.SimpleStrategy;
import kd.mpscmm.mscommon.writeoff.common.consts.PropertyDataType;
import kd.mpscmm.mscommon.writeoff.common.consts.SelectParams;
import kd.mpscmm.mscommon.writeoff.common.helper.MetaHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.PageShowHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.PresetHelper;
import kd.mpscmm.mscommon.writeoff.common.trans.FieldFormTranslator;
import kd.mpscmm.mscommon.writeoff.common.util.ColsTreeUtil;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.common.util.FormUtils;
import kd.mpscmm.mscommon.writeoff.form.AbstractWfFormPlugin;
import org.apache.commons.collections.CollectionUtils;

public class ReWriteRuleEditPlugin
extends AbstractWfFormPlugin
implements HyperLinkClickListener,
IBillPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"rewtfield"});
        this.addClickListeners(new String[]{"wffield"});
        this.addClickListeners(new String[]{"calformula"});
        this.addClickListeners(new String[]{"rewtfieldname", "wfbillfieldname"});
        this.addF7Listener(this, "alias", "wfbill");
        Toolbar toolbar1 = (Toolbar)this.getControl("advcontoolbarap3");
        toolbar1.addItemClickListener((ItemClickListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap1", "advcontoolbarap2", "advcontoolbarap3"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if ("deleteentryone".equals(key)) {
            PresetHelper.presetEntryRowDeleteCheck(view, model, evt, "rewritebillentity", "rwbeispreset");
        } else if ("deleteentrythree".equals(key)) {
            PresetHelper.presetEntryRowDeleteCheck(view, model, evt, "rewtformulentity", "rwfeispreset");
        } else if ("deleteentrytwo".equals(key)) {
            PresetHelper.presetEntryRowDeleteCheck(view, model, evt, "rewtmatchentity", "rwmeispreset");
        }
    }

    @Override
    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("ispreset", (Object)Boolean.FALSE);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String name = this.getModel().getDataEntity().getDataEntityType().getName();
        boolean refrenced = BaseDataRefrenceHelper.isRefrenced((String)name, (Object)this.getModel().getDataEntity().getPkValue());
        if (refrenced) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", "name", "writeofftype"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"newentry", "deleteentry"});
        }
    }

    public void afterLoadData(EventObject e) {
        this.translateInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void translateInfo() {
        IDataModel model = this.getModel();
        try {
            DynamicObject recordBill;
            FieldFormTranslator translator = FieldFormTranslator.create(this.getModel());
            translator.entryToSubEntryTranslate("rewritebillentity", "alias", "rewtformulentity", "rewtfieldnum", "rewtfield");
            DynamicObject writeoffType = this.getModel().getDataEntity().getDynamicObject("writeofftype");
            if (writeoffType != null && (recordBill = writeoffType.getDynamicObject("writeoffrecordbill")) != null) {
                String number = recordBill.getString("number");
                translator.headToSubEntryTranslate(number, "rewritebillentity", "rewtformulentity", "wffieldnum", "wffield");
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        finally {
            model.setDataChanged(false);
        }
    }

    @Override
    protected QFilter buildF7SelectFilter(String key, BeforeF7SelectEvent e) {
        String proName;
        super.buildF7SelectFilter(key, e);
        switch (proName = e.getProperty().getName()) {
            case "alias": {
                return this.getAliasqFilter(e);
            }
            case "wfbill": {
                return this.getWfBillqFilter();
            }
        }
        return null;
    }

    private QFilter getWfBillqFilter() {
        DynamicObject wfType = (DynamicObject)this.getValue("writeofftype");
        String numbe = wfType.getString("number");
        return new QFilter("writeofftypenumber", "=", (Object)numbe);
    }

    private QFilter getAliasqFilter(BeforeF7SelectEvent e) {
        DynamicObject wfType = (DynamicObject)this.getModel().getValue("writeofftype");
        if (wfType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u6838\u9500\u7c7b\u522b\u3002", (String)"ReWriteRuleEditPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            e.setCancel(true);
            return null;
        }
        QFilter qFilter = new QFilter("id", "=", wfType.getPkValue());
        DynamicObject wfTypeEntity = BusinessDataServiceHelper.loadSingleFromCache((String)"msmod_writeofftype", (String)"writeoffbillentry.wfbillalias", (QFilter[])qFilter.toArray());
        DynamicObjectCollection wfBills = wfTypeEntity.getDynamicObjectCollection("writeoffbillentry");
        ArrayList<Object> ids = new ArrayList<Object>(16);
        for (DynamicObject wfBill : wfBills) {
            DynamicObject alias = wfBill.getDynamicObject("wfbillalias");
            ids.add(alias.getPkValue());
        }
        return new QFilter("id", "in", ids);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData changeSet = e.getChangeSet()[0];
        Object oldValue = changeSet.getOldValue();
        Object newValue = changeSet.getNewValue();
        int rowIndex = changeSet.getRowIndex();
        switch (proName) {
            case "writeofftype": {
                this.writeoffTypeChanged(oldValue, newValue);
                break;
            }
            case "selectval": {
                this.selectValueChanged(rowIndex);
                break;
            }
            case "rewtfield": {
                this.billFieldChanged("rewtfield", rowIndex);
                break;
            }
            case "wffield": {
                this.billFieldChanged("wffield", rowIndex);
                break;
            }
            case "alias": {
                this.billFieldChanged("alias", rowIndex);
                break;
            }
            case "rewtbill": {
                this.billFieldChanged("rewtbill", rowIndex);
                break;
            }
            case "rewtfieldname": {
                this.billFieldChanged("rewtfieldname", rowIndex);
                break;
            }
            case "wfbillfieldname": {
                this.billFieldChanged("wfbillfieldname", rowIndex);
                break;
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = FormUtils.getOpKey(args)) {
            case "newentrythree": {
                IDataModel model = this.getModel();
                int parentindex = model.getEntryCurrentRowIndex("rewritebillentity");
                Object alias = model.getValue("alias", parentindex);
                if (alias != null) break;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53cd\u5199\u5355\u636e\u5206\u5f55\u4e2d\u6838\u9500\u5355\u636e\u6807\u8bc6\u5b57\u6bb5\u3002", (String)"ReWriteRuleEditPlugin_6", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if ("rewtformulentity".equals(entryName)) {
            this.formulAddRowDeal(e);
        } else if ("rewtmatchentity".equals(entryName)) {
            this.matchAddRowDeal();
        }
    }

    private void matchAddRowDeal() {
        int entryRowIndex = this.getModel().getEntryCurrentRowIndex("rewritebillentity");
        DynamicObject reBill = (DynamicObject)this.getModel().getValue("alias", entryRowIndex);
        if (reBill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f53\u524d\u884c\u6838\u9500\u5355\u636e\u6807\u8bc6\u3002", (String)"ReWriteRuleEditPlugin_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
    }

    private void formulAddRowDeal(AfterAddRowEventArgs e) {
        RowDataEntity[] rows;
        int entryRowIndex = this.getModel().getEntryCurrentRowIndex("rewritebillentity");
        DynamicObject reBill = (DynamicObject)this.getModel().getValue("alias", entryRowIndex);
        if (reBill == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f53\u524d\u884c\u6838\u9500\u5355\u636e\u6807\u8bc6\u3002", (String)"ReWriteRuleEditPlugin_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            return;
        }
        DynamicObject wfBillNumber = reBill.getDynamicObject("wfbill");
        for (RowDataEntity row : rows = e.getRowDataEntities()) {
            int rowIndex = row.getRowIndex();
            this.getModel().setValue("subrewtbill", wfBillNumber.getPkValue(), rowIndex);
        }
    }

    private void billFieldChanged(String field, int rowIndex) {
        Object value = this.getModel().getValue(field, rowIndex);
        if ("rewtfield".equals(field)) {
            if (value == null || "".equals(value)) {
                this.getModel().setValue("rewtfieldnum", null, rowIndex);
            }
        } else if ("wffield".equals(field)) {
            if (value == null || "".equals(value)) {
                this.getModel().setValue("wffieldnum", null, rowIndex);
            }
        } else if ("rewtfieldname".equals(field)) {
            if (StringUtils.isEmpty((CharSequence)((String)value))) {
                this.getModel().setValue("refieldnum", null, rowIndex);
            }
        } else if ("wfbillfieldname".equals(field)) {
            if (StringUtils.isEmpty((CharSequence)((String)value))) {
                this.getModel().setValue("wfbillfieldnum", null, rowIndex);
            }
        } else if ("rewtbill".equals(field)) {
            this.clearEntry(rowIndex);
            if (value == null) {
                this.getModel().setValue("alias", null, rowIndex);
            } else {
                DynamicObject wfBill = (DynamicObject)value;
                String billNumber = wfBill.getString("number");
                DynamicObject wfType = (DynamicObject)this.getModel().getValue("writeofftype");
                if (wfType == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u6838\u9500\u7c7b\u522b\u3002", (String)"ReWriteRuleEditPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
                }
                String number = wfType.getString("number");
                QFilter qFilter = new QFilter("writeofftypenumber", "=", (Object)number);
                qFilter.and("wfbill", "=", (Object)billNumber);
                List msmodBillType = QueryServiceHelper.queryPrimaryKeys((String)"msmod_billtype", (QFilter[])qFilter.toArray(), null, (int)-1);
                if (CollectionUtils.isNotEmpty((Collection)msmodBillType)) {
                    this.getModel().setValue("alias", msmodBillType.get(0), rowIndex);
                }
            }
        } else if ("alias".equals(field)) {
            this.clearEntry(rowIndex);
        }
    }

    private void clearEntry(int rowIndex) {
        DynamicObject reBill = this.getModel().getEntryRowEntity("rewritebillentity", rowIndex);
        DynamicObjectCollection match = reBill.getDynamicObjectCollection("rewtmatchentity");
        match.clear();
        DynamicObjectCollection formul = reBill.getDynamicObjectCollection("rewtformulentity");
        formul.clear();
        this.getView().updateView("rewritebillentity");
    }

    private void selectValueChanged(int rowIndex) {
        this.getModel().setValue("wffield", null, rowIndex);
        this.getModel().setValue("calformula", null, rowIndex);
        this.getModel().setValue("wffieldnum", null, rowIndex);
        this.getModel().setValue("calformudesc_tag", null, rowIndex);
    }

    private void writeoffTypeChanged(Object oldValue, Object newValue) {
        if (oldValue != null) {
            boolean wfBillIsSame;
            if (newValue != null && (wfBillIsSame = CommonUtils.judgeWfBillIsSame((DynamicObject)oldValue, (DynamicObject)newValue))) {
                return;
            }
            Long pkValue = (Long)((DynamicObject)oldValue).getPkValue();
            IPageCache pagecache = this.getPageCache();
            pagecache.put("MatchRuleConst_writeofftypeconfirmCB", String.valueOf(pkValue));
            String isUnCditMtConfmMsg = ResManager.loadKDString((String)"\u6838\u9500\u7c7b\u522b\u5207\u6362\u5c06\u6e05\u9664\u9875\u9762\u5df2\u7ef4\u62a4\u5206\u5f55\u7684\u6240\u6709\u4fe1\u606f\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"MatchRuleEditPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("MatchRuleConst_writeofftypeconfirmCB", (IFormPlugin)this);
            this.getView().showConfirm(isUnCditMtConfmMsg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, null, "");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent msgBoxClosedEvent) {
        super.confirmCallBack(msgBoxClosedEvent);
        String callBackId = msgBoxClosedEvent.getCallBackId();
        MessageBoxResult result = msgBoxClosedEvent.getResult();
        switch (callBackId) {
            case "MatchRuleConst_writeofftypeconfirmCB": {
                this.confirmWriteoffTypeCB(result);
                break;
            }
        }
    }

    private void confirmWriteoffTypeCB(MessageBoxResult result) {
        if (result.equals((Object)MessageBoxResult.Yes)) {
            this.getModel().setValue("description", null);
            this.getView().updateView("description");
            this.getModel().deleteEntryData("rewritebillentity");
            this.getModel().deleteEntryData("rewtformulentity");
            this.getModel().deleteEntryData("rewtmatchentity");
        } else {
            String oldValue = this.getPageCache().get("MatchRuleConst_writeofftypeconfirmCB");
            this.getModel().beginInit();
            this.getModel().setValue("writeofftype", (Object)oldValue);
            this.getView().updateView("writeofftype");
            this.getModel().endInit();
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "rewtfield": {
                this.clickFieldName(evt);
                break;
            }
            case "calformula": {
                this.clickFormula(evt);
                break;
            }
            case "wffield": {
                this.clickWriteoffField(evt);
                break;
            }
            case "rewtfieldname": {
                int parentIndex = this.getModel().getEntryCurrentRowIndex("rewritebillentity");
                int currSubIndex = this.getModel().getEntryCurrentRowIndex("rewtmatchentity");
                this.clickSubRewtBillFieldName(key, parentIndex, currSubIndex);
                break;
            }
            case "wfbillfieldname": {
                this.clickSubWfBillFieldName();
                break;
            }
        }
    }

    private void clickSubWfBillFieldName() {
        int currSubIndex = this.getModel().getEntryCurrentRowIndex("rewtmatchentity");
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("rewritebillentity");
        DynamicObject value = (DynamicObject)this.getModel().getValue("wfbill", currSubIndex);
        if (value == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u9500\u5355\u636e\u3002", (String)"ReWriteRuleEditPlugin_7", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            return;
        }
        String billType = value.getDynamicObject("wfbill").getString("number");
        DynamicObject reBill = (DynamicObject)this.getModel().getValue("rewtbill", currentRowIndex);
        String reFieldNum = (String)this.getModel().getValue("refieldnum", currSubIndex);
        if (StringUtils.isEmpty((CharSequence)reFieldNum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53cd\u5199\u5355\u636e\u5b57\u6bb5\u3002", (String)"ReWriteRuleEditPlugin_3", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            return;
        }
        IDataEntityProperty property = this.getBillFieldProp(reBill.getString("number"), reFieldNum);
        if (property == null) {
            this.clickFieldName(billType, "wfbillfieldname", currSubIndex, null, new IDataEntityProperty[0]);
        } else {
            String[] field = reFieldNum.split("\\.");
            String suffField = field[field.length - 1];
            if ("id".equals(suffField) || "seq".equals(suffField)) {
                this.clickFieldName(billType, "wfbillfieldname", currSubIndex, null, new IDataEntityProperty[0]);
            } else {
                this.clickFieldName(billType, "wfbillfieldname", currSubIndex, null, property);
            }
        }
    }

    private IDataEntityProperty getBillFieldProp(String billType, String fieldName) {
        if (StringUtils.isEmpty((CharSequence)billType) || StringUtils.isEmpty((CharSequence)fieldName)) {
            return null;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
        String[] field = fieldName.split("\\.");
        IDataEntityProperty property = dataEntityType.findProperty(field[field.length - 1]);
        return property;
    }

    private void clickSubRewtBillFieldName(String fieldNameKey, int parentIndex, int currSubIndex) {
        IDataModel model = this.getModel();
        Object srcBillType = model.getValue("alias", parentIndex);
        if (srcBillType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f53\u524d\u884c\u6838\u9500\u5355\u636e\u6807\u8bc6\u3002", (String)"ReWriteRuleEditPlugin_4", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection matchCditSubEntry = this.getModel().getEntryEntity("rewtmatchentity");
        ArrayList<String> list = new ArrayList<String>();
        for (DynamicObject entry : matchCditSubEntry) {
            String fieldKey = entry.getString("refieldnum");
            list.add(fieldKey);
        }
        String billType = ((DynamicObject)srcBillType).getDynamicObject("wfbill").getString("number");
        this.clickFieldName(billType, fieldNameKey, currSubIndex, list, new IDataEntityProperty[0]);
    }

    private void clickWriteoffField(EventObject evt) {
        DynamicObject writeoffType = this.getModel().getDataEntity().getDynamicObject("writeofftype");
        if (writeoffType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u9500\u7c7b\u522b\u3002", (String)"ReWriteRuleEditPlugin_2", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        DynamicObject recordBill = writeoffType.getDynamicObject("writeoffrecordbill");
        if (recordBill != null) {
            String number = recordBill.getString("number");
            this.showColsTreePage(number, null, null, "wffield");
        }
    }

    private void clickFormula(EventObject evt) {
        DynamicObject writeoffType = this.getModel().getDataEntity().getDynamicObject("writeofftype");
        if (writeoffType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u6838\u9500\u7c7b\u522b\u3002", (String)"ReWriteRuleEditPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        DynamicObject recordBill = writeoffType.getDynamicObject("writeoffrecordbill");
        if (recordBill != null) {
            this.showSelectFieldForm(recordBill.getString("number"), "calformula");
        }
    }

    private void clickFieldName(EventObject evt) {
        DynamicObject targetObj = (DynamicObject)this.getModel().getValue("subrewtbill");
        if (targetObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f53\u524d\u884c\u53cd\u5199\u5355\u636e\u3002", (String)"ReWriteRuleEditPlugin_5", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            return;
        }
        this.showColsTreePage(targetObj.getString("number"), null, null, "rewtfield");
    }

    private void clickFieldName(String billType, String fieldName, int currSubIndex, List<String> filterFields, IDataEntityProperty ... properties) {
        if (StringUtils.isEmpty((CharSequence)billType)) {
            return;
        }
        if (filterFields == null) {
            filterFields = new ArrayList<String>(1);
        }
        PageShowHelper.showSubEColsTree3Page(this, billType, null, fieldName, currSubIndex, filterFields, properties);
    }

    private void showColsTreePage(String entityNumber, String entryKey, IColsSelectStrategy strategy, String key) {
        IColsSelectStrategy selectStrategy = strategy;
        if (selectStrategy == null) {
            selectStrategy = new SimpleStrategy();
        }
        SelectParams params = new SelectParams();
        MetaHelper metaHelper = new MetaHelper(selectStrategy, entityNumber);
        String jsonTree = metaHelper.buildTree2JSON(entryKey, new PropertyDataType[0]);
        params.setJsonTree(jsonTree);
        FormShowParameter fp = FormUtils.readyColsTreePage(params, new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(fp);
    }

    private void showSelectFieldForm(String entryName, String key) {
        int row = this.getModel().getEntryCurrentRowIndex("rewtformulentity");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entryName);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(dataEntityType);
        String formulaJson = (String)this.getModel().getValue("calformudesc_tag", row);
        TreeNode billTreeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
        String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getCustomParams().put("formula", formulaJson);
        showParameter.getCustomParams().put("entitynumber", dataEntityType.getName());
        showParameter.getCustomParams().put("treenodes", fldNodes);
        showParameter.setFormId("botp_formula");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String key = e.getActionId();
        Object returnData = e.getReturnData();
        switch (key) {
            case "rewtfield": 
            case "wffield": {
                this.callBackFieldName(e, key);
                break;
            }
            case "calformula": {
                this.callBackFormula(returnData);
                break;
            }
            case "rewtfieldname": {
                this.callBackBillField(e, key, "refieldnum");
                break;
            }
            case "wfbillfieldname": {
                this.callBackBillField(e, key, "wfbillfieldnum");
                break;
            }
        }
    }

    private void callBackBillField(ClosedCallBackEvent e, String fieldName, String fieldKey) {
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONObject dataJson = JSONObject.parseObject((String)data.get(0).toString());
        int currSubIndex = Integer.parseInt(this.getPageCache().get("subindex"));
        this.getModel().setValue(fieldName, dataJson.get((Object)"text"), currSubIndex);
        this.getModel().setValue(fieldKey, dataJson.get((Object)"id"), currSubIndex);
        this.getView().updateView("rewtmatchentity");
    }

    private void handleValues(JSONObject dataJson, String fieldName, String fieldKey, int currSubIndex) {
        IDataModel model = this.getModel();
        int parentIndex = model.getEntryCurrentRowIndex("matchrelateentry");
        DynamicObject parentDy = (DynamicObject)model.getEntryEntity("matchrelateentry").get(parentIndex);
        DynamicObject subDy = (DynamicObject)parentDy.getDynamicObjectCollection("matchcditsubentry").get(currSubIndex);
        subDy.set(fieldName, dataJson.get((Object)"text"));
        subDy.set(fieldKey, dataJson.get((Object)"id"));
        subDy.set("comparison", (Object)"=");
        this.getView().updateView("matchcditsubentry");
    }

    private void callBackFormula(Object returnData) {
        if (returnData == null) {
            return;
        }
        String result = returnData.toString();
        CRCondition formula = (CRCondition)SerializationUtils.fromJsonString((String)result, CRCondition.class);
        int row = this.getModel().getEntryCurrentRowIndex("rewtformulentity");
        if (formula != null) {
            this.getModel().setValue("calformudesc_tag", (Object)result, row);
            this.getModel().setValue("calformula", (Object)formula.getExprDesc(), row);
        }
    }

    private void callBackFieldName(ClosedCallBackEvent e, String filedName) {
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONObject dataJson = JSONObject.parseObject((String)data.get(0).toString());
        this.getModel().setValue(filedName, dataJson.get((Object)"text"));
        if (filedName.equals("rewtfield")) {
            this.getModel().setValue("rewtfieldnum", dataJson.get((Object)"id"));
        } else if (filedName.equals("wffield")) {
            this.getModel().setValue("wffieldnum", dataJson.get((Object)"id"));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        int index = e.getRowIndex();
        this.getModel().setValue("calformula", null, index);
        this.getModel().setValue("calformudesc_tag", null, index);
    }
}

