/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.util.FormUtils;

public class WfRecordGroupEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String algoKey = WfRecordGroupEditPlugin.class.getName();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, "billtype", "wftype");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setCombItems();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("ispreset", (Object)Boolean.FALSE);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName;
        super.propertyChanged(e);
        switch (proName = e.getProperty().getName()) {
            case "wftype": {
                this.writeoffTypeChanged();
                break;
            }
        }
    }

    private void writeoffTypeChanged() {
        this.getModel().setValue("billtype", null);
        this.getModel().setValue("groupfield", null);
        this.setCombItems();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "billtype": {
                this.wfBillTypeF7Select(showParameter, e);
                break;
            }
            case "wftype": {
                this.wfTypeF7Select(showParameter, e);
                break;
            }
        }
    }

    private void wfTypeF7Select(ListShowParameter showParameter, BeforeF7SelectEvent e) {
        String sql = "select   a.fnumber   from t_meta_formdesign  a  where a.finheritpath in (select  b.fid from t_meta_formdesign b where  b.fnumber in ('msmod_updownwfrecordtpl','msmod_updownamounttpl'))";
        DataSet data = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.meta, (String)sql);
        ArrayList<String> list = new ArrayList<String>(16);
        while (data.hasNext()) {
            String billType = data.next().getString("fnumber");
            list.add(billType);
        }
        QFilter filter = new QFilter("writeoffrecordbill", "in", list);
        filter.and("enable", "=", (Object)"1");
        showParameter.getListFilterParameter().setFilter(filter);
    }

    private void wfBillTypeF7Select(ListShowParameter showParameter, BeforeF7SelectEvent e) {
        DynamicObject wfType = (DynamicObject)this.getModel().getValue("wftype");
        if (wfType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u9500\u7c7b\u522b\u3002", (String)"WfRecordGroupEditPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("id", "=", wfType.getPkValue());
        DynamicObject wfTypeEntity = BusinessDataServiceHelper.loadSingleFromCache((String)"msmod_writeofftype", (String)"writeoffbillentry.wfbillalias", (QFilter[])qFilter.toArray());
        DynamicObjectCollection wfBills = wfTypeEntity.getDynamicObjectCollection("writeoffbillentry");
        ArrayList<Object> ids = new ArrayList<Object>(16);
        for (DynamicObject wfBill : wfBills) {
            DynamicObject alias = wfBill.getDynamicObject("wfbillalias");
            ids.add(alias.getPkValue());
        }
        QFilter wfBillQFilter = new QFilter("id", "in", ids);
        showParameter.getListFilterParameter().setFilter(wfBillQFilter);
    }

    private void setCombItems() {
        DynamicObject wfType = (DynamicObject)this.getModel().getValue("wftype");
        ComboEdit srcBillType = (ComboEdit)this.getView().getControl("groupfield");
        srcBillType.setComboItems(new ArrayList(1));
        if (wfType == null) {
            return;
        }
        DynamicObject wfRecord = wfType.getDynamicObject("writeoffrecordbill");
        if (wfRecord == null) {
            return;
        }
        String number = wfRecord.getString("number");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)number);
        Map allEntities = dataEntityType.getAllEntities();
        EntityType entry = (EntityType)allEntities.get("entry");
        Map propertyMap = entry.getFields();
        Collection entityTypes = propertyMap.values();
        ArrayList<ComboItem> opItems = new ArrayList<ComboItem>(32);
        for (IDataEntityProperty entityType : entityTypes) {
            String name = entityType.getName();
            Boolean filter = "wfinfo".equals(name) || "mainwfinfo".equals(name) || "asswfinfo".equals(name);
            if (filter.booleanValue()) continue;
            opItems.add(new ComboItem(entityType.getDisplayName(), name));
        }
        srcBillType.setComboItems(opItems);
    }
}

