/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.kdtx.common.constant.ActionType;
import kd.bos.kdtx.common.constant.TriggerType;
import kd.bos.kdtx.common.constant.TxOperationResult;
import kd.bos.kdtx.common.entity.TxLogInfo;
import kd.bos.kdtx.sdk.api.KdtxBusinessHelper;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.mscommon.writeoff.business.config.manager.WriteOffParamManager;
import kd.mpscmm.mscommon.writeoff.common.helper.PageShowHelper;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.form.AbstractWfFormPlugin;

public class WriteOffNlogEdit
extends AbstractWfFormPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.wfOpComboItems();
        this.showKDTXParam();
    }

    private void showKDTXParam() {
        WriteOffParamManager manager = WriteOffParamManager.create();
        this.getView().setVisible(Boolean.valueOf(manager.isLogKdtxParam()), new String[]{"reqinfo"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key = e.getOperateKey();
        if (key.equals("detailcondition")) {
            this.showMatchCondition();
        } else if (key.equals("showkdtxmsg")) {
            this.showKdtxMsg();
        } else if (key.equals("retry")) {
            this.kdtxRetry();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "querywriteoffrecord": {
                this.showWriteOffRecord();
                break;
            }
            case "querykdtxbiz": {
                this.showWriteOffBussiness();
                break;
            }
        }
    }

    private void wfOpComboItems() {
        DynamicObject value = (DynamicObject)this.getModel().getValue("srcbillentity");
        if (value != null) {
            ArrayList<ComboItem> operationItems = new ArrayList<ComboItem>(16);
            String formId = value.getString("number");
            List ops = EntityMetadataCache.getDataEntityOperate((String)formId);
            for (Map op : ops) {
                String opKey = (String)op.get("key");
                operationItems.add(new ComboItem(LocaleString.fromMap((Map)((Map)op.get("name"))), opKey));
            }
            ComboEdit woffEdit = (ComboEdit)this.getView().getControl("operate");
            woffEdit.setComboItems(operationItems);
        }
    }

    private void kdtxRetry() {
        int currentRowInde = this.getModel().getEntryCurrentRowIndex("entryentity");
        String taskstatus = ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(currentRowInde)).get("taskstatus").toString();
        if (!taskstatus.equals("S")) {
            Object businessid = ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(currentRowInde)).get("businessid");
            if (businessid == null || "".equals(businessid)) {
                return;
            }
            DynamicObject wftype = (DynamicObject)this.getValue("wftype");
            if ("B".equals(wftype.getString("writeofftype"))) {
                KdtxBusinessHelper.manuallyRetry((String)"msmod_feeshare", (String)businessid.toString());
            } else {
                KdtxBusinessHelper.manuallyRetry((String)"msmod_writeoff", (String)businessid.toString());
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u91cd\u65b0\u53d1\u8d77\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"WriteOffNlogEdit_TASK_RETRY_SUCESS", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u65e0\u9700\u91cd\u8bd5\u3002", (String)"WriteOffNlogEdit_NO_TASK_RETRY", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
    }

    private void showKdtxMsg() {
        int currentRowInde = this.getModel().getEntryCurrentRowIndex("entryentity");
        Object businessid = ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(currentRowInde)).get("businessid");
        if (businessid == null || "".equals(businessid)) {
            return;
        }
        List msg = KdtxBusinessHelper.queryTxLogInfo((String)"msmod_writeoff", (String)businessid.toString());
        String markDownStr = this.buildMarkDownStr(msg);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msmod_kdtxlog");
        showParameter.getCustomParams().put("mdlog", markDownStr);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private String buildMarkDownStr(List<TxLogInfo> msg) {
        StringBuilder sb = new StringBuilder();
        String txdesc = ResManager.loadKDString((String)"\u4e8b\u52a1\u573a\u666f\u63cf\u8ff0", (String)"WriteOffNLogInfo_txdesc", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
        String actiontype = ResManager.loadKDString((String)"\u4e8b\u52a1\u64cd\u4f5c\u9636\u6bb5", (String)"WriteOffNLogInfo_actiontype", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
        String branchdesc = ResManager.loadKDString((String)"\u5206\u652f\u4e8b\u52a1\u573a\u666f", (String)"WriteOffNLogInfo_branchdesc", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
        String tiggertype = ResManager.loadKDString((String)"\u89e6\u53d1\u65b9\u5f0f", (String)"WriteOffNLogInfo_tiggertype", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
        String txrs = ResManager.loadKDString((String)"\u4e8b\u52a1\u7ed3\u679c", (String)"WriteOffNLogInfo_txrs", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
        String createtime = ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4", (String)"WriteOffNLogInfo_createtime", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
        String endertime = ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4", (String)"WriteOffNLogInfo_endertime", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
        sb.append(txdesc).append("|").append(actiontype).append("|").append(branchdesc).append("|").append(tiggertype).append("|").append(txrs).append("|").append(createtime).append("|").append(endertime).append("\n");
        sb.append("----").append("|").append("----").append("|").append("----").append("|").append("----").append("|").append("----").append("|").append("----").append("|").append("----").append("\n");
        for (TxLogInfo txLogInfo : msg) {
            sb.append(txLogInfo.getTxDesc()).append("|");
            sb.append(ActionType.get((int)txLogInfo.getActionType()).getName()).append("|");
            sb.append(txLogInfo.getBranchDesc() == null ? "" : txLogInfo.getBranchDesc()).append("|");
            sb.append(TriggerType.get((int)Integer.parseInt(txLogInfo.getTriggerType())).getName()).append("|");
            sb.append(TxOperationResult.get((int)txLogInfo.getResult()).getName()).append("|");
            sb.append(CommonUtils.getDateString2(txLogInfo.getCreateTime())).append("|");
            sb.append(CommonUtils.getDateString2(txLogInfo.getUpdatedTime())).append("\n");
        }
        return sb.toString();
    }

    private void showMatchCondition() {
        int currentRowInde = this.getModel().getEntryCurrentRowIndex("entryentity1");
        Object logInfo = ((DynamicObject)this.getModel().getEntryEntity("entryentity1").get(currentRowInde)).get("matchcondition_tag");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msmod_matchcondition");
        showParameter.getCustomParams().put("mdlog", logInfo);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showWriteOffRecord() {
        DynamicObject wftype = (DynamicObject)this.getValue("wftype");
        DynamicObject wfRecordObj = wftype.getDynamicObject("writeoffrecordbill");
        String wfRecordEntity = wfRecordObj.getString("number");
        String wfSeq = (String)this.getValue("wfseq");
        ListShowParameter listParam = PageShowHelper.getBaseDataListParam(wfRecordEntity, new QFilter("wfseq", "=", (Object)wfSeq).and("writeofftypeid", "=", wftype.getPkValue()));
        this.getView().showForm((FormShowParameter)listParam);
    }

    private void showWriteOffBussiness() {
        String traceId = (String)this.getValue("traceid");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msmod_kdtxbiz_info");
        showParameter.getCustomParams().put("traceid", traceId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }
}

