/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.cols.ExcludeFieldStrategy;
import kd.mpscmm.mscommon.writeoff.common.cols.IColsSelectStrategy;
import kd.mpscmm.mscommon.writeoff.common.helper.BotpPushHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.PresetHelper;
import kd.mpscmm.mscommon.writeoff.common.trans.CRConditionFormTranslator;
import kd.mpscmm.mscommon.writeoff.common.trans.FieldFormTranslator;
import kd.mpscmm.mscommon.writeoff.common.util.FormUtils;
import kd.mpscmm.mscommon.writeoff.form.AbstractWfFormPlugin;
import kd.mpscmm.mscommon.writeoff.form.entity.FormConditionFilter;
import kd.mpscmm.mscommon.writeoff.form.entity.FormSelectFieldKey;
import kd.mpscmm.mscommon.writeoff.lang.FormLang;
import org.apache.commons.collections.CollectionUtils;

public class WriteOffTypeEditPlugin
extends AbstractWfFormPlugin
implements RowClickEventListener,
IBillPlugin {
    private static final String algoKey = WriteOffTypeEditPlugin.class.getName();

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"buttonap"});
        FormUtils.addF7Listener((BeforeF7SelectListener)this, "botprule", "writeoffrecordbill", "wfmapping", "rbwfmapping", "wfbillalias", "srcbilltype", "targetbilltype");
        EntryGrid wfEntryGrid = (EntryGrid)this.getControl("writeoffbillentry");
        wfEntryGrid.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap1", "advcontoolbarap2"});
        BotpPushHelper.showConvertRuleEdit(this.getView(), "botprule");
    }

    @Override
    protected String presetKey() {
        return "ispreset";
    }

    public void afterLoadData(EventObject e) {
        this.translateInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void translateInfo() {
        IDataModel model = this.getModel();
        try {
            FieldFormTranslator translator = FieldFormTranslator.create(this.getModel());
            translator.entryToSubEntryTranslate("writeoffbillentry", "wfbillalias", "wffieldsubentry", "writeofffieldkey", "writeofffieldname");
            translator.entryToEntryTranslate("writeoffbillentry", "wfbillalias", "wholefieldkey", "wholefieldname");
            CRConditionFormTranslator crTranslator = CRConditionFormTranslator.create(this.getModel());
            crTranslator.entryToEntryTranslate("writeoffbillentry", "wfbillalias", "filterconditiondesc_tag", "filterconditionview");
            crTranslator.entryToEntryTranslate("writeoffbillentry", "wfbillalias", "cfilterconditiondesc_tag", "cfilterconditionview");
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        finally {
            model.setDataChanged(false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setFeeShareAndMainShareVisiable();
        this.setSubEntryFieldEnable();
        this.lockMainShare();
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = FormUtils.getOpKey(e)) {
            case "newentry": 
            case "deleteentry": {
                EntryGrid wfBillEntry = (EntryGrid)this.getControl("writeoffbillentry");
                int billEntryFocusIndex = wfBillEntry.getEntryState().getFocusRow();
                if (-1 == billEntryFocusIndex) break;
                this.setSubEntryEnable(billEntryFocusIndex);
                this.setSubEntryFieldEnable();
                break;
            }
            case "newentry_sub": 
            case "deleteentry_sub": {
                EntryGrid wfBillSubEntry = (EntryGrid)this.getControl("wffieldsubentry");
                int subEntryFocusIndex = wfBillSubEntry.getEntryState().getFocusRow();
                if (-1 == subEntryFocusIndex) break;
                this.setEnableByValueMethod(subEntryFocusIndex);
                break;
            }
        }
    }

    private void checkBeforeNewSubE(BeforeDoOperationEventArgs args, IDataModel model, IFormView view) {
        EntryGrid matchRelateGrid = (EntryGrid)this.getControl("writeoffbillentry");
        int pFocusIndex = matchRelateGrid.getEntryState().getFocusRow();
        if (pFocusIndex == -1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u9500\u5355\u636e\u5206\u5f55\u884c\u3002", (String)"WriteOffTypeEditPluginNotSelEntryRow", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData changeSet = e.getChangeSet()[0];
        int rowIndex = changeSet.getRowIndex();
        switch (proName) {
            case "writeofftype": {
                this.writeOffTypeChange();
                break;
            }
            case "valuemethod": {
                this.valueMethodChange(rowIndex);
                this.setEnableByValueMethod(rowIndex);
                break;
            }
            case "writeoffbilltype": {
                this.clearWFBillEntryRow(rowIndex);
                this.initEntryRow(rowIndex);
                break;
            }
            case "srcbilltype": {
                this.billTypeChanged(rowIndex);
                break;
            }
            case "targetbilltype": {
                this.billTypeChanged(rowIndex);
                this.getModel().setValue("isdeletefilter", null, rowIndex);
                this.getModel().setValue("isdeletefilterdesc_tag", null, rowIndex);
                break;
            }
            case "isautogenerate": {
                this.isAutoGeneChanged(rowIndex);
                break;
            }
            case "writeoffcalcfield": {
                this.mainFieldChanged(e);
                break;
            }
            case "calculationrule": {
                this.calRuleFieldChanged(e);
                break;
            }
            case "isinvolved": {
                this.isInvolvedChanged(rowIndex);
                this.setSubEntryEnable(rowIndex);
                break;
            }
            case "writeoffrecordbill": {
                this.wfRecordChanged();
                break;
            }
            case "wfbillalias": {
                this.writeoffAliasChanged(rowIndex);
                break;
            }
            case "ismainshare": {
                this.isManShare(changeSet, rowIndex);
                break;
            }
        }
    }

    private void isManShare(ChangeData changeSet, int rowIndex) {
        this.lockMainShare();
        this.setSubEntryEnable(rowIndex);
        if (!((Boolean)changeSet.getNewValue()).booleanValue()) {
            this.getModel().deleteEntryData("wffieldsubentry");
        } else {
            for (int i = 0; i < this.getModel().getEntryEntity("writeoffbillentry").size(); ++i) {
                if (i == rowIndex) continue;
                DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("writeoffbillentry").get(i);
                entry.set("wffieldsubentry", null);
            }
        }
    }

    private void writeoffAliasChanged(int rowIndex) {
        DynamicObject alias = (DynamicObject)this.getModel().getValue("wfbillalias", rowIndex);
        if (alias == null) {
            this.getModel().setValue("writeoffbilltype", null, rowIndex);
        } else {
            DynamicObject wfBill = alias.getDynamicObject("wfbill");
            this.getModel().setValue("writeoffbilltype", (Object)wfBill, rowIndex);
        }
    }

    private void wfRecordChanged() {
        IDataModel model = this.getModel();
        DynamicObject wfRecord = (DynamicObject)model.getValue("writeoffrecordbill");
        DynamicObjectCollection entryEntity = model.getEntryEntity("writeoffbillentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject wfBill = (DynamicObject)model.getValue("writeoffbilltype", i);
            List<Object> wfRecordMapping = this.getWfRecordMapping(wfRecord, wfBill);
            if (CollectionUtils.isNotEmpty(wfRecordMapping) && wfRecordMapping.size() == 1) {
                model.setValue("wfmapping", wfRecordMapping.get(0), i);
                continue;
            }
            model.setValue("wfmapping", null, i);
        }
        this.getView().updateView("writeoffbillentry");
    }

    private void isInvolvedChanged(int rowIndex) {
        IDataModel model = this.getModel();
        boolean isinvolved = (Boolean)model.getValue("isinvolved", rowIndex);
        if (!isinvolved) {
            DynamicObject wfBillEntry = model.getEntryRowEntity("writeoffbillentry", rowIndex);
            DynamicObjectCollection wfFieldSubEntry = wfBillEntry.getDynamicObjectCollection("wffieldsubentry");
            wfFieldSubEntry.clear();
            this.getView().updateView("wffieldsubentry");
        }
    }

    private void calRuleFieldChanged(PropertyChangedArgs e) {
        boolean calRule;
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (newValue instanceof Boolean && (calRule = ((Boolean)newValue).booleanValue())) {
            int curRowIndex = this.getModel().getEntryCurrentRowIndex("wffieldsubentry");
            this.getModel().setValue("writeoffcalcfield", (Object)Boolean.TRUE, curRowIndex);
        }
    }

    private void writeOffTypeChange() {
        this.setFeeShareAndMainShareVisiable();
        DynamicObjectCollection wfBillEntryCollection = this.getModel().getEntryEntity("writeoffbillentry");
        for (DynamicObject wfBillEntry : wfBillEntryCollection) {
            wfBillEntry.set("ismainshare", (Object)0);
            DynamicObjectCollection entries = wfBillEntry.getDynamicObjectCollection("wffieldsubentry");
            for (DynamicObject entry : entries) {
                entry.set("calculationrule", (Object)wfBillEntryCollection);
            }
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"wffieldsubentry", "newentry_sub", "deleteentry_sub"});
        this.getView().updateView("writeoffbillentry");
        this.getView().updateView("wffieldsubentry");
    }

    private void setFeeShareAndMainShareVisiable() {
        IDataModel model = this.getModel();
        String writeoffType = (String)model.getValue("writeofftype");
        model.setValue("isfeeshare", (Object)0);
        this.getView().setVisible(Boolean.TRUE, new String[]{"isfeeshare", "ismainshare"});
        if ("B".equals(writeoffType)) {
            model.setValue("isfeeshare", (Object)1);
            this.getView().setVisible(Boolean.FALSE, new String[]{"isfeeshare"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ismainshare"});
        }
    }

    private void setSubEntryEnable(int rowIndex) {
        boolean result;
        IDataModel model = this.getModel();
        this.getView().setEnable(Boolean.TRUE, new String[]{"wffieldsubentry", "newentry_sub", "deleteentry_sub"});
        Boolean isMainShere = (Boolean)model.getValue("ismainshare", rowIndex);
        Boolean isInvolved = (Boolean)model.getValue("isinvolved", rowIndex);
        String writeoffType = (String)model.getValue("writeofftype");
        boolean bl = result = (isMainShere == null || isMainShere == false) && "B".equals(writeoffType) || isInvolved == null || isInvolved == false;
        if (result) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"wffieldsubentry", "newentry_sub", "deleteentry_sub"});
        }
    }

    private void valueMethodChange(int rowIndex) {
        IDataModel model = this.getModel();
        model.setValue("wffieldplugin", null, rowIndex);
        model.setValue("writeofffieldname", null, rowIndex);
        model.setValue("writeofffieldkey", null, rowIndex);
    }

    private void setEnableByValueMethod(int rowIndex) {
        String valueMethod;
        IDataModel model = this.getModel();
        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"wffieldplugin", "writeofffieldname"});
        switch (valueMethod = (String)model.getValue("valuemethod", rowIndex)) {
            case "A": {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"writeofffieldname"});
                break;
            }
            case "C": {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"wffieldplugin"});
                break;
            }
        }
    }

    private void setSubEntryFieldEnable() {
        DynamicObjectCollection wffieldsubentry = this.getModel().getEntryEntity("wffieldsubentry");
        if (wffieldsubentry == null) {
            return;
        }
        for (int subRowIndex = 0; subRowIndex < wffieldsubentry.size(); ++subRowIndex) {
            this.setEnableByValueMethod(subRowIndex);
        }
    }

    private void initEntryRow(int rowIndex) {
        DynamicObject record = (DynamicObject)this.getModel().getValue("writeoffrecordbill");
        DynamicObject writeoffBillType = (DynamicObject)this.getModel().getValue("writeoffbilltype", rowIndex);
        if (writeoffBillType == null) {
            this.getModel().setValue("writeoffbillname", null, rowIndex);
            this.getModel().setValue("writeoffbillnumber", null, rowIndex);
        } else {
            String billName = writeoffBillType.getString("name");
            String billNumber = writeoffBillType.getString("number");
            this.getModel().setValue("writeoffbillname", (Object)billName, rowIndex);
            this.getModel().setValue("writeoffbillnumber", (Object)billNumber, rowIndex);
        }
        List<Object> wfRecordMapping = this.getWfRecordMapping(record, writeoffBillType);
        if (CollectionUtils.isNotEmpty(wfRecordMapping) && wfRecordMapping.size() == 1) {
            this.getModel().setValue("wfmapping", wfRecordMapping.get(0), rowIndex);
        } else {
            this.getModel().setValue("wfmapping", null, rowIndex);
        }
        this.getView().updateView("writeoffbillentry", rowIndex);
    }

    private List<Object> getWfRecordMapping(DynamicObject record, DynamicObject wfBill) {
        if (record == null || wfBill == null) {
            return new ArrayList<Object>();
        }
        QFilter qFilter = new QFilter("targetobj", "=", record.getPkValue());
        qFilter.and("sourcebill", "=", wfBill.getPkValue());
        qFilter.and("isenable", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.queryPrimaryKeys((String)"sbs_billfieldmapping", (QFilter[])qFilter.toArray(), null, (int)-1);
    }

    private void mainFieldChanged(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (newValue instanceof Boolean) {
            boolean isMainFieldJob = (Boolean)newValue;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("wffieldsubentry");
            int rowCount = entryEntity.size();
            int curRowIndex = this.getModel().getEntryCurrentRowIndex("wffieldsubentry");
            if (isMainFieldJob) {
                this.getView().setEnable(Boolean.TRUE, curRowIndex, new String[]{"calculationrule"});
                for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    if (curRowIndex == rowIndex) continue;
                    DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("wffieldsubentry", rowIndex);
                    this.getModel().beginInit();
                    entryRowEntity.set("writeoffcalcfield", (Object)Boolean.FALSE);
                    entryRowEntity.set("calculationrule", (Object)Boolean.FALSE);
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"calculationrule"});
                    this.getModel().endInit();
                    this.getView().updateView("writeoffcalcfield", rowIndex);
                    this.getView().updateView("calculationrule", rowIndex);
                }
            } else {
                this.getModel().setValue("calculationrule", (Object)Boolean.FALSE, curRowIndex);
            }
        }
    }

    private void isAutoGeneChanged(int rowIndex) {
        IDataModel model = this.getModel();
        boolean isAutoGenerate = (Boolean)model.getValue("isautogenerate", rowIndex);
        if (isAutoGenerate) {
            this.getModel().setValue("filterconditiondesc_tag", (Object)"", rowIndex);
            this.getModel().setValue("filterconditionview", (Object)"", rowIndex);
            this.getModel().setValue("cfilterconditiondesc_tag", (Object)"", rowIndex);
            this.getModel().setValue("cfilterconditionview", (Object)"", rowIndex);
        }
    }

    private void billTypeChanged(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject srcBillType = (DynamicObject)model.getValue("srcbilltype", rowIndex);
        DynamicObject targetBillType = (DynamicObject)model.getValue("targetbilltype", rowIndex);
        if (srcBillType == null || targetBillType == null) {
            this.getModel().setValue("botprule", null, rowIndex);
            return;
        }
        HashSet<String> botpNumSet = new HashSet<String>(16);
        int entryRowCount = model.getEntryRowCount("autogenebillentry");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject botpRuleObj;
            if (i == rowIndex || (botpRuleObj = (DynamicObject)model.getValue("botprule", i)) == null) continue;
            String botpNumber = botpRuleObj.getString("number");
            botpNumSet.add(botpNumber);
        }
        String srcBlTypeNum = this.findBillNum(srcBillType);
        String targetBlTypeNum = this.findBillNum(targetBillType);
        QFilter botpFilter = new QFilter("sourceentitynumber.number", "=", (Object)srcBlTypeNum);
        botpFilter.and("targetentitynumber.number", "=", (Object)targetBlTypeNum);
        botpFilter.and("number", "not in", botpNumSet);
        botpFilter.and("enabled", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection botpObjs = QueryServiceHelper.query((String)"botp_crlist", (String)"id", (QFilter[])botpFilter.toArray());
        if (botpObjs == null || botpObjs.size() == 0 || botpObjs.size() > 1) {
            this.getModel().setValue("botprule", null, rowIndex);
            return;
        }
        Long destBotpId = ((DynamicObject)botpObjs.get(0)).getLong("id");
        this.getModel().setValue("botprule", (Object)destBotpId, rowIndex);
    }

    private String findBillNum(DynamicObject wfBillType) {
        return wfBillType.getDynamicObject("wfbill").getString("number");
    }

    private void clearWFBillEntryRow(int rowIndex) {
        IDataModel model = this.getModel();
        model.setValue("filterconditiondesc_tag", (Object)"", rowIndex);
        model.setValue("filterconditionview", (Object)"", rowIndex);
        model.setValue("cfilterconditiondesc_tag", (Object)"", rowIndex);
        model.setValue("cfilterconditionview", (Object)"", rowIndex);
        model.setValue("isautogenerate", (Object)Boolean.FALSE, rowIndex);
        model.setValue("isinvolved", (Object)Boolean.TRUE, rowIndex);
        model.setValue("wholefieldname", (Object)"", rowIndex);
        model.setValue("wholefieldkey", (Object)"", rowIndex);
        DynamicObject writeOffBillEntry = model.getEntryRowEntity("writeoffbillentry", rowIndex);
        DynamicObjectCollection wfFieldSubEntry = writeOffBillEntry.getDynamicObjectCollection("wffieldsubentry");
        wfFieldSubEntry.clear();
        this.getView().updateView("writeoffbillentry");
        this.lockMainShare();
    }

    public void entryRowClick(RowClickEvent e) {
        Control control = (Control)e.getSource();
        int rowIndex = e.getRow();
        if ("writeoffbillentry".equals(control.getKey())) {
            this.setSubEntryEnable(rowIndex);
            this.setSubEntryFieldEnable();
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if ("deleteentry_a".equals(key)) {
            PresetHelper.presetEntryRowDeleteCheck(view, model, evt, "autogenebillentry", "wfbeispreset");
        } else if ("deleteentryplugin".equals(key)) {
            PresetHelper.presetEntryRowDeleteCheck(view, model, evt, "pluginentity", "peispreset");
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String proName = e.getProperty().getName();
        int rowIndex = e.getRow();
        switch (proName) {
            case "writeoffrecordbill": {
                this.beforeF7WfRecordBill(e);
                break;
            }
            case "botprule": {
                this.beforeF7BotpRule(e, rowIndex);
                break;
            }
            case "wfmapping": 
            case "rbwfmapping": {
                this.beforeF7WfMapping(e, rowIndex);
                break;
            }
            case "srcbilltype": {
                this.beforeF7WfSrcBillType(e);
                break;
            }
            case "targetbilltype": {
                this.beforeF7WfTagBillType(e);
                break;
            }
            case "wfbillalias": {
                this.beforeF7WfBillAlias(e);
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryRow = e.getEntryProp().getName();
        if ("writeoffbillentry".equals(entryRow)) {
            this.lockMainShare();
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryRow = e.getEntryProp().getName();
        if ("writeoffbillentry".equals(entryRow)) {
            this.lockMainShare();
        }
    }

    private void lockMainShare() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("writeoffbillentry");
        int mainShareIndex = -1;
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (!((Boolean)model.getValue("ismainshare", i)).booleanValue()) continue;
            mainShareIndex = i;
        }
        boolean isOnMainShare = mainShareIndex >= 0;
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (i == mainShareIndex) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"ismainshare"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"isautogenerate"});
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(!isOnMainShare), i, new String[]{"ismainshare"});
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"isautogenerate"});
        }
    }

    private void beforeF7WfBillAlias(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ArrayList<String> list = new ArrayList<String>(4);
        String number = (String)this.getModel().getValue("number");
        list.add(number);
        list.add("");
        QFilter qFilter = new QFilter("writeofftypenumber", "in", list);
        showParameter.getListFilterParameter().setQFilters(Collections.singletonList(qFilter));
    }

    private void beforeF7WfTagBillType(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        List<Long> tagBills = this.getBillAliasByWay(true);
        QFilter qFilter = new QFilter("id", "in", tagBills);
        showParameter.getListFilterParameter().setQFilters(Collections.singletonList(qFilter));
    }

    private void beforeF7WfSrcBillType(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        List<Long> srcBills = this.getBillAliasByWay(false);
        QFilter qFilter = new QFilter("id", "in", srcBills);
        showParameter.getListFilterParameter().setQFilters(Collections.singletonList(qFilter));
    }

    private List<Long> getBillAliasByWay(boolean isAutoBill) {
        ArrayList<Long> bills = new ArrayList<Long>(16);
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity("writeoffbillentry");
        for (DynamicObject entiy : entryEntitys) {
            boolean auto;
            DynamicObject alias = entiy.getDynamicObject("wfbillalias");
            boolean bl = auto = isAutoBill == entiy.getBoolean("isautogenerate");
            if (alias == null || !auto) continue;
            bills.add((Long)alias.getPkValue());
        }
        return bills;
    }

    private void beforeF7WfMapping(BeforeF7SelectEvent e, int rowIndex) {
        IDataModel model = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject wfRecord = (DynamicObject)model.getValue("writeoffrecordbill");
        if (wfRecord == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u6838\u9500\u8bb0\u5f55\u5b58\u50a8\u3002", (String)"WriteOffTypeEditPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        DynamicObject wfBill = (DynamicObject)model.getValue("writeoffbilltype", rowIndex);
        if (wfBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u5f53\u524d\u884c\u6838\u9500\u5355\u636e\u3002", (String)"WriteOffTypeEditPlugin_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("targetobj", "=", wfRecord.getPkValue());
        qFilter.and("sourcebill", "=", wfBill.getPkValue());
        qFilter.and("isenable", "=", (Object)Boolean.TRUE);
        showParameter.getListFilterParameter().setQFilters(Collections.singletonList(qFilter));
    }

    private void beforeF7WfRecordBill(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String sql = "select   a.fnumber   from t_meta_formdesign  a  where a.finheritpath in (select  b.fid from t_meta_formdesign b where  b.fnumber in ('msmod_updownwfrecordtpl','msmod_leftrighwfrecordtpl','msmod_leftrtamounttpl','msmod_mainassisttpl','msmod_updownamounttpl'))";
        DataSet data = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.meta, (String)sql);
        ArrayList<String> list = new ArrayList<String>(16);
        while (data.hasNext()) {
            String billType = data.next().getString("fnumber");
            list.add(billType);
        }
        QFilter qFilter = new QFilter("id", "in", list);
        showParameter.getListFilterParameter().setQFilters(Collections.singletonList(qFilter));
    }

    private void beforeF7BotpRule(BeforeF7SelectEvent e, int rowIndex) {
        IDataModel model = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject srcBillType = (DynamicObject)model.getValue("srcbilltype", rowIndex);
        if (srcBillType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u6765\u6e90\u5355\u636e\u3002", (String)"WriteOffTypeEditPlugin_2", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        DynamicObject targetBillType = (DynamicObject)model.getValue("targetbilltype", rowIndex);
        if (targetBillType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u76ee\u6807\u5355\u636e\u3002", (String)"WriteOffTypeEditPlugin_3", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        HashSet<String> botpNumSet = new HashSet<String>();
        int entryRowCount = model.getEntryRowCount("autogenebillentry");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject botpRuleObj;
            if (i == rowIndex || (botpRuleObj = (DynamicObject)model.getValue("botprule", i)) == null) continue;
            String botpNumber = botpRuleObj.getString("number");
            botpNumSet.add(botpNumber);
        }
        String srcBlTypeNum = this.findBillNum(srcBillType);
        String targetBlTypeNum = this.findBillNum(targetBillType);
        QFilter botpFilter = new QFilter("sourceentitynumber.number", "=", (Object)srcBlTypeNum);
        botpFilter.and("targetentitynumber.number", "=", (Object)targetBlTypeNum);
        botpFilter.and("enabled", "=", (Object)Boolean.TRUE);
        botpFilter.and("number", "not in", botpNumSet);
        showParameter.getListFilterParameter().setQFilters(Collections.singletonList(botpFilter));
    }

    @Override
    protected List<FormConditionFilter> getFormConditions() {
        return Arrays.asList(FormConditionFilter.build("wfbillalias", "writeoffbillentry", "filterconditionview", "filterconditiondesc"), FormConditionFilter.build("wfbillalias", "writeoffbillentry", "cfilterconditionview", "cfilterconditiondesc"), FormConditionFilter.build("targetbilltype", "autogenebillentry", "isdeletefilter", "isdeletefilterdesc", false));
    }

    @Override
    protected void beforeShowFilterPage(FormConditionFilter formCondition) {
        super.beforeShowFilterPage(formCondition);
        switch (formCondition.getCondtionKey()) {
            case "filterconditionview": 
            case "cfilterconditionview": {
                this.checkIsAutoGenerate();
                break;
            }
        }
    }

    private boolean checkIsAutoGenerate() {
        int entryCurrRow = this.getModel().getEntryCurrentRowIndex("msmod_scheme_bill");
        boolean isAutoGenerate = (Boolean)this.getModel().getValue("isautogenerate", entryCurrRow);
        if (isAutoGenerate) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u81ea\u52a8\u751f\u6210\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"WriteOffTypeEditPluginCannotSetCdit", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    protected List<FormSelectFieldKey> getSelectFieldKey() {
        FormSelectFieldKey wfWholeFieldKey = FormSelectFieldKey.buildBoolean("wfbillalias", "writeoffbillentry", "wholefieldname", "wholefieldkey");
        FormSelectFieldKey wfBillFieldKey = FormSelectFieldKey.buildQuantity("wfbillalias", "wffieldsubentry", "writeofffieldname", "writeofffieldkey");
        wfBillFieldKey.setBillAliasEntryKey("writeoffbillentry");
        return Arrays.asList(wfWholeFieldKey, wfBillFieldKey);
    }

    @Override
    protected void beforeClickFieldKey(FormSelectFieldKey fieldKey) {
        if ("wholefieldname".equals(fieldKey.getFieldName())) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("writeoffbillentry");
            if (!((Boolean)this.getModel().getValue("isinvolved", rowIndex)).booleanValue()) {
                throw new KDBizException(FormLang.wfBillIsNotInvolved());
            }
        }
        super.beforeClickFieldKey(fieldKey);
    }

    @Override
    protected IColsSelectStrategy getSelectStrategy(FormSelectFieldKey fieldKey) {
        if ("writeofffieldname".equals(fieldKey.getFieldName())) {
            ArrayList<String> fields = new ArrayList<String>();
            DynamicObjectCollection writeOffBillEntry = this.getModel().getEntryEntity("wffieldsubentry");
            for (DynamicObject entry : writeOffBillEntry) {
                fields.add(entry.getString("writeofffieldkey"));
            }
            return new ExcludeFieldStrategy(fields);
        }
        return super.getSelectStrategy(fieldKey);
    }
}

