/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.mpscmm.mscommon.writeoff.lang.NounLang;

public class WriteOffTypeListEdit
extends AbstractListPlugin {
    private Map<String, Long> entityToTableId = new HashMap<String, Long>(16);
    private static final String[][] DATA_INFO = new String[][]{{"msmod_scheme", "writeofftype"}, {"msmod_matchrule", "writeofftype"}, {"msmod_rewriterule", "writeofftype"}, {"msmod_sharerule", "writeofftype"}, {"msmod_schemeset", "writeofftype"}, {"msmod_recordfieldgroup", "wftype"}};

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("trackwfdatabase".equals(e.getOperateKey())) {
            this.trackWfDataBase(e);
        }
    }

    private void trackWfDataBase(AfterDoOperationEventArgs e) {
        List wfTypeIds = e.getOperationResult().getSuccessPkIds();
        ArrayList<Map<Long, List<BFRowLinkDownNode>>> trackDatas = new ArrayList<Map<Long, List<BFRowLinkDownNode>>>(16);
        for (String[] dataInfo : DATA_INFO) {
            Map<Long, List<BFRowLinkDownNode>> typeToData = this.getTypeToDatas(wfTypeIds, dataInfo[0], dataInfo[1]);
            trackDatas.add(typeToData);
        }
        ArrayList<BFRowLinkDownNode> nodes = new ArrayList<BFRowLinkDownNode>(16);
        for (Object wftypeId : wfTypeIds) {
            BFRowLinkDownNode wftypeNode = this.createNode("msmod_scheme", (Long)wftypeId);
            HashMap<BFRowId, BFRowLinkDownNode> map = new HashMap<BFRowId, BFRowLinkDownNode>(16);
            wftypeNode.setTNodes(map);
            for (Map map2 : trackDatas) {
                List datanodes = (List)map2.get(wftypeId);
                if (datanodes == null) continue;
                for (BFRowLinkDownNode datanode : datanodes) {
                    map.put(datanode.getRowId(), datanode);
                }
            }
            nodes.add(wftypeNode);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getCustomParams().put("lookuptracker_use_list", String.valueOf(true));
        showParameter.setFormId("botp_lookuptracker");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String linkNodesJson = SerializationUtils.serializeToBase64(nodes);
        showParameter.getCustomParams().put("linknodes", linkNodesJson);
        showParameter.setCaption(NounLang.trackWFBaseData());
        this.getView().showForm(showParameter);
    }

    public BFRowLinkDownNode createNode(String entity, Long pkId) {
        Long tableId = this.entityToTableId.get(entity);
        if (tableId == null) {
            TableDefine wftTableDefine = EntityMetadataCache.loadTableDefine((String)entity, (String)entity);
            tableId = wftTableDefine.getTableId();
            this.entityToTableId.put(entity, tableId);
        }
        BFRowId bfRowId = new BFRowId(tableId, pkId, tableId, pkId);
        BFRowLinkDownNode schemenode = new BFRowLinkDownNode(bfRowId);
        return schemenode;
    }

    private Map<Long, List<BFRowLinkDownNode>> getTypeToDatas(Collection<Object> writeTypeIds, String dataEntity, String writeOffKey) {
        Map wfBaseDatas = BusinessDataServiceHelper.loadFromCache((String)dataEntity, (QFilter[])new QFilter(writeOffKey, "in", writeTypeIds).toArray());
        HashMap<Long, List<BFRowLinkDownNode>> typeToMatchRule = new HashMap<Long, List<BFRowLinkDownNode>>(16);
        for (DynamicObject wfBaseData : wfBaseDatas.values()) {
            DynamicObject wfTypeObj = wfBaseData.getDynamicObject(writeOffKey);
            if (wfTypeObj == null) continue;
            BFRowLinkDownNode node = this.createNode(wfBaseData.getDataEntityType().getName(), wfBaseData.getLong("id"));
            MapUtils.mapGetListValue(typeToMatchRule, wfTypeObj.getLong("id")).add(node);
        }
        return typeToMatchRule;
    }
}

