/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.form.queryscheme;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.form.queryscheme.ISchemeSavePlugin;

public class SchemeSaveExtPlugin
extends AbstractFormPlugin
implements ISchemeSavePlugin,
ICloseCallBack {
    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter parameter = e.getFormShowParameter();
        String billType = (String)parameter.getCustomParam("billType");
        String entityName = MetadataServiceHelper.getDataEntityType((String)billType).getDisplayName().getLocaleValue();
        parameter.setCaption(entityName);
        super.preOpenForm(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button conditonBtn = (Button)this.getView().getControl("btnok");
        conditonBtn.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String billType = (String)formShowParameter.getCustomParam("billType");
        if (StringUtils.isEmpty((CharSequence)billType)) {
            return;
        }
        String entryKey = (String)formShowParameter.getCustomParam("entryKey");
        this.getPageCache().put("entryKey", entryKey);
        this.initFilterPage(billType, formShowParameter);
        this.getView().setEnable(Boolean.TRUE, new String[]{"filter"});
        this.getView().updateView("filter");
    }

    private void initFilterPage(String billType, FormShowParameter formShowParameter) {
        String defaultFilter = (String)formShowParameter.getCustomParam("defaultFilter");
        List maps = (List)formShowParameter.getCustomParam("filterConditonField");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filter");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        EntityTypeUtil helper = new EntityTypeUtil();
        List defaultCols = helper.getFilterColumns((IDataEntityType)mainEntityType, false);
        if (StringUtils.isNotEmpty((CharSequence)defaultFilter)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)defaultFilter, FilterCondition.class);
            filterGrid.SetValue(filterCondition);
        }
        defaultCols.addAll(maps);
        filterGrid.setFilterColumns(defaultCols);
        filterGrid.setEntityNumber(billType);
        FilterCondition condition = filterGrid.getFilterGridState().getFilterCondition();
        filterGrid.SetValue(condition);
        String billNameCtl = "filtername";
        Label billNameLab = (Label)this.getControl(billNameCtl);
        if (billNameLab == null) {
            billNameLab = (Label)this.getView().getControl(ISVService.getISVInfo().getId() + billNameCtl);
        }
        billNameLab.setText(mainEntityType.getDisplayName().getLocaleValue());
    }

    @Override
    public void beforeSaveSchemeExt(IFormView view) {
        String filterCtl = "filter";
        FilterGrid filterGrid = (FilterGrid)view.getControl(filterCtl);
        FilterCondition condition = filterGrid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        view.getModel().setValue("filtervalue", (Object)jsonStr);
    }

    public void click(EventObject e) {
        Control c = (Control)e.getSource();
        String key = c.getKey();
        if (StringUtils.isNotBlank((CharSequence)key) && "btnok".equals(key)) {
            this.returnData();
        }
    }

    private void returnData() {
        JSONObject returnData = new JSONObject();
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filter");
        FilterCondition condition = filterGrid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        returnData.put("filtervalue", (Object)jsonStr);
        String entryKey = this.getPageCache().get("entryKey");
        returnData.put("entryKey", (Object)entryKey);
        returnData.put("billEntity", (Object)filterGrid.getEntityNumber());
        this.getView().returnDataToParent((Object)returnData);
        this.getView().close();
    }

    @Override
    public void selectSchemeDealExt(DynamicObject dbFormDataDyc, IFormView view) {
        FilterGrid filterGrid = (FilterGrid)view.getControl("filter");
        String filterValue = dbFormDataDyc.getString("filtervalue");
        if (StringUtils.isEmpty((CharSequence)filterValue)) {
            FilterCondition filterCondition = new FilterCondition();
            filterGrid.SetValue(filterCondition);
            return;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterValue, FilterCondition.class);
        filterGrid.SetValue(filterCondition);
    }

    @Override
    public DynamicObjectCollection getSaveSchemeListDataExt(IFormView view) {
        String pageKey = this.getWfEntryKey(view);
        QFilter formIdf = new QFilter("formid", "=", (Object)view.getEntityId());
        formIdf.and("creator", "=", (Object)RequestContext.get().getCurrUserId());
        formIdf.and("wfpagekey", "=", (Object)pageKey);
        DynamicObjectCollection schemeDycs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"msmod_query_scheme", (String)"id,name,isdefault,schemestr,wfpagekey", (QFilter[])formIdf.toArray(), (String)"isdefault desc,modifytime desc");
        return schemeDycs;
    }

    @Override
    public void saveSchemeDynaDealExt(IFormView view, DynamicObject schemeDyna) {
        String entryKey = this.getWfEntryKey(view);
        schemeDyna.set("wfpagekey", (Object)entryKey);
    }

    @Override
    public QFilter checkSchemeNameQfilter(IFormView view) {
        String entryKey = this.getWfEntryKey(view);
        return new QFilter("wfpagekey", "=", (Object)entryKey);
    }

    private String getWfEntryKey(IFormView view) {
        String entryKey = (String)view.getFormShowParameter().getCustomParam("entryKey");
        String wfType = (String)view.getFormShowParameter().getCustomParam("writeofftype");
        return wfType + entryKey;
    }

    @Override
    public boolean checkDataChangedExt() {
        return false;
    }
}

