/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.form.scheme;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.mscommon.writeoff.common.cols.IColsSelectStrategy;
import kd.mpscmm.mscommon.writeoff.common.cols.SimpleStrategy;
import kd.mpscmm.mscommon.writeoff.common.consts.SelectParams;
import kd.mpscmm.mscommon.writeoff.common.helper.EntityParseNewHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.PresetHelper;
import kd.mpscmm.mscommon.writeoff.common.trans.FieldFormTranslator;
import kd.mpscmm.mscommon.writeoff.common.util.ColsTreeUtil;
import kd.mpscmm.mscommon.writeoff.common.util.FormUtils;
import kd.mpscmm.mscommon.writeoff.form.AbstractWfTypeBaseDataPlugin;

public class SchemeEditPlugin
extends AbstractWfTypeBaseDataPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"fieldname"});
        FormUtils.addF7Listener((BeforeF7SelectListener)this, "masterbill", "assistbill", "assistbillsec", "otherbill", "sortbilltype", "rewritebilltype", "matchrule", "rewriterule", "sharerule");
        this.addItemClickListeners(new String[]{"advcontoolbarap11", "advcontoolbarap1"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setShareVisible();
    }

    public void afterLoadData(EventObject e) {
        this.translateInfo();
    }

    @Override
    public void afterCopyData(EventObject e) {
        this.translateInfo();
    }

    private void translateInfo() {
        IDataModel model = this.getModel();
        try {
            FieldFormTranslator translator = FieldFormTranslator.create(this.getModel());
            translator.entryToEntryTranslate("msmod_smsort", "sortbilltype", "fieldno", "fieldname");
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        finally {
            model.setDataChanged(false);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if ("deleteentrysort".equals(key)) {
            PresetHelper.presetEntryRowDeleteCheck(view, model, evt, "msmod_smsort", "smsispreset");
        }
    }

    @Override
    protected String presetKey() {
        return "precut";
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        block12: for (int i = 0; i < valueSet.length; ++i) {
            Object newValue = valueSet[i].getNewValue();
            Object oldValue = valueSet[i].getOldValue();
            int rowIndex = valueSet[i].getRowIndex();
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue != null && newValue != null && oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (oldValue != null && newValue != null && oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                return;
            }
            switch (fieldName) {
                case "sortbilltype": {
                    this.sortbillTypeChanged(rowIndex);
                    continue block12;
                }
                case "isunconditionmatch": {
                    this.unconditionMatchChanged(newValue);
                    continue block12;
                }
                case "fieldname": {
                    this.fieldNameChanged(rowIndex);
                    continue block12;
                }
                case "writeofftype": {
                    this.setShareVisible();
                    continue block12;
                }
            }
        }
    }

    private void setShareVisible() {
        DynamicObject writeOffType = (DynamicObject)this.getModel().getValue("writeofftype");
        if (writeOffType != null && "B".equals(writeOffType.getString("writeofftype"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"sharerule", "sharedescription"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"sharerule", "sharedescription"});
        }
    }

    private void fieldNameChanged(int rowIndex) {
        String value = (String)this.getModel().getValue("fieldname", rowIndex);
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.getModel().setValue("fieldno", null, rowIndex);
            this.getModel().setValue("sorttype", null, rowIndex);
        }
    }

    private void unconditionMatchChanged(Object newValue) {
        if (((Boolean)newValue).booleanValue()) {
            this.getModel().setValue("matchrule", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"matchrule"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"matchrule"});
        }
    }

    private void sortbillTypeChanged(int rowIndex) {
        this.getModel().setValue("sorttype", null, rowIndex);
        this.getModel().setValue("fieldname", null, rowIndex);
        this.getModel().setValue("fieldno", null, rowIndex);
    }

    @Override
    protected void clearWriteOffType() {
        this.getModel().setValue("matchrule", null);
        this.getModel().setValue("description", null);
        this.getModel().setValue("sharerule", null);
        this.getView().updateView("matchrule");
        this.getView().updateView("description");
        this.getModel().deleteEntryData("msmod_smsort");
        this.getView().updateView("msmod_smsort");
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        IDataModel bill = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        Object writeofftypeOb = bill.getValue("writeofftype");
        if (writeofftypeOb == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u9500\u7c7b\u522b\u3002", (String)"SchemeEditPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        DynamicObject writeofftype = (DynamicObject)writeofftypeOb;
        switch (fieldKey) {
            case "matchrule": 
            case "sharerule": {
                this.matchRuleF7Select(showParameter, writeofftype);
                break;
            }
            case "sortbilltype": {
                this.sortBilltypeF7Select(showParameter, writeofftype);
                break;
            }
        }
    }

    private void matchRuleF7Select(ListShowParameter showParameter, DynamicObject writeofftype) {
        Long writeofftypeId = Long.parseLong(writeofftype.getPkValue().toString());
        QFilter qFilter = new QFilter("writeofftype", "=", (Object)writeofftypeId);
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void sortBilltypeF7Select(ListShowParameter showParameter, DynamicObject writeofftype) {
        QFilter wfBillQFilter = new QFilter("id", "in", this.getWriteOffTypeBillAlias());
        showParameter.getListFilterParameter().setFilter(wfBillQFilter);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "fieldname": {
                this.clickFieldName(evt);
                break;
            }
        }
    }

    private void clickFieldName(EventObject evt) {
        DynamicObject targetObj = (DynamicObject)this.getModel().getValue("sortbilltype");
        if (targetObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f53\u524d\u884c\u5355\u636e\u7c7b\u578b\u3002", (String)"SchemeEditPlugin_3", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            return;
        }
        this.showColsTreePage(targetObj.getDynamicObject("wfbill").getString("number"), null, "fieldname");
    }

    private void showColsTreePage(String entityNumber, IColsSelectStrategy strategy, String key) {
        IColsSelectStrategy selectStrategy = strategy;
        if (selectStrategy == null) {
            selectStrategy = new SimpleStrategy();
        }
        SelectParams params = new SelectParams();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(mainType);
        parameter.setOnlyPhysicsField(false);
        parameter.setIncludePKField(true);
        TreeNode rootNode = EntityParseNewHelper.buildBillTreeNodes(parameter, true);
        String fieldNodes = SerializationUtils.toJsonString((Object)rootNode);
        params.setJsonTree(fieldNodes);
        FormShowParameter fp = FormUtils.readyColsTreePage(params, new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(fp);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String closeActionId = e.getActionId();
        String returnData = (String)e.getReturnData();
        if (StringUtils.isEmpty((CharSequence)closeActionId) || returnData == null || StringUtils.isEmpty((CharSequence)returnData)) {
            return;
        }
        switch (closeActionId) {
            case "fieldname": {
                this.callBackFieldName(e, closeActionId, "fieldno");
                break;
            }
        }
    }

    private void callBackFieldName(ClosedCallBackEvent e, String filedName, String filedNo) {
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONObject dataJson = JSONObject.parseObject((String)data.get(0).toString());
        this.handleValues(dataJson, filedName, filedNo);
    }

    private void handleValues(JSONObject dataJson, String filedName, String filedNo) {
        IDataModel model = this.getModel();
        model.setValue(filedName, dataJson.get((Object)"text"));
        model.setValue(filedNo, dataJson.get((Object)"id"));
    }
}

