/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.form.validate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.LinkQueryPkId;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserService;

public class WriteOffDataFixForm
extends AbstractFormPlugin
implements HyperLinkClickListener {
    protected static final Log logger = LogFactory.getLog(WriteOffDataFixForm.class);
    private static final String SM_WFRECORD = "A";
    private static final String AR_VERIFYRECORD = "B";
    private static final String CAL_PURWFRECORD = "C";
    private static final String CAL_SALWFRECORD = "D";
    private static final String[] QUERY_FIELDS = new String[]{"wfqtykey", "wfbaseqtykey", "unwfqtykey", "unwfbaseqtykey"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((AbstractGrid)this.getControl("entryentity")).addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"query", "gensql", "datafix", "rowdatafix"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "writeofftype": {
                this.changeWriteOffType(e);
            }
        }
    }

    private void changeWriteOffType(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        IDataModel model = this.getModel();
        String billentity = null;
        if (SM_WFRECORD.equals(newValue)) {
            model.setValue("wfqtykey", (Object)"billentry.entrustverifyqty");
            model.setValue("wfbaseqtykey", (Object)"billentry.entrustverifybaseqty");
            model.setValue("unwfqtykey", (Object)"billentry.entrustunverifyqty");
            model.setValue("unwfbaseqtykey", (Object)"billentry.entrustunverifybaseqty");
            model.setValue("writeoffrecordentity", (Object)"sm_wfrecord");
            model.setValue("billidkey", (Object)"entry.billid");
            model.setValue("entryidkey", (Object)"entry.billentryid");
            model.setValue("verifyqtykey", (Object)"entry.verifyqty");
            model.setValue("verifybaseqtykey", (Object)"entry.qty");
            billentity = "im_saloutbill";
        } else if (AR_VERIFYRECORD.equals(newValue)) {
            model.setValue("wfqtykey", (Object)"billentry.verifyqty");
            model.setValue("wfbaseqtykey", (Object)"billentry.verifybaseqty");
            model.setValue("unwfqtykey", (Object)"billentry.unverifyqty");
            model.setValue("unwfbaseqtykey", (Object)"billentry.unverifybaseqty");
            model.setValue("writeoffrecordentity", (Object)"ar_verifyrecord");
            model.setValue("billidkey", (Object)"billid");
            model.setValue("entryidkey", (Object)"billentryid");
            model.setValue("verifyqtykey", (Object)"verifyqty");
            model.setValue("verifybaseqtykey", (Object)"verifybaseqty");
            billentity = "im_saloutbill";
        } else if (CAL_PURWFRECORD.equals(newValue)) {
            model.setValue("wfqtykey", (Object)"billentry.verifyqty");
            model.setValue("wfbaseqtykey", (Object)"billentry.verifybaseqty");
            model.setValue("unwfqtykey", (Object)"billentry.unverifyqty");
            model.setValue("unwfbaseqtykey", (Object)"billentry.unverifybaseqty");
            model.setValue("writeoffrecordentity", (Object)"cal_purwfrecord");
            model.setValue("billidkey", (Object)"billid");
            model.setValue("entryidkey", (Object)"billentryid");
            model.setValue("verifyqtykey", (Object)"verifyqty");
            model.setValue("verifybaseqtykey", (Object)"verifybaseqty");
            billentity = "im_purinbill";
        } else if (CAL_SALWFRECORD.equals(newValue)) {
            model.setValue("wfqtykey", (Object)"billentry.verifyqty");
            model.setValue("wfbaseqtykey", (Object)"billentry.verifybaseqty");
            model.setValue("unwfqtykey", (Object)"billentry.unverifyqty");
            model.setValue("unwfbaseqtykey", (Object)"billentry.unverifybaseqty");
            model.setValue("writeoffrecordentity", (Object)"cal_salwfrecord");
            model.setValue("billidkey", (Object)"billid");
            model.setValue("entryidkey", (Object)"billentryid");
            model.setValue("verifyqtykey", (Object)"verifyqty");
            model.setValue("verifybaseqtykey", (Object)"verifybaseqty");
            billentity = "im_saloutbill";
        }
        model.setValue("billobj", (Object)BusinessDataServiceHelper.loadSingleFromCache((String)"bos_billmainentity", (QFilter[])new QFilter("number", "=", billentity).toArray()));
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("billobjfilter");
        filterGrid.SetValue(new FilterCondition());
        if (billentity != null) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billentity);
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols1 = helper.getFilterColumns((IDataEntityType)mainEntityType, false);
            filterGrid.setEntityNumber(mainEntityType.getName());
            filterGrid.setFilterColumns(cols1);
            this.getView().setEnable(Boolean.TRUE, new String[]{"billobjfilter"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"billobjfilter"});
        }
        this.getView().updateView("billobjfilter");
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "query": {
                this.queryData();
                break;
            }
            case "rowdatafix": {
                this.dataFixByRow();
                break;
            }
            case "datafix": {
                this.dataFixByFilter();
                break;
            }
            case "gensql": {
                this.genSql();
            }
        }
    }

    private void dataFixByRow() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRowIdex = entryGrid.getSelectRows();
        if (selectRowIdex == null || selectRowIdex.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"plsselectone", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u4fee\u590d\u9009\u4e2d\u7684{0}\u6761\u6570\u636e\uff1f", (String)"isfixselectdata", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[]{selectRowIdex.length}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("dataFixByRow", (IFormPlugin)this));
    }

    private void dataFixByFilter() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u4fee\u590d\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\u3010{0}\u3011\u7684\u5168\u90e8\u6570\u636e\uff1f", (String)"isfixfilterdata", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[]{String.valueOf(this.getBillFilter())}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("dataFixByFilter", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (MessageBoxResult.Yes == e.getResult()) {
            String callBackId;
            switch (callBackId = e.getCallBackId()) {
                case "dataFixByRow": {
                    this.dataFixByRowCloseCallBack();
                    break;
                }
                case "dataFixByFilter": {
                    this.dataFixByFilterCloseCallBack();
                    break;
                }
            }
        }
    }

    private void dataFixByRowCloseCallBack() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        HashSet<Long> billIds = new HashSet<Long>(16);
        HashSet<Long> entryIds = new HashSet<Long>(16);
        int[] selectRowIdex = entryGrid.getSelectRows();
        if (selectRowIdex == null || selectRowIdex.length == 0) {
            throw new KDBizException("please select row.");
        }
        for (int i : selectRowIdex) {
            billIds.add((Long)this.getModel().getValue("billid", i));
            entryIds.add((Long)this.getModel().getValue("entryid", i));
        }
        logger.info("\u4fee\u590d\u9009\u4e2d\u7684\u5355\u636eids\uff1a" + billIds + "\uff0c\u5206\u5f55ids\uff1a" + entryIds);
        List<String> fixDataByDataSet = this.fixDataByDataSet(this.getDataResults(billIds, entryIds));
        this.showFixInfo(fixDataByDataSet);
    }

    private void dataFixByFilterCloseCallBack() {
        ArrayList<String> fixDataByDataSet = new ArrayList<String>(16);
        QFilter billFilter = this.getBillFilter();
        String billentity = ((DynamicObject)this.getValue("billobj")).getString("number");
        Long lastEntryId = 0L;
        while (true) {
            HashSet<Long> billIds = new HashSet<Long>(16);
            HashSet<Long> entryIds = new HashSet<Long>(16);
            QFilter filter = new QFilter("billentry.id", ">", (Object)lastEntryId).and(billFilter);
            DataSet billObjs = QueryServiceHelper.queryDataSet((String)"WriteOffDataFixForm.queryBillIds", (String)billentity, (String)"id, billentry.id as entryid", (QFilter[])filter.toArray(), (String)"billentry.id", (int)10000);
            logger.info("\u4fee\u590d\u5355\u636e\uff1a" + billentity + "\uff0c\u8fc7\u6ee4\u6761\u4ef6\uff1a" + String.valueOf(billFilter));
            for (Row billRow : billObjs) {
                Long billId = billRow.getLong("id");
                billIds.add(billId);
                Long entryId = billRow.getLong("entryid");
                entryIds.add(entryId);
                lastEntryId = entryId;
            }
            if (billIds.isEmpty() || entryIds.isEmpty()) break;
            List<String> fixDatas = this.fixDataByDataSet(this.getDataResults(billIds, entryIds));
            fixDataByDataSet.addAll(fixDatas);
        }
        this.showFixInfo(fixDataByDataSet);
    }

    private void queryData() {
        this.getModel().deleteEntryData("entryentity");
        TableValueSetter vs = this.queryDataForBatch();
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
        this.getView().updateView("entryentity");
    }

    private TableValueSetter queryDataForBatch() {
        DataSet resultDataSet;
        TableValueSetter vs = new TableValueSetter(new String[0]);
        QFilter billFilter = this.getBillFilter();
        String billentity = ((DynamicObject)this.getValue("billobj")).getString("number");
        Long lastEntryId = 0L;
        block0: while (true) {
            HashSet<Long> billIds = new HashSet<Long>(16);
            HashSet<Long> entryIds = new HashSet<Long>(16);
            QFilter filter = new QFilter("billentry.id", ">", (Object)lastEntryId).and(billFilter);
            logger.info("\u67e5\u8be2\u6570\u636e\uff1a" + filter);
            DataSet billObjs = QueryServiceHelper.queryDataSet((String)"WriteOffDataFixForm.queryBillIds", (String)billentity, (String)"id, billentry.id as entryid", (QFilter[])filter.toArray(), (String)"billentry.id", (int)10000);
            for (Row billRow : billObjs) {
                Long billId = billRow.getLong("id");
                billIds.add(billId);
                Long entryId = billRow.getLong("entryid");
                entryIds.add(entryId);
                lastEntryId = entryId;
            }
            if (billIds.isEmpty() || entryIds.isEmpty()) {
                return vs;
            }
            resultDataSet = this.getDataResults(billIds, entryIds);
            boolean onlyDiff = (Boolean)this.getValue("onlydiff");
            if (onlyDiff) {
                resultDataSet = resultDataSet.filter("wfqty <> verifyqty");
            }
            if (((Boolean)this.getValue("filerover")).booleanValue()) {
                resultDataSet = resultDataSet.filter("Abs(baseqty) - Abs(verifybaseqty) < 0");
            }
            Iterator iterator = resultDataSet.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                Row row = (Row)iterator.next();
                BigDecimal wfQty = row.getBigDecimal("wfqty");
                BigDecimal verifyqty = row.getBigDecimal("verifyqty");
                if (onlyDiff && verifyqty == null && BigDecimal.ZERO.compareTo(wfQty) == 0) continue;
                vs.addField("billno", new Object[]{row.get("billno")});
                vs.addField("billid", new Object[]{row.get("id")});
                vs.addField("entryseq", new Object[]{row.get("seq")});
                vs.addField("entryid", new Object[]{row.get("billentry.id")});
                vs.addField("qty", new Object[]{row.get("qty")});
                vs.addField("baseqty", new Object[]{row.get("baseqty")});
                vs.addField("wfqty", new Object[]{wfQty});
                vs.addField("wfbaseqty", new Object[]{row.get("wfbaseqty")});
                vs.addField("unwfqty", new Object[]{row.get("unwfqty")});
                vs.addField("unwfbaseqty", new Object[]{row.get("unwfbaseqty")});
                vs.addField("verifyqty", new Object[]{verifyqty});
                vs.addField("baseverifyqty", new Object[]{row.get("verifybaseqty")});
                if (vs.getCount() > 50000) break block0;
            }
            break;
        }
        logger.info("\u4ec5\u5c55\u793a\u524d50000\u6570\u636e");
        resultDataSet.close();
        return vs;
    }

    private void genSql() {
        String tableName = ((DynamicObject)this.getValue("billobj")).getString("number");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)tableName);
        String[] fieldKeys = QUERY_FIELDS;
        HashMap tableToProps = new HashMap(16);
        HashMap<String, String> dbFieldToField = new HashMap<String, String>(16);
        for (String fieldKey : fieldKeys) {
            String[] stringArray = ((String)this.getModel().getValue(fieldKey)).split("\\.");
            String propKey = stringArray[stringArray.length - 1];
            IDataEntityProperty prop = entityType.findProperty(propKey);
            String tableAlias = prop.getParent().getAlias();
            String tableGroup = prop.getTableGroup();
            if (StringUtils.isNotEmpty((CharSequence)tableGroup)) {
                tableAlias = tableAlias + "_" + (String)tableGroup;
            }
            WriteOffDataFixForm.mapGetListValue(tableToProps, tableAlias).add(prop);
            dbFieldToField.put(prop.getAlias(), fieldKey.replace("key", ""));
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRowIdex = entryGrid.getSelectRows();
        ArrayList<String> sqls = new ArrayList<String>(selectRowIdex.length);
        for (Map.Entry entry : tableToProps.entrySet()) {
            List props = (List)entry.getValue();
            StringBuilder str = new StringBuilder();
            str.append("update ");
            str.append((String)entry.getKey());
            str.append(" set ");
            boolean isBegin = true;
            for (IDataEntityProperty prop : props) {
                if (!isBegin) {
                    str.append(",");
                }
                str.append(prop.getAlias());
                str.append(" = %s");
                if (!isBegin) continue;
                isBegin = false;
            }
            str.append(" where fentryid = %s;");
            String sqlTemplate = str.toString();
            for (int i : selectRowIdex) {
                Object[] sqlValue = new Object[props.size() + 1];
                int j = 0;
                for (IDataEntityProperty prop : props) {
                    sqlValue[j] = this.getFieldValue((String)dbFieldToField.get(prop.getAlias()), i);
                    ++j;
                }
                sqlValue[j] = this.getModel().getValue("entryid", i);
                sqls.add(String.format(sqlTemplate, sqlValue));
            }
        }
        FormShowParameter textShow = new FormShowParameter();
        textShow.setFormId("bos_multitext");
        textShow.getCustomParams().put("params", sqls);
        textShow.setCaption("Fix SQL");
        textShow.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(textShow);
    }

    public static <T, A> List<T> mapGetListValue(Map<A, List<T>> map, A key) {
        List<T> value = map.get(key);
        if (value == null) {
            value = new ArrayList<T>(16);
            map.put(key, value);
        }
        return value;
    }

    private Object getFieldValue(String key, int i) {
        BigDecimal value = BigDecimal.ZERO;
        if ("unwfqty".equals(key)) {
            value = ((BigDecimal)this.getModel().getValue("qty", i)).subtract((BigDecimal)this.getModel().getValue("verifyqty", i));
        } else if ("unwfbaseqty".equals(key)) {
            value = ((BigDecimal)this.getModel().getValue("baseqty", i)).subtract((BigDecimal)this.getModel().getValue("baseverifyqty", i));
        } else if ("wfqty".equals(key)) {
            value = (BigDecimal)this.getModel().getValue("verifyqty", i);
        } else if ("wfbaseqty".equals(key)) {
            value = (BigDecimal)this.getModel().getValue("baseverifyqty", i);
        }
        return value.stripTrailingZeros().toPlainString();
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String fieldName = e.getFieldName();
        if ("billno".equals(fieldName)) {
            this.showBillInfo(e.getRowIndex());
        } else if ("baseverifyqty".equals(fieldName)) {
            this.showRecordListInfo(e.getRowIndex());
        }
    }

    private void showBillInfo(int rowIndex) {
        Object billid = this.getModel().getValue("billid", rowIndex);
        String billentity = ((DynamicObject)this.getValue("billobj")).getString("number");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(billentity);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId(billid);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showRecordListInfo(int i) {
        String recordEntity = this.getStrValue("writeoffrecordentity");
        String entryIdKey = this.getStrValue("entryidkey");
        Object entryId = this.getModel().getValue("entryid", i);
        QFilter entryFilter = null;
        entryFilter = AR_VERIFYRECORD.equals(this.getStrValue("writeofftype")) || CAL_SALWFRECORD.equals(this.getStrValue("writeofftype")) ? new QFilter(entryIdKey, "=", entryId).or("entry.e_billentryid", "=", entryId) : new QFilter(entryIdKey, "=", entryId);
        ListShowParameter baseDataListParam = WriteOffDataFixForm.getBaseDataListParam(recordEntity, entryFilter);
        this.getView().showForm((FormShowParameter)baseDataListParam);
    }

    public static ListShowParameter getBaseDataListParam(String bdEntity, QFilter dataQFilter) {
        DynamicObjectCollection results = QueryServiceHelper.query((String)bdEntity, (String)"id", (QFilter[])dataQFilter.toArray());
        LinkQueryPkIdCollection lkIds = new LinkQueryPkIdCollection();
        for (DynamicObject result : results) {
            lkIds.add((Object)new LinkQueryPkId(result.get("id")));
        }
        ListShowParameter params = new ListShowParameter();
        params.setBillFormId(bdEntity);
        if (dataQFilter != null) {
            ListFilterParameter filterParam = new ListFilterParameter();
            filterParam.setFilter(dataQFilter);
            params.setListFilterParameter(filterParam);
        }
        params.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        params.setFormId("bos_list");
        params.setShowFilter(false);
        params.setShowQuickFilter(false);
        params.setLinkQueryPkIdCollection(lkIds);
        return params;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("checkrecord".equals(e.getOperateKey())) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.showRecordListInfo(rowIndex);
        }
    }

    private DataSet getDataResults(Set<Long> billIds, Set<Long> entryIds) {
        String billentity = ((DynamicObject)this.getValue("billobj")).getString("number");
        String queryFieldStr = this.transToQueryField(QUERY_FIELDS);
        DataSet billInfos = QueryServiceHelper.queryDataSet((String)"WriteOffDataFixForm.queryBillData", (String)billentity, (String)("id,billno,billentry.id" + this.buildSelectField("billentry", "seq", "qty", "baseqty") + queryFieldStr), (QFilter[])new QFilter("billentry.id", "in", entryIds).toArray(), null);
        DataSet recordInfos = this.buildRecordDataSet(billIds, entryIds);
        DataSet resultDataSet = billInfos.leftJoin(recordInfos).on("billentry.id", "billentryid").select(billInfos.getRowMeta().getFieldNames(), new String[]{"verifyqty", "verifybaseqty"}).finish();
        return resultDataSet;
    }

    private DataSet buildRecordDataSet(Set<Long> billIds, Set<Long> entryIds) {
        String recordEntity = this.getStrValue("writeoffrecordentity");
        String billIdKey = this.getStrValue("billidkey");
        String entryIdKey = this.getStrValue("entryidkey");
        String verifyqtyField = this.transToQueryField(new String[]{"entryidkey", "verifyqtykey", "verifybaseqtykey"});
        DataSet recordInfos = QueryServiceHelper.queryDataSet((String)"WriteOffDataFixForm.queryRecordData", (String)recordEntity, (String)("id as wfrecordid" + verifyqtyField), (QFilter[])new QFilter(entryIdKey, "in", entryIds).and(billIdKey, "in", billIds).toArray(), null);
        String strValue = this.getStrValue("writeofftype");
        if (AR_VERIFYRECORD.equals(strValue)) {
            DataSet subRecordInfos = QueryServiceHelper.queryDataSet((String)"WriteOffDataFixForm.querySubRecordData", (String)recordEntity, (String)"id as wfrecordid, entry.e_billentryid as entryidkey , entry.e_verifyqty as verifyqtykey, entry.e_verifybaseqty as verifybaseqtykey", (QFilter[])new QFilter("entry.e_billentryid", "in", entryIds).and("entry.e_billid", "in", billIds).toArray(), null);
            recordInfos = recordInfos.union(subRecordInfos);
        } else if (CAL_PURWFRECORD.equals(strValue)) {
            DataSet subRecordInfos = QueryServiceHelper.queryDataSet((String)"WriteOffDataFixForm.querySubRecordData", (String)recordEntity, (String)"id as wfrecordid, entry.e_billentryid as entryidkey , entry.e_verifyqty as verifyqtykey, entry.e_verifybaseqty as verifybaseqtykey", (QFilter[])new QFilter("entry.e_billentryid", "in", entryIds).and("entry.e_billid", "in", billIds).toArray(), null);
            recordInfos = recordInfos.union(subRecordInfos);
        } else if (CAL_SALWFRECORD.equals(strValue)) {
            DataSet subRecordInfos = QueryServiceHelper.queryDataSet((String)"WriteOffDataFixForm.querySubRecordData", (String)recordEntity, (String)"id as wfrecordid, entry.e_billentryid as entryidkey , entry.e_verifyqty as verifyqtykey, entry.e_verifybaseqty as verifybaseqtykey", (QFilter[])new QFilter("entry.e_billentryid", "in", entryIds).and("entry.e_billid", "in", billIds).toArray(), null);
            recordInfos = recordInfos.union(subRecordInfos);
        }
        return recordInfos.groupBy(new String[]{"entryid"}).sum("verifyqty").sum("verifybaseqty").finish().select("entryid as billentryid, verifyqty, verifybaseqty");
    }

    private String transToQueryField(String[] queryFields) {
        StringBuilder str = new StringBuilder();
        for (String field : queryFields) {
            str.append(String.format(",%s as %s", this.getValue(field), field.replace("key", "")));
        }
        String queryFieldStr = str.toString();
        return queryFieldStr;
    }

    private String buildSelectField(String entryKey, String ... fieldKey) {
        StringBuilder builder = new StringBuilder();
        for (String field : fieldKey) {
            builder.append(String.format(" ,%s.%s as %s", entryKey, field, field));
        }
        return builder.toString();
    }

    private List<String> fixDataByDataSet(DataSet resultDataSet) {
        resultDataSet = resultDataSet.filter("wfqty <> verifyqty");
        String sqlTemplate = null;
        String wfType = this.getStrValue("writeofftype");
        if (SM_WFRECORD.equals(wfType)) {
            sqlTemplate = "UPDATE t_im_saloutbillentry_r SET fentrustverifyqty = ?,fentrustverifybaseqty = ?,fentrustunverifyqty = ?, fentrustunverifybaseqty = ? WHERE fentryid = ?;";
        } else if (CAL_PURWFRECORD.equals(wfType)) {
            sqlTemplate = "UPDATE t_im_purinbillentry_r SET fverifyqty = ?,fverifybaseqty = ?,funverifyqty = ?, funverifybaseqty = ? WHERE fentryid = ?;";
        } else if (AR_VERIFYRECORD.equals(wfType) || CAL_SALWFRECORD.equals(wfType)) {
            sqlTemplate = "UPDATE t_im_saloutbillentry_r SET fverifyqty = ?,fverifybaseqty = ?,funverifyqty = ?,funverifybaseqty = ? WHERE fentryid = ?;";
        } else {
            throw new KDBizException("not support writeoff type data fix!");
        }
        ArrayList<String> fixedBillInfo = new ArrayList<String>();
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
        for (Row row : resultDataSet) {
            BigDecimal billWfQty;
            BigDecimal verifyBaseQty;
            BigDecimal verifyQty;
            BigDecimal baseQty;
            BigDecimal qty = row.getBigDecimal("qty");
            if (qty == null) {
                qty = BigDecimal.ZERO;
            }
            if ((baseQty = row.getBigDecimal("baseqty")) == null) {
                baseQty = BigDecimal.ZERO;
            }
            if ((verifyQty = row.getBigDecimal("verifyqty")) == null) {
                verifyQty = BigDecimal.ZERO;
            }
            if ((verifyBaseQty = row.getBigDecimal("verifybaseqty")) == null) {
                verifyBaseQty = BigDecimal.ZERO;
            }
            if (verifyQty.compareTo(billWfQty = row.getBigDecimal("wfqty")) == 0) continue;
            Object[] sqlParam = new Object[]{verifyQty, verifyBaseQty, qty.subtract(verifyQty), baseQty.subtract(verifyBaseQty), row.get("billentry.id")};
            fixedBillInfo.add(this.fixedInfoTemplate(sqlParam));
            sqlParams.add(sqlParam);
        }
        if (sqlParams.isEmpty()) {
            return fixedBillInfo;
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"SCM"), (String)sqlTemplate, sqlParams);
        return fixedBillInfo;
    }

    private String fixedInfoTemplate(Object[] param) {
        return ResManager.loadKDString((String)"\u5206\u5f55id:{4}\u4fee\u590d\u4e3a\uff1a\u5df2\u6838\u9500{0}\u3001\u5df2\u6838\u9500\u57fa\u672c\u6570\u91cf{1}\u3001\u672a\u6838\u9500{2}\u3001\u672a\u6838\u9500\u57fa\u672c\u6570\u91cf{3}", (String)"WriteOffDataFixForm_0", (String)"mpscmm-mscommon-writeoff", (Object[])param);
    }

    protected Object getValue(String key) {
        Object value = this.getModel().getValue(key);
        if (value == null) {
            this.keyNoValue(key);
        }
        return value;
    }

    protected String getStrValue(String key) {
        String value = (String)this.getModel().getValue(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.keyNoValue(key);
        }
        return value;
    }

    private void keyNoValue(String key) {
        MainEntityType entityType = this.getModel().getDataEntityType();
        IDataEntityProperty findProperty = entityType.findProperty(key);
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165%s\u3002", (String)"AbstractWfFormPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), findProperty.getDisplayName().getLocaleValue()));
    }

    private QFilter getBillFilter() {
        String billentity = ((DynamicObject)this.getValue("billobj")).getString("number");
        FilterGrid.FilterGridState filterGridState = ((FilterGrid)this.getView().getControl("billobjfilter")).getFilterGridState();
        String filterString = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
        if (StringUtils.isEmpty((CharSequence)filterString)) {
            return QFilter.of((String)"1=1", (Object[])new Object[0]);
        }
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterString, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)billentity), condition);
        UserService userService = new UserService();
        fb.setUserService((IUserService)userService);
        fb.buildFilter(false);
        QFilter filterTextToQfilter = fb.getQFilter();
        if (filterTextToQfilter == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"plsconfigfilter", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        return filterTextToQfilter;
    }

    private void showFixInfo(List<String> fixInfo) {
        if (fixInfo.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6570\u636e\u9700\u8981\u4fee\u590d\u3002", (String)"nodatafix", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            return;
        }
        if (fixInfo.size() > 10000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fee\u590d\u7684\u6570\u636e\u8d85\u8fc710000\u6761, \u8bf7\u67e5\u770bmontior\u65e5\u5fd7\u4fe1\u606f\uff1a traceid:{0}", (String)"oversizechekmonitor", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[]{RequestContext.get().getTraceId()}));
            return;
        }
        FormShowParameter textShow = new FormShowParameter();
        textShow.setFormId("bos_multitext");
        textShow.getCustomParams().put("params", fixInfo);
        textShow.setCaption("Fix SQL");
        textShow.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(textShow);
    }
}

