/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.op.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.lang.FormLang;
import kd.mpscmm.mscommon.writeoff.op.BaseDataRefInfo;

public abstract class AbstractAbleValidator
extends AbstractValidator {
    private static final List<BaseDataRefInfo> dataInfos = new ArrayList<BaseDataRefInfo>(16);

    public Set<String> preparePropertys() {
        HashSet<String> keys = new HashSet<String>(16);
        for (BaseDataRefInfo refInfo : dataInfos) {
            keys.add(refInfo.getRefKey());
        }
        return keys;
    }

    public void checkDataEnable() {
        String entityType = this.getDataEntities()[0].getDataEntity().getDataEntityType().getName();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityType);
        for (BaseDataRefInfo baseDataRefInfo : dataInfos) {
            if (!baseDataRefInfo.getDataEntityType().equals(entityType)) continue;
            IDataEntityProperty property = dataEntityType.findProperty(baseDataRefInfo.getRefKey());
            this.checkPropEnable(baseDataRefInfo, property);
        }
    }

    private void checkPropEnable(BaseDataRefInfo baseDataRefInfo, IDataEntityProperty property) {
        HashSet<Object> pkValues = new HashSet<Object>(16);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject value = (DynamicObject)dataEntity.getValue(baseDataRefInfo.getRefKey());
            if (value == null) continue;
            Object pkValue = value.getPkValue();
            pkValues.add(pkValue);
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)baseDataRefInfo.getRefDataEntityType(), (String)"id,number", (QFilter[])new QFilter("id", "in", pkValues).and("enable", "=", (Object)Boolean.FALSE).toArray());
        HashSet<Object> disableIds = new HashSet<Object>(16);
        for (DynamicObject resultObj : query) {
            disableIds.add(resultObj.get("id"));
        }
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            Object pkValue;
            DynamicObject value = (DynamicObject)dataEntity.getValue(baseDataRefInfo.getRefKey());
            if (value == null || !disableIds.contains(pkValue = value.getPkValue())) continue;
            String erroMessage = FormLang.dataNotEnable(property, value.getString("number"));
            this.addErrorMessage(dataEntity, erroMessage);
        }
    }

    public void checkDataDisable() {
        String entityType = this.getDataEntities()[0].getDataEntity().getDataEntityType().getName();
        for (BaseDataRefInfo baseDataRefInfo : dataInfos) {
            if (!baseDataRefInfo.getRefDataEntityType().equals(entityType)) continue;
            this.checkPropDisable(baseDataRefInfo);
        }
    }

    private void checkPropDisable(BaseDataRefInfo baseDataRefInfo) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)baseDataRefInfo.getDataEntityType());
        HashSet<Object> pkValues = new HashSet<Object>(16);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            pkValues.add(dataEntity.getBillPkId());
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)baseDataRefInfo.getDataEntityType(), (String)("id,number," + baseDataRefInfo.getRefKey()), (QFilter[])new QFilter(baseDataRefInfo.getRefKey(), "in", pkValues).and("enable", "=", (Object)Boolean.TRUE).toArray());
        HashMap<Object, String> refDataNumber = new HashMap<Object, String>(16);
        for (DynamicObject queryObj : query) {
            String number = queryObj.getString("number");
            Object refId = queryObj.get(baseDataRefInfo.getRefKey());
            String str = (String)refDataNumber.get(refId);
            if (str == null) {
                str = number;
            } else if (!str.contains(number)) {
                str = str + "," + number;
            }
            refDataNumber.put(refId, str);
        }
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            Object billPkId = dataEntity.getBillPkId();
            String refDataNum = (String)refDataNumber.get(billPkId);
            if (!StringUtils.isNotEmpty((CharSequence)refDataNum)) continue;
            this.addErrorMessage(dataEntity, FormLang.refDataEnable(entityType, refDataNum));
        }
    }

    static {
        dataInfos.add(new BaseDataRefInfo("msmod_scheme", "matchrule", "msmod_matchrule"));
        dataInfos.add(new BaseDataRefInfo("msmod_scheme", "writeofftype", "msmod_writeofftype"));
        dataInfos.add(new BaseDataRefInfo("msmod_scheme", "sharerule", "msmod_sharerule"));
        dataInfos.add(new BaseDataRefInfo("msmod_schemeset", "msmod_scheme_bill.msmod_sch_subentry.sub_wf_scheme", "msmod_scheme"));
    }
}

