/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.op.validator;

import java.util.ArrayList;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import org.apache.commons.collections.CollectionUtils;

public class MatchRuleSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            this.checkMatch(dataEntity);
            this.valEntryRepeat(dataEntity);
            this.checkSubEntryCount(dataEntity);
            this.checkMatchRelateEntrySame(dataEntity);
            this.checkRangeMatch(dataEntity);
        }
    }

    private void checkRangeMatch(ExtendedDataEntity dataEntity) {
        DynamicObject entityObj = dataEntity.getDataEntity();
        DynamicObjectCollection matchRelates = entityObj.getDynamicObjectCollection("matchrelateentry");
        if (matchRelates.size() > 1) {
            for (DynamicObject matchRelate : matchRelates) {
                String seq = matchRelate.getString("seq");
                DynamicObjectCollection subCollection = matchRelate.getDynamicObjectCollection("matchcditsubentry");
                for (DynamicObject sub : subCollection) {
                    String comparsion = sub.getString("comparison");
                    if ("=".equals(comparsion)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e24\u65b9\u4ee5\u4e0a\u6838\u9500\u4e0d\u652f\u6301\u8303\u56f4\u5339\u914d\u3002", (String)"MatchRuleSaveValidatorDataRepeat_4", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
                    return;
                }
            }
        }
    }

    private void checkMatchRelateEntrySame(ExtendedDataEntity dataEntity) {
        DynamicObject entityObj = dataEntity.getDataEntity();
        DynamicObjectCollection matchRelates = entityObj.getDynamicObjectCollection("matchrelateentry");
        if (matchRelates.size() > 0) {
            for (DynamicObject matchRelate : matchRelates) {
                String seq = matchRelate.getString("seq");
                DynamicObject srcBillType = matchRelate.getDynamicObject("srcbilltype");
                DynamicObject tagBillType = matchRelate.getDynamicObject("targetbilltype");
                if (tagBillType == null || srcBillType == null || !tagBillType.getString("falias").equals(srcBillType.getString("falias"))) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5339\u914d\u5173\u7cfb\u7b2c%s\u884c\u6e90\u5355\u636e\u548c\u76ee\u6807\u5355\u636e\u4e0d\u80fd\u76f8\u540c\u3002", (String)"MatchRuleSaveValidatorDataRepeat_3", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), seq));
            }
        }
    }

    private void checkSubEntryCount(ExtendedDataEntity dataEntity) {
        DynamicObject entityObj = dataEntity.getDataEntity();
        DynamicObjectCollection matchRelates = entityObj.getDynamicObjectCollection("matchrelateentry");
        if (matchRelates.size() > 1) {
            DynamicObjectCollection subEntrys = ((DynamicObject)matchRelates.get(0)).getDynamicObjectCollection("matchcditsubentry");
            Integer subEntryCount = subEntrys.size();
            for (DynamicObject matchRelate : matchRelates) {
                DynamicObjectCollection subEntryList = matchRelate.getDynamicObjectCollection("matchcditsubentry");
                if (subEntryCount.intValue() == subEntryList.size()) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6bcf\u6761\u5339\u914d\u5173\u7cfb\u5206\u5f55\u7684\u5339\u914d\u6761\u4ef6\u5b50\u5206\u5f55\u6570\u91cf\u5e94\u8be5\u4e00\u6837\u3002", (String)"MatchRuleSaveValidatorDataRepeat_2", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            }
        }
    }

    private void checkMatch(ExtendedDataEntity dataEntity) {
        DynamicObject entityObj = dataEntity.getDataEntity();
        DynamicObjectCollection matchRelates = entityObj.getDynamicObjectCollection("matchrelateentry");
        if (CollectionUtils.isEmpty((Collection)matchRelates)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5339\u914d\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MatchRuleSaveValidatorDataRepeat_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        for (DynamicObject matchRelate : matchRelates) {
            String seq = matchRelate.getString("seq");
            DynamicObjectCollection dynamicObjectCollection = matchRelate.getDynamicObjectCollection("matchcditsubentry");
            if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5339\u914d\u5173\u7cfb\u7b2c%s\u884c\u5bf9\u5e94\u5339\u914d\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MatchRuleSaveValidatorDataRepeat_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), seq));
        }
    }

    protected void valEntryRepeat(ExtendedDataEntity dataEntity) {
        ArrayList<String> entryDataList = new ArrayList<String>();
        DynamicObject entityObj = dataEntity.getDataEntity();
        DynamicObjectCollection wfBillEntry = entityObj.getDynamicObjectCollection("matchrelateentry");
        for (DynamicObject entryObj : wfBillEntry) {
            Object srcBillTypeObj = entryObj.get("srcbilltype");
            Object targetBillTypeObj = entryObj.get("targetbilltype");
            if (srcBillTypeObj == null && targetBillTypeObj == null) continue;
            int seq = entryObj.getInt("seq");
            String srcBillNumber = srcBillTypeObj == null ? "" : String.valueOf(((DynamicObject)srcBillTypeObj).getPkValue());
            String targetBillNumber = targetBillTypeObj == null ? "" : String.valueOf(((DynamicObject)targetBillTypeObj).getPkValue());
            String rowData = srcBillNumber + "_" + targetBillNumber;
            if (entryDataList.contains(rowData)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u5339\u914d\u89c4\u5219\u201d\u7684\u201c\u5339\u914d\u5173\u7cfb\u201d\u5206\u5f55\u7b2c%s\u884c\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u3002", (String)"MatchRuleSaveValidatorDataRepeat", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), seq));
                continue;
            }
            entryDataList.add(rowData);
        }
    }
}

