/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.op.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class ReWriteRuleSaveValidator
extends AbstractValidator {
    private static final String SELECT_VALUE = "selectvalue";
    private static final String CALCULATE_VALUE = "1";
    private static final String WRITEOFF_VALUE = "0";
    private static final String WRITEOFF_FIELD = "writeofffield";
    private static final String CALCULATE_FORMULA = "calculateformula";

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        Map<Object, String> allReRule = this.getAllReRule();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.checkEntity(dataEntity, allReRule);
        }
    }

    private void checkEntity(ExtendedDataEntity dataEntity, Map<Object, String> allReRule) {
        DynamicObject entityObj = dataEntity.getDataEntity();
        DynamicObjectCollection reWriteRuleEntity = entityObj.getDynamicObjectCollection("rewritebillentity");
        if (CollectionUtils.isEmpty((Collection)reWriteRuleEntity)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53cd\u5199\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReWriteRuleSaveValidator_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        DynamicObject wfType = entityObj.getDynamicObject("writeofftype");
        String wfTypeNumber = wfType.getString("name");
        String ruleNumber = allReRule.get(wfType.getPkValue());
        if (ruleNumber != null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6838\u9500\u7c7b\u522b(%s)\uff0c\u5df2\u5b58\u5728\u53cd\u5199\u89c4\u5219\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"ReWriteRuleSaveValidator_5", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), wfTypeNumber));
        }
        for (DynamicObject ob : reWriteRuleEntity) {
            DynamicObject alias = ob.getDynamicObject("alias");
            if (alias == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u9500\u5355\u636e\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReWriteRuleSaveValidator_3", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
                continue;
            }
            String number = alias.getString("falias");
            DynamicObjectCollection collection = ob.getDynamicObjectCollection("rewtformulentity");
            if (CollectionUtils.isEmpty((Collection)collection)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6838\u9500\u5355\u636e\u6807\u8bc6(%s)\u7684\u53cd\u5199\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReWriteRuleSaveValidator_4", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), number));
            }
            for (DynamicObject reFormlu : collection) {
                String value = reFormlu.getString("selectval");
                String writeoff = reFormlu.getString("wffieldnum");
                String calculate = reFormlu.getString("calformula");
                if (WRITEOFF_VALUE.equals(value) && StringUtils.isEmpty((CharSequence)writeoff)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d6\u503c\u65b9\u5f0f\u4e3a\u6838\u9500\u7ed3\u679c\uff0c\u6838\u9500\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReWriteRuleSaveValidator_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
                    continue;
                }
                if (!CALCULATE_VALUE.equals(value) || !StringUtils.isEmpty((CharSequence)calculate)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d6\u503c\u65b9\u5f0f\u4e3a\u8ba1\u7b97\u516c\u5f0f\uff0c\u8ba1\u7b97\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReWriteRuleSaveValidator_2", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            }
        }
    }

    private Map<Object, String> getAllReRule() {
        ExtendedDataEntity[] dataEntities;
        HashMap<Object, String> map = new HashMap<Object, String>(16);
        ArrayList<Object> list = new ArrayList<Object>(8);
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            Object pkValue = dataEntity.getDataEntity().getPkValue();
            list.add(pkValue);
        }
        QFilter qFilter = new QFilter("id", "not in", list);
        DynamicObjectCollection reRules = QueryServiceHelper.query((String)"msmod_rewriterule", (String)"number,writeofftype", (QFilter[])qFilter.toArray());
        for (DynamicObject reRule : reRules) {
            String number = reRule.getString("number");
            Object wfType = reRule.get("writeofftype");
            map.put(wfType, number);
        }
        return map;
    }
}

