/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.op.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.lang.FormLang;
import org.apache.commons.collections.CollectionUtils;

public class SchemeSetSaveValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(SchemeSetSaveValidator.class);

    public Set<String> preparePropertys() {
        Set strings = super.preparePropertys();
        strings.add("writeofftype");
        return strings;
    }

    public void validate() {
        logger.info("\u6d41\u7a0b\u6838\u9500\u6821\u9a8cinfo");
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        ArrayList<Object> list = new ArrayList<Object>(4);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.checkWriteoffBill(dataEntity);
            this.checkWriteOffScheme(dataEntity);
            this.checkWriteOffSchemeRepeat(dataEntity);
            this.checkWfTypeData(dataEntity);
            this.checkSameObject(list, dataEntity);
        }
    }

    private void checkWriteOffSchemeRepeat(ExtendedDataEntity dataEntity) {
        DynamicObject obj = dataEntity.getDataEntity();
        DynamicObjectCollection entires = obj.getDynamicObjectCollection("msmod_scheme_bill");
        block0: for (DynamicObject entry : entires) {
            HashSet<Long> existWfSchemes = new HashSet<Long>(16);
            DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("msmod_sch_subentry");
            for (DynamicObject subEntry : subEntries) {
                DynamicObject schemeObj = subEntry.getDynamicObject("sub_wf_scheme");
                if (schemeObj == null) continue;
                long wfTypeId = schemeObj.getLong("id");
                if (existWfSchemes.contains(wfTypeId)) {
                    this.addErrorMessage(dataEntity, FormLang.entryExistWriteOffScheme(subEntry.getInt("seq")));
                    continue block0;
                }
                existWfSchemes.add(wfTypeId);
            }
        }
    }

    private void checkSameObject(List<Object> list, ExtendedDataEntity dataEntity) {
        DynamicObject entityObj = dataEntity.getDataEntity();
        DynamicObject wfType = entityObj.getDynamicObject("writeofftype");
        if (list.contains(wfType.getPkValue())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u6838\u9500\u7c7b\u522b\u7684\u6838\u9500\u8bb0\u5f55\u5206\u7ec4\uff0c\u6838\u9500\u7c7b\u522b\u4e3a:%s\u3002", (String)"SchemeSetSaveValidator_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), wfType.getString("name")));
        }
        list.add(wfType.getPkValue());
    }

    private void checkWfTypeData(ExtendedDataEntity dataEntity) {
        DynamicObject entityObj = dataEntity.getDataEntity();
        DynamicObject wfType = entityObj.getDynamicObject("writeofftype");
        QFilter qFilter = new QFilter("writeofftype", "=", wfType.getPkValue());
        qFilter.and("enable", "=", (Object)"1");
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"msmod_schemeset", (QFilter[])qFilter.toArray(), null, (int)-1);
        ids.remove(entityObj.getPkValue());
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u9500\u7c7b\u522b\uff08%s\uff09,\u5df2\u5b58\u5728\u542f\u7528\u7684\u6d41\u7a0b\u6838\u9500\u914d\u7f6e\u3002", (String)"SchemeSetSaveValidator_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), wfType.getString("name")));
        }
    }

    private void checkWriteOffScheme(ExtendedDataEntity dataEntity) {
        DynamicObject entityObj = dataEntity.getDataEntity();
        DynamicObject headWfType = entityObj.getDynamicObject("writeofftype");
        DynamicObjectCollection schemeBillList = entityObj.getDynamicObjectCollection("msmod_scheme_bill");
        for (DynamicObject row : schemeBillList) {
            DynamicObjectCollection subentry = row.getDynamicObjectCollection("msmod_sch_subentry");
            if (CollectionUtils.isEmpty((Collection)subentry)) {
                DynamicObject writeOffBill = row.getDynamicObject("writeoffbill");
                if (writeOffBill == null) continue;
                String billName = row.getDynamicObject("writeoffbill").getString("falias");
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6838\u9500\u5355\u636e%s\u7684\u6838\u9500\u987a\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SchemeSetSaveValidator_04", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), billName));
                continue;
            }
            for (DynamicObject subRow : subentry) {
                DynamicObject sbuSchema = subRow.getDynamicObject("sub_wf_scheme");
                if (null == sbuSchema) continue;
                DynamicObject sbuWfType = sbuSchema.getDynamicObject("writeofftype");
                if (null == headWfType || null == sbuWfType || ObjectUtils.nullSafeEquals((Object)headWfType.getPkValue(), (Object)sbuWfType.getPkValue())) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6d41\u7a0b\u6838\u9500\u65b9\u6848\u7684\u6838\u9500\u7c7b\u522b\u4e0e\u57fa\u672c\u4fe1\u606f\u4e2d\u6240\u9009\u6838\u9500\u7c7b\u522b\u4e0d\u4e00\u81f4\u3002", (String)"SchemeSetSaveValidator_05", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            }
        }
    }

    private void checkWriteoffBill(ExtendedDataEntity dataEntity) {
        DynamicObject entityObj = dataEntity.getDataEntity();
        DynamicObjectCollection schemeBillList = entityObj.getDynamicObjectCollection("msmod_scheme_bill");
        for (DynamicObject bill : schemeBillList) {
            String seq = bill.getString("seq");
            this.dealWriteoffOp(dataEntity, bill, seq);
        }
    }

    private void dealWriteoffOp(ExtendedDataEntity dataEntity, DynamicObject bill, String seq) {
        String writeoffop = bill.getString("writeoffop");
        String rewriteoffop = bill.getString("rewriteoffop");
        if (writeoffop != null && rewriteoffop != null) {
            String[] writeoffopSplit = writeoffop.split(",");
            String[] rewriteoffopSplit = rewriteoffop.split(",");
            List<String> writeoffList = Arrays.asList(writeoffopSplit);
            for (String op : rewriteoffopSplit) {
                if (!StringUtils.isNotEmpty((CharSequence)op) || !writeoffList.contains(op)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6838\u9500\u5355\u636e\u7b2c%s\u884c\u6570\u636e\u6838\u9500\u548c\u53cd\u6838\u9500\u64cd\u4f5c\u76f8\u540c\u3002", (String)"SchemeSetSaveValidator_02", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), seq));
            }
        }
    }
}

