/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.op.validator;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.mpscmm.mscommon.writeoff.lang.FormLang;

public class ShareRuleSaveValidator
extends AbstractValidator {
    public void validate() {
        this.checkDenomAndNumer();
        this.checkConfigNoFilter();
        this.checkValueMethod();
    }

    private void checkValueMethod() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection shareRuleEntries = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            for (DynamicObject shareRuleEntry : shareRuleEntries) {
                DynamicObjectCollection shareRuleStandardEntries = shareRuleEntry.getDynamicObjectCollection("subentryentity");
                for (DynamicObject shareRuleStandardEntry : shareRuleStandardEntries) {
                    String valueMethod = shareRuleStandardEntry.getString("valuemethod");
                    if ("A".equals(valueMethod) && StringUtils.isEmpty((CharSequence)shareRuleStandardEntry.getString("sharebillfieldkey"))) {
                        this.addErrorMessage(dataEntity, FormLang.plsInsertFieldKey(shareRuleEntry.getInt("seq"), shareRuleStandardEntry.getInt("seq")));
                        continue;
                    }
                    if (!"C".equals(valueMethod) || !StringUtils.isEmpty((CharSequence)shareRuleStandardEntry.getString("wffieldplugin"))) continue;
                    this.addErrorMessage(dataEntity, FormLang.plsInsertPluginField(shareRuleEntry.getInt("seq"), shareRuleStandardEntry.getInt("seq")));
                }
            }
        }
    }

    private void checkConfigNoFilter() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            ArrayList<Integer> noneConfigSeqs = new ArrayList<Integer>(16);
            DynamicObjectCollection shareRuleEntries = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            for (DynamicObject shareRuleEntry : shareRuleEntries) {
                String filters = shareRuleEntry.getString("filtercondition");
                if (!StringUtils.isEmpty((CharSequence)filters)) continue;
                noneConfigSeqs.add(shareRuleEntry.getInt("seq"));
            }
            if (shareRuleEntries.size() <= 1 || noneConfigSeqs.isEmpty()) continue;
            this.addErrorMessage(dataEntity, FormLang.filterConditionNotAllowNull(noneConfigSeqs));
        }
    }

    private void checkDenomAndNumer() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection shareRuleEntries = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            for (DynamicObject shareRuleEntry : shareRuleEntries) {
                DynamicObjectCollection shareRuleStandardEntries = shareRuleEntry.getDynamicObjectCollection("subentryentity");
                int denoms = 0;
                int numers = 0;
                DynamicObject numBill = null;
                DynamicObject demBill = null;
                String shareMatchType = null;
                for (DynamicObject shareRuleStandardEntry : shareRuleStandardEntries) {
                    String shareWeight = shareRuleStandardEntry.getString("shareweight");
                    if ("0".equals(shareWeight)) {
                        ++numers;
                        numBill = shareRuleStandardEntry.getDynamicObject("sharewfbillalias");
                        continue;
                    }
                    if (!"1".equals(shareWeight)) continue;
                    ++denoms;
                    demBill = shareRuleStandardEntry.getDynamicObject("sharewfbillalias");
                    shareMatchType = shareRuleStandardEntry.getString("sharedembillmatchtype");
                }
                if (denoms > 1) {
                    this.addErrorMessage(dataEntity, FormLang.onlyOneDenominator(shareRuleEntry.getInt("seq")));
                    continue;
                }
                if (numers != 1) {
                    this.addErrorMessage(dataEntity, FormLang.onlyOneNumerator(shareRuleEntry.getInt("seq")));
                    continue;
                }
                if (demBill != null && StringUtils.isBlank(shareMatchType)) {
                    this.addErrorMessage(dataEntity, FormLang.plsInsertlineMatchType(shareRuleEntry.getInt("seq")));
                    continue;
                }
                if (numBill == null || demBill == null || !"0".equals(shareMatchType) || StringUtils.equals((CharSequence)numBill.getString("number"), (CharSequence)demBill.getString("number"))) continue;
                HashSet<String> srcNum = new HashSet<String>(16);
                HashSet<String> tgtDem = new HashSet<String>(16);
                DynamicObjectCollection matchEntries = shareRuleEntry.getDynamicObjectCollection("matchconditionentity");
                for (DynamicObject matchEntry : matchEntries) {
                    DynamicObject tgtBill = matchEntry.getDynamicObject("tgtwfbillalias");
                    DynamicObject srcBill = matchEntry.getDynamicObject("srcwfbillalias");
                    if (srcBill != null) {
                        srcNum.add(srcBill.getString("number"));
                    }
                    if (tgtBill == null) continue;
                    tgtDem.add(tgtBill.getString("number"));
                }
                if (srcNum.contains(numBill.getString("number")) && tgtDem.contains(demBill.getString("number"))) continue;
                this.addErrorMessage(dataEntity, FormLang.plsConfigSrcToTgtBillMatchEntry(shareRuleEntry.getInt("seq"), numBill, demBill));
            }
        }
    }
}

