/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.op.validator;

import java.util.Collection;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.lang.FormLang;
import org.apache.commons.collections.CollectionUtils;

public class WfTypeSortSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            this.checkEntity(dataEntity);
            this.checkWriteOffTypeRepeat(dataEntity);
        }
    }

    private void checkWriteOffTypeRepeat(ExtendedDataEntity dataEntity) {
        DynamicObject obj = dataEntity.getDataEntity();
        DynamicObjectCollection entires = obj.getDynamicObjectCollection("entryentity");
        HashSet<Long> existWfTypes = new HashSet<Long>(16);
        for (DynamicObject entry : entires) {
            DynamicObject wfTypeObj = entry.getDynamicObject("writeofftype");
            if (wfTypeObj == null) continue;
            long wfTypeId = wfTypeObj.getLong("id");
            if (existWfTypes.contains(wfTypeId)) {
                this.addErrorMessage(dataEntity, FormLang.entryExistWriteOffType(entry.getInt("seq")));
                break;
            }
            existWfTypes.add(wfTypeId);
        }
    }

    private void checkEntity(ExtendedDataEntity dataEntity) {
        DynamicObject entityObj = dataEntity.getDataEntity();
        DynamicObject billType = entityObj.getDynamicObject("writeoffbill");
        String op = entityObj.getString("writeoffop");
        String number = entityObj.getString("number");
        DynamicObjectCollection wfTypeSortEntity = entityObj.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)wfTypeSortEntity)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u9500\u7c7b\u522b\u987a\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WfTypeSortSaveValidator_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        for (DynamicObject ob : wfTypeSortEntity) {
            DynamicObject wfSchemeset = ob.getDynamicObject("writeoffschemeset");
            if (wfSchemeset == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u7684\u6838\u9500\u7c7b\u522b\u6216\u8005\u6d41\u7a0b\u6838\u9500\u914d\u7f6e\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"WfTypeSortSaveValidator_2", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
                continue;
            }
            QFilter qFilter = new QFilter("writeoffbill", "=", billType.getPkValue());
            qFilter.and("writeoffop", "=", (Object)op);
            qFilter.and("entryentity.writeoffschemeset", "=", wfSchemeset.getPkValue());
            qFilter.and("id", "!=", entityObj.getPkValue());
            boolean has = QueryServiceHelper.exists((String)"msmod_writeofftype_sort", (QFilter[])qFilter.toArray());
            if (!has) continue;
            String writeofftype = wfSchemeset.getString("writeofftype.name");
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u6838\u9500\u987a\u5e8f(%1$s)\uff0c\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u6838\u9500\u7c7b\u522b(%2$s)\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"WfTypeSortSaveValidator_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), number, writeofftype));
        }
    }
}

