/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.op.validator;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.manager.WriteOffParamManager;
import kd.mpscmm.mscommon.writeoff.lang.FormLang;
import org.apache.commons.collections.CollectionUtils;

public class WriteOffTypeSaveValidator
extends AbstractValidator {
    private static final String DYNAM_FIELD = "C";
    private static final String[] HEAD_KEY_FIELD = new String[]{"writeoffrecordbill"};
    private static final String[] WFBILL_KEY_FIELD = new String[]{"wfbillalias", "isautogenerate", "isinvolved"};
    private static final String[] WFFIELD_KEY_FIELD = new String[]{"wffieldplugin", "writeofffieldkey", "writeoffcalcfield", "calculationrule"};

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        boolean strictValidate = WriteOffParamManager.create().isStrictValidate();
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            this.validateMainShare(dataEntity);
            this.valEntryRepeat(dataEntity);
            this.checkWfRecord(dataEntity);
            this.checkMainField(dataEntity);
            this.checkAsstField(dataEntity);
            this.checkAutoGenerat(dataEntity);
            this.checkAutoBill(dataEntity);
            if (strictValidate) {
                this.checkSameBillAndFields(dataEntity);
            }
            this.checkWFFieldIsNull(dataEntity);
            this.checkWfBill(dataEntity);
        }
    }

    private void validateMainShare(ExtendedDataEntity dataEntity) {
        DynamicObject wfTypeEntity = dataEntity.getDataEntity();
        String wrtieOffType = wfTypeEntity.getString("writeofftype");
        if ("B".equals(wrtieOffType)) {
            boolean isConfigMain = false;
            int mainShareSeq = -1;
            DynamicObjectCollection wfBills = wfTypeEntity.getDynamicObjectCollection("writeoffbillentry");
            for (DynamicObject wfBill : wfBills) {
                if (!wfBill.getBoolean("ismainshare")) continue;
                mainShareSeq = wfBill.getInt("seq");
                isConfigMain = true;
            }
            if (!isConfigMain) {
                this.addErrorMessage(dataEntity, FormLang.writeOffTypeNotConfigMainShare());
            } else if (mainShareSeq != 1) {
                this.addErrorMessage(dataEntity, FormLang.writeOffTypeMustConfigFristLineMainShare());
            } else if (wfBills.size() > 2) {
                this.addErrorMessage(dataEntity, FormLang.writeOffTypeOnlySupportTwoBill());
            }
        }
    }

    private void checkWfBill(ExtendedDataEntity dataEntity) {
        Object pkId = dataEntity.getBillPkId();
        if (pkId.equals(0L)) {
            return;
        }
        if (!QueryServiceHelper.exists((String)"msmod_writeofftype", (Object)pkId)) {
            return;
        }
        DynamicObject wftypeObj = BusinessDataServiceHelper.loadSingle((Object)pkId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"msmod_writeofftype"));
        if (!this.checkChangeKeyField(wftypeObj, dataEntity.getDataEntity())) {
            return;
        }
        Object billPkId = dataEntity.getBillPkId();
        QFilter qFilter = new QFilter("writeofftype", "=", billPkId);
        this.checkConf("msmod_scheme", qFilter);
        this.checkConf("msmod_matchrule", qFilter);
        this.checkConf("msmod_schemeset", qFilter);
        this.checkConf("msmod_rewriterule", qFilter);
        QFilter recordGroupQFilter = new QFilter("wftype", "=", billPkId);
        this.checkConf("msmod_recordfieldgroup", recordGroupQFilter);
    }

    private boolean checkChangeKeyField(DynamicObject dbwftypeObj, DynamicObject curWftypeObj) {
        if (!this.checkFieldDataSame(dbwftypeObj, curWftypeObj, HEAD_KEY_FIELD)) {
            return true;
        }
        DynamicObjectCollection curEntryList = curWftypeObj.getDynamicObjectCollection("writeoffbillentry");
        DynamicObjectCollection dataBaseEntryList = dbwftypeObj.getDynamicObjectCollection("writeoffbillentry");
        if (curEntryList.size() != dataBaseEntryList.size()) {
            return true;
        }
        for (int i = 0; i < curEntryList.size(); ++i) {
            DynamicObject dataBaseEntry;
            DynamicObject curEntry = (DynamicObject)curEntryList.get(i);
            if (!this.checkFieldDataSame(curEntry, dataBaseEntry = (DynamicObject)dataBaseEntryList.get(i), WFBILL_KEY_FIELD)) {
                return true;
            }
            DynamicObjectCollection curEntryFields = curEntry.getDynamicObjectCollection("wffieldsubentry");
            DynamicObjectCollection dbEntryFields = dataBaseEntry.getDynamicObjectCollection("wffieldsubentry");
            if (curEntryFields.size() != dbEntryFields.size()) {
                return true;
            }
            for (int j = 0; j < curEntryFields.size(); ++j) {
                DynamicObject dbSubEntryField;
                DynamicObject curSubEntryField = (DynamicObject)curEntryFields.get(j);
                if (this.checkFieldDataSame(curSubEntryField, dbSubEntryField = (DynamicObject)dbEntryFields.get(j), WFFIELD_KEY_FIELD)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkFieldDataSame(DynamicObject obj, DynamicObject obj2, String[] Fields) {
        for (String field : Fields) {
            Object field1 = obj.get(field);
            Object field2 = obj2.get(field);
            boolean isSame = false;
            if (field1 == null || field2 == null) {
                if (field1 != null || field2 != null) return false;
                isSame = true;
            } else {
                isSame = field1 instanceof DynamicObject ? ((DynamicObject)field1).getPkValue().equals(((DynamicObject)field2).getPkValue()) : field1.equals(field2);
            }
            if (isSame) continue;
            return false;
        }
        return true;
    }

    private void checkConf(String entityName, QFilter qFilter) {
        DynamicObjectCollection results = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qFilter.toArray());
        if (!results.isEmpty()) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5f15\u7528\u4e86\u6b64\u6570\u636e\uff0c\u4e0d\u80fd\u4fee\u6539\u201c\u6838\u9500\u5355\u636e\u201d\u5b57\u6bb5\u3002", (String)"WriteOffTypeSaveValidator_5", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), dataEntityType.getDisplayName().getLocaleValue()));
        }
    }

    private void checkAsstField(ExtendedDataEntity dataEntity) {
        DynamicObject entityObj = dataEntity.getDataEntity();
        DynamicObjectCollection wfBillEntry = entityObj.getDynamicObjectCollection("writeoffbillentry");
        if (CollectionUtils.isEmpty((Collection)wfBillEntry)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u9500\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WriteOffTypeSaveValidatorDataRepeat_4", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        for (DynamicObject entry : wfBillEntry) {
            boolean isWf = entry.getBoolean("isinvolved");
            DynamicObject wfMapping = entry.getDynamicObject("wfmapping");
            if (isWf && wfMapping == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u9500\u5355\u636e\u7b2c{0}\u884c\uff0c\u53c2\u4e0e\u6838\u9500\u7684\u6838\u9500\u5355\u636e\uff0c\u6838\u9500\u8bb0\u5f55\u6620\u5c04\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WriteOffTypeSaveValidatorDataRepeat_16", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[]{entry.getInt("seq")}));
            }
            String seq = entry.getString("seq");
            DynamicObjectCollection wfFields = entry.getDynamicObjectCollection("wffieldsubentry");
            for (DynamicObject field : wfFields) {
                String valueMethod = field.getString("valuemethod");
                if (field.getBoolean("writeoffcalcfield") || !DYNAM_FIELD.equals(valueMethod)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6838\u9500\u5355\u636e\u7b2c%s\u884c\u672a\u5f00\u542f\u201c\u6838\u9500\u4e3b\u5b57\u6bb5\u201d\uff0c\u53d6\u503c\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u52a8\u6001\u5b57\u6bb5\u3002", (String)"WriteOffTypeSaveValidatorDataRepeat_14", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), seq));
            }
        }
    }

    private void checkWFFieldIsNull(ExtendedDataEntity dataEntity) {
        DynamicObject entity = dataEntity.getDataEntity();
        DynamicObjectCollection wfbills = entity.getDynamicObjectCollection("writeoffbillentry");
        for (DynamicObject wfbill : wfbills) {
            DynamicObjectCollection wfBillFields = wfbill.getDynamicObjectCollection("wffieldsubentry");
            for (DynamicObject wfBillField : wfBillFields) {
                String calformuladesc = wfBillField.getString("calformuladesc_tag");
                String wffieldplugin = wfBillField.getString("wffieldplugin");
                String writeofffieldkey = wfBillField.getString("writeofffieldkey");
                String valuemethod = wfBillField.getString("valuemethod");
                boolean writeoffcalcfield = wfBillField.getBoolean("writeoffcalcfield");
                if (!writeoffcalcfield && "B".equals(valuemethod)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u6838\u9500\u4e3b\u5b57\u6bb5\u7684\u53d6\u503c\u65b9\u5f0f\u4e0d\u80fd\u8bbe\u7f6e\u4e3a\u8ba1\u7b97\u516c\u5f0f\u3002", (String)"WriteOffTypeSaveValidator_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
                }
                if ("A".equals(valuemethod) && StringUtils.isEmpty((CharSequence)writeofffieldkey)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u9500\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WriteOffTypeSaveValidator_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
                    continue;
                }
                if ("B".equals(valuemethod)) {
                    if (StringUtils.isEmpty((CharSequence)calformuladesc)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u9500\u5b57\u6bb5\u8ba1\u7b97\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WriteOffTypeSaveValidator_2", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
                        continue;
                    }
                    CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)calformuladesc, CRCondition.class);
                    String expression = condition.getExpression();
                    if (!StringUtils.isEmpty((CharSequence)expression)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u9500\u5b57\u6bb5\u8ba1\u7b97\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WriteOffTypeSaveValidator_2", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
                    continue;
                }
                if (!DYNAM_FIELD.equals(valuemethod) || !StringUtils.isEmpty((CharSequence)wffieldplugin)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u52a8\u6001\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WriteOffTypeSaveValidator_3", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            }
        }
    }

    private void checkWfRecord(ExtendedDataEntity dataEntity) {
        DynamicObject entityObj = dataEntity.getDataEntity();
        DynamicObject recordObj = entityObj.getDynamicObject("writeoffrecordbill");
        boolean isLeftRightRecord = WriteOffTypeSaveValidator.isLeftRightRecord(recordObj);
        DynamicObjectCollection entryList = entityObj.getDynamicObjectCollection("writeoffbillentry");
        if (isLeftRightRecord && CollectionUtils.isNotEmpty((Collection)entryList) && entryList.size() > 2) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5de6\u53f3\u7ed3\u6784\u6838\u9500\u8bb0\u5f55\u53ea\u652f\u6301\u4e24\u65b9\u6838\u9500\u3002", (String)"WriteOffTypeSaveValidatorDataRepeat_10", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
    }

    private void checkAutoBill(ExtendedDataEntity dataEntity) {
        DynamicObject entityObj = dataEntity.getDataEntity();
        DynamicObjectCollection wfBillEntrys = entityObj.getDynamicObjectCollection("writeoffbillentry");
        DynamicObjectCollection autoEntrys = entityObj.getDynamicObjectCollection("autogenebillentry");
        ArrayList list = new ArrayList();
        for (DynamicObject entry : wfBillEntrys) {
            DynamicObject alias = entry.getDynamicObject("wfbillalias");
            if (alias == null) continue;
            boolean aBoolean = entry.getBoolean("isautogenerate");
            HashMap<Object, Boolean> map = new HashMap<Object, Boolean>(16);
            map.put(alias.getPkValue(), aBoolean);
            list.add(map);
        }
        for (DynamicObject entry : autoEntrys) {
            DynamicObject targetBillType = entry.getDynamicObject("targetbilltype");
            DynamicObject srcBillType = entry.getDynamicObject("srcbilltype");
            List tagList = list.stream().filter(n -> n.get(targetBillType.getPkValue()) != null).collect(Collectors.toList());
            List srcList = list.stream().filter(n -> n.get(srcBillType.getPkValue()) != null).collect(Collectors.toList());
            String seq = entry.getString("seq");
            if (CollectionUtils.isEmpty(srcList)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u751f\u6210\u5355\u636e\u7b2c%s\u884c\u6765\u6e90\u5355\u636e\u4e0d\u662f\u5df2\u9009\u6838\u9500\u5355\u636e\u3002", (String)"WriteOffTypeSaveValidatorDataRepeat_6", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), seq));
                return;
            }
            if (CollectionUtils.isEmpty(tagList)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u751f\u6210\u5355\u636e\u7b2c%s\u884c\u76ee\u6807\u5355\u636e\u4e0d\u662f\u5df2\u9009\u6838\u9500\u5355\u636e\u3002", (String)"WriteOffTypeSaveValidatorDataRepeat_7", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), seq));
                return;
            }
            List srcAuto = srcList.stream().filter(n -> ((Boolean)n.get(srcBillType.getPkValue())).equals(Boolean.FALSE)).collect(Collectors.toList());
            List tagAuto = tagList.stream().filter(n -> ((Boolean)n.get(targetBillType.getPkValue())).equals(Boolean.TRUE)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(srcAuto)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u751f\u6210\u5355\u636e\u7b2c%s\u884c\u6765\u6e90\u5355\u636e\u65e0\u975e\u81ea\u52a8\u751f\u6210\u5355\u636e\u3002", (String)"WriteOffTypeSaveValidatorDataRepeat_8", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), seq));
            }
            if (!CollectionUtils.isEmpty(tagAuto)) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u751f\u6210\u5355\u636e\u7b2c%s\u884c\u76ee\u6807\u5355\u636e\u65e0\u81ea\u52a8\u751f\u6210\u5355\u636e\u3002", (String)"WriteOffTypeSaveValidatorDataRepeat_9", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), seq));
        }
    }

    private void checkAutoGenerat(ExtendedDataEntity dataEntity) {
        DynamicObject entityObj = dataEntity.getDataEntity();
        DynamicObjectCollection wfBillEntrys = entityObj.getDynamicObjectCollection("writeoffbillentry");
        DynamicObjectCollection autoEntrys = entityObj.getDynamicObjectCollection("autogenebillentry");
        HashMap<Object, String> map = new HashMap<Object, String>(16);
        for (DynamicObject dynamicObject : wfBillEntrys) {
            if (!dynamicObject.getBoolean("isautogenerate")) continue;
            DynamicObject alias = dynamicObject.getDynamicObject("wfbillalias");
            String seq = dynamicObject.getString("seq");
            map.put(alias.getPkValue(), seq);
        }
        for (DynamicObject dynamicObject : autoEntrys) {
            DynamicObject targetType = dynamicObject.getDynamicObject("targetbilltype");
            map.remove(targetType.getPkValue());
        }
        if (map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                String seq = (String)entry.getValue();
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6838\u9500\u5355\u636e\u7b2c%s\u884c\u5df2\u9009\u81ea\u52a8\u751f\u6210\uff0c\u5fc5\u987b\u914d\u7f6eBotp\u89c4\u5219\u3002", (String)"WriteOffTypeSaveValidatorDataRepeat_5", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), seq));
            }
        }
    }

    private void checkMainField(ExtendedDataEntity dataEntity) {
        DynamicObject entityObj = dataEntity.getDataEntity();
        DynamicObjectCollection wfBillEntry = entityObj.getDynamicObjectCollection("writeoffbillentry");
        if (CollectionUtils.isEmpty((Collection)wfBillEntry)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u9500\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WriteOffTypeSaveValidatorDataRepeat_4", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        String wfType = entityObj.getString("writeofftype");
        for (DynamicObject entry : wfBillEntry) {
            String seq = entry.getString("seq");
            ArrayList<DynamicObject> mainFields = new ArrayList<DynamicObject>(5);
            boolean isWf = entry.getBoolean("isinvolved");
            boolean ismainShare = entry.getBoolean("ismainshare");
            boolean isCheckFieldsSingle = false;
            if ("B".equals(wfType)) {
                if (ismainShare) {
                    isCheckFieldsSingle = true;
                }
            } else if (isWf) {
                isCheckFieldsSingle = true;
            }
            DynamicObjectCollection wfFields = entry.getDynamicObjectCollection("wffieldsubentry");
            for (DynamicObject field : wfFields) {
                if (!field.getBoolean("writeoffcalcfield")) continue;
                mainFields.add(field);
            }
            if (mainFields.isEmpty() && isCheckFieldsSingle) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6838\u9500\u5355\u636e\u7b2c%s\u884c\u5fc5\u987b\u8bbe\u7f6e\u4e00\u4e2a\u6838\u9500\u4e3b\u5b57\u6bb5\u3002", (String)"WriteOffTypeSaveValidatorDataRepeat_2", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), seq));
                continue;
            }
            if (mainFields.size() <= 1) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6838\u9500\u5355\u636e\u7b2c%s\u884c\u53ea\u80fd\u8bbe\u7f6e\u4e00\u4e2a\u6838\u9500\u4e3b\u5b57\u6bb5\u3002", (String)"WriteOffTypeSaveValidatorDataRepeat_3", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), seq));
        }
    }

    private static boolean isLeftRightRecord(DynamicObject wfRecordBill) {
        String recordTypeName = wfRecordBill.getString("number");
        if (recordTypeName == null) {
            return false;
        }
        String inheritPath = EntityMetadataCache.getDataEntityType((String)recordTypeName).getInheritPath();
        if (inheritPath != null) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityTypeById((String)inheritPath);
            if ("msmod_leftrighwfrecordtpl".equals(dataEntityType.getName())) {
                return true;
            }
            if ("msmod_updownwfrecordtpl".equals(dataEntityType.getName())) {
                return false;
            }
        }
        return false;
    }

    private void valEntryRepeat(ExtendedDataEntity dataEntity) {
        HashSet<Object> ids = new HashSet<Object>(16);
        DynamicObject entityObj = dataEntity.getDataEntity();
        DynamicObjectCollection wfBillEntry = entityObj.getDynamicObjectCollection("writeoffbillentry");
        for (DynamicObject entryObj : wfBillEntry) {
            int seq = entryObj.getInt("seq");
            DynamicObject alias = entryObj.getDynamicObject("wfbillalias");
            if (alias == null) {
                throw new KDBizException(FormLang.writeOffTypeAliasIsEmpty(seq));
            }
            if (ids.contains(alias.getPkValue())) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u6838\u9500\u7c7b\u522b\u201d\u7684\u201c\u6838\u9500\u5355\u636e\u6807\u8bc6\u201d\u5206\u5f55\u7b2c%s\u884c\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u3002", (String)"WriteOffTypeSaveValidatorDataRepeat_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), seq));
                continue;
            }
            ids.add(alias.getPkValue());
        }
    }

    private void checkSameBillAndFields(ExtendedDataEntity dataEntity) {
        DynamicObject curWriteOffObj = dataEntity.getDataEntity();
        Long entityId = curWriteOffObj.getLong("id");
        String writeOffNumber = curWriteOffObj.getString("number");
        DynamicObjectCollection wfBillEntrys = curWriteOffObj.getDynamicObjectCollection("writeoffbillentry");
        ArrayList<Object> wfBillNumberSet = new ArrayList<Object>(16);
        for (DynamicObject entry : wfBillEntrys) {
            DynamicObject wfBillNumer = entry.getDynamicObject("wfbillalias");
            wfBillNumberSet.add(wfBillNumer.get("wfbill.number"));
        }
        Set<String> wfBillRelKeys = this.buildWriteOffBillRelKeys(curWriteOffObj);
        Map<String, DynamicObject> curWfFieldKeys = this.buildWriteOffFieldKeys(curWriteOffObj);
        QFilter sameWfBillQ = new QFilter("number", "!=", (Object)writeOffNumber).and("writeofftype", "=", (Object)curWriteOffObj.getString("writeofftype")).and("enable", "=", (Object)Boolean.TRUE);
        if (entityId != null) {
            sameWfBillQ.and("id", "!=", (Object)entityId);
        }
        sameWfBillQ.and("writeoffbillentry.wfbillalias.wfbill.number", "in", wfBillNumberSet);
        Map sameWfTypes = BusinessDataServiceHelper.loadFromCache((String)"msmod_writeofftype", (QFilter[])sameWfBillQ.toArray());
        if (sameWfTypes.isEmpty()) {
            return;
        }
        for (DynamicObject dbWriteOffType : sameWfTypes.values()) {
            HashSet<String> relJoinSet = new HashSet<String>(wfBillRelKeys);
            relJoinSet.retainAll(this.buildWriteOffBillRelKeys(dbWriteOffType));
            if (relJoinSet.isEmpty()) continue;
            Map<String, DynamicObject> dbFieldKeys = this.buildWriteOffFieldKeys(dbWriteOffType);
            HashSet<String> fieldKeyJoinSet = new HashSet<String>(curWfFieldKeys.keySet());
            fieldKeyJoinSet.retainAll(dbFieldKeys.keySet());
            if (fieldKeyJoinSet.isEmpty()) continue;
            ArrayList<String> fieldInfo = new ArrayList<String>(16);
            for (String sameFieldKey : fieldKeyJoinSet) {
                DynamicObject fiedEntry = curWfFieldKeys.get(sameFieldKey);
                String fieldName = fiedEntry.getString("writeofffieldname");
                DynamicObject wfBillEntry = (DynamicObject)fiedEntry.getParent();
                DynamicObject wfBillNumer = wfBillEntry.getDynamicObject("wfbillalias");
                String entityName = wfBillNumer.getString("wfbill.name");
                fieldInfo.add(entityName + "-" + fieldName);
            }
            String billNum = dbWriteOffType.getString("number");
            String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u6838\u9500\u5355\u636e\u3001\u76f8\u540c\u6838\u9500\u5b57\u6bb5\u7684\u6838\u9500\u7c7b\u522b\u7f16\u7801{0}\u3002", (String)"WriteOffTypeSaveValidatorDataRepeat_13", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), billNum);
            this.addErrorMessage(dataEntity, errorMsg + fieldInfo);
        }
    }

    private Set<String> buildWriteOffBillRelKeys(DynamicObject curWriteOffObj) {
        HashSet<String> keys = new HashSet<String>(16);
        ArrayList<String> writeOffBills = new ArrayList<String>(16);
        DynamicObjectCollection wfBillEntrys = curWriteOffObj.getDynamicObjectCollection("writeoffbillentry");
        for (DynamicObject entry : wfBillEntrys) {
            DynamicObject wfBillNumer = entry.getDynamicObject("wfbillalias");
            String wfBillEntity = wfBillNumer.getString("wfbill.number");
            if (!writeOffBills.isEmpty()) {
                for (String wfBill : writeOffBills) {
                    keys.add(wfBill + "@" + wfBillEntity);
                    keys.add(wfBillEntity + "@" + wfBill);
                }
            }
            writeOffBills.add(wfBillNumer.getString("wfbill.number"));
        }
        return keys;
    }

    private Map<String, DynamicObject> buildWriteOffFieldKeys(DynamicObject curWriteOffObj) {
        HashMap<String, DynamicObject> fieldKeyEntryMap = new HashMap<String, DynamicObject>();
        DynamicObjectCollection wfBillEntrys = curWriteOffObj.getDynamicObjectCollection("writeoffbillentry");
        for (DynamicObject entry : wfBillEntrys) {
            DynamicObject wfBillNumer = entry.getDynamicObject("wfbillalias");
            String wfBillEntity = wfBillNumer.getString("wfbill.number");
            DynamicObjectCollection fieldKeyEntry = entry.getDynamicObjectCollection("wffieldsubentry");
            for (DynamicObject wfFieldEntry : fieldKeyEntry) {
                String fieldKey = wfFieldEntry.getString("writeofffieldkey");
                if (!StringUtils.isNotEmpty((CharSequence)fieldKey)) continue;
                String key = wfBillEntity + "#" + fieldKey;
                fieldKeyEntryMap.put(key, wfFieldEntry);
            }
        }
        return fieldKeyEntryMap;
    }
}

