/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.op.validator;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;

public class WriteoffSchemeSaveValidator
extends AbstractValidator {
    public void validate() {
        this.checkMatchRule();
        this.checkRef();
    }

    private void checkRef() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        HashMap<Long, Long> wfTypeMap = new HashMap<Long, Long>(4);
        List ids = Stream.of(dataEntities).map(item -> item.getValue("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", ids);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)WriteoffSchemeSaveValidator.class.getName(), (String)"msmod_scheme", (String)"id,writeofftype", (QFilter[])qFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long id = row.getLong("id");
                Long wfTypeId = row.getLong("writeofftype");
                wfTypeMap.put(id, wfTypeId);
            }
        }
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject entity = extendedDataEntity.getDataEntity();
            Long schemaId = (Long)entity.getPkValue();
            Object oldWfTypeId = wfTypeMap.get(schemaId);
            Long newWfTypeId = entity.getLong("writeofftype.id");
            if (0L == schemaId || ObjectUtils.nullSafeEquals(oldWfTypeId, (Object)newWfTypeId) || !BaseDataRefrenceHelper.isRefrenced((String)"msmod_scheme", (Object)schemaId)) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6838\u9500\u65b9\u6848\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u4fee\u6539\u6838\u9500\u7c7b\u522b\u3002", (String)"WriteoffSchemeSaveValidator_3", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
    }

    private void checkMatchRule() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            DynamicObject entry = dataEntity.getDataEntity();
            boolean aBoolean = entry.getBoolean("isunconditionmatch");
            DynamicObject writeOffType = entry.getDynamicObject("writeofftype");
            DynamicObject match = entry.getDynamicObject("matchrule");
            if (aBoolean) {
                if (match != null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u6761\u4ef6\u5339\u914d\uff0c\u5339\u914d\u89c4\u5219\u5fc5\u987b\u4e3a\u7a7a\u3002", (String)"WriteoffSchemeSaveValidator_2", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
                }
            } else if (match == null) {
                Object pkValue = writeOffType.getPkValue();
                QFilter qFilter = new QFilter("id", "=", pkValue);
                qFilter.and("writeoffbillentry.isautogenerate", "=", (Object)Boolean.FALSE);
                DynamicObjectCollection noAutoGeneBillList = QueryServiceHelper.query((String)"msmod_writeofftype", (String)"writeoffbillentry.id", (QFilter[])qFilter.toArray());
                if (noAutoGeneBillList.size() != 1) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5339\u914d\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WriteoffSchemeSaveValidator_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
                }
            }
            if (!this.getIsShareType(entry) || entry.getDynamicObject("sharerule") != null) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u644a\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"matruleNotEmpty", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
    }

    private boolean getIsShareType(DynamicObject schemeObj) {
        DynamicObject wfTypeDym = schemeObj.getDynamicObject("writeofftype");
        String writeOffType = wfTypeDym.getString("writeofftype");
        return "B".equals(writeOffType);
    }
}

