/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.mpscmm.mscommon.writeoff.params;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.impl.AbstractWFFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.impl.FalseFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.impl.QWFFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.impl.WFMatchFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchConditionInfo;
import kd.mpscmm.mscommon.writeoff.common.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.lang.NounLang;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IMatchPlugin;

public class ExtMatchInfo {
    private boolean isNotMatch = false;
    private List<QFilter> filterLists = new ArrayList<QFilter>(16);
    private Set<Object> ids = new HashSet<Object>(16);
    private List<AbstractWFFilter> wfFilter = new ArrayList<AbstractWFFilter>(16);

    public boolean isNotMatch() {
        return this.isNotMatch;
    }

    public Set<Object> getIds() {
        return this.ids;
    }

    public void setNotMatch() {
        this.isNotMatch = true;
    }

    public void setFilter(QFilter filter) {
        if (filter != null) {
            if (this.filterLists == null) {
                this.filterLists = new ArrayList<QFilter>(16);
            }
            this.filterLists.add(filter);
        }
    }

    public void addIds(Object[] matchIds) {
        this.ids.addAll(Arrays.asList(matchIds));
    }

    public List<AbstractWFFilter> getWfFilter() {
        return this.wfFilter;
    }

    public void initMatchFilter(IMatchPlugin plugin) {
        if (this.isNotMatch) {
            FalseFilter notMatchFilter = new FalseFilter();
            WriteOffMatchConditionInfo condition = new WriteOffMatchConditionInfo(NounLang.extFilter(plugin.getClass()), null, String.valueOf(CommonHelper.getEmptyFilter()));
            notMatchFilter.setInfo(condition);
            this.wfFilter.add(notMatchFilter);
            return;
        }
        if (!this.ids.isEmpty()) {
            WFMatchFilter matchFilter = new WFMatchFilter("id", "in", this.ids);
            WriteOffMatchConditionInfo condition = new WriteOffMatchConditionInfo(NounLang.extFilter(plugin.getClass()), "in", String.format("id:%s", String.valueOf(this.ids)));
            matchFilter.setInfo(condition);
            this.wfFilter.add(matchFilter);
        }
        for (QFilter filter : this.filterLists) {
            QWFFilter qFilter = new QWFFilter(filter);
            WriteOffMatchConditionInfo condition = new WriteOffMatchConditionInfo(NounLang.extFilter(plugin.getClass()), null, String.valueOf(filter));
            qFilter.setInfo(condition);
            this.wfFilter.add(qFilter);
        }
    }

    public static ExtMatchInfo merge(ExtMatchInfo a, ExtMatchInfo b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ExtMatchInfo info = new ExtMatchInfo();
        info.isNotMatch = a.isNotMatch || b.isNotMatch;
        info.filterLists.addAll(a.filterLists);
        info.filterLists.addAll(b.filterLists);
        info.ids.addAll(a.ids);
        info.ids.addAll(b.ids);
        return info;
    }
}

