/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.config.vo;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareBillConfig;
import kd.mpscmm.mscommon.feeshare.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.business.config.manager.WriteOffParamManager;
import kd.mpscmm.mscommon.writeoff.business.config.vo.AbstractObjMappingConfig;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.mpscmm.mscommon.writeoff.common.helper.EntityParseHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffRecordHelper;
import kd.mpscmm.mscommon.writeoff.common.util.DynamicObjectUtil;

public class FeeShareTypeConfig
extends AbstractObjMappingConfig {
    private boolean leftRightRecord;
    private WriteoffTemplateTypeEnum wfRecordTemplateEnum;
    private String wfRecordTemplateNum;
    private String recordNum;
    private String recordEntryType;
    private Integer priority = Integer.MAX_VALUE;
    private List<FeeShareBillConfig> billConfigs = new ArrayList<FeeShareBillConfig>(16);
    private Map<String, Object> extParam = new HashMap<String, Object>(16);
    private String wfseq;
    private boolean iswriteoffshare = true;

    public static FeeShareTypeConfig buildById(Long typeId) {
        DynamicObject writeOffObj = BusinessDataServiceHelper.loadSingleFromCache((Object)typeId, (String)"msmod_writeofftype");
        return FeeShareTypeConfig.build(writeOffObj);
    }

    public static FeeShareTypeConfig build(DynamicObject writeOffTypeEntity) {
        FeeShareTypeConfig config = new FeeShareTypeConfig(writeOffTypeEntity);
        config.initRecordInfo();
        config.initWriteOffBillConfig();
        return config;
    }

    public static FeeShareTypeConfig build(DynamicObject writeOffObj, WriteOffParamManager wfParam) {
        FeeShareTypeConfig config = FeeShareTypeConfig.build(writeOffObj);
        config.iswriteoffshare = wfParam.isWriteOffShare();
        return config;
    }

    private void initRecordInfo() {
        DynamicObject writeOffRecordObj = this.getObj().getDynamicObject("writeoffrecordbill");
        if (writeOffRecordObj != null) {
            WriteoffTemplateTypeEnum wfTemplateType;
            String recordNum;
            this.recordNum = recordNum = writeOffRecordObj.getString("number");
            this.recordEntryType = "entry";
            this.wfRecordTemplateEnum = wfTemplateType = WriteOffRecordHelper.getWfTemplateTypeByChildEntity((String)recordNum);
            MainEntityType inheritEntity = EntityParseHelper.getInheritEntity((String)recordNum);
            if (inheritEntity != null) {
                String templateName;
                this.wfRecordTemplateNum = templateName = inheritEntity.getName();
            }
        }
    }

    private void initWriteOffBillConfig() {
        DynamicObjectCollection writeOffBillEntities = this.getObj().getDynamicObjectCollection("writeoffbillentry");
        for (DynamicObject writeOffBillEntry : writeOffBillEntities) {
            FeeShareBillConfig writeOffBillConfig = FeeShareBillConfig.build(writeOffBillEntry);
            writeOffBillConfig.setTypeConfig(this);
            this.billConfigs.add(writeOffBillConfig);
        }
        this.billConfigs.sort(Comparator.comparingInt(FeeShareBillConfig::getSeq));
    }

    public FeeShareBillConfig getMainShareConfig() {
        if (this.isShare()) {
            for (FeeShareBillConfig writeOffBillConfig : this.billConfigs) {
                if (!writeOffBillConfig.isMainShare()) continue;
                return writeOffBillConfig;
            }
        }
        return null;
    }

    public FeeShareBillConfig getAssistShareConfig() {
        if (this.isShare()) {
            for (FeeShareBillConfig writeOffBillConfig : this.billConfigs) {
                if (writeOffBillConfig.isMainShare()) continue;
                return writeOffBillConfig;
            }
        }
        return null;
    }

    private FeeShareTypeConfig(DynamicObject obj) {
        super(obj);
    }

    public Long getId() {
        return DynamicObjectUtil.getPkValue((DynamicObject)this.getObj());
    }

    public String getName() {
        return this.getObj().getString("name");
    }

    public FeeShareBillConfig getBillConfigsById(Long wfBillId) {
        return this.billConfigs.stream().filter(n -> n.getObjId().equals(wfBillId)).findFirst().orElse(null);
    }

    public FeeShareBillConfig getBillConfigsByMainFieldId(Long wfBillId) {
        return this.billConfigs.stream().filter(n -> n.getWriteOffColumnConfig().getObjId().equals(wfBillId)).findFirst().orElse(null);
    }

    public boolean isLeftRightRecord() {
        return this.leftRightRecord;
    }

    public void setLeftRightRecord(boolean leftRightRecord) {
        this.leftRightRecord = leftRightRecord;
    }

    public WriteoffTemplateTypeEnum getWfRecordTemplateEnum() {
        return this.wfRecordTemplateEnum;
    }

    public String getWfRecordTemplateNum() {
        return this.wfRecordTemplateNum;
    }

    public String getRecordNum() {
        return this.recordNum;
    }

    @Deprecated
    public String getRecordBillType() {
        return this.recordNum;
    }

    public String getRecordEntryType() {
        return this.recordEntryType;
    }

    public String getWriteOffPluginName() {
        return this.getObj().getString("writeoffplugin");
    }

    public List<FeeShareBillConfig> getBillConfigs() {
        return this.billConfigs;
    }

    public void setBillConfigs(List<FeeShareBillConfig> billConfigs) {
        this.billConfigs = billConfigs;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        if (priority != null) {
            this.priority = priority;
        }
    }

    public List<Long> getRecordMappingIdByWfType() {
        ArrayList<Long> mappingIds = new ArrayList<Long>(4);
        DynamicObjectCollection wfBills = this.getObj().getDynamicObjectCollection("writeoffbillentry");
        for (DynamicObject wfBill : wfBills) {
            DynamicObject mapping = wfBill.getDynamicObject("wfmapping");
            if (mapping == null) continue;
            mappingIds.add((Long)mapping.getPkValue());
        }
        return mappingIds;
    }

    public FeeShareBillConfig getBillConf(String billAlias) {
        return this.billConfigs.stream().filter(n -> n.getBillAlias().equals(billAlias)).findFirst().orElse(null);
    }

    public String getWfseq() {
        return this.wfseq;
    }

    public void setWfseq(String wfseq) {
        this.wfseq = wfseq;
    }

    public String getType() {
        return this.getObj().getString("writeofftype");
    }

    public boolean isShare() {
        if (!this.iswriteoffshare && (WriteOffTypeIdConst.HXLB_ACTUALFEE_SHARE.equals(this.getObjId()) || WriteOffTypeIdConst.HXLB_ESTFEE_SHARE.equals(this.getObjId()))) {
            return false;
        }
        return "B".equals(this.getType());
    }

    public String getTypeName() {
        return this.getObj().getString("name");
    }

    public void setExtParam(Map<String, Object> extParam) {
        this.extParam = extParam;
    }

    public Map<String, Object> getWfExtParams() {
        return this.extParam;
    }
}

