/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.config.vo;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsLargeTextValue;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchConditionConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchRuleConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareMatchGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FsDataTable;
import kd.mpscmm.mscommon.feeshare.common.util.MatcherUtil;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.FilterFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.IWFFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.impl.AbstractWFFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.impl.WFMatchFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchConditionInfo;
import kd.mpscmm.mscommon.writeoff.common.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.common.util.DynamicObjectUtil;

public class FsMatchRelationConfig
implements Cloneable {
    protected static final Log logger = LogFactory.getLog(FsMatchRelationConfig.class);
    private Long wfTypeId;
    private Long matchId;
    private Long matchEntryId;
    private String srcBillTypeKey;
    private String targetBillTypeKey;
    private String srcBillType;
    private String targetBillType;
    private FsMatchRuleConfig matchRuleConfig = null;
    private List<FsMatchConditionConfig> matchConditionConfigs;
    private String trackRelation = null;

    static FsMatchRelationConfig build(FsMatchRuleConfig matchRuleConfig, DynamicObject matchRelation) {
        FsMatchRelationConfig matchRelationConfig = new FsMatchRelationConfig();
        matchRelationConfig.matchRuleConfig = matchRuleConfig;
        DynamicObject srcBillTypeObject = matchRelation.getDynamicObject("srcbilltype");
        String srcBillTypeKey = CommonHelper.getWfBillKey((DynamicObject)srcBillTypeObject);
        matchRelationConfig.setSrcBillTypeKey(srcBillTypeKey);
        String srcBillType = srcBillTypeObject == null ? null : srcBillTypeObject.getDynamicObject("wfbill").getString("number");
        matchRelationConfig.setSrcBillType(srcBillType);
        DynamicObject parent = (DynamicObject)matchRelation.getParent();
        DynamicObject wfType = parent.getDynamicObject("writeofftype");
        matchRelationConfig.setMatchId((Long)parent.getPkValue());
        matchRelationConfig.setWfTypeId((Long)wfType.getPkValue());
        matchRelationConfig.setMatchEntryId((Long)matchRelation.getPkValue());
        DynamicObject targetBillTypeObject = matchRelation.getDynamicObject("targetbilltype");
        String targetBillTypeKey = CommonHelper.getWfBillKey((DynamicObject)targetBillTypeObject);
        matchRelationConfig.setTargetBillTypeKey(targetBillTypeKey);
        String targetBillType = targetBillTypeObject == null ? null : targetBillTypeObject.getDynamicObject("wfbill").getString("number");
        matchRelationConfig.setTargetBillType(targetBillType);
        DynamicObjectCollection conditions = matchRelation.getDynamicObjectCollection("matchcditsubentry");
        ArrayList<FsMatchConditionConfig> matchConditionConfigs = new ArrayList<FsMatchConditionConfig>(16);
        for (DynamicObject matchCondition : conditions) {
            FsMatchConditionConfig conditionConfig = FsMatchConditionConfig.build(matchCondition);
            conditionConfig.setSrcBillType(srcBillType);
            conditionConfig.setTargetBillType(targetBillType);
            matchConditionConfigs.add(conditionConfig);
        }
        matchRelationConfig.setMatchConditionConfigs(matchConditionConfigs);
        return matchRelationConfig;
    }

    public FsMatchRelationConfig clone() {
        FsMatchRelationConfig config;
        try {
            config = (FsMatchRelationConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (this.matchConditionConfigs != null) {
            ArrayList<FsMatchConditionConfig> list = new ArrayList<FsMatchConditionConfig>(16);
            for (FsMatchConditionConfig matchConditionConfig : this.matchConditionConfigs) {
                list.add(matchConditionConfig.clone());
            }
            config.matchConditionConfigs = list;
        }
        return config;
    }

    public List<String> getMatchCondtionFields() {
        return this.matchConditionConfigs.stream().map(FsMatchConditionConfig::getSrcBillFieldKey).collect(Collectors.toList());
    }

    public List<FsMatchConditionConfig> getMatchConditionConfigs() {
        return this.matchConditionConfigs;
    }

    private void setMatchConditionConfigs(List<FsMatchConditionConfig> matchConditionConfigs) {
        this.matchConditionConfigs = matchConditionConfigs;
    }

    public String getSrcBillTypeKey() {
        return this.srcBillTypeKey;
    }

    public void setSrcBillTypeKey(String srcBillTypeKey) {
        this.srcBillTypeKey = srcBillTypeKey;
    }

    public String getTargetBillTypeKey() {
        return this.targetBillTypeKey;
    }

    public void setTargetBillTypeKey(String targetBillTypeKey) {
        this.targetBillTypeKey = targetBillTypeKey;
    }

    public String getSrcBillType() {
        return this.srcBillType;
    }

    public void setSrcBillType(String srcBillType) {
        this.srcBillType = srcBillType;
    }

    public String getTargetBillType() {
        return this.targetBillType;
    }

    public void setTargetBillType(String targetBillType) {
        this.targetBillType = targetBillType;
    }

    public Long getMatchEntryId() {
        return this.matchEntryId;
    }

    public void setMatchEntryId(Long matchEntryId) {
        this.matchEntryId = matchEntryId;
    }

    public Long getMatchId() {
        return this.matchId;
    }

    public void setMatchId(Long matchId) {
        this.matchId = matchId;
    }

    public Long getWfTypeId() {
        return this.wfTypeId;
    }

    public void setWfTypeId(Long wfTypeId) {
        this.wfTypeId = wfTypeId;
    }

    public List<FsMatchConditionConfig> getHintConfigs() {
        return this.getMatchConditionConfigs().stream().filter(n -> n.getHint()).collect(Collectors.toList());
    }

    public boolean isOnHint() {
        List<FsMatchConditionConfig> hintConfigs = this.getHintConfigs();
        return hintConfigs != null && !hintConfigs.isEmpty();
    }

    public String toString() {
        return "[srcBillType=" + this.srcBillType + ", targetBillType=" + this.targetBillType + "]";
    }

    public List<QFilter> getHintFilter(List<FeeShareMatchGroup> groups, String wfMainFieldId) {
        List<FsMatchConditionConfig> hintFieldConfigs = this.matchConditionConfigs.stream().filter(n -> n.getHint()).collect(Collectors.toList());
        String[] hintFields = new String[hintFieldConfigs.size()];
        int index = 0;
        for (FsMatchConditionConfig hintConfig : hintFieldConfigs) {
            hintFields[index] = hintConfig.getSrcBillFieldKey();
            ++index;
        }
        FsDataTable hintDataTable = FsDataTable.create(hintFields);
        int i = 0;
        for (FsMatchConditionConfig matchConditionConfig : this.matchConditionConfigs) {
            if (matchConditionConfig.getHint().booleanValue()) {
                long id = 0L;
                for (FeeShareMatchGroup writeOffMatchGroup : groups) {
                    Object dimValue = writeOffMatchGroup.getMatchKeys().get(i);
                    hintDataTable.addData(id, matchConditionConfig.getSrcBillFieldKey(), dimValue);
                    ++id;
                }
            }
            ++i;
        }
        return MatcherUtil.buildQueryFilter(hintFieldConfigs, hintDataTable, wfMainFieldId);
    }

    public List<IWFFilter> buildMatchRuleFilter(FeeShareMatchGroup matchGroup, String matchWfFieldId, boolean isDBFilter) {
        List<FsMatchConditionConfig> conditions = this.getMatchConditionConfigs();
        String targetBillType = this.getTargetBillType();
        ArrayList<IWFFilter> filters = new ArrayList<IWFFilter>(16);
        List<Object> matchKeys = matchGroup.getMatchKeys();
        for (int i = 0; i < conditions.size(); ++i) {
            FsMatchConditionConfig config = conditions.get(i);
            String fieldKey = config.getTargetBillFieldKey();
            IDataEntityProperty tgtPropType = config.getTgtPropType();
            String comparison = config.comparisonResver();
            if (MatcherUtil.isUseMasterid(tgtPropType) && !(tgtPropType instanceof ItemClassProp)) {
                fieldKey = fieldKey + ".masterid";
            }
            Object dataValue = matchKeys.get(i);
            Set<Object> targetValue = DynamicObjectUtil.getObjectPk((Object)dataValue);
            if ("ap_finapbill".equals(targetBillType) && ("detailentry.e_sourcebillid".equals(fieldKey) || "detailentry.e_sourcebillentryid".equals(fieldKey))) {
                targetValue = String.valueOf(targetValue);
            }
            Object qFilterConditon = null;
            if (config.checkEmptyValue(targetValue)) {
                qFilterConditon = config.getEmptyEqual().booleanValue() ? FilterFactory.createEqualsEmpty((String)fieldKey, (IDataEntityProperty)tgtPropType, (Object)targetValue) : FilterFactory.createFalse();
            } else if (targetValue instanceof FsLargeTextValue) {
                List<Long> ids;
                FsLargeTextValue text = (FsLargeTextValue)((Object)targetValue);
                List<Long> entryIds = text.getEntryIds();
                qFilterConditon = entryIds != null && !entryIds.isEmpty() ? ("cal_costrecord_subentity".equals(targetBillType) ? new WFMatchFilter("entry.bizbillentryid", "in", text.getEntryIds()) : new WFMatchFilter(matchWfFieldId, "in", text.getEntryIds())) : ((ids = text.getIds()) != null && !ids.isEmpty() ? ("cal_costrecord_subentity".equals(targetBillType) ? new WFMatchFilter("bizbillid", "in", text.getIds()) : new WFMatchFilter("id", "in", text.getIds())) : FilterFactory.createFalse());
            } else if (targetValue instanceof List && "=".equals(comparison)) {
                qFilterConditon = new WFMatchFilter(fieldKey, "in", (Object)targetValue);
            } else if (isDBFilter && tgtPropType instanceof ItemClassProp) {
                IDataEntityProperty srcProp = config.getSrcPropType();
                if (srcProp instanceof BasedataProp) {
                    String srcEntity = ((BasedataProp)srcProp).getBaseEntityId();
                    if ("bd_customer".equals(srcEntity)) {
                        targetValue = this.getControlDataIds("bd_customer", targetValue);
                    } else if ("bd_supplier".equals(srcEntity)) {
                        targetValue = this.getControlDataIds("bd_supplier", targetValue);
                    }
                    qFilterConditon = new WFMatchFilter(fieldKey, "in", targetValue);
                }
            } else {
                qFilterConditon = new WFMatchFilter(fieldKey, comparison, (Object)targetValue);
            }
            filters.add((IWFFilter)qFilterConditon);
            if (!(qFilterConditon instanceof AbstractWFFilter)) continue;
            WriteOffMatchConditionInfo matchCondition = new WriteOffMatchConditionInfo();
            matchCondition.setPropName(config.getTargetBillFieldName());
            matchCondition.setComparison(comparison);
            Object name = DynamicObjectUtil.getObjectName((Object)dataValue);
            matchCondition.setValue(name == null ? "" : name.toString());
            ((AbstractWFFilter)qFilterConditon).setInfo(matchCondition);
        }
        return filters;
    }

    private Set<Object> getControlDataIds(String dataEntity, Object masterid) {
        Map values = BusinessDataServiceHelper.loadFromCache((String)dataEntity, (String)"id", (QFilter[])new QFilter("masterid", "=", masterid).toArray());
        HashSet<Object> ids = new HashSet<Object>(16);
        ids.add(masterid);
        ids.addAll(values.keySet());
        return ids;
    }

    public FsMatchRuleConfig getMatchRuleConfig() {
        return this.matchRuleConfig;
    }

    public String getTrackRelation() {
        return this.trackRelation;
    }

    public void setTrackRelation(String trackRelation) {
        this.trackRelation = trackRelation;
    }
}

