/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.config.vo;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareBillConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchConditionConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchRelationConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.AbstractObjMappingConfig;
import org.apache.commons.collections.CollectionUtils;

public class FsMatchRuleConfig
extends AbstractObjMappingConfig {
    private List<FsMatchRelationConfig> relationConfigs = new ArrayList<FsMatchRelationConfig>(16);

    public static FsMatchRuleConfig build(DynamicObject matchRuleObj) {
        FsMatchRuleConfig config = new FsMatchRuleConfig(matchRuleObj);
        config.initRelationConfigs();
        return config;
    }

    private void initRelationConfigs() {
        DynamicObjectCollection matchCollection = this.getObj().getDynamicObjectCollection("matchrelateentry");
        for (DynamicObject matchRelation : matchCollection) {
            FsMatchRelationConfig matchRelationConfig = FsMatchRelationConfig.build(this, matchRelation);
            this.relationConfigs.add(matchRelationConfig);
        }
    }

    public List<FsMatchRelationConfig> getByPromoter(FeeShareBillConfig billTypeConfig) {
        String name = billTypeConfig.getBillAlias();
        return this.getByPromoter(name);
    }

    public FsMatchRelationConfig getFristByPromoter(String billAlias) {
        List<FsMatchRelationConfig> cloneList = this.getByPromoter(billAlias);
        if (CollectionUtils.isNotEmpty(cloneList)) {
            return cloneList.get(0);
        }
        return null;
    }

    public List<FsMatchRelationConfig> getByPromoter(String billAlias) {
        ArrayList<FsMatchRelationConfig> cloneList = new ArrayList<FsMatchRelationConfig>(10);
        for (FsMatchRelationConfig config : this.getRelationConfigs()) {
            cloneList.add(config.clone());
        }
        ArrayList<FsMatchRelationConfig> list = new ArrayList<FsMatchRelationConfig>(10);
        this.sortMatchRelationByPromoter(billAlias, list, cloneList);
        return list;
    }

    private void sortMatchRelationByPromoter(String billTypeKey, List<FsMatchRelationConfig> list, List<FsMatchRelationConfig> cloneList) {
        List collect = cloneList.stream().filter(n -> n.getSrcBillTypeKey().equals(billTypeKey) || n.getTargetBillTypeKey().equals(billTypeKey)).collect(Collectors.toList());
        while (cloneList.size() > 0 && CollectionUtils.isNotEmpty(collect)) {
            for (FsMatchRelationConfig matchRelationConfig : collect) {
                if (matchRelationConfig.getSrcBillTypeKey().equals(billTypeKey)) {
                    if (!list.contains(matchRelationConfig)) {
                        list.add(matchRelationConfig);
                    }
                    cloneList.remove(matchRelationConfig);
                    this.sortMatchRelationByPromoter(matchRelationConfig.getTargetBillTypeKey(), list, cloneList);
                    continue;
                }
                if (!matchRelationConfig.getTargetBillTypeKey().equals(billTypeKey)) continue;
                String srcBillTypeKey = matchRelationConfig.getSrcBillTypeKey();
                String srcBillType = matchRelationConfig.getSrcBillType();
                String tagBillType = matchRelationConfig.getTargetBillType();
                matchRelationConfig.setSrcBillTypeKey(billTypeKey);
                matchRelationConfig.setSrcBillType(tagBillType);
                matchRelationConfig.setTargetBillTypeKey(srcBillTypeKey);
                matchRelationConfig.setTargetBillType(srcBillType);
                List<FsMatchConditionConfig> matchConditionConfigs = matchRelationConfig.getMatchConditionConfigs();
                for (FsMatchConditionConfig config : matchConditionConfigs) {
                    config.fieldExchange();
                }
                if (!list.contains(matchRelationConfig)) {
                    list.add(matchRelationConfig);
                }
                cloneList.remove(matchRelationConfig);
                this.sortMatchRelationByPromoter(matchRelationConfig.getTargetBillTypeKey(), list, cloneList);
            }
        }
    }

    private FsMatchRuleConfig(DynamicObject obj) {
        super(obj);
    }

    public List<FsMatchRelationConfig> getRelationConfigs() {
        return this.relationConfigs;
    }

    public void setRelationConfigs(List<FsMatchRelationConfig> relationConfigs) {
        this.relationConfigs = relationConfigs;
    }

    public FsMatchRelationConfig getRelationByBillType(String billType) {
        if (StringUtils.isEmpty((CharSequence)billType)) {
            return null;
        }
        return this.relationConfigs.stream().filter(n -> billType.equals(n.getSrcBillType()) || billType.equals(n.getTargetBillType())).findFirst().orElse(null);
    }

    public Boolean isTargetDoLargeTextMatch(String string) {
        for (FsMatchRelationConfig relationConfigs : this.relationConfigs) {
            if (!StringUtils.equals((CharSequence)string, (CharSequence)relationConfigs.getTargetBillTypeKey())) continue;
            List<FsMatchConditionConfig> matchConditionConfigs = relationConfigs.getMatchConditionConfigs();
            for (FsMatchConditionConfig matchConditionConfig : matchConditionConfigs) {
                if (!"id,entryid".equals(matchConditionConfig.getTargetBillFieldKey())) continue;
                return true;
            }
        }
        return false;
    }
}

