/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.action.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.feeshare.business.config.manager.BillFieldInfoManager;
import kd.mpscmm.mscommon.feeshare.business.config.manager.FeeShareConfigManager;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareBillConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FlowFeeShareBillOperateConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FlowFeeShareConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsFieldInfo;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchConditionConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchRelationConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchRuleConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsRecordColumnConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsRecordMappingConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsSchemeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsWriteBackConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsWriteBackRuleConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.DenomBillMatchConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.NumeratorConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.ShareRuleBillConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.ShareRuleConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareExecuteContext;
import kd.mpscmm.mscommon.feeshare.business.engine.action.AbstractFeeShareAction;
import kd.mpscmm.mscommon.feeshare.business.engine.plugin.FsPluginExtFactory;
import kd.mpscmm.mscommon.feeshare.common.util.MatcherUtil;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffMainFieldCalPlugin;

public class BillSelectFieldLoadAction
extends AbstractFeeShareAction {
    protected void doAction() {
        FeeShareConfigManager configManager = this.getConfigManager();
        HashMap entityConfigedFields = new HashMap(16);
        List<FeeShareTypeConfig> allWriteOffTypeConfigs = configManager.getAllFeeShareTypeConfigs();
        for (FeeShareTypeConfig typeConfig : allWriteOffTypeConfigs) {
            List<FeeShareBillConfig> billConfigs = typeConfig.getBillConfigs();
            Iterator<FeeShareBillConfig> iterator = billConfigs.iterator();
            while (iterator.hasNext()) {
                FeeShareBillConfig billConfig = iterator.next();
                String string = billConfig.getBillType();
                Set needFields = MapUtils.mapGetSetValue(entityConfigedFields, (Object)string);
                needFields.addAll(this.addFixFields(string));
                if (billConfig.getWriteOffColumnConfig() != null) {
                    needFields.add(billConfig.getWfCalcFieldIdName());
                }
                Set fields = CommonUtils.wfTypeQfiterFieldPathDeal((String)string, billConfig.getFieldList());
                needFields.addAll(fields);
                if (!billConfig.isMainShare()) continue;
                IWriteOffMainFieldCalPlugin fieldCalClass = billConfig.getWriteOffColumnConfig().mainFieldCalClass();
                List calNeedFields = fieldCalClass.calNeedFields();
                needFields.addAll(calNeedFields);
            }
            FsWriteBackConfig writeBackConfigById = configManager.getWriteBackConfigById(typeConfig.getId());
            if (writeBackConfigById == null) continue;
            List<FsWriteBackRuleConfig> backRuleConfigs = writeBackConfigById.getBackRuleConfigs();
            for (FsWriteBackRuleConfig writeBackRuleConfig : backRuleConfigs) {
                Iterator<FsMatchRelationConfig> sourceBillType = writeBackRuleConfig.getSourceBillType();
                String recordColumn = writeBackRuleConfig.getSourceColumn();
                MapUtils.mapGetSetValue(entityConfigedFields, (Object)sourceBillType).add(recordColumn);
            }
        }
        Map<String, Set<String>> prePareFieldMap = FsPluginExtFactory.getPrePareFieldMap(allWriteOffTypeConfigs);
        MapUtils.addSet(entityConfigedFields, prePareFieldMap);
        Collection<FsRecordMappingConfig> allConfig = configManager.getAllConfig();
        for (Object mappingConfig : allConfig) {
            String srcEntity = mappingConfig.getSrcEntity();
            Set set = (Set)entityConfigedFields.get(srcEntity);
            if (set == null) continue;
            List<FsRecordColumnConfig> recordColumnConfigs = mappingConfig.getRecordColumnConfigs();
            for (FsRecordColumnConfig columnConifg : recordColumnConfigs) {
                if ("0".equals(columnConifg.getSelectValue())) {
                    set.add(columnConifg.getSourceColumn());
                    continue;
                }
                if ("curdata".equals(columnConifg.getExpression())) continue;
                BOSExpression expr = new BOSExpression(columnConifg.getExpression());
                Set fields = CommonUtils.wfTypeQfiterFieldPathDeal((String)srcEntity, (Collection)expr.getVars());
                set.addAll(fields);
            }
        }
        List<FsSchemeConfig> allSchemeConfigs = configManager.getAllSchemeConfigs();
        for (Object schemeConfig : allSchemeConfigs) {
            Long shareRuleId;
            FsMatchRuleConfig fsMatchRuleConfig = configManager.getMatchRuleConfigBySchemeId(schemeConfig.getId(), schemeConfig.getFeeShareTypeId());
            if (fsMatchRuleConfig != null) {
                List<FsMatchRelationConfig> relationConfigs = fsMatchRuleConfig.getRelationConfigs();
                for (FsMatchRelationConfig matchRelationConfig : relationConfigs) {
                    Set srcEntityField = MapUtils.mapGetSetValue(entityConfigedFields, (Object)matchRelationConfig.getSrcBillType());
                    Set tgtEntityField = MapUtils.mapGetSetValue(entityConfigedFields, (Object)matchRelationConfig.getTargetBillType());
                    List<FsMatchConditionConfig> matchConfigs = matchRelationConfig.getMatchConditionConfigs();
                    for (FsMatchConditionConfig config : matchConfigs) {
                        IDataEntityProperty tgtPropType;
                        IDataEntityProperty srcPropType = config.getSrcPropType();
                        if (srcPropType != null) {
                            String srcBillFieldKey = config.getSrcBillFieldKey();
                            srcEntityField.add(srcBillFieldKey);
                            if (MatcherUtil.isUseMasterid(srcPropType)) {
                                srcEntityField.add(srcBillFieldKey + ".masterid");
                            }
                        }
                        if ((tgtPropType = config.getTgtPropType()) == null) continue;
                        String targetBillFieldKey = config.getTargetBillFieldKey();
                        tgtEntityField.add(targetBillFieldKey);
                        if (!MatcherUtil.isUseMasterid(tgtPropType)) continue;
                        tgtEntityField.add(targetBillFieldKey + ".masterid");
                    }
                }
            }
            if ((shareRuleId = schemeConfig.getShareRuleId()) == null) continue;
            ShareRuleConfig shareRuleConfig = configManager.getShareRuleConfigById(shareRuleId);
            List<ShareRuleBillConfig> shareBillConfigs = shareRuleConfig.getShareBillConfigs();
            for (ShareRuleBillConfig shareRuleBillConfig : shareBillConfigs) {
                String shareBillEntity = shareRuleBillConfig.getBillType();
                MapUtils.mapGetSetValue(entityConfigedFields, (Object)shareBillEntity).addAll(CommonUtils.wfTypeQfiterFieldPathDeal((String)shareBillEntity, shareRuleBillConfig.getFieldList()));
                NumeratorConfig numerator = shareRuleBillConfig.getNumerator();
                String billEntity = numerator.getBillEntity();
                Set numNeedFields = MapUtils.mapGetSetValue(entityConfigedFields, (Object)billEntity);
                numNeedFields.addAll(numerator.getFieldList());
                FsFieldInfo wfFieldInfo = numerator.getWfFieldInfo();
                String wfCalcFieldIdName = wfFieldInfo.getWfCalcFieldIdName();
                numNeedFields.add(wfCalcFieldIdName);
                List mainFields = wfFieldInfo.getMainFieldCalClass().calNeedFields();
                numNeedFields.addAll(mainFields);
                DenomBillMatchConfig denomMatchConfigs = shareRuleBillConfig.getDenomMatchConfigs();
                if (denomMatchConfigs == null) continue;
                List<String> srcFields = denomMatchConfigs.getSrcConfigs();
                numNeedFields.addAll(srcFields);
            }
        }
        List<FlowFeeShareConfig> allWorkflowScheme = this.getConfigManager().getAllWorkflowScheme();
        for (FlowFeeShareConfig flowFeeShareConfig : allWorkflowScheme) {
            List<FlowFeeShareBillOperateConfig> operateConfigs = flowFeeShareConfig.getOperateConfigs();
            for (FlowFeeShareBillOperateConfig opConfig : operateConfigs) {
                String billType = opConfig.getBillType();
                Set needFields = MapUtils.mapGetSetValue(entityConfigedFields, (Object)billType);
                Set fields = CommonUtils.wfTypeQfiterFieldPathDeal((String)billType, opConfig.getFieldList());
                needFields.addAll(fields);
            }
        }
        DynamicObjectCollection billFieldInfos = QueryServiceHelper.query((String)"msmod_loadbillfield", (String)"billentity, entryentity.fieldkey,entryentity.reffield", (QFilter[])new QFilter("billentity", "in", entityConfigedFields.keySet()).toArray());
        for (DynamicObject fieldConfig : billFieldInfos) {
            String[] reffields;
            String billEntity = fieldConfig.getString("billentity");
            String fieldKey = fieldConfig.getString("entryentity.fieldkey");
            Set configFields = MapUtils.mapGetSetValue(entityConfigedFields, (Object)billEntity);
            configFields.add(fieldKey);
            String reffield = fieldConfig.getString("entryentity.reffield");
            if (!StringUtils.isNotEmpty((CharSequence)reffield)) continue;
            for (String field : reffields = reffield.split(",")) {
                configFields.add(fieldKey + "." + field);
            }
        }
        BillFieldInfoManager billFieldInfoManager = ((FeeShareExecuteContext)this.getExecuteContext()).getBillFieldInfo();
        for (Map.Entry entityConfigField : entityConfigedFields.entrySet()) {
            String entity = (String)entityConfigField.getKey();
            Set fields = (Set)entityConfigField.getValue();
            for (String field : fields) {
                billFieldInfoManager.addFullFieldKey(entity, field);
            }
        }
    }

    private Set<String> addFixFields(String billEntity) {
        HashSet<String> fileds = new HashSet<String>(16);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billEntity);
        Map allFields = dataEntityType.getAllFields();
        IDataEntityProperty orgPro = (IDataEntityProperty)allFields.get("org");
        if (orgPro != null && orgPro.getParent() != null && orgPro.getParent() instanceof BillEntityType) {
            fileds.add("org");
        }
        fileds.add("id");
        fileds.add("billno");
        return fileds;
    }
}

