/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.action.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareBillConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FlowFeeShareBillOperateConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FlowFeeShareConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FlowFeeShareSchemeContextConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsFieldInfo;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchRuleConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsSchemeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.ShareRuleBillConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.ShareRuleConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareExecuteContext;
import kd.mpscmm.mscommon.feeshare.business.engine.action.impl.AbstractBillGroupAction;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareBillGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareMatchGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareObject;
import kd.mpscmm.mscommon.feeshare.business.engine.param.impl.FlowFeeShareReqParam;
import kd.mpscmm.mscommon.feeshare.common.helper.FeeShareGroupHelper;
import kd.mpscmm.mscommon.feeshare.lang.EngineLang;
import kd.mpscmm.mscommon.writeoff.common.log.WriteOffExeucteInfo;
import org.apache.commons.collections.CollectionUtils;

public class FlowBillGroupAction
extends AbstractBillGroupAction {
    @Override
    protected List<FeeShareMatchGroup> getBillGroup() {
        FeeShareExecuteContext executeContext = (FeeShareExecuteContext)this.getExecuteContext();
        FlowFeeShareReqParam reqParam = (FlowFeeShareReqParam)executeContext.getReqParam();
        String reqbillEntity = reqParam.getReqbillEntity();
        ArrayList<FeeShareMatchGroup> groups = new ArrayList<FeeShareMatchGroup>(16);
        List<FeeShareTypeConfig> typeConfigs = this.getConfigManager().getAllFeeShareTypeConfigs();
        for (FeeShareTypeConfig typeConfig : typeConfigs) {
            log.info("\u8bfb\u53d6\u7c7b\u522b" + typeConfig.getName() + "\u5206\u7ec4\u914d\u7f6e");
            List bills = typeConfig.getBillConfigs().stream().filter(n -> n.getBillType().equals(reqbillEntity)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(bills)) continue;
            List<FeeShareMatchGroup> billGroup = null;
            FeeShareBillConfig feeShareBillConfig = (FeeShareBillConfig)((Object)bills.get(0));
            billGroup = feeShareBillConfig.isMainShare() ? this.doShareMainGroup(typeConfig, feeShareBillConfig, reqParam) : this.doShareAssistGroup(typeConfig, feeShareBillConfig, reqParam);
            groups.addAll(billGroup);
        }
        return groups;
    }

    private List<FeeShareMatchGroup> doShareMainGroup(FeeShareTypeConfig typeConfig, FeeShareBillConfig billTypeConfig, FlowFeeShareReqParam reqParam) {
        FsFieldInfo wfFieldInfo = billTypeConfig.getWriteOffColumnConfig().getWfFieldInfo();
        String mainFieldEntry = billTypeConfig.getMainFieldEntry();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.addAll(billTypeConfig.getFilters());
        filters.add(new QFilter("id", "in", reqParam.getReqbillIds()));
        DynamicObjectCollection dataEntities = ((FeeShareExecuteContext)this.getExecuteContext()).getBillDataSource().queryBillData(reqParam.getReqbillEntity(), mainFieldEntry, filters.toArray(new QFilter[filters.size()]));
        if (CollectionUtils.isEmpty((Collection)dataEntities)) {
            log.info("\u5206\u644a\u5e73\u53f0\uff1a\u4e0d\u6ee1\u8db3\u5206\u644a\u7c7b\u522b\u6761\u4ef6\u6216\u5355\u636e\u4e0d\u5b58\u5728\u3002" + reqParam.getReqbillIds());
            return Collections.emptyList();
        }
        ArrayList<FeeShareObject> feeShareObjects = new ArrayList<FeeShareObject>();
        for (DynamicObject dataEntity : dataEntities) {
            WriteOffExeucteInfo executeInfo;
            FeeShareObject feeShareObj = FeeShareObject.create(typeConfig, billTypeConfig, dataEntity, wfFieldInfo);
            if (feeShareObj.isCurWriteOffZero()) {
                executeInfo = ((FeeShareExecuteContext)this.getExecuteContext()).getExecuteInfo();
                executeInfo.addInfo(dataEntity.getPkValue(), typeConfig.getId(), feeShareObj.getPkValue(), Long.valueOf(0L), EngineLang.curWriteOffIsZero(typeConfig, billTypeConfig));
                continue;
            }
            if (!billTypeConfig.checkHighCondtion(feeShareObj.getFeeShareObjectBase())) {
                executeInfo = ((FeeShareExecuteContext)this.getExecuteContext()).getExecuteInfo();
                executeInfo.addInfo(dataEntity.getPkValue(), typeConfig.getId(), feeShareObj.getPkValue(), Long.valueOf(0L), EngineLang.writeOffTypeNotFilter(typeConfig, billTypeConfig));
                continue;
            }
            feeShareObjects.add(feeShareObj);
        }
        if (CollectionUtils.isEmpty(feeShareObjects)) {
            for (DynamicObject dataEntity : dataEntities) {
                ((FeeShareExecuteContext)this.getExecuteContext()).getExecuteInfo().addInfo(dataEntity.getPkValue(), typeConfig.getId(), EngineLang.writeOffTypeNotMatch(typeConfig));
            }
            return Collections.emptyList();
        }
        FeeShareBillGroup feeShareGroup = new FeeShareBillGroup(typeConfig, billTypeConfig);
        feeShareGroup.addFeeShareObjects(feeShareObjects);
        return this.splitGroup(typeConfig, reqParam, feeShareGroup, false);
    }

    private List<FeeShareMatchGroup> doShareAssistGroup(FeeShareTypeConfig typeConfig, FeeShareBillConfig billTypeConfig, FlowFeeShareReqParam reqParam) {
        FlowFeeShareConfig workFlowShemeConfig = this.getConfigManager().getWorkflowSchemeByWriteOffTypeId(typeConfig.getId());
        List<FlowFeeShareBillOperateConfig> operateConfigs = workFlowShemeConfig.getBillOperateConfigByOper(billTypeConfig.getBillAlias(), reqParam.getOperationKey());
        if (operateConfigs == null || operateConfigs.isEmpty()) {
            log.info("\u5206\u644a\u5e73\u53f0\u83b7\u53d6\u5355\u636e\u5206\u7ec4\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u6d41\u7a0b\u5206\u644a\u5355\u636e\u914d\u7f6e\u3002" + billTypeConfig.getBillAlias());
            return Collections.emptyList();
        }
        FsFieldInfo mainColumn = null;
        for (FlowFeeShareBillOperateConfig workflowBillOperateConfig : operateConfigs) {
            List<FlowFeeShareSchemeContextConfig> configs = workflowBillOperateConfig.getSchemeContextConfigs();
            block1: for (FlowFeeShareSchemeContextConfig flowFeeShareSchemeContextConfig : configs) {
                FsSchemeConfig schemeConfig = this.getConfigManager().getSchemeConfigById(flowFeeShareSchemeContextConfig.getSchemeId(), typeConfig.getId());
                ShareRuleConfig srConfig = this.getConfigManager().getShareRuleConfigById(schemeConfig.getShareRuleId());
                for (ShareRuleBillConfig srBillConfig : srConfig.getShareBillConfigs()) {
                    String wfCalcFieldIdName = srBillConfig.getNumerator().getWfFieldInfo().getWfCalcFieldIdName();
                    mainColumn = srBillConfig.getNumerator().getWfFieldInfo();
                    if ("id".equals(wfCalcFieldIdName)) continue;
                    continue block1;
                }
            }
        }
        if (mainColumn == null) {
            throw new KDBizException("Sharerule Config erro.");
        }
        String mainFieldEntry = mainColumn.getMainFieldCalClass().mainFieldEntry();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.addAll(billTypeConfig.getFilters());
        filters.add(new QFilter("id", "in", reqParam.getReqbillIds()));
        DynamicObjectCollection dataEntities = ((FeeShareExecuteContext)this.getExecuteContext()).getBillDataSource().queryBillData(reqParam.getReqbillEntity(), mainFieldEntry, filters.toArray(new QFilter[filters.size()]));
        if (CollectionUtils.isEmpty((Collection)dataEntities)) {
            log.info("\u5206\u644a\u5e73\u53f0\uff1a\u4e0d\u6ee1\u8db3\u5206\u644a\u7c7b\u522b\u6761\u4ef6\u6216\u5355\u636e\u4e0d\u5b58\u5728\u3002" + reqParam.getReqbillIds());
            return Collections.emptyList();
        }
        ArrayList<FeeShareObject> shareObjs = new ArrayList<FeeShareObject>(16);
        for (DynamicObject dataEntity : dataEntities) {
            FeeShareObject feeShareObject = FeeShareObject.createShareAssist(typeConfig, billTypeConfig, dataEntity, mainFieldEntry);
            shareObjs.add(feeShareObject);
        }
        FeeShareBillGroup feeShareBillGroup = new FeeShareBillGroup(typeConfig, billTypeConfig);
        feeShareBillGroup.addFeeShareObjects(shareObjs);
        return this.splitGroup(typeConfig, reqParam, feeShareBillGroup, true);
    }

    private List<FeeShareMatchGroup> splitGroup(FeeShareTypeConfig typeConfig, FlowFeeShareReqParam reqParam, FeeShareBillGroup feeShareBillGroup, boolean isShareAssist) {
        FeeShareBillConfig billTypeConfig;
        ArrayList<FeeShareMatchGroup> groups = new ArrayList<FeeShareMatchGroup>(16);
        FlowFeeShareConfig workFlowShemeConfig = this.getConfigManager().getWorkflowSchemeByWriteOffTypeId(typeConfig.getId());
        List<FlowFeeShareBillOperateConfig> operateConfigs = workFlowShemeConfig.getBillOperateConfigByOper((billTypeConfig = feeShareBillGroup.getBillTypeConfig()).getBillAlias(), reqParam.getOperationKey());
        if (operateConfigs == null || operateConfigs.isEmpty()) {
            log.info("\u5206\u644a\u5e73\u53f0\u83b7\u53d6\u5355\u636e\u5206\u7ec4\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u6d41\u7a0b\u5206\u644a\u5355\u636e\u914d\u7f6e\u3002" + billTypeConfig.getBillAlias());
            return Collections.emptyList();
        }
        List<FeeShareObject> typeWriteOffObjs = feeShareBillGroup.getFeeShareObjects();
        for (FlowFeeShareBillOperateConfig wfFlowConfig : operateConfigs) {
            if (typeWriteOffObjs.isEmpty()) {
                ((FeeShareExecuteContext)this.getExecuteContext()).getExecuteInfo().addInfo(typeWriteOffObjs, EngineLang.notFlowSchemeObjs(workFlowShemeConfig));
                continue;
            }
            List<FeeShareObject> matchedObj = FeeShareGroupHelper.getMatchedObjAndRemove(wfFlowConfig, typeWriteOffObjs);
            if (matchedObj.isEmpty()) {
                ((FeeShareExecuteContext)this.getExecuteContext()).getExecuteInfo().addInfo(typeWriteOffObjs, EngineLang.notMatchFlowSchemeFilter(workFlowShemeConfig));
                continue;
            }
            List<FlowFeeShareSchemeContextConfig> schemeContextConfigs = wfFlowConfig.getSchemeContextConfigs();
            for (FlowFeeShareSchemeContextConfig schemeContextConfig : schemeContextConfigs) {
                FsSchemeConfig schemeConfig = this.getConfigManager().getSchemeConfigById(schemeContextConfig.getSchemeId(), typeConfig.getId());
                if (schemeConfig.isNoCondition()) {
                    ((FeeShareExecuteContext)this.getExecuteContext()).getExecuteInfo().addInfo(typeWriteOffObjs, schemeConfig.getId(), EngineLang.notAllowExecuteNoCondition(schemeConfig));
                    continue;
                }
                FsMatchRuleConfig matchRuleConfig = this.getConfigManager().getMatchRuleConfigById(schemeConfig.getMatchRuleId(), typeConfig.getId());
                if (matchRuleConfig == null) {
                    ((FeeShareExecuteContext)this.getExecuteContext()).getExecuteInfo().addInfo(typeWriteOffObjs, schemeConfig.getId(), EngineLang.matchRuleNotEnable(schemeConfig));
                    continue;
                }
                if (matchRuleConfig.isTargetDoLargeTextMatch(billTypeConfig.getBillAlias()).booleanValue()) {
                    ((FeeShareExecuteContext)this.getExecuteContext()).getExecuteInfo().addInfo(typeWriteOffObjs, schemeConfig.getId(), EngineLang.NotSupportTargetDoLargetTextMatch(matchRuleConfig));
                    continue;
                }
                List<FeeShareMatchGroup> writeOffMatchGroups = FeeShareGroupHelper.groupByMatchRule(wfFlowConfig, typeConfig, billTypeConfig, schemeConfig, matchRuleConfig, matchedObj, ((FeeShareExecuteContext)this.getExecuteContext()).getPluginFactory());
                ShareRuleConfig shareRuleConfig = this.getConfigManager().getShareRuleConfigById(schemeConfig.getShareRuleId());
                if (!isShareAssist && (writeOffMatchGroups = FeeShareGroupHelper.splitByShareRule(writeOffMatchGroups, shareRuleConfig)).isEmpty()) {
                    ((FeeShareExecuteContext)this.getExecuteContext()).getExecuteInfo().addInfo(typeWriteOffObjs, schemeConfig.getId(), EngineLang.noMatchedShareRuleBill(shareRuleConfig));
                    continue;
                }
                for (FeeShareMatchGroup writeOffMatchGroup : writeOffMatchGroups) {
                    writeOffMatchGroup.setWfFlowConfig(wfFlowConfig);
                    writeOffMatchGroup.setShareRuleConfig(shareRuleConfig);
                }
                groups.addAll(writeOffMatchGroups);
            }
        }
        return groups;
    }
}

