/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.action.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FlowFeeShareBillOperateConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FlowFeeShareConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FlowFeeShareSchemeContextConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsRecordMappingConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsSchemeConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareExecuteContext;
import kd.mpscmm.mscommon.feeshare.business.engine.action.AbstractFeeShareAction;
import kd.mpscmm.mscommon.feeshare.business.engine.param.impl.FlowFeeShareReqParam;
import kd.mpscmm.mscommon.feeshare.lang.EngineLang;
import kd.mpscmm.mscommon.writeoff.common.util.DynamicObjectUtil;

public class FlowFeeShareLoadAction
extends AbstractFeeShareAction {
    protected void doAction() {
        String reqBillEntity;
        FlowFeeShareReqParam reqParam = (FlowFeeShareReqParam)((FeeShareExecuteContext)this.getExecuteContext()).getReqParam();
        String operationKey = reqParam.getOperationKey();
        List<DynamicObject> schemeSetObjList = this.getSchemeSetList(operationKey, reqBillEntity = reqParam.getReqbillEntity());
        if (schemeSetObjList.isEmpty()) {
            ((FeeShareExecuteContext)this.getExecuteContext()).getExecuteInfo().addInfos(reqParam.getReqbillIds(), EngineLang.noMatchedWriteOffScheme());
            return;
        }
        HashSet<Long> schemeIds = new HashSet<Long>(16);
        HashSet<Long> writeOffTypeIds = new HashSet<Long>(16);
        for (DynamicObject schemeSets : schemeSetObjList) {
            FlowFeeShareConfig workFlowConfigs = FlowFeeShareConfig.build(schemeSets, operationKey, reqBillEntity);
            this.getConfigManager().addWorkflowSchemeConfig(workFlowConfigs);
            writeOffTypeIds.add(workFlowConfigs.getFeeShareTypeId());
            for (FlowFeeShareBillOperateConfig wfBillOperConfig : workFlowConfigs.getOperateConfigs()) {
                for (FlowFeeShareSchemeContextConfig flowFeeShareSchemeContextConfig : wfBillOperConfig.getSchemeContextConfigs()) {
                    schemeIds.add(flowFeeShareSchemeContextConfig.getSchemeId());
                }
            }
        }
        QFilter schemeFilter = new QFilter("id", "in", schemeIds).and("enable", "=", (Object)Boolean.TRUE);
        Map schemeEntities = BusinessDataServiceHelper.loadFromCache((String)"msmod_scheme", (QFilter[])schemeFilter.toArray());
        for (DynamicObject schemeEntity : schemeEntities.values()) {
            FsSchemeConfig schemeConfig = FsSchemeConfig.build(schemeEntity);
            this.getConfigManager().addSchemeContextConfig(schemeConfig);
        }
        if (schemeEntities.isEmpty()) {
            ((FeeShareExecuteContext)this.getExecuteContext()).getExecuteInfo().addInfos(reqParam.getReqbillIds(), EngineLang.writeOffSchemeNoEnable());
        }
        QFilter typeFilter = new QFilter("id", "in", writeOffTypeIds).and("enable", "=", (Object)Boolean.TRUE);
        Map writeOffObjs = BusinessDataServiceHelper.loadFromCache((String)"msmod_writeofftype", (QFilter[])typeFilter.toArray());
        Map<Long, Integer> wfTypeSortMap = this.getWfTypeSortMap();
        HashSet<Long> recordMappingIds = new HashSet<Long>(16);
        for (DynamicObject writeOffObj : writeOffObjs.values()) {
            Long wrtieOffId = DynamicObjectUtil.getPkValue((DynamicObject)writeOffObj);
            FeeShareTypeConfig fsTypeConfig = FeeShareTypeConfig.build(writeOffObj, ((FeeShareExecuteContext)this.getExecuteContext()).getWfParam());
            recordMappingIds.addAll(fsTypeConfig.getRecordMappingIdByWfType());
            fsTypeConfig.setPriority(wfTypeSortMap.get(wrtieOffId));
            this.getConfigManager().addFeeShareTypeConfig(fsTypeConfig);
        }
        QFilter qFilter = new QFilter("id", "in", recordMappingIds);
        Map allRecordMappingObjs = BusinessDataServiceHelper.loadFromCache((String)"sbs_billfieldmapping", (QFilter[])qFilter.toArray());
        for (DynamicObject mapping : allRecordMappingObjs.values()) {
            FsRecordMappingConfig rmConfig = FsRecordMappingConfig.build(mapping);
            this.getConfigManager().addRecordMappingConfig(rmConfig);
        }
        if (writeOffObjs.isEmpty()) {
            ((FeeShareExecuteContext)this.getExecuteContext()).getExecuteInfo().addInfos(reqParam.getReqbillIds(), EngineLang.writeOffTypeNoEnable());
        }
    }

    private List<DynamicObject> getSchemeSetList(String operationKey, String reqbillEntity) {
        QFilter billFilter = new QFilter("msmod_scheme_bill.writeoffbill.wfbill", "=", (Object)reqbillEntity).and("writeofftype.writeofftype", "=", (Object)"B").and("enable", "=", (Object)Boolean.TRUE);
        Map schemeSetObjs = BusinessDataServiceHelper.loadFromCache((String)"msmod_schemeset", (QFilter[])billFilter.toArray());
        ArrayList<DynamicObject> schemeSetObjList = new ArrayList<DynamicObject>(8);
        block0: for (DynamicObject schemeObj : schemeSetObjs.values()) {
            DynamicObjectCollection schemeBills = schemeObj.getDynamicObjectCollection("msmod_scheme_bill");
            for (DynamicObject schemeBill : schemeBills) {
                String op = schemeBill.getString("writeoffop");
                DynamicObject writeOffBill = schemeBill.getDynamicObject("writeoffbill");
                String billEntity = writeOffBill.getDynamicObject("wfbill").getString("number");
                String[] ops = op.split(",");
                HashSet<String> opSet = new HashSet<String>(Arrays.asList(ops));
                if (!reqbillEntity.equals(billEntity) || !opSet.contains(operationKey)) continue;
                schemeSetObjList.add(schemeObj);
                continue block0;
            }
        }
        return schemeSetObjList;
    }

    private Map<Long, Integer> getWfTypeSortMap() {
        FlowFeeShareReqParam param = (FlowFeeShareReqParam)((FeeShareExecuteContext)this.getExecuteContext()).getReqParam();
        HashMap<Long, Integer> wfTypeSortMap = new HashMap<Long, Integer>(16);
        QFilter qFilter = new QFilter("writeoffop", "=", (Object)param.getOperationKey());
        qFilter.and("writeoffbill", "=", (Object)param.getReqbillEntity());
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"msmod_writeofftype_sort", (String)"entryentity.writeofftype,entryentity.seq", (QFilter[])qFilter.toArray());
        for (DynamicObject ob : query) {
            wfTypeSortMap.put(ob.getLong("entryentity.writeofftype"), ob.getInt("entryentity.seq"));
        }
        return wfTypeSortMap;
    }
}

