/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.action.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareBillConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsSchemeConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareExecuteContext;
import kd.mpscmm.mscommon.feeshare.business.engine.action.impl.AbstractManualBillGroupAction;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareManualEntity;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareManualGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.param.impl.ManualFeeShareReqParam;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.FilterFactory;
import org.apache.commons.collections.CollectionUtils;

public class ManualBillGroupAction
extends AbstractManualBillGroupAction {
    public static final String WFFIELD_FORMULA = "B";
    public static final String WFFIELD_PLUGIN = "C";
    public static final String SPIT = "@@";

    @Override
    protected boolean isSkipAction() {
        return super.isSkipAction() || CollectionUtils.isEmpty(this.getConfigManager().getAllFeeShareTypeConfigs());
    }

    @Override
    protected List<FeeShareManualGroup> getManuBillGroup() {
        FeeShareExecuteContext executeContext = (FeeShareExecuteContext)this.getExecuteContext();
        Integer maxHandleBillSize = executeContext.getWfParam().getMaxHandleBillSize();
        ManualFeeShareReqParam reqParam = (ManualFeeShareReqParam)executeContext.getReqParam();
        FeeShareTypeConfig writeOffTypeConfig = this.getConfigManager().getWfTypeConfigById(reqParam.getWfTypeId());
        FsSchemeConfig schemeConfig = this.getConfigManager().getSchemeConfigById(reqParam.getSchemeId(), writeOffTypeConfig.getId());
        ArrayList<FeeShareManualGroup> groups = new ArrayList<FeeShareManualGroup>(16);
        List<FeeShareManualEntity> manualEntity = this.buildManualEntity(reqParam, writeOffTypeConfig);
        int i = 0;
        for (FeeShareManualEntity writeOffManualEntity : manualEntity) {
            FeeShareBillConfig billConfig = writeOffManualEntity.getBillConfig();
            FeeShareManualGroup writeOffManualGroup = FeeShareManualGroup.build(writeOffTypeConfig, billConfig, schemeConfig, executeContext.getBillDataSource());
            String billEntryIdKey = writeOffManualEntity.getMainFieldIdKey();
            String entityName = billConfig.getBillType();
            Map<Object, BigDecimal> curMainFieldValueMap = writeOffManualEntity.getCurMainFieldValueMap();
            writeOffManualGroup.setFilter(Collections.singletonList(FilterFactory.create((String)entityName, (String)billEntryIdKey, (String)"in", curMainFieldValueMap.keySet())), maxHandleBillSize);
            if (i == 0) {
                writeOffManualGroup.setCurMainFieldValueMap(curMainFieldValueMap);
                writeOffManualGroup.initFeeShareObject();
            }
            groups.add(writeOffManualGroup);
            ++i;
        }
        return groups;
    }

    private List<FeeShareManualEntity> buildManualEntity(ManualFeeShareReqParam reqParam, FeeShareTypeConfig writeOffTypeConfig) {
        ArrayList<FeeShareManualEntity> entitys = new ArrayList<FeeShareManualEntity>(16);
        List<Map<Object, BigDecimal>> curMainFieldValueMaps = reqParam.getCurMainFieldValueMaps();
        Map entryMap = (Map)reqParam.getParams().get("entry");
        Map mainFieldKey = (Map)reqParam.getParams().get("entrywfmainfieldmap");
        for (int i = 0; i < curMainFieldValueMaps.size(); ++i) {
            FeeShareBillConfig writeOffBillConfig = writeOffTypeConfig.getBillConfigs().get(i);
            Map<Object, BigDecimal> curMainFieldValueMap = curMainFieldValueMaps.get(i);
            FeeShareManualEntity entity = new FeeShareManualEntity(writeOffBillConfig, curMainFieldValueMap);
            String fieldKey = (String)mainFieldKey.get(entryMap.get(i));
            if (fieldKey != null) {
                String[] split = fieldKey.split(SPIT);
                String wfMainField = split[0];
                String wfMainFieldMethod = split[1];
                if ("A".equals(wfMainFieldMethod)) {
                    entity.setMainFieldKey(wfMainField);
                } else if (WFFIELD_FORMULA.equals(wfMainFieldMethod) || WFFIELD_PLUGIN.equals(wfMainFieldMethod)) {
                    String wfCalcFieldIdName = entity.getBillConfig().getWfCalcFieldIdName();
                    entity.setMainFieldKey(wfCalcFieldIdName);
                }
            }
            entitys.add(entity);
        }
        return entitys;
    }
}

