/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.action.impl.step;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.exception.KDBizException;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsSchemeConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareExecuteContext;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareTypeContext;
import kd.mpscmm.mscommon.feeshare.business.engine.action.AbstractFeeShareStepAction;
import kd.mpscmm.mscommon.feeshare.business.engine.core.context.FeeShareSnapshotContext;
import kd.mpscmm.mscommon.feeshare.business.engine.core.kdtx.KdtxFeeShareService;
import kd.mpscmm.mscommon.feeshare.business.engine.core.listener.FsSnapListener;
import kd.mpscmm.mscommon.feeshare.business.engine.core.record.FeeShareRecordManager;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareLogInfo;
import kd.mpscmm.mscommon.feeshare.business.engine.param.impl.AbstractManualReqParam;
import kd.mpscmm.mscommon.feeshare.ext.defaultplugin.proxy.FeeSharePluginProxy;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;

public class WriteBackBillSetpAction
extends AbstractFeeShareStepAction {
    protected boolean isSkipAction() {
        return !((FeeShareTypeContext)this.getExecuteContext()).isWriteOff();
    }

    protected void doAction() {
        FeeShareTypeContext writeOffTypeContext = (FeeShareTypeContext)this.getExecuteContext();
        FeeShareRecordManager recordManager = writeOffTypeContext.getRecordManager();
        if (recordManager.isEmpty()) {
            if (writeOffTypeContext.getExecuteContext().isFlowFeeShare()) {
                FeeShareLogInfo logInfo = this.getWFExecuteContext().getWriteOffLogByTypeId(((FeeShareTypeContext)this.getExecuteContext()).getTypeConfig().getId());
                logInfo.setErrorType("B");
            } else {
                this.manualHandleNoneRecord();
            }
            return;
        }
        FeeShareSnapshotContext snapshotContext = writeOffTypeContext.getSnapshotContext();
        if (TX.inTX()) {
            TX.addCommitListener((CommitListener)new FsSnapListener(snapshotContext));
        }
        try (TraceSpan trace = Tracer.create((String)"WriteOff-SaveSnapshot", (String)"saveWfSnapShoot");){
            snapshotContext.saveWfSnapShoot();
        }
        List<Object> checkResults = Collections.emptyList();
        try (AlgoContext context = Algo.newContext();
             TraceSpan trace = Tracer.create((String)"WriteOff-checkPass", (String)"checkPass");){
            checkResults = snapshotContext.checkPass();
        }
        if (checkResults.isEmpty()) {
            var6_9 = null;
            try (TraceSpan trace = Tracer.create((String)"WriteOff-callKDTXService", (String)"callKDTXService");){
                this.callKDTXService();
            }
            catch (Throwable throwable) {
                var6_9 = throwable;
                throw throwable;
            }
        } else {
            FeeShareLogInfo logInfo = this.getWFExecuteContext().getWriteOffLogByTypeId(((FeeShareTypeContext)this.getExecuteContext()).getTypeConfig().getId());
            logInfo.setErrorType("C");
            snapshotContext.deleteSnapShoots();
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u53cd\u5199\u8d85\u989d\u6821\u9a8c\u5931\u8d25\u3002{0}", (String)"WfSnapShootHolder_3", (String)"mpscmm-mscommon-feeshare", (Object[])new Object[]{checkResults.toString()}));
        }
    }

    private void callKDTXService() {
        FeeShareTypeContext writeOffTypeContext = (FeeShareTypeContext)this.getExecuteContext();
        FeeShareExecuteContext wfExecuteContext = this.getWFExecuteContext();
        FeeShareRecordManager recordManager = writeOffTypeContext.getRecordManager();
        List<DynamicObject> writeoffRecords = recordManager.getRecordObjs();
        FeeShareSnapshotContext snapshotContext = writeOffTypeContext.getSnapshotContext();
        FeeShareTypeConfig typeConfig = writeOffTypeContext.getTypeConfig();
        TraceSpan trace = Tracer.create((String)"WriteOff-WB-updateSnapShootStatus", (String)"updateSnapShootStatus");
        Object object = null;
        try {
            snapshotContext.updateSnapShootStatus();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (trace != null) {
                if (object != null) {
                    try {
                        trace.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    trace.close();
                }
            }
        }
        HashSet<String> businessInfos = new HashSet<String>(16);
        for (DynamicObject wfRecord : writeoffRecords) {
            Set<String> buildBusinessKeys = WriteBackBillSetpAction.buildBusinessKeys(wfRecord, typeConfig);
            businessInfos.addAll(buildBusinessKeys);
        }
        boolean isManualWriteOff = writeOffTypeContext.getExecuteContext().isManualFeeShare();
        KdtxFeeShareService service = new KdtxFeeShareService(businessInfos, typeConfig, isManualWriteOff, wfExecuteContext);
        service.setWriteOffLog(writeOffTypeContext.getWriteOffLog());
        try (TraceSpan trace2 = Tracer.create((String)"WriteOff-WB-kdtxWriteOffRecord", (String)"kdtxWriteOffRecord");){
            service.kdtxWriteOffRecord(typeConfig, writeoffRecords);
        }
        HashMap<String, Map<String, List<Object[]>>> writeBackSQLs = new HashMap<String, Map<String, List<Object[]>>>(16);
        MapUtils.add(writeBackSQLs, recordManager.getGenerateWriteBackSql());
        FeeSharePluginProxy writeOffPluginProxy = ((FeeShareTypeContext)this.getExecuteContext()).getPluginFactory().createWriteOffPluginProxy(typeConfig);
        MapUtils.add(writeBackSQLs, writeOffPluginProxy.buildBackSql(recordManager.getRecordObjs()));
        HashMap<Long, List<DynamicObject>> writeoffRecordMap = new HashMap<Long, List<DynamicObject>>(4);
        writeoffRecordMap.put(typeConfig.getId(), writeoffRecords);
        try (TraceSpan trace3 = Tracer.create((String)"WriteOff-WB-kdtxBackWriteBill", (String)"kdtxBackWriteBill");){
            service.kdtxBackWriteBill(writeBackSQLs, snapshotContext.getSnapShootIdMap(), writeoffRecordMap);
        }
        List<Map<String, Object>> recordKdtxParams = recordManager.getRecordKdtxParams(isManualWriteOff);
        try (TraceSpan trace4 = Tracer.create((String)"WriteOff-WB-kdtxWfPlugin", (String)"kdtxWfPlugin");){
            service.kdtxWfPlugin(writeoffRecords, recordKdtxParams);
        }
    }

    private void manualHandleNoneRecord() {
        FeeShareTypeContext writeOffTypeContext = (FeeShareTypeContext)this.getExecuteContext();
        FeeShareExecuteContext wfExecuteContext = this.getWFExecuteContext();
        AbstractManualReqParam reqParam = (AbstractManualReqParam)wfExecuteContext.getReqParam();
        if (!writeOffTypeContext.isMatch()) {
            FsSchemeConfig schemeConfigById = wfExecuteContext.getConfigManager().getSchemeConfigById(reqParam.getSchemeId(), writeOffTypeContext.getTypeConfig().getId());
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u9500\u65b9\u6848\u201c%s\u201d\u4e0b\u65e0\u5339\u914d\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6838\u9500\u65b9\u6848\u6216\u91cd\u65b0\u9009\u62e9\u6570\u636e\u6838\u9500\u3002", (String)"ManualWfGroupExecutor_0", (String)"mpscmm-mscommon-feeshare", (Object[])new Object[0]), schemeConfigById.getName()));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6838\u9500\u8bb0\u5f55\u4ea7\u751f\u3002", (String)"WfSnapShootHolder_4", (String)"mpscmm-mscommon-feeshare", (Object[])new Object[0]));
    }

    private static Set<String> buildBusinessKeys(DynamicObject recordBill, FeeShareTypeConfig typeConfig) {
        HashSet<String> businessInfos;
        block3: {
            block2: {
                businessInfos = new HashSet<String>(16);
                String recordType = recordBill.getDataEntityType().getName();
                businessInfos.add(recordType + "#" + recordBill.getPkValue());
                if (WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST != typeConfig.getWfRecordTemplateEnum()) break block2;
                WriteBackBillSetpAction.addBusinessKey(recordBill, "billtype", "billid", businessInfos);
                DynamicObjectCollection entryList = recordBill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entryList) {
                    WriteBackBillSetpAction.addBusinessKey(entry, "e_billtype", "e_billid", businessInfos);
                }
                break block3;
            }
            if (WriteoffTemplateTypeEnum.TEMPLATE_UP_DOWN != typeConfig.getWfRecordTemplateEnum()) break block3;
            DynamicObjectCollection entryList = recordBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryList) {
                WriteBackBillSetpAction.addBusinessKey(entry, "billtype", "billid", businessInfos);
            }
        }
        return businessInfos;
    }

    private static void addBusinessKey(DynamicObject recordBill, String billTypeKey, String billIdKey, Set<String> businessInfos) {
        DynamicObject billType = recordBill.getDynamicObject(billTypeKey);
        if (billType != null) {
            String number = billType.getString("number");
            Long billId = recordBill.getLong(billIdKey);
            String key = number + "#" + billId;
            businessInfos.add(key);
        }
    }
}

