/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.core.feeshare.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsSchemeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.DenominatorConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.ShareRuleBillConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.core.FeeShareHandleGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.feeshare.impl.AbstractTemplateFeeShareStrategy;
import kd.mpscmm.mscommon.feeshare.business.engine.core.match.share.CandidateQueueField;
import kd.mpscmm.mscommon.feeshare.business.engine.core.match.share.QueryDenomBillMatcher;
import kd.mpscmm.mscommon.feeshare.business.engine.core.record.FeeShareRecordMapper;
import kd.mpscmm.mscommon.feeshare.business.engine.core.record.impl.ShareRecordStrategy;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareLogInfo;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareMatchGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareObject;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.ShareGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.plugin.FsPluginExtFactory;
import kd.mpscmm.mscommon.feeshare.ext.scmc.feeshare.BillDynamicMainFieldCal;
import kd.mpscmm.mscommon.feeshare.lang.EngineLang;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.sdk.mpscmm.mscommon.feeshare.params.FeeShareObjectBase;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffMainFieldCalPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class StandardFeeShareStrategy
extends AbstractTemplateFeeShareStrategy {
    protected static final Log logger = LogFactory.getLog(StandardFeeShareStrategy.class);
    private static final String FILTER = "qFilter";
    private static final String SELECT_PROPERTIES = "queryProperties";
    private static final String SHARE_FEE_RECORD = "cal_feeshare_newrecord";

    @Override
    public void batchExecute(List<FeeShareHandleGroup> queueGroups) {
        List<ShareGroup> createShareGroups = this.createShareGroups(queueGroups);
        if (createShareGroups.isEmpty()) {
            return;
        }
        FsSchemeConfig schemeConfig = queueGroups.get(0).getGroup().getSchemeConfig();
        List<ShareGroup> writeOffQueueGroups = this.executeShareAlgorithm(createShareGroups);
        for (ShareGroup shareGroup : writeOffQueueGroups) {
            ShareRuleBillConfig shareRuleBillConfig = shareGroup.getShareRuleBillConfig();
            ShareRecordStrategy recordStrategy = new ShareRecordStrategy();
            recordStrategy.setExecuteContext(this.getExecuteContext());
            recordStrategy.setTypeConfig(this.getTypeConfig());
            recordStrategy.setSchemeContextConfig(schemeConfig);
            recordStrategy.setShareRuleBillConfig(shareRuleBillConfig);
            FeeShareRecordMapper recordBill = recordStrategy.generate(shareGroup.getQueues(), null);
            List<FeeShareObjectBase> assistQueue = StandardFeeShareStrategy.cloneObjs(shareGroup.getAssitQueue());
            this.recordNumerator(recordBill.getRecordBill(), shareRuleBillConfig, assistQueue);
            FsPluginExtFactory.check(recordBill.getRecordBill(), this.getTypeConfig());
            this.getSnapShootHolder().addRecordBill(recordBill);
        }
    }

    public List<ShareGroup> createShareGroups(List<FeeShareHandleGroup> queueGroups) {
        ArrayList<ShareGroup> shareGroups = new ArrayList<ShareGroup>(16);
        for (FeeShareHandleGroup handleGroup : queueGroups) {
            if (handleGroup.isMainMatch()) {
                FeeShareMatchGroup group = handleGroup.getGroup();
                ShareGroup shareGroup = new ShareGroup(group.getShareRuleBillConfig(), StandardFeeShareStrategy.extractObjs(group.getFeeShareObjects()), StandardFeeShareStrategy.extractObjs(handleGroup.getMatchedQueues()));
                shareGroups.add(shareGroup);
                continue;
            }
            List<FeeShareObjectBase> mainQueue = StandardFeeShareStrategy.extractObjs(handleGroup.getMatchedQueues());
            HashMap splitBySrbillConfig = new HashMap(16);
            for (FeeShareObjectBase fsObj : mainQueue) {
                ShareRuleBillConfig billConifg = this.getShareRuleConfig().getShareBillConifg(fsObj);
                if (billConifg == null) continue;
                MapUtils.mapGetListValue(splitBySrbillConfig, (Object)billConifg.getObjId()).add(fsObj);
            }
            List<FeeShareObjectBase> assistQueue = StandardFeeShareStrategy.extractObjs(handleGroup.getGroup().getFeeShareObjects());
            for (Map.Entry mainQueueEntry : splitBySrbillConfig.entrySet()) {
                ShareRuleBillConfig shareBillConfig = this.getShareRuleConfig().getShareBillConfig((Long)mainQueueEntry.getKey());
                List<FeeShareObjectBase> newMainQueue = StandardFeeShareStrategy.cloneObjs((List)mainQueueEntry.getValue());
                ArrayList<FeeShareObjectBase> newAsisstQueue = new ArrayList<FeeShareObjectBase>(16);
                Long fbillId = null;
                for (FeeShareObjectBase assistWfObj : assistQueue) {
                    Long curbillId = (Long)assistWfObj.getBillPk();
                    if (shareBillConfig.getDenominator() == null && fbillId != null && Long.compare(fbillId, curbillId) != 0) continue;
                    fbillId = curbillId;
                    FeeShareObject assistObj = FeeShareObject.createShareAssist(this.getTypeConfig(), this.getTypeConfig().getAssistShareConfig(), assistWfObj.getDyObj(), shareBillConfig);
                    newAsisstQueue.add(assistObj.getFeeShareObjectBase());
                }
                ShareGroup group = new ShareGroup(shareBillConfig, newMainQueue, newAsisstQueue);
                shareGroups.add(group);
            }
        }
        return shareGroups;
    }

    protected List<ShareGroup> executeShareAlgorithm(List<ShareGroup> shareGroups) {
        ArrayList<ShareGroup> sharedList;
        block10: {
            sharedList = new ArrayList<ShareGroup>(16);
            try {
                List<Map<String, Object>> demoMap = this.queryShareDenominator(shareGroups);
                Map<Object, BigDecimal> hasShareQtyMap = BillDynamicMainFieldCal.queryShareRecord(shareGroups, this.getTypeConfig());
                for (ShareGroup shareGroup : shareGroups) {
                    ShareRuleBillConfig shareRuleBillConfig = shareGroup.getShareRuleBillConfig();
                    List<FeeShareObjectBase> mainShareQueue = shareGroup.getMainQueue();
                    List<FeeShareObjectBase> assistQueue = shareGroup.getAssitQueue();
                    DenominatorConfig denominator = shareRuleBillConfig.getDenominator();
                    IWriteOffMainFieldCalPlugin mainShareFiled = this.getTypeConfig().getMainShareConfig().getWriteOffColumnConfig().getWfFieldInfo().getMainFieldCalClass();
                    BigDecimal allSubNumesAmount = this.getAllSubNumesAmount(shareRuleBillConfig, assistQueue);
                    BigDecimal allSubDemosAmount = this.getSubDemosAmount(shareRuleBillConfig, assistQueue, allSubNumesAmount, demoMap);
                    for (FeeShareObjectBase mainObject : mainShareQueue) {
                        int precision = mainShareFiled.mainFieldPrecision((WriteOffObjectBase)mainObject);
                        BigDecimal shareAmount = mainObject.getWriteOffNumber();
                        List<FeeShareObjectBase> newAssistQueue = StandardFeeShareStrategy.cloneObjs(assistQueue);
                        if (allSubNumesAmount.compareTo(allSubDemosAmount) > 0) {
                            this.calculateShareAmtWithTailDiff(shareRuleBillConfig, newAssistQueue, shareAmount, allSubNumesAmount, precision);
                        } else if (allSubNumesAmount.compareTo(allSubDemosAmount) == 0) {
                            this.calculateShareAmtWithTailDiff(shareRuleBillConfig, newAssistQueue, shareAmount, allSubDemosAmount, precision);
                        } else {
                            BigDecimal sharedAmount = BigDecimal.ZERO;
                            if (denominator != null && denominator.getWfFieldInfo().getMainFieldCalClass() instanceof BillDynamicMainFieldCal) {
                                BigDecimal hasSharedQty = hasShareQtyMap.getOrDefault(mainObject.getPkValue(), BigDecimal.ZERO);
                                BillDynamicMainFieldCal mainFieldCal = (BillDynamicMainFieldCal)denominator.getWfFieldInfo().getMainFieldCalClass();
                                sharedAmount = mainFieldCal.shareAmountCal(shareRuleBillConfig, newAssistQueue, shareAmount, allSubDemosAmount, precision, hasSharedQty);
                            } else {
                                sharedAmount = this.calculateShareAmt(shareRuleBillConfig, newAssistQueue, shareAmount, allSubDemosAmount, precision);
                            }
                            mainObject.setFeeShareNumber(sharedAmount);
                        }
                        mainObject.setWfComplete(true);
                        List<FeeShareObjectBase> newMainQueue = Collections.singletonList(mainObject);
                        ShareGroup newShareGroup = new ShareGroup(shareRuleBillConfig, newMainQueue, newAssistQueue);
                        sharedList.add(newShareGroup);
                    }
                }
            }
            catch (Exception e) {
                logger.info("\u5206\u644a\u5931\u8d25\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                FeeShareLogInfo logInfo = this.getExecuteContext().getWriteOffLogByTypeId(this.getTypeConfig().getId());
                if (logInfo == null) break block10;
                logInfo.setErrorMessage(e);
            }
        }
        return sharedList;
    }

    private BigDecimal getSubDemosAmount(ShareRuleBillConfig shareRuleBillConfig, List<FeeShareObjectBase> candidateQueue, BigDecimal allSubNumesAmount, List<Map<String, Object>> demoMap) {
        BigDecimal allSubDemosAmount = BigDecimal.ZERO;
        DenominatorConfig denominator = shareRuleBillConfig.getDenominator();
        allSubDemosAmount = denominator == null ? allSubNumesAmount : (denominator.isPluginMatch() ? FsPluginExtFactory.getShareDenominator(denominator.getObj(), candidateQueue, this.getTypeConfig()) : (shareRuleBillConfig.onSameBillAlias() ? new CandidateQueueField(denominator).getDenominator(denominator.getObj(), candidateQueue) : new QueryDenomBillMatcher(shareRuleBillConfig).getDenominatorByMatchExpression(candidateQueue, demoMap)));
        return allSubDemosAmount;
    }

    private BigDecimal getAllSubNumesAmount(ShareRuleBillConfig shareRuleBillConfig, List<FeeShareObjectBase> candidateQueue) {
        BigDecimal allSubNumesAmount = BigDecimal.ZERO;
        for (FeeShareObjectBase subObj : candidateQueue) {
            BigDecimal curWriteOffNumber = subObj.getCurWriteOffNumber();
            if (shareRuleBillConfig.getNumerator().isAbsolute()) {
                curWriteOffNumber = curWriteOffNumber.abs();
            }
            allSubNumesAmount = allSubNumesAmount.add(curWriteOffNumber);
        }
        return allSubNumesAmount;
    }

    private BigDecimal calculateShareAmt(ShareRuleBillConfig shareRuleBillConfig, List<FeeShareObjectBase> candidateQueue, BigDecimal allShareAmount, BigDecimal allSubDemosAmount, int precision) {
        if (BigDecimal.ZERO.compareTo(allSubDemosAmount) == 0) {
            throw new KDBizException(EngineLang.denmonIsZero());
        }
        BigDecimal sharedAmount = BigDecimal.ZERO;
        for (FeeShareObjectBase subObj : candidateQueue) {
            BigDecimal curWriteOffNumber = subObj.getCurWriteOffNumber();
            if (shareRuleBillConfig.getNumerator().isAbsolute()) {
                curWriteOffNumber = curWriteOffNumber.abs();
            }
            BigDecimal curShareAmt = allShareAmount.multiply(curWriteOffNumber).divide(allSubDemosAmount, precision, RoundingMode.HALF_UP);
            subObj.setWriteOffNumber(curShareAmt);
            sharedAmount = sharedAmount.add(curShareAmt);
        }
        return sharedAmount;
    }

    private void calculateShareAmtWithTailDiff(ShareRuleBillConfig shareRuleBillConfig, List<FeeShareObjectBase> candidateQueue, BigDecimal allShareAmount, BigDecimal allSubDemosAmount, int precision) {
        BigDecimal calculateShareAmt = this.calculateShareAmt(shareRuleBillConfig, candidateQueue, allShareAmount, allSubDemosAmount, precision);
        BigDecimal diffAmount = allShareAmount.subtract(calculateShareAmt);
        if (BigDecimal.ZERO.compareTo(diffAmount) != 0) {
            this.handleDiff(candidateQueue, diffAmount);
        }
    }

    private void handleDiff(List<FeeShareObjectBase> candidateQueue, BigDecimal diffAmt) {
        BigDecimal maxAmt = BigDecimal.ZERO;
        FeeShareObjectBase maxObj = null;
        for (FeeShareObjectBase writeObject : candidateQueue) {
            BigDecimal objShareAmt = writeObject.getWriteOffNumber();
            if (maxObj != null && objShareAmt.abs().compareTo(maxAmt) <= 0) continue;
            maxAmt = objShareAmt.abs();
            maxObj = writeObject;
        }
        if (maxObj != null && diffAmt.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal amtWithDiff = maxObj.getWriteOffNumber().add(diffAmt);
            maxObj.setWriteOffNumber(amtWithDiff);
        }
    }

    private List<Map<String, Object>> queryShareDenominator(List<ShareGroup> shareGroups) {
        HashMap queryMap = new HashMap(16);
        for (ShareGroup shareGroup : shareGroups) {
            ShareRuleBillConfig shareRuleBillConfig = shareGroup.getShareRuleBillConfig();
            DenominatorConfig denominator = shareRuleBillConfig.getDenominator();
            if (denominator == null || denominator.isPluginMatch() || shareRuleBillConfig.onSameBillAlias()) continue;
            List<FeeShareObjectBase> assistQueue = shareGroup.getAssitQueue();
            String billEntityNum = denominator.getBillEntity();
            Map<String, Object> selectProAndFilterMap = new QueryDenomBillMatcher(shareRuleBillConfig).buildQFilterAndQueryProperties(assistQueue);
            QFilter qFilter = (QFilter)selectProAndFilterMap.get(FILTER);
            Set selectProperties = (Set)selectProAndFilterMap.get(SELECT_PROPERTIES);
            Map queryObj = (Map)queryMap.get(billEntityNum);
            if (queryObj == null) {
                HashMap<String, Object> qFilterAndSelectPropertiesMap = new HashMap<String, Object>(16);
                qFilterAndSelectPropertiesMap.put(FILTER, qFilter);
                qFilterAndSelectPropertiesMap.put(SELECT_PROPERTIES, selectProperties);
                queryMap.put(billEntityNum, qFilterAndSelectPropertiesMap);
                continue;
            }
            ((QFilter)queryObj.get(FILTER)).or(qFilter);
            ((Set)queryObj.get(SELECT_PROPERTIES)).addAll(selectProperties);
        }
        ArrayList<Map<String, Object>> targetValueList = new ArrayList<Map<String, Object>>();
        for (Map.Entry entry : queryMap.entrySet()) {
            String billNumber = (String)entry.getKey();
            Map value = (Map)entry.getValue();
            Set selectProperties = (Set)value.get(SELECT_PROPERTIES);
            QFilter qFilters = (QFilter)value.get(FILTER);
            DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"queryDemosBillInfo", (String)billNumber, (String)String.join((CharSequence)",", selectProperties), (QFilter[])new QFilter[]{qFilters}, null);
            for (Row row : queryDataSet) {
                HashMap<String, Object> targetValueMap = new HashMap<String, Object>(16);
                for (String targetField : selectProperties) {
                    targetValueMap.put(targetField, row.get(targetField));
                }
                targetValueList.add(targetValueMap);
            }
        }
        return targetValueList;
    }

    private void recordNumerator(DynamicObject recordBill, ShareRuleBillConfig shareRuleBillConfig, List<FeeShareObjectBase> assistQueue) {
        FeeShareTypeConfig typeConfig = this.getTypeConfig();
        String recordNum = typeConfig.getRecordNum();
        if (SHARE_FEE_RECORD.equals(recordNum) || "tyx_up_sr".equals(recordNum)) {
            String recordEntryType = typeConfig.getRecordEntryType();
            String fieldKey = shareRuleBillConfig.getNumerator().getWfFieldInfo().getWriteOffFieldKey();
            HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>(16);
            for (FeeShareObjectBase feeShareObjectBase : assistQueue) {
                map.put((Long)feeShareObjectBase.getPkValue(), (BigDecimal)feeShareObjectBase.getValue(fieldKey));
            }
            for (DynamicObject dynamicObject : recordBill.getDynamicObjectCollection(recordEntryType)) {
                BigDecimal qty = (BigDecimal)map.get(dynamicObject.getLong("billentryid"));
                if (qty == null) continue;
                dynamicObject.set("numerator", (Object)qty);
            }
        }
    }

    public Set<Long> getWriteOffTypeIds() {
        return null;
    }
}

