/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.core.kdtx;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.Param;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareExecuteContext;
import kd.mpscmm.mscommon.feeshare.business.engine.core.listener.FsRollbackListener;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareLogInfo;
import kd.mpscmm.mscommon.feeshare.business.engine.param.IFeeShareReqParam;
import kd.mpscmm.mscommon.feeshare.business.engine.param.impl.FlowFeeShareReqParam;
import kd.mpscmm.mscommon.feeshare.business.engine.param.impl.ManualAutoFeeShareReqParam;
import kd.mpscmm.mscommon.feeshare.business.engine.param.impl.ManualFeeShareReqParam;
import kd.mpscmm.mscommon.feeshare.business.engine.plugin.FsPluginExtFactory;
import kd.mpscmm.mscommon.feeshare.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.feeshare.common.kdtxargs.FsParam;
import kd.mpscmm.mscommon.feeshare.ext.defaultplugin.AbstractFeeShareExtPlugin;
import kd.mpscmm.mscommon.feeshare.ext.scmc.feeshare.helper.StandardAmtExchange;
import kd.mpscmm.mscommon.feeshare.lang.EngineLang;
import kd.mpscmm.mscommon.writeoff.common.helper.ECServiceHelper;
import kd.mpscmm.mscommon.writeoff.lang.TaskLang;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IKdtxWfPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class KdtxFeeShareService {
    private static final String KDTX_FEESHARERECORD_SCENE_CODE = "msmod_feeshare";
    private static final String KDTX_FEESHARERECORD_GENERATE_SUBSCENE_CODE = "msmod_feeshare_record";
    private static final String KDTX_FEESHARE_WRITEBACK_SUBSCENE_CODE = "msmod_feeshare_writeback";
    private static final String KDTX_FEESHARE_PLUGIN_SUBSCENE_CODE = "msmod_feeshare_plugin";
    private static final String KDTX_FEESHARE_RECORD_GENERATE_SERVICE = "FeeShareRecordService";
    private static final String KDTX_FEESHARE_WRITEBACK_SERVICE = "FeeShareWriteBackService";
    private static final String KDTX_FEESHARE_PLUGIN_SERVICE = "FeeSharePluginService";
    private static final Log logger = LogFactory.getLog(KdtxFeeShareService.class);
    private FeeShareExecuteContext executeContext;
    private List<String> businessInfos;
    private FeeShareTypeConfig fsType;
    private boolean isAsyn;
    private FeeShareLogInfo writeOffLog;

    public KdtxFeeShareService(Set<String> businessInfos, FeeShareTypeConfig wfType, boolean isManualWriteOff, FeeShareExecuteContext executeContext) {
        this.businessInfos = new ArrayList<String>(businessInfos);
        this.fsType = wfType;
        this.isAsyn = !isManualWriteOff;
        this.executeContext = executeContext;
    }

    public void kdtxWriteOffRecord(FeeShareTypeConfig wfType, List<DynamicObject> recordList) {
        FsParam commonParam = new FsParam();
        if (CollectionUtils.isEmpty(recordList)) {
            return;
        }
        if (wfType.getId().compareTo(WriteOffTypeIdConst.HXLB_ACTUALFEE_SHARE) == 0 || wfType.getId().compareTo(WriteOffTypeIdConst.HXLB_ESTFEE_SHARE) == 0) {
            this.resolveFeeShareRecord(recordList);
        }
        DynamicObject[] records = recordList.toArray(new DynamicObject[recordList.size()]);
        List<Object> successIds = KdtxFeeShareService.saveRecord(records);
        if (TX.inTX()) {
            TX.addCommitListener((CommitListener)FsRollbackListener.create(wfType.getRecordNum(), successIds));
        }
        commonParam.setBillNumber(records[0].getDataEntityType().getName());
        String dbRouteKey = records[0].getDataEntityType().getDBRouteKey();
        commonParam.setDbRout(dbRouteKey);
        commonParam.setWfTypeId(wfType.getId());
        commonParam.setIds(successIds);
        long taskLogId = this.logWriteOffTask(TaskLang.generateRecord(), KDTX_FEESHARE_RECORD_GENERATE_SERVICE, KDTX_FEESHARERECORD_GENERATE_SUBSCENE_CODE, (Object)commonParam);
        commonParam.setLogId(taskLogId);
        commonParam.setIsWfMode(this.getIsMode());
        commonParam.setWfExtParams(wfType.getWfExtParams());
        try {
            ECServiceHelper.execute((String)KDTX_FEESHARERECORD_SCENE_CODE, (String)KDTX_FEESHARERECORD_GENERATE_SUBSCENE_CODE, (String)"mpscmm", (String)"mscommon", (String)dbRouteKey, (String)KDTX_FEESHARE_RECORD_GENERATE_SERVICE, this.businessInfos, (Param)commonParam, (String)this.businessInfos.get(0), (boolean)this.isAsyn);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u6700\u7ec8\u4e00\u81f4\u5931\u8d25", (Throwable)e);
            throw new KDBizException(EngineLang.kdtxCallFail(e) + e.getMessage());
        }
    }

    private void resolveFeeShareRecord(List<DynamicObject> records) {
        Long feeRecordId;
        Date exratedate;
        Long entryid;
        DynamicObjectCollection aps;
        logger.info("\u542f\u7528\u6838\u9500\u5e73\u53f0\u8d39\u7528\u5206\u644a\uff0c\u8d39\u7528\u5206\u644a\u52fe\u7a3d\u8bb0\u5f55\u6570\u91cf\u4e3a\uff1a" + records.size());
        HashSet<Long> apbillids = new HashSet<Long>(16);
        HashSet<Long> apbillentryids = new HashSet<Long>(16);
        HashSet<Long> calorgs = new HashSet<Long>(16);
        boolean isActualFeeShare = false;
        HashMap<Long, DynamicObject> calorg2CurrencyMap = new HashMap<Long, DynamicObject>(4);
        HashMap<Object, StandardAmtExchange> calorg2StandardAmtExchangeMap = new HashMap<Object, StandardAmtExchange>(4);
        HashMap<Long, DynamicObject> feeRecordId2CurrencyMap = new HashMap<Long, DynamicObject>(4);
        HashMap<Long, Long> apeid2FeeRecordIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, Date> feeRecordId2ExrateDateMap = new HashMap<Long, Date>(16);
        HashMap<Long, DynamicObject> feeRecordId2ExpenseItemMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dynamicObject : records) {
            Long id = dynamicObject.getLong("id");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            long shareNum = Long.parseLong(simpleDateFormat.format(new Date()));
            dynamicObject.set("wfnumber", (Object)shareNum);
            calorgs.add(dynamicObject.getLong("org.id"));
            DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("entry");
            for (DynamicObject entryrow : entry) {
                String entity = entryrow.getString("billtype.id");
                if ("cal_costrecord_subentity".equals(entity)) {
                    entryrow.set("ismianbill", (Object)false);
                    continue;
                }
                if ("ap_finapbill".equals(entity)) {
                    isActualFeeShare = true;
                }
                entryrow.set("ismianbill", (Object)true);
                apbillids.add(entryrow.getLong("billid"));
                apbillentryids.add(entryrow.getLong("billentryid"));
                feeRecordId2CurrencyMap.put(id, entryrow.getDynamicObject("sharecurrency"));
                apeid2FeeRecordIdMap.put(entryrow.getLong("billentryid"), id);
                feeRecordId2ExpenseItemMap.put(id, entryrow.getDynamicObject("expenseitem"));
            }
        }
        Map baseCurrency = BusinessDataServiceHelper.loadFromCache((String)"bd_accountingsys_base", (String)"baseacctorg,basecurrrency,basecurrrency.amtprecision,exratetable", (QFilter[])new QFilter("baseacctorg", "in", calorgs).toArray());
        for (DynamicObject dynamicObject : baseCurrency.values()) {
            Long calorgId = dynamicObject.getDynamicObject("baseacctorg").getLong("id");
            DynamicObject basecurrrency = dynamicObject.getDynamicObject("basecurrrency");
            Long exratetable = dynamicObject.getDynamicObject("exratetable").getLong("id");
            calorg2CurrencyMap.put(calorgId, basecurrrency);
            calorg2StandardAmtExchangeMap.put(calorgId, new StandardAmtExchange(basecurrrency, exratetable));
        }
        if (isActualFeeShare) {
            QFilter qFilter = new QFilter("id", "in", apbillids);
            qFilter.and("detailentry.id", "in", apbillentryids);
            aps = QueryServiceHelper.query((String)"ap_finapbill", (String)"exratedate,detailentry.id as entryid", (QFilter[])qFilter.toArray(), null);
            for (DynamicObject ap : aps) {
                entryid = ap.getLong("entryid");
                exratedate = ap.getDate("exratedate");
                feeRecordId = (Long)apeid2FeeRecordIdMap.get(entryid);
                feeRecordId2ExrateDateMap.put(feeRecordId, exratedate);
            }
        } else {
            QFilter qFilter = new QFilter("id", "in", apbillids);
            qFilter.and("entry.id", "in", apbillentryids);
            aps = QueryServiceHelper.query((String)"ap_busbill", (String)"exratedate,entry.id as entryid", (QFilter[])qFilter.toArray(), null);
            for (DynamicObject ap : aps) {
                entryid = ap.getLong("entryid");
                exratedate = ap.getDate("exratedate");
                feeRecordId = (Long)apeid2FeeRecordIdMap.get(entryid);
                feeRecordId2ExrateDateMap.put(feeRecordId, exratedate);
            }
        }
        for (DynamicObject record : records) {
            Long id = record.getLong("id");
            long calorgid = record.getLong("org.id");
            DynamicObject currency = (DynamicObject)calorg2CurrencyMap.get(calorgid);
            DynamicObject feeRecordCurrency = (DynamicObject)feeRecordId2CurrencyMap.get(id);
            Date exrateDate = (Date)feeRecordId2ExrateDateMap.get(id);
            DynamicObject expenseItem = (DynamicObject)feeRecordId2ExpenseItemMap.get(id);
            DynamicObjectCollection entry = record.getDynamicObjectCollection("entry");
            for (DynamicObject entryrow : entry) {
                boolean isMainBill = entryrow.getBoolean("ismianbill");
                if (isMainBill) continue;
                entryrow.set("expenseitem", (Object)expenseItem);
                BigDecimal shareamount = entryrow.getBigDecimal("shareamount");
                if (currency == null || feeRecordCurrency == null) continue;
                if (currency.getLong("id") == feeRecordCurrency.getLong("id")) {
                    entryrow.set("e_amount", (Object)shareamount);
                    entryrow.set("e_taxamount", (Object)shareamount);
                    entryrow.set("currency_id", (Object)currency.getLong("id"));
                    entryrow.set("sharecurrency_id", (Object)currency.getLong("id"));
                    continue;
                }
                shareamount = ((StandardAmtExchange)calorg2StandardAmtExchangeMap.get(calorgid)).exchangeToStandardAmt(shareamount, feeRecordCurrency, exrateDate);
                entryrow.set("e_amount", (Object)shareamount);
                entryrow.set("e_taxamount", (Object)shareamount);
                entryrow.set("shareamount", (Object)shareamount);
                entryrow.set("sharetaxamount", (Object)shareamount);
                entryrow.set("currency_id", (Object)currency.getLong("id"));
                entryrow.set("sharecurrency_id", (Object)currency.getLong("id"));
            }
        }
    }

    private static List<Object> saveRecord(DynamicObject[] records) {
        SaveServiceHelper.save((DynamicObject[])records);
        ArrayList<Object> ids = new ArrayList<Object>(16);
        for (DynamicObject record : records) {
            ids.add(record.getPkValue());
        }
        return ids;
    }

    private String getIsMode() {
        IFeeShareReqParam reqParam = this.executeContext.getReqParam();
        if (reqParam instanceof FlowFeeShareReqParam) {
            return "1";
        }
        if (reqParam instanceof ManualAutoFeeShareReqParam) {
            return "3";
        }
        if (reqParam instanceof ManualFeeShareReqParam) {
            return "2";
        }
        return "";
    }

    public void kdtxBackWriteBill(Map<String, Map<String, List<Object[]>>> map, Map<String, Set<Long>> snapIdMap, Map<Long, List<DynamicObject>> writeoffRecordMap) {
        if (MapUtils.isEmpty(map)) {
            return;
        }
        Map<String, List<Object>> recordSerMap = this.resolveRecordMap(writeoffRecordMap);
        for (Map.Entry<String, Map<String, List<Object[]>>> sqlBuilderEntry : map.entrySet()) {
            FsParam commonParam = new FsParam();
            String DBRout = sqlBuilderEntry.getKey();
            commonParam.setDbRout(DBRout);
            Map<String, List<Object[]>> value = sqlBuilderEntry.getValue();
            commonParam.setParam(value);
            Set<Long> snapIds = snapIdMap.remove(DBRout);
            commonParam.setSnapShootIds(snapIds);
            commonParam.setRecordMap(recordSerMap);
            commonParam.setWfTypeId(this.fsType.getId());
            long taskLogId = this.logWriteOffTask(TaskLang.writeBack((String)DBRout), KDTX_FEESHARE_WRITEBACK_SERVICE, KDTX_FEESHARE_WRITEBACK_SUBSCENE_CODE, (Object)commonParam);
            commonParam.setLogId(taskLogId);
            commonParam.setWfExtParams(this.fsType.getWfExtParams());
            try {
                ECServiceHelper.execute((String)KDTX_FEESHARERECORD_SCENE_CODE, (String)KDTX_FEESHARE_WRITEBACK_SUBSCENE_CODE, (String)"mpscmm", (String)"mscommon", (String)DBRout, (String)KDTX_FEESHARE_WRITEBACK_SERVICE, Collections.emptyList(), (Param)commonParam, (String)this.businessInfos.get(0), (boolean)this.isAsyn);
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u6700\u7ec8\u4e00\u81f4\u5931\u8d25", (Throwable)e);
                throw new KDBizException(EngineLang.kdtxCallFail(e));
            }
        }
    }

    public void kdtxWfPlugin(List<DynamicObject> records, List<Map<String, Object>> recordKdtxParams) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        List<IKdtxWfPlugin> iKdtxWfPlugins = FsPluginExtFactory.kdtxWfPlugin(this.fsType.getId(), this.fsType.getWfExtParams());
        for (IKdtxWfPlugin plugin : iKdtxWfPlugins) {
            if (plugin instanceof AbstractFeeShareExtPlugin) {
                AbstractFeeShareExtPlugin extPlugin = (AbstractFeeShareExtPlugin)plugin;
                extPlugin.setExecuteContext(this.executeContext);
                extPlugin.setFstConfig(this.fsType);
            }
            FsParam commonParam = new FsParam();
            Map kdtxWfPluginParam = plugin.getKdtxWfPluginParam(recordKdtxParams);
            List ids = records.stream().map(n -> n.getPkValue()).collect(Collectors.toList());
            commonParam.setBillNumber(records.get(0).getDataEntityType().getName());
            commonParam.setValue(plugin.getClass().getName());
            commonParam.setWfTypeId(this.fsType.getId());
            commonParam.setIds(ids);
            long taskLogId = this.logWriteOffTask(TaskLang.executePlugin(plugin.getClass()), KDTX_FEESHARE_PLUGIN_SERVICE, KDTX_FEESHARE_PLUGIN_SUBSCENE_CODE, (Object)commonParam);
            commonParam.setLogId(taskLogId);
            commonParam.setKdtxWfPluginParam(kdtxWfPluginParam);
            commonParam.setWfExtParams(this.fsType.getWfExtParams());
            try {
                ECServiceHelper.execute((String)KDTX_FEESHARERECORD_SCENE_CODE, (String)KDTX_FEESHARE_PLUGIN_SUBSCENE_CODE, (String)"mpscmm", (String)"mscommon", (String)KDTX_FEESHARE_PLUGIN_SERVICE, Collections.emptyList(), (String)this.businessInfos.get(0), (Param)commonParam, (boolean)this.isAsyn);
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u6700\u7ec8\u4e00\u81f4\u6027\u5931\u8d25\u3002", (Throwable)e);
                throw new KDBizException(EngineLang.kdtxCallFail(e));
            }
        }
    }

    private Map<String, List<Object>> resolveRecordMap(Map<Long, List<DynamicObject>> recordMap) {
        HashMap<String, List<Object>> recordSerMap = new HashMap<String, List<Object>>(16);
        for (Map.Entry<Long, List<DynamicObject>> entry : recordMap.entrySet()) {
            Long wfTypeId = entry.getKey();
            List<DynamicObject> recordList = entry.getValue();
            if (recordList.isEmpty()) continue;
            DynamicObject[] records = recordList.toArray(new DynamicObject[recordList.size()]);
            List idList = recordList.stream().map(n -> n.getPkValue()).collect(Collectors.toList());
            String key = wfTypeId + "#" + records[0].getDataEntityType().getName();
            recordSerMap.put(key, idList);
        }
        return recordSerMap;
    }

    public void setWriteOffLog(FeeShareLogInfo writeOffLog) {
        this.writeOffLog = writeOffLog;
    }

    private long logWriteOffTask(String taskName, String taskClass, String branchcode, Object commonParam) {
        if (this.writeOffLog != null) {
            String reqParam = null;
            if (this.executeContext.getWfParam().isLogKdtxParam()) {
                reqParam = JSONObject.toJSONString((Object)commonParam);
            }
            return this.writeOffLog.addTaskEntry(taskName, taskClass, branchcode, this.businessInfos.get(0), reqParam);
        }
        return 0L;
    }
}

