/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.core.match;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareBillConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchConditionConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.core.match.entity.HintData;

public class HintDataMatcher {
    public static final Log log = LogFactory.getLog(HintDataMatcher.class);
    private Map<String, HintData> hintDataMap = new HashMap<String, HintData>(16);

    public HintData getHintData(Long matchEntryId, String targetBillAlias) {
        return this.hintDataMap.get(this.buildKey(matchEntryId, targetBillAlias));
    }

    public void addBotpLinkMatchData(Long matchEntryId, List<DynamicObject> hintQueryResults, List<QFilter> buildBotpLinkQueryFilter, Map<Long, Set<Long>> srcToTgtList, String trackInfo, FeeShareBillConfig tgtBillConf, List<FsMatchConditionConfig> botpFields) {
        String buildKey = this.buildKey(matchEntryId, tgtBillConf.getBillAlias());
        HintData hintData = new HintData();
        hintData.addBotpMatchData(hintQueryResults, buildBotpLinkQueryFilter, srcToTgtList, trackInfo, tgtBillConf, botpFields);
        this.hintDataMap.put(buildKey, hintData);
    }

    public void addMatchData(Long matchEntryId, List<DynamicObject> hintQueryResults, List<QFilter> hintQueryFilters, FeeShareBillConfig tgtBillConf, List<FsMatchConditionConfig> hintConfigs) {
        String buildKey = this.buildKey(matchEntryId, tgtBillConf.getBillAlias());
        HintData hintData = new HintData();
        hintData.addMatchData(hintQueryResults, hintQueryFilters, tgtBillConf, hintConfigs);
        this.hintDataMap.put(buildKey, hintData);
    }

    private String buildKey(Long matchEntryId, String billAlias) {
        return matchEntryId + "#" + billAlias;
    }

    public void clearCachedData() {
        this.hintDataMap.clear();
    }

    public Map<String, HintData> getHintDataMap() {
        return this.hintDataMap;
    }
}

