/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.core.match.share;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsFieldInfo;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchConditionConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.DenominatorConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.ShareRuleBillConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.core.plugin.BillFieldWFMainFieldCal;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FsDataTable;
import kd.mpscmm.mscommon.feeshare.common.util.MatcherUtil;
import kd.mpscmm.mscommon.feeshare.lang.EngineLang;
import kd.sdk.mpscmm.mscommon.feeshare.extpoint.IDenominatorGetPlugin;
import kd.sdk.mpscmm.mscommon.feeshare.params.FeeShareObjectBase;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffMainFieldCalPlugin;

public class QueryDenomBillMatcher
implements IDenominatorGetPlugin {
    private static final Log logger = LogFactory.getLog(QueryDenomBillMatcher.class);
    private ShareRuleBillConfig shareRuleBillConfig;

    public QueryDenomBillMatcher(ShareRuleBillConfig shareRuleConfig) {
        this.shareRuleBillConfig = shareRuleConfig;
    }

    @Override
    public BigDecimal getDenominator(DynamicObject shareRuleEntry, List<FeeShareObjectBase> writeOffObjects) {
        List<FsMatchConditionConfig> matchConditionConfigs = this.shareRuleBillConfig.getDenomMatchConfigs().getMatchConditionConfigs();
        DenominatorConfig denominator = this.shareRuleBillConfig.getDenominator();
        FsFieldInfo denomField = denominator.getWfFieldInfo();
        Map<String, Object> resolveMap = this.resolveMatchField(matchConditionConfigs, writeOffObjects, denominator);
        Set targetfields = (Set)resolveMap.get("targetFields");
        List demosBillFilters = (List)resolveMap.get("billFilter");
        List bosExpressions = (List)resolveMap.get("expression");
        HashMap<Long, BigDecimal> matchedField = new HashMap<Long, BigDecimal>(16);
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"queryDemosBillInfo", (String)denominator.getBillEntity(), (String)String.join((CharSequence)",", targetfields), (QFilter[])demosBillFilters.toArray(new QFilter[demosBillFilters.size()]), null);
        Object object = null;
        try {
            for (Row row : queryDataSet) {
                HashMap<String, Object> targetValue = new HashMap<String, Object>(16);
                for (String targetField : targetfields) {
                    targetValue.put(targetField, row.get(targetField));
                }
                for (BOSExpression expr : bosExpressions) {
                    Boolean isMatch = (Boolean)FormulaEngine.execExcelFormula((Expr)expr.getExpr(), targetValue);
                    if (!isMatch.booleanValue()) continue;
                    Long rowValue = row.getLong(denomField.getWfCalcFieldIdName());
                    IWriteOffMainFieldCalPlugin mainFieldCalClass = denomField.getMainFieldCalClass();
                    BigDecimal demonValue = null;
                    demonValue = mainFieldCalClass instanceof BillFieldWFMainFieldCal ? row.getBigDecimal(denomField.getWriteOffFieldKey()) : denomField.getMainFieldCalClass().wfManualmainFieldCal(row);
                    matchedField.put(rowValue, demonValue);
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (queryDataSet != null) {
                if (object != null) {
                    try {
                        queryDataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    queryDataSet.close();
                }
            }
        }
        if (matchedField.isEmpty()) {
            logger.debug("\u6838\u9500\u5e73\u53f0-\u5206\u644a\uff1a\u5339\u914d\u7b2c\u4e09\u65b9\u5355\u636e\u5931\u8d25\uff0c\u67e5\u8be2\u4fe1\u606f\uff1a" + denominator.getBillEntity() + "SelectField" + targetfields + " Fitler:" + demosBillFilters);
            logger.debug("\u6838\u9500\u5e73\u53f0-\u5206\u644a\uff1a\u5339\u914d\u7b2c\u4e09\u65b9\u5355\u636e\u5931\u8d25\uff0c\u5339\u914d\u6761\u4ef6\uff1a" + bosExpressions.toString());
            throw new KDBizException(EngineLang.demonBillMatchFail(this.shareRuleBillConfig));
        }
        logger.debug("\u6838\u9500\u5e73\u53f0-\u5206\u644a\uff1a\u83b7\u53d6\u5339\u914d\u5230\u7b2c\u4e09\u65b9\u5355\u636e\u4fe1\u606f\uff1a" + ((Object)matchedField).toString());
        BigDecimal allDemons = BigDecimal.ZERO;
        for (BigDecimal demon : matchedField.values()) {
            if (denominator.isAbsolute()) {
                demon = demon.abs();
            }
            allDemons = allDemons.add(demon);
        }
        return allDemons;
    }

    private BOSExpression buildTargetExpresion(List<FsMatchConditionConfig> matchConditionConfigs, Map<String, Object> srcValues) {
        StringBuilder expressionStr = new StringBuilder();
        for (FsMatchConditionConfig config : matchConditionConfigs) {
            Object value;
            if (config.checkEmptyValue(value = srcValues.get(config.getSrcBillFieldKey()))) {
                if (config.getEmptyEqual().booleanValue()) {
                    if (config.getSrcPropType() instanceof BasedataProp) {
                        value = 0L;
                    }
                } else {
                    return null;
                }
            }
            if (value instanceof Date) {
                String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)value);
                value = String.format("to_date('%s','yyyy-MM-dd HH:mm:ss')", date);
            } else if (value instanceof String) {
                value = String.format("'%s'", value);
            } else if (value instanceof DynamicObject) {
                value = ((DynamicObject)value).getLong("id");
            }
            String singleExpr = String.format("%s %s %s", config.getTargetBillFieldKey(), config.getComparison(), value);
            if (expressionStr.length() > 1) {
                expressionStr.append(" and ");
            }
            expressionStr.append(singleExpr);
        }
        return new BOSExpression(expressionStr.toString());
    }

    private List<QFilter> buildQueryFilter(List<FsMatchConditionConfig> matchConditionConfigs, FsDataTable numesBillTable) {
        List<QFilter> demosBillFilters = MatcherUtil.buildQueryFilter(matchConditionConfigs, numesBillTable);
        DenominatorConfig denominator = this.shareRuleBillConfig.getDenominator();
        demosBillFilters.addAll(denominator.getFilters());
        return demosBillFilters;
    }

    @Override
    public Set<Long> getShareDemonEntryIds() {
        return null;
    }

    private Map<String, Object> resolveMatchField(List<FsMatchConditionConfig> matchConditionConfigs, List<FeeShareObjectBase> writeOffObjects, DenominatorConfig denominator) {
        HashMap<String, Object> resolveMap = new HashMap<String, Object>(16);
        ArrayList<String> srcFields = new ArrayList<String>(16);
        HashSet<String> targetFields = new HashSet<String>(16);
        FsFieldInfo denomField = denominator.getWfFieldInfo();
        for (FsMatchConditionConfig matchColumnConfig : matchConditionConfigs) {
            srcFields.add(matchColumnConfig.getSrcBillFieldKey());
            targetFields.add(matchColumnConfig.getTargetBillFieldKey());
        }
        DynamicObject dynamicObject = denominator.getObj();
        if ("A".equals(dynamicObject.getString("valuemethod"))) {
            targetFields.add(denomField.getWriteOffFieldKey());
        }
        targetFields.add(denomField.getWfCalcFieldIdName());
        targetFields.addAll(denomField.getMainFieldCalClass().calNeedFields());
        resolveMap.put("targetFields", targetFields);
        FsDataTable numesBillTable = FsDataTable.create(srcFields.toArray(new String[srcFields.size()]));
        ArrayList<BOSExpression> targetExpression = new ArrayList<BOSExpression>(16);
        for (FeeShareObjectBase writeOffObject : writeOffObjects) {
            HashMap<String, Object> values = new HashMap<String, Object>(16);
            for (String srcField : srcFields) {
                values.put(srcField, writeOffObject.getValue(srcField));
            }
            BOSExpression expression = this.buildTargetExpresion(matchConditionConfigs, values);
            if (expression == null) continue;
            targetExpression.add(expression);
            numesBillTable.addData((Long)writeOffObject.getPkValue(), values);
        }
        if (targetExpression.isEmpty()) {
            throw new KDBizException(EngineLang.demonBillNoDataToMatch(this.shareRuleBillConfig));
        }
        resolveMap.put("expression", targetExpression);
        List<QFilter> qFilterList = this.buildQueryFilter(matchConditionConfigs, numesBillTable);
        resolveMap.put("billFilter", qFilterList);
        return resolveMap;
    }

    public Map<String, Object> buildQFilterAndQueryProperties(List<FeeShareObjectBase> writeOffObjects) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        List<FsMatchConditionConfig> matchConditionConfigs = this.shareRuleBillConfig.getDenomMatchConfigs().getMatchConditionConfigs();
        DenominatorConfig denominator = this.shareRuleBillConfig.getDenominator();
        Map<String, Object> resolveMap = this.resolveMatchField(matchConditionConfigs, writeOffObjects, denominator);
        Set targetFields = (Set)resolveMap.get("targetFields");
        List qFilterList = (List)resolveMap.get("billFilter");
        QFilter qFilter = null;
        for (QFilter filter : qFilterList) {
            if (qFilter == null) {
                qFilter = filter;
                continue;
            }
            qFilter = qFilter.and(filter);
        }
        result.put("queryProperties", targetFields);
        result.put("qFilter", qFilter);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public BigDecimal getDenominatorByMatchExpression(List<FeeShareObjectBase> writeOffObjects, List<Map<String, Object>> targetValues) {
        void var8_11;
        List<FsMatchConditionConfig> matchConditionConfigs = this.shareRuleBillConfig.getDenomMatchConfigs().getMatchConditionConfigs();
        DenominatorConfig denominator = this.shareRuleBillConfig.getDenominator();
        FsFieldInfo denomField = denominator.getWfFieldInfo();
        ArrayList<String> srcfields = new ArrayList<String>(16);
        for (FsMatchConditionConfig fsMatchConditionConfig : matchConditionConfigs) {
            srcfields.add(fsMatchConditionConfig.getSrcBillFieldKey());
        }
        HashMap<Long, BigDecimal> matchedField = new HashMap<Long, BigDecimal>(16);
        for (FeeShareObjectBase writeOffObject : writeOffObjects) {
            HashMap<String, Object> values = new HashMap<String, Object>(16);
            for (String srcField : srcfields) {
                values.put(srcField, writeOffObject.getValue(srcField));
            }
            BOSExpression expression = this.buildTargetExpresion(matchConditionConfigs, values);
            if (expression == null) continue;
            for (Map<String, Object> targetValue : targetValues) {
                Boolean isMatch = (Boolean)FormulaEngine.execExcelFormula((Expr)expression.getExpr(), targetValue);
                if (!isMatch.booleanValue()) continue;
                Long rowValue = (Long)targetValue.get(denomField.getWfCalcFieldIdName());
                IWriteOffMainFieldCalPlugin mainFieldCalClass = denomField.getMainFieldCalClass();
                BigDecimal demonValue = null;
                demonValue = mainFieldCalClass instanceof BillFieldWFMainFieldCal ? (BigDecimal)targetValue.get(denomField.getWriteOffFieldKey()) : mainFieldCalClass.dynamicMainFieldCal(targetValue);
                matchedField.put(rowValue, demonValue);
            }
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        for (BigDecimal demon : matchedField.values()) {
            if (denominator.isAbsolute()) {
                demon = demon.abs();
            }
            BigDecimal bigDecimal2 = var8_11.add(demon);
        }
        return var8_11;
    }
}

