/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareBillConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsSchemeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.NumeratorConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.ShareRuleBillConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.core.context.FeeShareSnapshotContext;
import kd.mpscmm.mscommon.feeshare.business.engine.core.match.BillDataSource;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareBillGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareObject;
import kd.mpscmm.mscommon.feeshare.lang.EngineLang;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.IWFFilter;

public class FeeShareManualGroup
extends FeeShareBillGroup {
    private FsSchemeConfig schemeConfig;
    private List<IWFFilter> filter;
    private int maxHandleBillSize = 5000;
    private BillDataSource billDataSource;
    private Map<Object, BigDecimal> curMainFieldValueMap = null;

    public static FeeShareManualGroup build(FeeShareTypeConfig typeConfig, FeeShareBillConfig billConfig, FsSchemeConfig schemeConfig, BillDataSource billDataSource) {
        FeeShareManualGroup writeOffGroup = new FeeShareManualGroup(typeConfig, billConfig);
        writeOffGroup.setSchemeConfig(schemeConfig);
        writeOffGroup.setBillDataSource(billDataSource);
        return writeOffGroup;
    }

    public FeeShareManualGroup(FeeShareTypeConfig typeConfig, FeeShareBillConfig billTypeConfig) {
        super(typeConfig, billTypeConfig);
    }

    public FsSchemeConfig getSchemeConfig() {
        return this.schemeConfig;
    }

    private void setSchemeConfig(FsSchemeConfig schemeConfig) {
        this.schemeConfig = schemeConfig;
    }

    public List<IWFFilter> getFilter() {
        return this.filter;
    }

    public void setFilter(List<IWFFilter> billFilter, int maxHandleSize) {
        this.filter = billFilter;
        this.maxHandleBillSize = maxHandleSize;
    }

    public void initFeeShareObject(ShareRuleBillConfig shareRuleBillConfig) {
        FeeShareBillConfig billTypeConfig = this.getBillTypeConfig();
        String entityName = billTypeConfig.getBillType();
        NumeratorConfig numerator = shareRuleBillConfig.getNumerator();
        String wfCalcFieldIdName = numerator.getWfFieldInfo().getWfCalcFieldIdName();
        String selectField = "id" + ("id".equals(wfCalcFieldIdName) ? "" : "," + wfCalcFieldIdName);
        HashSet<Object> ids = new HashSet<Object>(128);
        HashSet<Object> wfMainKey = new HashSet<Object>(128);
        ArrayList<Object> subfilters = new ArrayList<Object>(16);
        subfilters.addAll(this.filter);
        subfilters.addAll(numerator.getWfConditionFilters());
        try (DataSet idDataSet = QueryServiceHelper.queryDataSet((String)"manualGroup", (String)entityName, (String)selectField, (QFilter[])IWFFilter.toQFilters(subfilters), (String)"");){
            for (Row row : idDataSet) {
                ids.add(row.get("id"));
                wfMainKey.add(row.get(wfCalcFieldIdName));
            }
        }
        if (wfMainKey.isEmpty()) {
            throw new KDBizException(EngineLang.mainBillNotExist());
        }
        if (wfMainKey.size() >= this.maxHandleBillSize) {
            throw new KDBizException(EngineLang.overMaxHandleBillSize(this.maxHandleBillSize));
        }
        QFilter queryFilter = new QFilter("id", "in", ids);
        queryFilter.and(wfCalcFieldIdName, "in", wfMainKey);
        DynamicObjectCollection billDynamics = this.billDataSource.queryBillData(entityName, numerator.getWfFieldInfo().getMainFieldCalClass().mainFieldEntry(), IWFFilter.toQFilters(subfilters));
        ArrayList<FeeShareObject> feeShareObjects = new ArrayList<FeeShareObject>(16);
        for (DynamicObject billDynamic : billDynamics) {
            FeeShareObject feeShareObject = FeeShareObject.createShareAssist(this.getTypeConfig(), billTypeConfig, billDynamic, shareRuleBillConfig);
            if (feeShareObject.isCurWriteOffZero() || feeShareObject.isWfNumZero() || !billTypeConfig.checkHighCondtion(feeShareObject.getFeeShareObjectBase())) continue;
            feeShareObjects.add(feeShareObject);
        }
        this.getFeeShareObjects().clear();
        this.getFeeShareObjects().addAll(feeShareObjects);
    }

    public void initFeeShareObject() {
        FeeShareBillConfig billTypeConfig = this.getBillTypeConfig();
        if (!this.getFeeShareObjects().isEmpty() || billTypeConfig.getWriteOffColumnConfig() == null) {
            return;
        }
        String entityName = billTypeConfig.getBillType();
        String wfCalcFieldIdName = billTypeConfig.getWfCalcFieldIdName();
        String selectField = "id" + ("id".equals(wfCalcFieldIdName) ? "" : "," + wfCalcFieldIdName);
        HashSet<Object> ids = new HashSet<Object>(128);
        HashSet<Object> wfMainKey = new HashSet<Object>(128);
        try (DataSet idDataSet = QueryServiceHelper.queryDataSet((String)"manualGroup", (String)entityName, (String)selectField, (QFilter[])IWFFilter.toQFilters(this.filter), (String)"");){
            for (Row row : idDataSet) {
                ids.add(row.get("id"));
                wfMainKey.add(row.get(wfCalcFieldIdName));
            }
        }
        if (wfMainKey.isEmpty()) {
            throw new KDBizException(EngineLang.mainBillNotExist());
        }
        if (wfMainKey.size() >= this.maxHandleBillSize) {
            throw new KDBizException(EngineLang.overMaxHandleBillSize(this.maxHandleBillSize));
        }
        FeeShareSnapshotContext snapshotContext = new FeeShareSnapshotContext(this.getTypeConfig());
        snapshotContext.loadSnapShootMap(new ArrayList<Object>(ids), entityName);
        QFilter queryFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection billDynamics = this.billDataSource.queryBillData(entityName, this.getBillTypeConfig().getMainFieldEntry(), queryFilter);
        ArrayList<FeeShareObject> feeShareObjects = new ArrayList<FeeShareObject>(16);
        for (DynamicObject billDynamic : billDynamics) {
            FeeShareObject feeShareObject = FeeShareObject.create(this.getTypeConfig(), billTypeConfig, billDynamic, billTypeConfig.getWriteOffColumnConfig().getWfFieldInfo());
            if (feeShareObject.isCurWriteOffZero() || feeShareObject.isWfNumZero()) continue;
            if (this.curMainFieldValueMap != null) {
                Object pk = feeShareObject.getPkValue();
                BigDecimal curMainFieldValue = this.curMainFieldValueMap.get(pk);
                if (curMainFieldValue == null || BigDecimal.ZERO.compareTo(curMainFieldValue) == 0) continue;
                feeShareObject.setFeeShareNumber(curMainFieldValue);
                feeShareObjects.add(feeShareObject);
                continue;
            }
            if (!billTypeConfig.checkHighCondtion(feeShareObject.getFeeShareObjectBase())) continue;
            feeShareObjects.add(feeShareObject);
        }
        this.getFeeShareObjects().clear();
        this.getFeeShareObjects().addAll(feeShareObjects);
    }

    public Map<Object, BigDecimal> getCurMainFieldValueMap() {
        return this.curMainFieldValueMap;
    }

    public void setCurMainFieldValueMap(Map<Object, BigDecimal> curMainFieldValueMap) {
        this.curMainFieldValueMap = curMainFieldValueMap;
    }

    public void setBillDataSource(BillDataSource billDataSource) {
        this.billDataSource = billDataSource;
    }
}

