/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo;

import java.math.BigDecimal;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareBillConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareColumnConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsFieldInfo;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.NumeratorConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.ShareRuleBillConfig;
import kd.sdk.mpscmm.mscommon.feeshare.params.FeeShareAssitObjetBase;
import kd.sdk.mpscmm.mscommon.feeshare.params.FeeShareObjectBase;

public class FeeShareObject
implements Cloneable {
    private final FeeShareObjectBase feeShareObjectBase;
    private FeeShareTypeConfig typeConfig;
    private FeeShareBillConfig billConfig;
    private FsFieldInfo mainColumn;

    public FeeShareObject(FeeShareObjectBase feeShareObjectBase) {
        this.feeShareObjectBase = feeShareObjectBase;
    }

    public static FeeShareObject create(FeeShareTypeConfig typeConfig, FeeShareBillConfig billConfig, DynamicObject dataEntity) {
        FsFieldInfo fieldInfo = billConfig.getWriteOffColumnConfig().getWfFieldInfo();
        return FeeShareObject.create(typeConfig, billConfig, dataEntity, fieldInfo);
    }

    public static FeeShareObject create(FeeShareTypeConfig typeConfig, FeeShareBillConfig billConfig, DynamicObject dataEntity, FsFieldInfo wfFieldInfo) {
        FeeShareObjectBase fsObj = new FeeShareObjectBase();
        fsObj.setDyObject(dataEntity);
        FeeShareObject feeShareObject = new FeeShareObject(fsObj);
        feeShareObject.initInfo(typeConfig, billConfig);
        feeShareObject.setPrimaryColumn(wfFieldInfo);
        return feeShareObject;
    }

    public static FeeShareObject createShareAssist(FeeShareTypeConfig typeConfig, FeeShareBillConfig billConfig, DynamicObject dataEntity, ShareRuleBillConfig shareRulecBillConfig) {
        return FeeShareObject.createShareAssist(typeConfig, billConfig, dataEntity, shareRulecBillConfig.getNumerator());
    }

    public static FeeShareObject createShareAssist(FeeShareTypeConfig typeConfig, FeeShareBillConfig billConfig, DynamicObject dataEntity, NumeratorConfig numeratorConfig) {
        FeeShareAssitObjetBase fsObj = new FeeShareAssitObjetBase();
        fsObj.setDyObject(dataEntity);
        FeeShareObject feeShareObject = new FeeShareObject(fsObj);
        feeShareObject.initInfo(typeConfig, billConfig);
        feeShareObject.setPrimaryColumn(numeratorConfig.getWfFieldInfo());
        return feeShareObject;
    }

    public static FeeShareObject createShareAssist(FeeShareTypeConfig typeConfig, FeeShareBillConfig billConfig, DynamicObject dataEntity, String mainFieldEntry) {
        FeeShareAssitObjetBase fsObj = new FeeShareAssitObjetBase();
        fsObj.setDyObject(dataEntity);
        fsObj.setMainField(mainFieldEntry);
        FeeShareObject feeShareObject = new FeeShareObject(fsObj);
        feeShareObject.initInfo(typeConfig, billConfig);
        return feeShareObject;
    }

    private void initInfo(FeeShareTypeConfig typeConfig, FeeShareBillConfig billConfig) {
        this.typeConfig = typeConfig;
        this.feeShareObjectBase.setWfTypeEntity(typeConfig.getObj());
        this.billConfig = billConfig;
        this.feeShareObjectBase.setWfBillEntity(billConfig.getObj());
        FeeShareColumnConfig config = billConfig.getWriteOffColumnConfig();
        if (config != null) {
            this.feeShareObjectBase.setInvert(billConfig.getWriteOffColumnConfig().getCalculationRule());
        }
    }

    public FeeShareObject clone() {
        try {
            FeeShareObject writeOffObject = (FeeShareObject)super.clone();
            return writeOffObject;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FeeShareObject)) {
            return false;
        }
        FeeShareObject that = (FeeShareObject)o;
        return Objects.equals(this.getPkValue(), this.getPkValue()) && Objects.equals(this.typeConfig.getId(), that.typeConfig.getId()) && Objects.equals(this.billConfig.getBillAlias(), that.billConfig.getBillAlias());
    }

    public int hashCode() {
        return Objects.hash(this.feeShareObjectBase.getPkValue(), this.typeConfig.getId(), this.billConfig.getBillAlias());
    }

    public Object getValue(String key) {
        return this.feeShareObjectBase.getValue(key);
    }

    public Object getPkValue() {
        return this.feeShareObjectBase.getPkValue();
    }

    public Object getBillPk() {
        return this.feeShareObjectBase.getBillPk();
    }

    public String getBillEntityName() {
        return this.getBillConfig().getBillType();
    }

    public BigDecimal getFeeShareNumber() {
        return this.feeShareObjectBase.getFeeShareNumber();
    }

    public void setCurFeeShareNumber(BigDecimal wfNumber) {
        this.feeShareObjectBase.setCurFeeShareNumber(wfNumber);
    }

    public void setFeeShareNumber(BigDecimal writeOffNumber) {
        this.feeShareObjectBase.setFeeShareNumber(writeOffNumber);
    }

    public FeeShareTypeConfig getTypeConfig() {
        return this.typeConfig;
    }

    public void setTypeConfig(FeeShareTypeConfig typeConfig) {
        this.feeShareObjectBase.setWfTypeEntity(typeConfig.getObj());
        this.typeConfig = typeConfig;
    }

    public FeeShareBillConfig getBillConfig() {
        return this.billConfig;
    }

    public boolean isBillObj() {
        return this.feeShareObjectBase.isBillObj();
    }

    public boolean isCurWriteOffZero() {
        return BigDecimal.ZERO.compareTo(this.feeShareObjectBase.getCurFeeShareNumber()) == 0;
    }

    public boolean isWfNumZero() {
        return BigDecimal.ZERO.compareTo(this.feeShareObjectBase.getFeeShareNumber()) == 0;
    }

    public FeeShareObjectBase getFeeShareObjectBase() {
        return this.feeShareObjectBase;
    }

    public void setPrimaryColumn(FsFieldInfo mainColumn) {
        this.mainColumn = mainColumn;
        this.feeShareObjectBase.setMainWFFieldIdKey(mainColumn.getWfCalcFieldIdName());
        this.feeShareObjectBase.setPrimaryColumn(mainColumn.getWriteOffFieldKey());
        this.feeShareObjectBase.setPrimaryColumnEObjId(String.valueOf(mainColumn.getId()));
        BigDecimal curFeeShareNum = mainColumn.getMainFieldCalClass().mainFieldCal(this.getFeeShareObjectBase().getDyObj());
        this.feeShareObjectBase.setCurFeeShareNumber(curFeeShareNum);
        this.feeShareObjectBase.setFeeShareNumber(curFeeShareNum);
    }

    public FsFieldInfo getMainColumn() {
        return this.mainColumn;
    }

    public boolean isShareAssist() {
        return this.feeShareObjectBase instanceof FeeShareAssitObjetBase;
    }
}

