/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.executor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.feeshare.business.config.vo.AbstractFSCondtionConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareBillConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchRelationConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchRuleConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsSchemeConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareExecuteContext;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareTypeContext;
import kd.mpscmm.mscommon.feeshare.business.engine.core.FeeShareHandleGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.feeshare.FeeShareStrategyExecutor;
import kd.mpscmm.mscommon.feeshare.business.engine.core.match.entity.HintData;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareLogInfo;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareMatchGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareObject;
import kd.mpscmm.mscommon.feeshare.lang.EngineLang;

public abstract class AbstractFeeShareGroupExecutor {
    private static final Log logger = LogFactory.getLog(AbstractFeeShareGroupExecutor.class);
    private Boolean isMatchObj = Boolean.TRUE;
    private FeeShareTypeContext typeContext;

    public void init(FeeShareTypeContext typeContext) {
        this.typeContext = typeContext;
    }

    public abstract void doExecute(List<FeeShareMatchGroup> var1);

    protected boolean checkHintMatch(FeeShareLogInfo logInfo, FeeShareMatchGroup wfMatchGroup, FsMatchRelationConfig config) {
        Long matchId = config.getMatchId();
        FeeShareBillConfig targetConfig = this.getTypeConfig().getBillConf(config.getTargetBillTypeKey());
        HintData hintData = this.getHolder().getHintDataLoader().getHintData(matchId, targetConfig.getBillAlias());
        if (targetConfig != null && hintData != null) {
            if (!hintData.isNoMatchData()) {
                config.setTrackRelation(hintData.getTackInfo());
                return true;
            }
        } else {
            return true;
        }
        logInfo.setMatchLogsInfo(wfMatchGroup, Collections.emptyList(), config.getTargetBillType(), hintData.getConditionInfos(), "B");
        logger.info(String.format("\u3010%s\u3011\u5206\u644a\u5e73\u53f0\u67e5\u8be2Hint\u5339\u914d\u5355\u636e\u3010%s\u3011\u7ed3\u679c\u4e3a\u7a7a\u3002", this.getTypeConfig().getName(), targetConfig.getBillName()));
        return false;
    }

    protected FsMatchRuleConfig getMatchRule(FeeShareMatchGroup matchGroup) {
        FsSchemeConfig schemeConfig = matchGroup.getSchemeConfig();
        FsMatchRuleConfig matchRuleConfigById = this.getExecuteContext().getConfigManager().getMatchRuleConfigById(schemeConfig.getMatchRuleId(), schemeConfig.getShareRuleId());
        if (matchRuleConfigById == null) {
            throw new KDBizException(EngineLang.matchRuleValidateFail());
        }
        return matchRuleConfigById;
    }

    protected List<FeeShareObject> filterWriteOffObject(AbstractFSCondtionConfig condtionConfig, List<FeeShareObject> matchObjects) {
        ArrayList<FeeShareObject> filterObjects = new ArrayList<FeeShareObject>(16);
        for (FeeShareObject matchObject : matchObjects) {
            boolean check = condtionConfig.checkCondtion(matchObject.getFeeShareObjectBase()) && condtionConfig.checkHighCondtion(matchObject.getFeeShareObjectBase());
            if (!check) continue;
            filterObjects.add(matchObject);
        }
        return filterObjects;
    }

    protected FeeShareTypeContext getHolder() {
        return this.typeContext;
    }

    public FeeShareTypeConfig getTypeConfig() {
        return this.typeContext.getTypeConfig();
    }

    protected FeeShareExecuteContext getExecuteContext() {
        return this.getHolder().getExecuteContext();
    }

    public Boolean getMatchObj() {
        return this.isMatchObj;
    }

    protected void setMatchObj(Boolean matchObj) {
        this.isMatchObj = matchObj;
    }

    public void doFeeShare(List<FeeShareHandleGroup> queueGroups) {
        if (queueGroups.isEmpty()) {
            return;
        }
        FeeShareMatchGroup group = queueGroups.get(0).getGroup();
        try (TraceSpan trace = Tracer.create((String)"FeeShare-StrategyExecutor", (String)"writeOff");){
            FeeShareStrategyExecutor executor = new FeeShareStrategyExecutor(this.typeContext, group.getShareRuleConfig());
            executor.feeShare(queueGroups);
        }
    }
}

