/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.ext.scmc.cal.plugin.FeeShareInvokeCalPlugin;
import kd.mpscmm.mscommon.feeshare.ext.scmc.cal.plugin.ReFeeShareBackBillByPlugin;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.DefaultUnWfPlugin;
import kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin.ReMdcOmCmpWriteBackBillByPlugin;
import kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin.ReMdcOminWriteBackBillByPlugin;
import kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin.ReRevcfRedWriteBackBillByPlugin;
import kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin.ReWriteBackBillByPlugin;
import kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin.SctmUnWriteBackBillByPlugin;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.IWriteOffBasePlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IKdtxUnWfPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IUnWfEndWriteBackPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IUnWriteOffCheckPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IUnWriteOffPlugin;
import org.apache.commons.collections4.map.MultiKeyMap;

public class UnFsPluginExtFactory {
    private MultiKeyMap<String, PluginProxy<? extends IWriteOffBasePlugin>> unWfPluginCache = new MultiKeyMap();

    public List<IKdtxUnWfPlugin> kdtxBackWfPlugin(Long typeConfigId) {
        String wfTypeId = typeConfigId.toString();
        PluginProxy pluginProxy = this.getPluginProxy("SCMC_UNWRITEOFF_KDTX", wfTypeId);
        if (null == pluginProxy) {
            pluginProxy = PluginProxy.create(IKdtxUnWfPlugin.class, (String)"SCMC_UNWRITEOFF_KDTX");
            this.cachePluginProxy("SCMC_UNWRITEOFF_KDTX", wfTypeId, pluginProxy);
        }
        List plugins = CommonUtils.getPlugins((Object[])new IKdtxUnWfPlugin[]{new ReFeeShareBackBillByPlugin(), new ReWriteBackBillByPlugin(), new ReMdcOminWriteBackBillByPlugin(), new ReMdcOmCmpWriteBackBillByPlugin(), new ReRevcfRedWriteBackBillByPlugin(), new SctmUnWriteBackBillByPlugin()});
        plugins.addAll(pluginProxy.getPlugins());
        ArrayList<IKdtxUnWfPlugin> pluginList = new ArrayList<IKdtxUnWfPlugin>(plugins.size());
        for (IKdtxUnWfPlugin plugin : plugins) {
            if (!CommonUtils.isContain((Set)plugin.getWriteOffTypeIds(), (Long)typeConfigId)) continue;
            pluginList.add(plugin);
        }
        return pluginList;
    }

    public void endWriteBack(String DBRouteKey, List<DynamicObject> records, Long typeId) {
        String wfTypeId = typeId.toString();
        PluginProxy pluginProxy = this.getPluginProxy("SCMC_UNWRITEOFF_END_BACK", wfTypeId);
        if (null == pluginProxy) {
            DefaultUnWfPlugin defaultUnWfPlugin = new DefaultUnWfPlugin(typeId);
            pluginProxy = PluginProxy.create((Object)defaultUnWfPlugin, IUnWfEndWriteBackPlugin.class, (String)"SCMC_UNWRITEOFF_END_BACK");
            this.cachePluginProxy("SCMC_UNWRITEOFF_END_BACK", wfTypeId, pluginProxy);
        }
        pluginProxy.callAfter(p -> {
            if (CommonUtils.isContain((Set)p.getWriteOffTypeIds(), (Long)typeId)) {
                p.endWriteBack(DBRouteKey, records);
            }
            return null;
        });
    }

    public void autoBillDelete(String billType, List<Long> idList, Long typeId) {
        DefaultUnWfPlugin unWfPlugin = new DefaultUnWfPlugin(typeId);
        PluginProxy pluginProxy = PluginProxy.create((Object)unWfPlugin, IUnWriteOffPlugin.class, (String)"SCMC_UNWRITEOFF_COMMON");
        pluginProxy.callAfter(p -> {
            if (CommonUtils.isContain((Set)p.getWriteOffTypeIds(), (Long)typeId)) {
                p.autoBillDelete(billType, idList);
            }
            return null;
        });
    }

    public void beforeWfRecordDelete(List<DynamicObject> records, Long typeId, Boolean isCa) {
        String wfTypeId = typeId.toString();
        PluginProxy pluginProxy = this.getPluginProxy("SCMC_UNWRITEOFF_COMMON", wfTypeId);
        if (null == pluginProxy) {
            DefaultUnWfPlugin defaultUnWfPlugin = new DefaultUnWfPlugin(typeId, isCa);
            pluginProxy = PluginProxy.create((Object)defaultUnWfPlugin, IUnWriteOffPlugin.class, (String)"SCMC_UNWRITEOFF_COMMON");
            this.cachePluginProxy("SCMC_UNWRITEOFF_COMMON", wfTypeId, pluginProxy);
        }
        pluginProxy.callAfter(p -> {
            if (CommonUtils.isContain((Set)p.getWriteOffTypeIds(), (Long)typeId)) {
                p.beforeWfRecordDelete(records);
            }
            return null;
        });
    }

    public void beforeBackWriteOff(DynamicObject records, FeeShareTypeConfig typeConfig) {
        String wfTypeId = ((Object)((Object)typeConfig)).toString();
        PluginProxy pluginProxy = this.getPluginProxy("SCMC_UNWRITEOFF_COMMON", wfTypeId);
        if (null == pluginProxy) {
            DefaultUnWfPlugin defaultUnWfPlugin = new DefaultUnWfPlugin(typeConfig.getId());
            pluginProxy = PluginProxy.create((Object)defaultUnWfPlugin, IUnWriteOffPlugin.class, (String)"SCMC_UNWRITEOFF_COMMON");
            this.cachePluginProxy("SCMC_UNWRITEOFF_COMMON", wfTypeId, pluginProxy);
        }
        pluginProxy.callAfter(p -> {
            if (CommonUtils.isContain((Set)p.getWriteOffTypeIds(), (Long)typeConfig.getId())) {
                p.beforeBackWriteOff(records);
            }
            return null;
        });
    }

    public Map<String, Map<String, List<Object[]>>> buildBackSql(List<DynamicObject> records, FeeShareTypeConfig typeConfig) {
        String wfTypeId = ((Object)((Object)typeConfig)).toString();
        PluginProxy pluginProxy = this.getPluginProxy("SCMC_UNWRITEOFF_COMMON", wfTypeId);
        if (null == pluginProxy) {
            DefaultUnWfPlugin defaultUnWfPlugin = new DefaultUnWfPlugin(typeConfig.getId());
            pluginProxy = PluginProxy.create((Object)defaultUnWfPlugin, IUnWriteOffPlugin.class, (String)"SCMC_UNWRITEOFF_COMMON");
            this.cachePluginProxy("SCMC_UNWRITEOFF_COMMON", wfTypeId, pluginProxy);
        }
        HashMap<String, Map<String, List<Object[]>>> map = new HashMap<String, Map<String, List<Object[]>>>(16);
        pluginProxy.callAfter(p -> {
            Map sqlMap;
            if (CommonUtils.isContain((Set)p.getWriteOffTypeIds(), (Long)typeConfig.getId()) && (sqlMap = p.buildBackSql(records)) != null) {
                CommonUtils.buildSqlMap((Map)map, (Map)sqlMap);
            }
            return null;
        });
        return map;
    }

    public boolean check(DynamicObject record, FeeShareTypeConfig typeConfig, boolean isCa) {
        String wfTypeId = typeConfig.getId().toString();
        PluginProxy pluginProxy = this.getPluginProxy("SCMC_UNWRITEOFF_CHECK", wfTypeId);
        if (null == pluginProxy) {
            DefaultUnWfPlugin defaultUnWfPlugin = new DefaultUnWfPlugin(typeConfig.getId(), Boolean.valueOf(isCa));
            pluginProxy = PluginProxy.create((Object)defaultUnWfPlugin, IUnWriteOffCheckPlugin.class, (String)"SCMC_UNWRITEOFF_CHECK");
            this.cachePluginProxy("SCMC_UNWRITEOFF_CHECK", wfTypeId, pluginProxy);
        }
        pluginProxy.callAfter(p -> {
            if (CommonUtils.isContain((Set)p.getWriteOffTypeIds(), (Long)typeConfig.getId()) && !p.check(record)) {
                throw new KDBizException(EngineLang.unWriteOffFail());
            }
            return null;
        });
        return true;
    }

    public void batchCheck(List<DynamicObject> wfRecordList, FeeShareTypeConfig typeConfig, boolean isCa) {
        String wfTypeId = typeConfig.getId().toString();
        PluginProxy pluginProxy = this.getPluginProxy("SCMC_UNWRITEOFF_CHECK", wfTypeId);
        if (null == pluginProxy) {
            DefaultUnWfPlugin defaultUnWfPlugin = new DefaultUnWfPlugin(typeConfig.getId(), Boolean.valueOf(isCa));
            pluginProxy = PluginProxy.create((Object)defaultUnWfPlugin, IUnWriteOffCheckPlugin.class, (String)"SCMC_UNWRITEOFF_CHECK");
            this.cachePluginProxy("SCMC_UNWRITEOFF_CHECK", wfTypeId, pluginProxy);
        }
        pluginProxy.callAfter(p -> {
            if (CommonUtils.isContain((Set)p.getWriteOffTypeIds(), (Long)typeConfig.getId())) {
                p.check(wfRecordList);
            }
            return null;
        });
        FeeShareInvokeCalPlugin feeShareInvokeCalPlugin = new FeeShareInvokeCalPlugin();
        if (feeShareInvokeCalPlugin.getWriteOffTypeIds().contains(typeConfig.getId())) {
            feeShareInvokeCalPlugin.check(wfRecordList);
        }
    }

    private <T extends IWriteOffBasePlugin> PluginProxy<T> getPluginProxy(String extPointName, String wfTypeId) {
        return (PluginProxy)this.unWfPluginCache.get((Object)extPointName, (Object)wfTypeId);
    }

    private <T extends IWriteOffBasePlugin> void cachePluginProxy(String extPointName, String wfTypeId, PluginProxy<T> pluginProxy) {
        this.unWfPluginCache.put((Object)extPointName, (Object)wfTypeId, pluginProxy);
    }
}

