/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsWriteBackRuleConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.core.backfeeshare.entity.EntryBackFeeShareDetail;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.feeshare.params.FeeShareObjectBase;

public class FeeShareWriteBackHelper {
    public static List<Map<String, Object>> writeBack(FsWriteBackRuleConfig writeBackRuleConfig, FeeShareObjectBase writeOffObject, DynamicObject recordEntry, EntryBackFeeShareDetail.BackWriteDetail detail) {
        String sourceColumn = writeBackRuleConfig.getSourceColumn();
        String[] sourceColumnSegments = sourceColumn.split("\\.");
        String columnSegment = sourceColumnSegments[sourceColumnSegments.length - 1];
        if (writeBackRuleConfig.getAssignType().equals("0")) {
            return FeeShareWriteBackHelper.writeBackByColumn(writeBackRuleConfig, recordEntry, writeOffObject, columnSegment, detail);
        }
        return FeeShareWriteBackHelper.writeBackByExpression(writeBackRuleConfig, recordEntry, writeOffObject, columnSegment, detail);
    }

    private static List<Map<String, Object>> writeBackByColumn(FsWriteBackRuleConfig writeBackConfig, DynamicObject recordEntry, FeeShareObjectBase srcObject, String columnSegment, EntryBackFeeShareDetail.BackWriteDetail detail) {
        String[] recordColumnSegments = writeBackConfig.getRecordColumn().split("\\.");
        if (recordEntry.getParent() == null) {
            return FeeShareWriteBackHelper.buildMainAssWriteSqls(writeBackConfig, recordEntry, srcObject, columnSegment, detail);
        }
        Object value = FeeShareWriteBackHelper.getEntryRecordValue(recordEntry, recordColumnSegments);
        Map<String, Object> updateSql = FeeShareWriteBackHelper.writeBackMethod(writeBackConfig, srcObject, columnSegment, value, detail);
        return Collections.singletonList(updateSql);
    }

    private static List<Map<String, Object>> buildMainAssWriteSqls(FsWriteBackRuleConfig writeBackConfig, DynamicObject recordEntry, FeeShareObjectBase srcObject, String columnSegment, EntryBackFeeShareDetail.BackWriteDetail detail) {
        ArrayList<Map<String, Object>> updateSql = new ArrayList<Map<String, Object>>(4);
        Object value = FeeShareWriteBackHelper.getHeadRecordValue(recordEntry, writeBackConfig.getRecordColumn());
        if (value instanceof Object[]) {
            Object[] results;
            for (Object result : results = (Object[])value) {
                Map<String, Object> sql = FeeShareWriteBackHelper.writeBackMethod(writeBackConfig, srcObject, columnSegment, result, detail);
                updateSql.add(sql);
            }
        } else {
            Map<String, Object> sql = FeeShareWriteBackHelper.writeBackMethod(writeBackConfig, srcObject, columnSegment, value, detail);
            updateSql.add(sql);
        }
        return updateSql;
    }

    private static Object getHeadRecordValue(DynamicObject recordEntry, String recordColumnSegments) {
        RowDataModel billEntry = CommonUtils.getBillEntry((DynamicObject)recordEntry);
        return billEntry.getValue(recordColumnSegments);
    }

    private static Object getEntryRecordValue(DynamicObject recordEntry, String[] recordColumnSegments) {
        Object value;
        if (recordColumnSegments.length > 1) {
            value = recordEntry.get(recordColumnSegments[1]);
        } else {
            DynamicObject parent = (DynamicObject)recordEntry.getParent();
            value = parent.get(recordColumnSegments[0]);
        }
        return value;
    }

    private static List<Map<String, Object>> writeBackByExpression(FsWriteBackRuleConfig writeBackConfig, DynamicObject recordEntry, FeeShareObjectBase srcObject, String columnSegment, EntryBackFeeShareDetail.BackWriteDetail detail) {
        Object value = FeeShareWriteBackHelper.buildValue(writeBackConfig, recordEntry);
        Map<String, Object> stringObjectMap = FeeShareWriteBackHelper.writeBackMethod(writeBackConfig, srcObject, columnSegment, value, detail);
        return Collections.singletonList(stringObjectMap);
    }

    private static Map<String, Object> writeBackMethod(FsWriteBackRuleConfig writeBackConfig, FeeShareObjectBase writeOffObjectBase, String columnSegment, Object value, EntryBackFeeShareDetail.BackWriteDetail detail) {
        Object pkValue;
        String pkField;
        String alias;
        String tableGroup;
        String tableName;
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        IDataEntityProperty entryProperty = writeOffObjectBase.getMainFieldEntityType().findProperty(columnSegment);
        IDataEntityProperty mainProperty = writeOffObjectBase.getWFBillEntityType().findProperty(columnSegment);
        if (entryProperty != null) {
            tableName = writeOffObjectBase.getMainFieldEntityType().getAlias();
            tableGroup = entryProperty.getTableGroup();
            alias = entryProperty.getAlias();
            pkField = writeOffObjectBase.getPkField();
            pkValue = writeOffObjectBase.getPkValue();
        } else if (mainProperty != null) {
            tableName = writeOffObjectBase.getWFBillEntityType().getAlias();
            tableGroup = mainProperty.getTableGroup();
            alias = mainProperty.getAlias();
            pkField = writeOffObjectBase.getBillPkField();
            pkValue = writeOffObjectBase.getWfBillPk();
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u53cd\u5199\u5b57\u6bb5%s\u3002", (String)"WriteOffBillBackExecutor_0", (String)"mpscmm-mscommon-feeshare", (Object[])new Object[0]), columnSegment));
        }
        if (StringUtils.isNotEmpty((CharSequence)tableGroup)) {
            tableName = tableName + "_" + tableGroup;
        }
        String writeBackType = writeBackConfig.getWriteBackType();
        if (value instanceof BigDecimal) {
            BigDecimal writeBackValue = (BigDecimal)value;
            if (writeBackType.equals("0")) {
                String sql = "update " + tableName + " set " + alias + " = " + alias + " +  ?  where " + pkField + " = ? ;";
                Object[] objects = new Object[]{writeBackValue, pkValue};
                if ("1".equals(detail.getFlag())) {
                    String rollbackSql = "update " + tableName + " set " + alias + " = " + alias + " -  ?  where " + pkField + " = ? ;";
                    detail.setRollbackSql(rollbackSql);
                    detail.setSqlParam(objects);
                }
                map.put("sql", sql);
                map.put("params", objects);
                detail.setBillField(columnSegment);
                detail.setValue(writeBackValue);
                detail.setWriteBackType("0");
                return map;
            }
            if (writeBackType.equals("1")) {
                String sql = "update " + tableName + " set " + alias + " = " + alias + " - ?  where " + pkField + " = ? ;";
                Object[] objects = new Object[]{writeBackValue, pkValue};
                if ("1".equals(detail.getFlag())) {
                    String rollbackSql = "update " + tableName + " set " + alias + " = " + alias + " + ?  where " + pkField + " = ? ;";
                    detail.setRollbackSql(rollbackSql);
                    detail.setSqlParam(objects);
                }
                detail.setBillField(columnSegment);
                detail.setValue(writeBackValue);
                detail.setWriteBackType("1");
                map.put("sql", sql);
                map.put("params", objects);
                return map;
            }
            if (writeBackType.equals("2")) {
                Object srcValue = writeOffObjectBase.getValue(columnSegment);
                String sql = "update " + tableName + " set " + alias + " = ? where " + pkField + " = ?;";
                if ("1".equals(detail.getFlag())) {
                    Object[] param = new Object[]{srcValue, pkValue};
                    detail.setRollbackSql(sql);
                    detail.setSqlParam(param);
                }
                detail.setCoverOldValue(srcValue);
                detail.setBillField(columnSegment);
                detail.setCoverValue(writeBackValue.toPlainString());
                detail.setWriteBackType("2");
                Object[] objects = new Object[]{writeBackValue, pkValue};
                map.put("sql", sql);
                map.put("params", objects);
                return map;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53cd\u5199\u65b9\u5f0f(%s)\u4e0d\u5b58\u5728\u3002", (String)"WfSnapShootHolder_1", (String)"mpscmm-mscommon-feeshare", (Object[])new Object[0]), writeBackType));
        }
        if (writeBackType.equals("2")) {
            Object writeBackValue = FeeShareWriteBackHelper.getFieldValue(value);
            Object srcValue = writeOffObjectBase.getValue(columnSegment);
            Object oldWriteBackValue = FeeShareWriteBackHelper.getFieldValue(srcValue);
            String sql = "update " + tableName + " set " + alias + " = ? where " + pkField + " = ? ;";
            if ("1".equals(detail.getFlag())) {
                Object[] param = new Object[]{oldWriteBackValue, pkValue};
                detail.setRollbackSql(sql);
                detail.setSqlParam(param);
            }
            detail.setCoverOldValue(oldWriteBackValue);
            detail.setBillField(columnSegment);
            detail.setCoverValue(writeBackValue);
            detail.setWriteBackType("2");
            Object[] objects = new Object[]{writeBackValue, pkValue};
            map.put("sql", sql);
            map.put("params", objects);
            return map;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u975e\u6570\u5b57\u7c7b\u578b\u5b57\u6bb5\u4e0d\u80fd\u4f7f\u7528\u7d2f\u52a0\u3001\u7d2f\u51cf\u53cd\u5199\u65b9\u5f0f\u3002", (String)"WfSnapShootHolder_0", (String)"mpscmm-mscommon-feeshare", (Object[])new Object[0]));
    }

    private static Object getFieldValue(Object value) {
        Object writeBackValue = value;
        if (value instanceof DynamicObject) {
            writeBackValue = ((DynamicObject)value).getPkValue();
        }
        return writeBackValue;
    }

    private static Object buildValue(FsWriteBackRuleConfig writeBackConfig, DynamicObject recordEntry) {
        String expression = writeBackConfig.getExpression();
        if (StringUtils.isEmpty((CharSequence)expression)) {
            return null;
        }
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)expression, CRCondition.class);
        String[] columns = FormulaEngine.extractVariables((String)condition.getExpression());
        HashMap<String, Object> args = new HashMap<String, Object>(16);
        for (String column : columns) {
            String entryName = recordEntry.getDataEntityType().getName();
            DynamicObject parent = (DynamicObject)recordEntry.getParent();
            BillEntityType type = (BillEntityType)parent.getDataEntityType();
            RowDataModel rowDataModel = new RowDataModel(entryName, (MainEntityType)type);
            rowDataModel.setRowContext(recordEntry);
            args.put(column, rowDataModel.getValue(column));
        }
        Object result = FormulaEngine.execExcelFormula((String)condition.getExpression(), args);
        return result;
    }
}

