/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.ext.scmc.cal.plugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.mpscmm.mscommon.feeshare.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IMatchPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.params.MatchPluginResult;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectArgs;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class EstShareMatchPlugin
implements IMatchPlugin {
    private static final Log logger = LogFactory.getLog(EstShareMatchPlugin.class);

    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet((Long[])new Long[]{WriteOffTypeIdConst.HXLB_ESTFEE_SHARE});
    }

    public Set<Long> getMachRuleIds() {
        return CommonUtils.getIdSet((Long[])new Long[]{WriteOffTypeIdConst.PPGZ_EST_SHARE_PLUGIN_MATCH});
    }

    public Boolean matchCompare(MatchPluginResult response, Object srcValue) {
        return true;
    }

    public List<MatchPluginResult> matchCondition(WriteOffObjectArgs writeOffObjectArgs) {
        ArrayList<MatchPluginResult> results = new ArrayList<MatchPluginResult>(1);
        WriteOffObjectBase writeOffObject = writeOffObjectArgs.getWriteOffObjectBase();
        String entityKey = writeOffObject.getWFBillEntityName();
        if (!"ap_busbill".equals(entityKey)) {
            logger.info("EstShareMatchPlugin:\u6838\u9500\u5bf9\u8c61\u4e0d\u662f\u6682\u4f30\u5e94\u4ed8");
            return results;
        }
        Object billId = writeOffObject.getWfBillPk();
        Object entryId = writeOffObject.getPkValue();
        String entryKey = writeOffObject.getMainFieldEntityType().getName();
        boolean isAdjust = (Boolean)writeOffObject.getValue("isadjust");
        MatchPluginResult response = new MatchPluginResult();
        StringBuilder matchInfoBuild = new StringBuilder();
        matchInfoBuild.append(entityKey);
        matchInfoBuild.append('#');
        matchInfoBuild.append(billId);
        matchInfoBuild.append('#');
        matchInfoBuild.append(entryKey);
        matchInfoBuild.append('#');
        matchInfoBuild.append(entryId);
        matchInfoBuild.append('#');
        matchInfoBuild.append(isAdjust);
        response.setMatchValue(matchInfoBuild.toString());
        response.setMatchName("estshare");
        response.setComparison("in");
        results.add(response);
        return results;
    }

    public QFilter getMatchFilter(Object value, String targetEntity, String targetEntry) {
        logger.info("EstShareMatchPlugin:\u5f00\u59cb\u6784\u9020\u8fc7\u6ee4\u6761\u4ef6");
        if (!"cal_costrecord_subentity".equals(targetEntity)) {
            logger.info("EstShareMatchPlugin:\u76ee\u6807\u5355\u4e0d\u662f\u6210\u672c\u8bb0\u5f55:" + targetEntity);
            return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        }
        if (value == null) {
            logger.info("EstShareMatchPlugin:\u65e0\u5339\u914d\u7ed3\u679c");
            return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        }
        String[] values = value.toString().split("#");
        String entityKey = values[0];
        Long billId = Long.valueOf(values[1]);
        String entryKey = values[2];
        Long entryId = Long.valueOf(values[3]);
        boolean isAdjust = Boolean.parseBoolean(values[4]);
        if (!isAdjust) {
            logger.info("EstShareMatchPlugin:\u975e\u51b2\u56de\u5355\u5206\u644a");
            return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        }
        HashSet<Long> srcBillIds = new HashSet<Long>(8);
        HashSet<Long> srcBillEntryIds = new HashSet<Long>(8);
        this.handleLinkUpNodes(entityKey, entryKey, billId, entryId, "ap_busbill", srcBillIds, srcBillEntryIds);
        if (srcBillIds.isEmpty()) {
            logger.info("EstShareMatchPlugin:\u672a\u627e\u5230\u4e0a\u6e38\u6682\u4f30\u5e94\u4ed8\u5355");
            return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        }
        QFilter recordQ = new QFilter("entry.billid", "in", srcBillIds);
        recordQ.and("entry.billentryid", "in", srcBillEntryIds);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"cal_feeshare_newrecord", (String)"entry.billid,entry.billentryid,entry.calentryid", (QFilter[])recordQ.toArray());
        HashSet<Long> costRecordIds = new HashSet<Long>(16);
        HashSet<Long> costRecordEntryIds = new HashSet<Long>(16);
        for (DynamicObject record : records) {
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                Long calentryid = entry.getLong("calentryid");
                if (Long.compare(calentryid, 0L) == 0) continue;
                costRecordIds.add(entry.getLong("billid"));
                costRecordEntryIds.add(entry.getLong("billentryid"));
            }
        }
        if (costRecordIds.isEmpty()) {
            logger.info("EstShareMatchPlugin:\u4ece\u8d39\u7528\u5206\u644a\u52fe\u7a3d\u8bb0\u5f55\u4e2d\u6ca1\u6709\u83b7\u53d6\u5230\u6838\u7b97\u6210\u672c\u8bb0\u5f55");
            return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        }
        QFilter targetFilter = new QFilter("id", "in", costRecordIds);
        targetFilter.and(targetEntry, "in", costRecordEntryIds);
        return targetFilter;
    }

    private void handleLinkUpNodes(String curEntity, String curEntryKey, Long curId, Long curEntryId, String targetEntity, Set<Long> ids, Set<Long> entryIds) {
        List linkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)curEntity, (String)curEntryKey, (Long[])new Long[]{curId}, (Long[])new Long[]{curEntryId}, null);
        TableDefine tableDefine = EntityMetadataCache.loadMainTableDefine((String)targetEntity);
        Long upTableId = tableDefine.getTableId();
        for (BFRowLinkUpNode linkUpNode : linkUpNodes) {
            List<BFRowLinkUpNode> sourceNodes = EstShareMatchPlugin.findSourceNodes(linkUpNode, upTableId, curId);
            for (BFRowLinkUpNode sourceNode : sourceNodes) {
                ids.add(sourceNode.getRowId().getBillId());
                entryIds.add(sourceNode.getRowId().getEntryId());
            }
        }
    }

    private static List<BFRowLinkUpNode> findSourceNodes(BFRowLinkUpNode node, Long sMainTableId, Long id) {
        ArrayList<BFRowLinkUpNode> nodes = new ArrayList<BFRowLinkUpNode>(10);
        if (node.getRowId().getMainTableId().compareTo(sMainTableId) == 0 && node.getRowId().getBillId().compareTo(id) != 0) {
            nodes.add(node);
        } else {
            for (BFRowLinkUpNode sNode : node.getSNodes().values()) {
                nodes.addAll(EstShareMatchPlugin.findSourceNodes(sNode, sMainTableId, id));
            }
        }
        return nodes;
    }
}

