/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.ext.scmc.feeshare;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.ShareRuleBillConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.ShareGroup;
import kd.mpscmm.mscommon.feeshare.lang.EngineLang;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.feeshare.params.FeeShareObjectBase;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffMainFieldCalPlugin;

public class BillDynamicMainFieldCal
implements IWriteOffMainFieldCalPlugin {
    private static final String SHARE_FEE_RECORD = "cal_feeshare_newrecord";

    public Set<Long> getWfTypeBillEntryId() {
        return CommonUtils.getIdSet((Long[])new Long[]{1724049537695318019L, 1729865019774076929L});
    }

    public String getPluginField() {
        return "baseqty";
    }

    public String mainFieldEntry() {
        return "billentry";
    }

    public List<String> calNeedFields() {
        ArrayList<String> needFields = new ArrayList<String>(2);
        needFields.add(this.mainFieldEntry().concat(".").concat("baseqty"));
        return needFields;
    }

    public BigDecimal dynamicMainFieldCal(Map<String, Object> mapValue) {
        if (!mapValue.isEmpty()) {
            String mainField = this.mainFieldEntry().concat(".").concat(this.getPluginField());
            return (BigDecimal)mapValue.get(mainField);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal shareAmountCal(ShareRuleBillConfig shareRuleBillConfig, List<FeeShareObjectBase> candidateQueue, BigDecimal allShareAmount, BigDecimal allSubDemosAmount, int precision, BigDecimal hasSharedQty) {
        if (BigDecimal.ZERO.compareTo(allSubDemosAmount = allSubDemosAmount.subtract(hasSharedQty)) == 0) {
            throw new KDBizException(EngineLang.denmonIsZero());
        }
        BigDecimal sharedAmount = BigDecimal.ZERO;
        for (FeeShareObjectBase subObj : candidateQueue) {
            BigDecimal curWriteOffNumber = subObj.getCurWriteOffNumber();
            if (shareRuleBillConfig.getNumerator().isAbsolute()) {
                curWriteOffNumber = curWriteOffNumber.abs();
            }
            BigDecimal curShareAmt = BigDecimal.ZERO;
            curShareAmt = curWriteOffNumber.compareTo(allSubDemosAmount) > 0 ? allShareAmount.divide(BigDecimal.ONE, precision, RoundingMode.HALF_UP) : allShareAmount.multiply(curWriteOffNumber).divide(allSubDemosAmount, precision, RoundingMode.HALF_UP);
            allShareAmount = allShareAmount.subtract(curShareAmt);
            allSubDemosAmount = allSubDemosAmount.subtract(curWriteOffNumber);
            subObj.setWriteOffNumber(curShareAmt);
            sharedAmount = sharedAmount.add(curShareAmt);
        }
        return sharedAmount;
    }

    public static Map<Object, BigDecimal> queryShareRecord(List<ShareGroup> shareGroups, FeeShareTypeConfig typeConfig) {
        HashMap<Object, BigDecimal> hasShareQty = new HashMap<Object, BigDecimal>(16);
        String recordBillType = typeConfig.getRecordNum();
        if (SHARE_FEE_RECORD.equals(recordBillType)) {
            DynamicObject[] dynamicObjects;
            HashSet<Object> shareMainEntryId = new HashSet<Object>(16);
            for (ShareGroup shareGroup : shareGroups) {
                List<FeeShareObjectBase> mainQueueObjects = shareGroup.getMainQueue();
                for (FeeShareObjectBase writeOffObjectBase : mainQueueObjects) {
                    shareMainEntryId.add(writeOffObjectBase.getPkValue());
                }
            }
            String recordEntryType = typeConfig.getRecordEntryType();
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)recordBillType, (String)"id,entry.billentryid,entry.numerator,entry.ismianbill", (QFilter[])new QFilter("entry.billentryid", "in", shareMainEntryId).toArray())) {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(recordEntryType);
                for (DynamicObject obj : dynamicObjectCollection) {
                    if (!obj.getBoolean("ismianbill")) continue;
                    Object mainShareObjId = ((DynamicObject)dynamicObjectCollection.get(0)).get("billentryid");
                    BigDecimal hasSharedQty = hasShareQty.getOrDefault(mainShareObjId, BigDecimal.ZERO);
                    hasShareQty.put(mainShareObjId, hasSharedQty.add(BillDynamicMainFieldCal.getQty(dynamicObjectCollection)));
                }
            }
        }
        return hasShareQty;
    }

    private static BigDecimal getQty(DynamicObjectCollection dynamicObjectCollection) {
        BigDecimal qty = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            if (dynamicObject.getBoolean("ismianbill")) continue;
            BigDecimal curQty = dynamicObject.getBigDecimal("numerator");
            qty = qty.add(curQty);
        }
        return qty;
    }
}

