/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.op.validator;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.mpscmm.mscommon.writeoff.lang.FormLang;

public class ShareRuleSaveValidator
extends AbstractValidator {
    public void validate() {
        this.checkDenomAndNumer();
        this.checkConfigNoFilter();
        this.checkValueMethod();
    }

    private void checkValueMethod() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection shareRuleEntries = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            for (DynamicObject shareRuleEntry : shareRuleEntries) {
                DynamicObjectCollection shareRuleStandardEntries = shareRuleEntry.getDynamicObjectCollection("subentryentity");
                for (DynamicObject shareRuleStandardEntry : shareRuleStandardEntries) {
                    String valueMethod = shareRuleStandardEntry.getString("valuemethod");
                    if ("A".equals(valueMethod) && StringUtils.isEmpty((CharSequence)shareRuleStandardEntry.getString("sharebillfieldkey"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u644a\u6807\u51c6\u524d\u7f6e\u6761\u4ef6\u7b2c%1$s\u884c\uff1a\u5206\u644a\u6807\u51c6\u7b2c%2$s\u884c\u5206\u644a\u6807\u51c6\u53d6\u503c\u65b9\u5f0f\u4e3a\u6e90\u5355\u5b57\u6bb5\uff0c\u8bf7\u5f55\u5165\u5206\u644a\u6807\u51c6\u5b57\u6bb5\u3002", (String)"plsInsertFieldKey", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), shareRuleEntry.getInt("seq"), shareRuleStandardEntry.getInt("seq")));
                        continue;
                    }
                    if (!"C".equals(valueMethod) || !StringUtils.isEmpty((CharSequence)shareRuleStandardEntry.getString("wffieldplugin"))) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u644a\u6807\u51c6\u524d\u7f6e\u6761\u4ef6\u7b2c%1$s\u884c\uff1a\u5206\u644a\u6807\u51c6\u7b2c%2$s\u884c\u5206\u644a\u6807\u51c6\u53d6\u503c\u65b9\u5f0f\u4e3a\u52a8\u6001\u5b57\u6bb5\uff0c\u8bf7\u5f55\u5165\u52a8\u6001\u5b57\u6bb5\u3002", (String)"plsInsertseqPluginField", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), shareRuleEntry.getInt("seq"), shareRuleStandardEntry.getInt("seq")));
                }
            }
        }
    }

    private void checkConfigNoFilter() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            ArrayList<Integer> noneConfigSeqs = new ArrayList<Integer>(16);
            DynamicObjectCollection shareRuleEntries = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            for (DynamicObject shareRuleEntry : shareRuleEntries) {
                String filters = shareRuleEntry.getString("filtercondition");
                if (!StringUtils.isEmpty((CharSequence)filters)) continue;
                noneConfigSeqs.add(shareRuleEntry.getInt("seq"));
            }
            if (shareRuleEntries.size() <= 1 || noneConfigSeqs.isEmpty()) continue;
            this.addErrorMessage(dataEntity, FormLang.filterConditionNotAllowNull(noneConfigSeqs));
        }
    }

    private void checkDenomAndNumer() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection shareRuleEntries = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            for (DynamicObject shareRuleEntry : shareRuleEntries) {
                DynamicObjectCollection shareRuleStandardEntries = shareRuleEntry.getDynamicObjectCollection("subentryentity");
                int denoms = 0;
                int numers = 0;
                DynamicObject numBill = null;
                DynamicObject demBill = null;
                String shareMatchType = null;
                for (DynamicObject shareRuleStandardEntry : shareRuleStandardEntries) {
                    String shareWeight = shareRuleStandardEntry.getString("shareweight");
                    if ("0".equals(shareWeight)) {
                        ++numers;
                        numBill = shareRuleStandardEntry.getDynamicObject("sharewfbillalias");
                        continue;
                    }
                    if (!"1".equals(shareWeight)) continue;
                    ++denoms;
                    demBill = shareRuleStandardEntry.getDynamicObject("sharewfbillalias");
                    shareMatchType = shareRuleStandardEntry.getString("sharedembillmatchtype");
                }
                if (denoms > 1) {
                    this.addErrorMessage(dataEntity, FormLang.onlyOneDenominator((int)shareRuleEntry.getInt("seq")));
                    continue;
                }
                if (numers != 1) {
                    this.addErrorMessage(dataEntity, FormLang.onlyOneNumerator((int)shareRuleEntry.getInt("seq")));
                    continue;
                }
                if (demBill != null && StringUtils.isBlank(shareMatchType)) {
                    this.addErrorMessage(dataEntity, FormLang.plsInsertlineMatchType((int)shareRuleEntry.getInt("seq")));
                    continue;
                }
                if (numBill == null || demBill == null || !"0".equals(shareMatchType)) continue;
                String numBillNumber = numBill.getString("number");
                String demBillNumber = demBill.getString("number");
                if (numBillNumber == null || demBillNumber == null || StringUtils.equals((CharSequence)numBillNumber, (CharSequence)demBillNumber)) continue;
                HashSet<String> srcNum = new HashSet<String>(16);
                HashSet<String> tgtDem = new HashSet<String>(16);
                DynamicObjectCollection matchEntries = shareRuleEntry.getDynamicObjectCollection("matchconditionentity");
                for (DynamicObject matchEntry : matchEntries) {
                    DynamicObject tgtBill = matchEntry.getDynamicObject("tgtwfbillalias");
                    DynamicObject srcBill = matchEntry.getDynamicObject("srcwfbillalias");
                    if (srcBill != null) {
                        srcNum.add(srcBill.getString("number"));
                    }
                    if (tgtBill == null) continue;
                    tgtDem.add(tgtBill.getString("number"));
                }
                if (srcNum.contains(numBill.getString("number")) && tgtDem.contains(demBill.getString("number"))) continue;
                this.addErrorMessage(dataEntity, FormLang.plsConfigSrcToTgtBillMatchEntry((int)shareRuleEntry.getInt("seq"), (DynamicObject)numBill, (DynamicObject)demBill));
            }
        }
    }
}

