/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.assigncfg.form;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AssignCfgOrgPlugin
extends AbstractFormPlugin {
    public void initialize() {
        this.addClickListeners(new String[]{"btnsave"});
        this.addItemClickListeners(new String[]{"toolbar"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey().toLowerCase()) {
            case "btnaddline": {
                this.openOrgF7();
                break;
            }
            case "btndeleteline": {
                this.refreshOrgf7();
            }
        }
    }

    private void refreshOrgf7() {
        DynamicObjectCollection curOrgList = this.getModel().getEntryEntity("orgentry");
        HashSet<Long> orgs = new HashSet<Long>();
        for (DynamicObject obj : curOrgList) {
            orgs.add(obj.getDynamicObject("orgid").getLong("id"));
        }
        this.getModel().setValue("orgf7", (Object)orgs.toArray());
    }

    private void openOrgF7() {
        MulBasedataEdit base = (MulBasedataEdit)this.getControl("orgf7");
        base.setOrgFuncId(this.getOrgFuncId(this.getModel().getValue("bizobjectid")));
        base.click();
    }

    private String getOrgFuncId(Object bizObject) {
        if (StringUtils.isBlank((Object)bizObject)) {
            return "15";
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bizObject.toString());
        if (dataEntityType == null) {
            return "15";
        }
        String mainOrg = dataEntityType.getMainOrg();
        if (StringUtils.isBlank((CharSequence)mainOrg)) {
            return "15";
        }
        MainOrgProp org = (MainOrgProp)dataEntityType.getProperty(mainOrg);
        if (org == null) {
            return "15";
        }
        String orgfuncid = org.getOrgFunc();
        return StringUtils.isBlank((CharSequence)orgfuncid) ? "15" : orgfuncid;
    }

    public void click(EventObject evt) {
        String itemkey;
        Control c = (Control)evt.getSource();
        switch (itemkey = c.getKey().toLowerCase()) {
            case "btnsave": {
                Object billid = this.getView().getFormShowParameter().getCustomParam("fid");
                this.deleteEntry(billid);
                this.saveData();
                this.getView().close();
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.clearAllEntryRow();
        IDataModel model = this.getModel();
        Object billId = this.getView().getFormShowParameter().getCustomParam("fid");
        QFilter qFilter = new QFilter("id", "=", billId);
        DynamicObjectCollection orgEntry = QueryServiceHelper.query((String)"msmod_assigncfg", (String)"id,orgentry.orgid orgid,orgentry.isincludesuborg isincludesuborg,orgentry.orgid.number number,orgentry.orgid.name name", (QFilter[])qFilter.toArray());
        HashSet<String> orgSet = new HashSet<String>();
        if (orgEntry != null && orgEntry.size() > 0) {
            for (int rowIdx = 0; rowIdx < orgEntry.size(); ++rowIdx) {
                DynamicObject orgObj = (DynamicObject)orgEntry.get(rowIdx);
                String orgid = orgObj.getString("orgid");
                if (StringUtils.isBlank((Object)orgObj.get("number"))) break;
                model.createNewEntryRow("orgentry");
                model.setValue("orgid", orgObj.get("orgid"), rowIdx);
                model.setValue("isincludesuborg", orgObj.get("isincludesuborg"), rowIdx);
                orgSet.add(orgid);
            }
        }
        Set orgs = orgSet.stream().map(Long::valueOf).collect(Collectors.toSet());
        this.getModel().setValue("orgf7", (Object)orgs.toArray());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if ("orgf7".equals(proName)) {
            this.refreshOrgEntity(e);
        }
    }

    private void refreshOrgEntity(PropertyChangedArgs e) {
        DynamicObjectCollection curOrgList = this.getModel().getEntryEntity("orgentry");
        HashMap<Long, Object> subOrgMap = new HashMap<Long, Object>();
        for (DynamicObject curOrgObj : curOrgList) {
            DynamicObject org = curOrgObj.getDynamicObject("orgid");
            if (org == null) continue;
            subOrgMap.put(org.getLong("id"), curOrgObj.get("isincludesuborg"));
        }
        this.clearAllEntryRow();
        DynamicObjectCollection orgCol = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
        if (orgCol.size() == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("orgentry", orgCol.size());
        int m = orgCol.size();
        for (int rowIdx = 0; rowIdx < m; ++rowIdx) {
            DynamicObject orgObj = (DynamicObject)orgCol.get(rowIdx);
            DynamicObject org = orgObj.getDynamicObject("fbasedataId");
            if (org == null) continue;
            this.getModel().setValue("orgid", (Object)org, rowIdx);
            Object isIncludeSubOrg = subOrgMap.get(org.getLong("id"));
            if (isIncludeSubOrg == null) continue;
            this.getModel().setValue("isincludesuborg", isIncludeSubOrg, rowIdx);
        }
    }

    private void saveData() {
        IDataModel model = this.getModel();
        Object assignCfgId = this.getView().getFormShowParameter().getCustomParam("fid");
        DynamicObject assignCfgDym = BusinessDataServiceHelper.newDynamicObject((String)"msmod_assigncfg");
        assignCfgDym.set("id", assignCfgId);
        DynamicObjectCollection orgCollection = model.getEntryEntity("orgentry");
        DynamicObject[] orgArr = new DynamicObject[orgCollection.size()];
        Integer rowIdx = 0;
        while (rowIdx < orgCollection.size()) {
            DynamicObject orgEntity = BusinessDataServiceHelper.newDynamicObject((String)"msmod_assigncfg_orgentity");
            orgEntity.set("assigncfg", (Object)assignCfgDym);
            orgEntity.set("orgid", model.getValue("orgid", rowIdx.intValue()));
            orgEntity.set("isincludesuborg", model.getValue("isincludesuborg", rowIdx.intValue()));
            orgEntity.set("seq", (Object)rowIdx);
            orgArr[rowIdx.intValue()] = orgEntity;
            Integer n = rowIdx;
            Integer n2 = rowIdx = Integer.valueOf(rowIdx + 1);
        }
        SaveServiceHelper.save((DynamicObject[])orgArr);
        DynamicObject[] assignCfgArray = BusinessDataServiceHelper.load((Object[])new Object[]{assignCfgId}, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"msmod_assigncfg"));
        SaveServiceHelper.saveOperate((String)"msmod_assigncfg", (DynamicObject[])assignCfgArray, (OperateOption)OperateOption.create());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AssignCfgOrgPlugin_0", (String)"mpscmm-mscommon-common", (Object[])new Object[0]));
    }

    private void deleteEntry(Object assignCfgId) {
        QFilter qFilter = new QFilter("assigncfg", "=", assignCfgId);
        DeleteServiceHelper.delete((String)"msmod_assigncfg_orgentity", (QFilter[])qFilter.toArray());
    }

    private void clearAllEntryRow() {
        this.getModel().deleteEntryData("orgentry");
    }
}

