/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.template.form;

import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.mscommon.lang.FormLang;

public class AbstractMSCBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void beforeF7Select(BeforeF7SelectEvent event) {
        try {
            QFilter filter = this.buildF7SelectFilter(event.getProperty().getName(), event);
            if (filter != null) {
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(filter);
            }
        }
        catch (KDBizException e) {
            event.setCancel(true);
            ErrorCode errorCode = e.getErrorCode();
            if ("MSCOMMON-COM0001".equals(errorCode.getCode())) {
                this.getView().showTipNotification(errorCode.getMessage());
            }
            throw e;
        }
    }

    protected QFilter buildF7SelectFilter(String key, BeforeF7SelectEvent event) {
        return null;
    }

    protected Object getValue(String key) {
        Object value = this.getModel().getValue(key);
        if (value == null) {
            MainEntityType entityType = this.getModel().getDataEntityType();
            IDataEntityProperty findProperty = entityType.findProperty(key);
            throw new KDBizException(new ErrorCode("MSCOMMON-COM0001", FormLang.plsSelect(findProperty.getDisplayName().getLocaleValue())), new Object[0]);
        }
        return value;
    }

    protected Object getValue(String key, int index) {
        Object value = this.getModel().getValue(key, index);
        if (value == null) {
            MainEntityType entityType = this.getModel().getDataEntityType();
            IDataEntityProperty findProperty = entityType.findProperty(key);
            throw new KDBizException(new ErrorCode("MSCOMMON-COM0001", FormLang.PlsSelectIndex(findProperty.getDisplayName().getLocaleValue(), index)), new Object[0]);
        }
        return value;
    }
}

