/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.freeze.core.config.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.freeze.core.config.vo.FreezeMappingField;
import kd.mpscmm.mscommon.freeze.core.config.vo.FreezeMappingSetting;
import org.apache.commons.lang3.ObjectUtils;

public class FreezeMappingService {
    private static final String MAPPING_FIELDS = new StringJoiner(",").add("sourcebill").add("targetobj").add("colsmap.sourcebillcolno").add("colsmap.sourcebillcol").add("colsmap.targetobjcolno").add("colsmap.targetobjcol").toString();

    public static List<FreezeMappingSetting> load(String srcEntityNumber) {
        QFilter qFilter = new QFilter("sourcebill", "=", (Object)srcEntityNumber).and("targetobj", "in", (Object)FreezeMappingService.getFormIds()).and("isenable", "=", (Object)Boolean.TRUE);
        Map mappingMap = BusinessDataServiceHelper.loadFromCache((String)"sbs_billfieldmapping", (String)MAPPING_FIELDS, (QFilter[])qFilter.toArray());
        return FreezeMappingService.parseMappingSetting(mappingMap.values());
    }

    private static String[] getFormIds() {
        return new String[]{"msmod_freezelog"};
    }

    private static List<FreezeMappingSetting> parseMappingSetting(Collection<DynamicObject> mappings) {
        if (ObjectUtils.isEmpty(mappings)) {
            return Collections.emptyList();
        }
        return mappings.stream().map(item -> {
            FreezeMappingSetting freezeMappingSetting = new FreezeMappingSetting();
            freezeMappingSetting.setSrcEntityNumber(item.getDynamicObject("sourcebill").getString("number"));
            freezeMappingSetting.setTargetEntityNumber(item.getDynamicObject("targetobj").getString("number"));
            DynamicObjectCollection colsmap = item.getDynamicObjectCollection("colsmap");
            freezeMappingSetting.setFreezeMappingFields(FreezeMappingService.parseFieldMappings(colsmap));
            return freezeMappingSetting;
        }).collect(Collectors.toList());
    }

    private static List<FreezeMappingField> parseFieldMappings(DynamicObjectCollection colsmap) {
        ArrayList<FreezeMappingField> mappingFields = new ArrayList<FreezeMappingField>(colsmap.getRowCount());
        for (DynamicObject map : colsmap) {
            FreezeMappingField freezeMappingField = new FreezeMappingField();
            freezeMappingField.setSrcFieldNumber(map.getString("sourcebillcol"));
            freezeMappingField.setSrcFieldName(map.getString("sourcebillcolno"));
            freezeMappingField.setTargetFieldNumber(map.getString("targetobjcol"));
            freezeMappingField.setTargetFieldName(map.getString("targetobjcolno"));
            mappingFields.add(freezeMappingField);
        }
        return mappingFields;
    }
}

